/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.catalog;

import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.ResolvedTable;
import org.apache.spark.sql.catalyst.analysis.UnresolvedTable;
import org.apache.spark.sql.catalyst.analysis.UnresolvedTable$;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.plans.logical.AnalysisHelper$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.V1Table;
import org.apache.spark.sql.delta.DeltaAnalysis;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaLog$;
import org.apache.spark.sql.delta.DeltaTableUtils$;
import org.apache.spark.sql.delta.DeltaTimeTravelSpec;
import org.apache.spark.sql.delta.DeltaUnsupportedTableFeatureException;
import org.apache.spark.sql.delta.InvalidProtocolVersionException;
import org.apache.spark.sql.delta.UnresolvedPathBasedDeltaTable;
import org.apache.spark.sql.delta.catalog.DeltaTableV2;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple6;
import scala.collection.Iterable;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;

public final class DeltaTableV2$ {
    public static final DeltaTableV2$ MODULE$ = new DeltaTableV2$();

    public Option<Tuple6<SparkSession, Path, Option<CatalogTable>, Option<String>, Option<DeltaTimeTravelSpec>, Map<String, String>>> unapply(DeltaTableV2 deltaTable) {
        return new Some((Object)new Tuple6((Object)deltaTable.spark(), (Object)deltaTable.path(), deltaTable.catalogTable(), deltaTable.tableIdentifier(), deltaTable.timeTravelOpt(), deltaTable.options()));
    }

    public DeltaTableV2 apply(SparkSession spark, Path path, Option<CatalogTable> catalogTable, Option<String> tableIdentifier, Map<String, String> options, Option<DeltaTimeTravelSpec> timeTravelOpt) {
        DeltaTableV2 deltaTable = new DeltaTableV2(spark, path, catalogTable, tableIdentifier, timeTravelOpt, options);
        if (spark == null || spark.sessionState() == null || !BoxesRunTime.unboxToBoolean((Object)spark.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.ENABLE_TABLE_REDIRECT_FEATURE()))) {
            return deltaTable;
        }
        return (DeltaTableV2)AnalysisHelper$.MODULE$.allowInvokingTransformsInAnalyzer((Function0 & Serializable)() -> {
            Path newPath;
            Path finalDeltaLogPath;
            DeltaLog deltaLog = deltaTable.deltaLog();
            Path rootDeltaLogPath = DeltaLog$.MODULE$.logPathFor(deltaTable.org$apache$spark$sql$delta$catalog$DeltaTableV2$$rootPath().toString());
            Path path = finalDeltaLogPath = DeltaLog$.MODULE$.formalizeDeltaPath(spark, options, rootDeltaLogPath);
            Path path2 = deltaLog.logPath();
            Option<CatalogTable> catalogTableOpt = !(path != null ? !path.equals(path2) : path2 != null) ? catalogTable : deltaLog.getInitialCatalogTable();
            Option tableIdentifier = catalogTableOpt.map((Function1 & Serializable)x$7 -> x$7.identifier().identifier());
            Path x$1 = newPath = new Path(deltaLog.dataPath().toUri());
            Option<CatalogTable> x$2 = catalogTableOpt;
            Option x$3 = tableIdentifier;
            SparkSession x$4 = deltaTable.copy$default$1();
            Option<DeltaTimeTravelSpec> x$5 = deltaTable.copy$default$5();
            Map<String, String> x$6 = deltaTable.copy$default$6();
            return deltaTable.copy(x$4, x$1, x$2, (Option<String>)x$3, x$5, x$6);
        });
    }

    public DeltaTableV2 apply(SparkSession spark, Path tablePath, Map<String, String> options, String cmd) {
        UnresolvedPathBasedDeltaTable unresolved = new UnresolvedPathBasedDeltaTable(tablePath.toString(), options, cmd);
        return this.extractFrom(new DeltaAnalysis(spark).apply(unresolved), cmd);
    }

    public DeltaTableV2 apply(SparkSession spark, TableIdentifier tableId, String cmd) {
        UnresolvedTable unresolved = new UnresolvedTable(tableId.nameParts(), cmd, UnresolvedTable$.MODULE$.apply$default$3());
        return this.extractFrom(spark.sessionState().analyzer().ResolveRelations().apply((LogicalPlan)unresolved), cmd);
    }

    public Option<CatalogTable> apply$default$3() {
        return None$.MODULE$;
    }

    public Option<String> apply$default$4() {
        return None$.MODULE$;
    }

    public Map<String, String> apply$default$5() {
        return Predef$.MODULE$.Map().empty();
    }

    public Option<DeltaTimeTravelSpec> apply$default$6() {
        return None$.MODULE$;
    }

    public DeltaTableV2 extractFrom(LogicalPlan plan, String cmd) {
        return (DeltaTableV2)this.maybeExtractFrom(plan).getOrElse((Function0 & Serializable)() -> {
            throw DeltaErrors$.MODULE$.notADeltaTableException(cmd);
        });
    }

    public Option<DeltaTableV2> maybeExtractFrom(LogicalPlan plan) {
        V1Table v1Table;
        Table t;
        boolean bl = false;
        ResolvedTable resolvedTable = null;
        LogicalPlan logicalPlan = plan;
        if (logicalPlan instanceof ResolvedTable) {
            bl = true;
            resolvedTable = (ResolvedTable)logicalPlan;
            Table d = resolvedTable.table();
            if (d instanceof DeltaTableV2) {
                DeltaTableV2 deltaTableV2 = (DeltaTableV2)d;
                return new Some((Object)deltaTableV2);
            }
        }
        if (bl && (t = resolvedTable.table()) instanceof V1Table && DeltaTableUtils$.MODULE$.isDeltaTable((v1Table = (V1Table)t).catalogTable())) {
            return new Some((Object)this.apply(SparkSession$.MODULE$.active(), new Path(v1Table.v1Table().location()), (Option<CatalogTable>)new Some((Object)v1Table.v1Table()), this.apply$default$4(), this.apply$default$5(), this.apply$default$6()));
        }
        return None$.MODULE$;
    }

    public <T> T withEnrichedUnsupportedTableException(Option<CatalogTable> catalogTable, Option<String> tableName, Function0<T> thunk) {
        Object object;
        LazyRef tableNameToUse$lzy = new LazyRef();
        try {
            object = thunk.apply();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof InvalidProtocolVersionException) {
                InvalidProtocolVersionException invalidProtocolVersionException = (InvalidProtocolVersionException)throwable2;
                if (DeltaTableV2$.tableNameToUse$1(tableNameToUse$lzy, catalogTable, tableName).exists((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)DeltaTableV2$.$anonfun$withEnrichedUnsupportedTableException$1(invalidProtocolVersionException, x$8)))) {
                    throw invalidProtocolVersionException.copy((String)DeltaTableV2$.tableNameToUse$1(tableNameToUse$lzy, catalogTable, tableName).get(), invalidProtocolVersionException.copy$default$2(), invalidProtocolVersionException.copy$default$3(), invalidProtocolVersionException.copy$default$4(), invalidProtocolVersionException.copy$default$5()).initCause(invalidProtocolVersionException);
                }
            }
            if (throwable2 instanceof DeltaUnsupportedTableFeatureException) {
                DeltaUnsupportedTableFeatureException deltaUnsupportedTableFeatureException = (DeltaUnsupportedTableFeatureException)throwable2;
                if (DeltaTableV2$.tableNameToUse$1(tableNameToUse$lzy, catalogTable, tableName).exists((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)DeltaTableV2$.$anonfun$withEnrichedUnsupportedTableException$2(deltaUnsupportedTableFeatureException, x$9)))) {
                    String x$1 = (String)DeltaTableV2$.tableNameToUse$1(tableNameToUse$lzy, catalogTable, tableName).get();
                    String x$2 = deltaUnsupportedTableFeatureException.copy$default$1();
                    Iterable<String> x$3 = deltaUnsupportedTableFeatureException.copy$default$3();
                    throw deltaUnsupportedTableFeatureException.copy(x$2, x$1, x$3).initCause(deltaUnsupportedTableFeatureException);
                }
            }
            throw throwable;
        }
        return (T)object;
    }

    public <T> Option<String> withEnrichedUnsupportedTableException$default$2() {
        return None$.MODULE$;
    }

    private static final /* synthetic */ Option tableNameToUse$lzycompute$1(LazyRef tableNameToUse$lzy$1, Option catalogTable$2, Option tableName$1) {
        Option option;
        LazyRef lazyRef = tableNameToUse$lzy$1;
        synchronized (lazyRef) {
            Option option2;
            if (tableNameToUse$lzy$1.initialized()) {
                option2 = (Option)tableNameToUse$lzy$1.value();
            } else {
                Option option3;
                Option option4 = catalogTable$2;
                if (option4 instanceof Some) {
                    Some some = (Some)option4;
                    CatalogTable ct = (CatalogTable)some.value();
                    None$ x$1 = None$.MODULE$;
                    String x$2 = ct.identifier().copy$default$1();
                    Option x$3 = ct.identifier().copy$default$2();
                    Some some2 = new Some((Object)ct.identifier().copy(x$2, x$3, (Option)x$1).unquotedString());
                    option3 = some2;
                } else if (None$.MODULE$.equals(option4)) {
                    option3 = tableName$1;
                } else {
                    throw new MatchError((Object)option4);
                }
                option2 = (Option)tableNameToUse$lzy$1.initialize((Object)option3);
            }
            option = option2;
        }
        return option;
    }

    private static final Option tableNameToUse$1(LazyRef tableNameToUse$lzy$1, Option catalogTable$2, Option tableName$1) {
        if (tableNameToUse$lzy$1.initialized()) {
            return (Option)tableNameToUse$lzy$1.value();
        }
        return DeltaTableV2$.tableNameToUse$lzycompute$1(tableNameToUse$lzy$1, catalogTable$2, tableName$1);
    }

    public static final /* synthetic */ boolean $anonfun$withEnrichedUnsupportedTableException$1(InvalidProtocolVersionException x10$1, String x$8) {
        String string = x$8;
        String string2 = x10$1.tableNameOrPath();
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$withEnrichedUnsupportedTableException$2(DeltaUnsupportedTableFeatureException x11$1, String x$9) {
        String string = x$9;
        String string2 = x11$1.tableNameOrPath();
        return string == null ? string2 != null : !string.equals(string2);
    }

    private DeltaTableV2$() {
    }
}

