/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.commands;

import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.MDC;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.delta.DeletionVectorsTableFeature$;
import org.apache.spark.sql.delta.DeltaConfigs$;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaOperations;
import org.apache.spark.sql.delta.IcebergCompat$;
import org.apache.spark.sql.delta.IcebergCompatBase;
import org.apache.spark.sql.delta.OptimisticTransaction;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.UniversalFormat$;
import org.apache.spark.sql.delta.actions.Action;
import org.apache.spark.sql.delta.actions.AddFile$Tags$ICEBERG_COMPAT_VERSION$;
import org.apache.spark.sql.delta.actions.Format;
import org.apache.spark.sql.delta.actions.Metadata;
import org.apache.spark.sql.delta.actions.Protocol$;
import org.apache.spark.sql.delta.catalog.DeltaTableV2;
import org.apache.spark.sql.delta.commands.AlterTableSetPropertiesDeltaCommand;
import org.apache.spark.sql.delta.logging.DeltaLogKeys$;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.util.Utils$;
import org.apache.spark.sql.functions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.MapOps;
import scala.collection.SetOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005UaaB\u0005\u000b!\u0003\r\ta\u0006\u0005\u0006I\u0001!\t!\n\u0005\bS\u0001\u0011\r\u0011\"\u0003+\u0011\u0015a\u0004\u0001\"\u0003>\u0011\u0015)\u0005A\"\u0001G\u0011\u0015I\u0006\u0001\"\u0003[\u0011\u0015q\u0007\u0001\"\u0003p\u0011\u0015q\b\u0001\"\u0003\u0000\u0011\u001d\tY\u0001\u0001C\t\u0003\u001b\u0011\u0011EU3pe\u001e$\u0016M\u00197f\r>\u0014X\u000b]4sC\u0012,WK\\5g_Jl\u0007*\u001a7qKJT!a\u0003\u0007\u0002\u0011\r|W.\\1oINT!!\u0004\b\u0002\u000b\u0011,G\u000e^1\u000b\u0005=\u0001\u0012aA:rY*\u0011\u0011CE\u0001\u0006gB\f'o\u001b\u0006\u0003'Q\ta!\u00199bG\",'\"A\u000b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001Ab\u0004\u0005\u0002\u001a95\t!DC\u0001\u001c\u0003\u0015\u00198-\u00197b\u0013\ti\"D\u0001\u0004B]f\u0014VM\u001a\t\u0003?\tj\u0011\u0001\t\u0006\u0003C1\t\u0001\"\\3uKJLgnZ\u0005\u0003G\u0001\u0012A\u0002R3mi\u0006dunZ4j]\u001e\fa\u0001J5oSR$C#\u0001\u0014\u0011\u0005e9\u0013B\u0001\u0015\u001b\u0005\u0011)f.\u001b;\u0002#I,wO]5uK\u000eCWmY6UC\ndW-F\u0001,!\u0011a3GN\u001d\u000f\u00055\n\u0004C\u0001\u0018\u001b\u001b\u0005y#B\u0001\u0019\u0017\u0003\u0019a$o\\8u}%\u0011!GG\u0001\u0007!J,G-\u001a4\n\u0005Q*$aA'ba*\u0011!G\u0007\t\u00033]J!\u0001\u000f\u000e\u0003\u0007%sG\u000fE\u0002-uYJ!aO\u001b\u0003\u0007M+G/A\ttQ\u0006dGn\u00115fG.\u0014Vm\u001e:ji\u0016$2AP!D!\tIr(\u0003\u0002A5\t9!i\\8mK\u0006t\u0007\"\u0002\"\u0004\u0001\u00041\u0014AC8mIZ+'o]5p]\")Ai\u0001a\u0001m\u0005Qa.Z<WKJ\u001c\u0018n\u001c8\u0002\u001f=\u0004H/[7ju\u0016\u0014\u0015PU3pe\u001e$\"a\u0012+\u0011\u0007!k\u0005K\u0004\u0002J\u0017:\u0011aFS\u0005\u00027%\u0011AJG\u0001\ba\u0006\u001c7.Y4f\u0013\tquJA\u0002TKFT!\u0001\u0014\u000e\u0011\u0005E\u0013V\"\u0001\b\n\u0005Ms!a\u0001*po\")Q\u000b\u0002a\u0001-\u0006a1\u000f]1sWN+7o]5p]B\u0011\u0011kV\u0005\u00031:\u0011Ab\u00159be.\u001cVm]:j_:\f1#\u001a8bE2,\u0017jY3cKJ<7i\\7qCR$BAJ.dQ\")A,\u0002a\u0001;\u0006)A/\u00192mKB\u0011a,Y\u0007\u0002?*\u0011\u0001\rD\u0001\bG\u0006$\u0018\r\\8h\u0013\t\u0011wL\u0001\u0007EK2$\u0018\rV1cY\u00164&\u0007C\u0003e\u000b\u0001\u0007Q-\u0001\u000bdkJ\u0014XM\u001c;D_6\u0004\u0018\r\u001e,feNLwN\u001c\t\u00043\u00194\u0014BA4\u001b\u0005\u0019y\u0005\u000f^5p]\")\u0011.\u0002a\u0001U\u0006q1m\\7qCR$v.\u00128bE2,\u0007CA6m\u001b\u0005a\u0011BA7\r\u0005EI5-\u001a2fe\u001e\u001cu.\u001c9bi\n\u000b7/Z\u0001\u0011O\u0016$h*^7PM\u0006#GMR5mKN$B\u0001\u001d<ysB!\u0011$]:t\u0013\t\u0011(D\u0001\u0004UkBdWM\r\t\u00033QL!!\u001e\u000e\u0003\t1{gn\u001a\u0005\u0006o\u001a\u0001\rAN\u0001\u0015S\u000e,'-\u001a:h\u0007>l\u0007/\u0019;WKJ\u001c\u0018n\u001c8\t\u000bq3\u0001\u0019A/\t\u000bi4\u0001\u0019A>\u0002\u0011Mt\u0017\r]:i_R\u0004\"a\u001b?\n\u0005ud!\u0001C*oCB\u001c\bn\u001c;\u0002\u0013\u0011|'+Z<sSR,GcB$\u0002\u0002\u0005\u0015\u0011q\u0001\u0005\u0007\u0003\u00079\u0001\u0019A/\u0002\rQ\f'oZ3u\u0011\u0015)v\u00011\u0001W\u0011\u0019\tIa\u0002a\u0001m\u0005QB/\u0019:hKRL5-\u001a2fe\u001e\u001cu.\u001c9biZ+'o]5p]\u0006\u0011S\u000f]4sC\u0012,WK\\5g_Jl\u0017jY3cKJ<7i\\7qCR4VM]:j_:$raRA\b\u0003#\t\u0019\u0002\u0003\u0004\u0002\u0004!\u0001\r!\u0018\u0005\u0006+\"\u0001\rA\u0016\u0005\u0007\u0003\u0013A\u0001\u0019\u0001\u001c")
public interface ReorgTableForUpgradeUniformHelper
extends DeltaLogging {
    public void org$apache$spark$sql$delta$commands$ReorgTableForUpgradeUniformHelper$_setter_$org$apache$spark$sql$delta$commands$ReorgTableForUpgradeUniformHelper$$rewriteCheckTable_$eq(Map<Object, Set<Object>> var1);

    public Map<Object, Set<Object>> org$apache$spark$sql$delta$commands$ReorgTableForUpgradeUniformHelper$$rewriteCheckTable();

    private boolean shallCheckRewrite(int oldVersion, int newVersion) {
        return ((SetOps)this.org$apache$spark$sql$delta$commands$ReorgTableForUpgradeUniformHelper$$rewriteCheckTable().getOrElse((Object)BoxesRunTime.boxToInteger((int)oldVersion), (Function0 & Serializable)() -> Predef$.MODULE$.Set().empty())).contains((Object)BoxesRunTime.boxToInteger((int)newVersion));
    }

    public Seq<Row> optimizeByReorg(SparkSession var1);

    private void enableIcebergCompat(DeltaTableV2 table, Option<Object> currentCompatVersion, IcebergCompatBase compatToEnable) {
        OptimisticTransaction alterConfTxn;
        Map newConf = (Map)((MapOps)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)compatToEnable.config().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DeltaConfigs$.MODULE$.COLUMN_MAPPING_MODE().key()), (Object)"name")}))).$plus$plus((IterableOnce)currentCompatVersion.map((Function1 & Serializable)x$1 -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)IcebergCompat$.MODULE$.getForVersion(BoxesRunTime.unboxToInt((Object)x$1)).config().key()), (Object)"false")));
        if (compatToEnable.incompatibleTableFeatures().contains((Object)DeletionVectorsTableFeature$.MODULE$)) {
            newConf = (Map)newConf.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DeltaConfigs$.MODULE$.ENABLE_DELETION_VECTORS_CREATION().key()), (Object)"false"));
        }
        if ((alterConfTxn = table.startTransaction(table.startTransaction$default$1())).protocol().minWriterVersion() < 7) {
            newConf = (Map)newConf.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Protocol$.MODULE$.MIN_WRITER_VERSION_PROP()), (Object)"7"));
        }
        if (alterConfTxn.protocol().minReaderVersion() < 3) {
            newConf = (Map)newConf.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Protocol$.MODULE$.MIN_READER_VERSION_PROP()), (Object)"3"));
        }
        Metadata metadata = alterConfTxn.metadata();
        String x$12 = metadata.description();
        Map x$2 = (Map)metadata.configuration().$plus$plus((IterableOnce)newConf);
        String x$3 = metadata.copy$default$1();
        String x$4 = metadata.copy$default$2();
        Format x$5 = metadata.copy$default$4();
        String x$6 = metadata.copy$default$5();
        Seq<String> x$7 = metadata.copy$default$6();
        Option<Object> x$8 = metadata.copy$default$8();
        Metadata newMetadata = metadata.copy(x$3, x$4, x$12, x$5, x$6, x$7, (Map<String, String>)x$2, x$8);
        alterConfTxn.updateMetadata(newMetadata, alterConfTxn.updateMetadata$default$2());
        alterConfTxn.commit((Seq<Action>)Nil$.MODULE$, new DeltaOperations.UpgradeUniformProperties((Map<String, String>)newConf));
    }

    private Tuple2<Object, Object> getNumOfAddFiles(int icebergCompatVersion, DeltaTableV2 table, Snapshot snapshot) {
        long numOfAddFilesWithTag = snapshot.allFiles().select("tags", (Seq)Nil$.MODULE$).where(Utils$.MODULE$.try_element_at(functions$.MODULE$.col("tags"), AddFile$Tags$ICEBERG_COMPAT_VERSION$.MODULE$.name()).$eq$eq$eq((Object)Integer.toString(icebergCompatVersion))).count();
        long numOfAddFiles = snapshot.numOfFiles();
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"For table ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)DeltaLogKeys$.MODULE$.TABLE_NAME(), table.tableIdentifier())})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"at version ", ", there are "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)DeltaLogKeys$.MODULE$.VERSION(), (Object)BoxesRunTime.boxToLong((long)snapshot.version()))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " addFiles, and "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)DeltaLogKeys$.MODULE$.NUM_FILES(), (Object)BoxesRunTime.boxToLong((long)numOfAddFiles))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " addFiles with "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)DeltaLogKeys$.MODULE$.NUM_FILES2(), (Object)BoxesRunTime.boxToLong((long)numOfAddFilesWithTag))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"ICEBERG_COMPAT_VERSION=", " tag."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)DeltaLogKeys$.MODULE$.VERSION2(), (Object)BoxesRunTime.boxToLong((long)icebergCompatVersion))})))));
        return new Tuple2.mcJJ.sp(numOfAddFiles, numOfAddFilesWithTag);
    }

    private Seq<Row> doRewrite(DeltaTableV2 target, SparkSession sparkSession, int targetIcebergCompatVersion) {
        Tuple2 tuple2;
        Tuple2 tuple22;
        boolean allAddFilesHaveTag;
        boolean bl;
        Snapshot snapshot = target.update();
        Option<Object> currIcebergCompatVersionOpt = IcebergCompat$.MODULE$.getEnabledVersion(snapshot.metadata());
        IcebergCompatBase targetIcebergCompatObject = IcebergCompat$.MODULE$.getForVersion(targetIcebergCompatVersion);
        boolean mayNeedRewrite = this.shallCheckRewrite(BoxesRunTime.unboxToInt((Object)currIcebergCompatVersionOpt.getOrElse((Function0)(JFunction0.mcI.sp & Serializable)() -> 0)), targetIcebergCompatVersion);
        if (!currIcebergCompatVersionOpt.contains((Object)BoxesRunTime.boxToInteger((int)targetIcebergCompatVersion))) {
            this.enableIcebergCompat(target, currIcebergCompatVersionOpt, targetIcebergCompatObject);
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Update table ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)DeltaLogKeys$.MODULE$.TABLE_NAME(), target.tableIdentifier())})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"to iceberg compat version = "}))).log((Seq)Nil$.MODULE$)).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " successfully."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)DeltaLogKeys$.MODULE$.VERSION(), (Object)BoxesRunTime.boxToInteger((int)targetIcebergCompatVersion))})))));
            bl = true;
        } else {
            bl = false;
        }
        boolean didUpdateIcebergCompatVersion = bl;
        Tuple2<Object, Object> tuple23 = this.getNumOfAddFiles(targetIcebergCompatVersion, target, snapshot);
        if (tuple23 == null) {
            throw new MatchError(tuple23);
        }
        long numOfAddFilesBefore = tuple23._1$mcJ$sp();
        long numOfAddFilesWithTagBefore = tuple23._2$mcJ$sp();
        Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(numOfAddFilesBefore, numOfAddFilesWithTagBefore);
        long numOfAddFilesBefore2 = sp2._1$mcJ$sp();
        long numOfAddFilesWithTagBefore2 = sp2._2$mcJ$sp();
        boolean bl2 = allAddFilesHaveTag = numOfAddFilesWithTagBefore2 == numOfAddFilesBefore2;
        if (mayNeedRewrite && !allAddFilesHaveTag) {
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Reorg Table ", " to "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)DeltaLogKeys$.MODULE$.TABLE_NAME(), target.tableIdentifier())})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"iceberg compat version = ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)DeltaLogKeys$.MODULE$.VERSION(), (Object)BoxesRunTime.boxToInteger((int)targetIcebergCompatVersion))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"need rewrite data files."}))).log((Seq)Nil$.MODULE$))));
            Seq metrics = this.liftedTree1$1(sparkSession, targetIcebergCompatVersion);
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Rewrite table ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)DeltaLogKeys$.MODULE$.TABLE_NAME(), target.tableIdentifier())})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"to iceberg compat version = ", " successfully."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)DeltaLogKeys$.MODULE$.VERSION(), (Object)BoxesRunTime.boxToInteger((int)targetIcebergCompatVersion))})))));
            tuple22 = new Tuple2((Object)new Some((Object)metrics), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        } else {
            tuple22 = tuple2 = new Tuple2((Object)None$.MODULE$, (Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Option metricsOpt = (Option)tuple2._1();
        boolean didRewrite = tuple2._2$mcZ$sp();
        Tuple2 tuple24 = new Tuple2((Object)metricsOpt, (Object)BoxesRunTime.boxToBoolean((boolean)didRewrite));
        Option metricsOpt2 = (Option)tuple24._1();
        boolean didRewrite2 = tuple24._2$mcZ$sp();
        Snapshot updatedSnapshot = target.deltaLog().update(target.deltaLog().update$default$1(), target.deltaLog().update$default$2(), target.deltaLog().update$default$3());
        Tuple2<Object, Object> tuple25 = this.getNumOfAddFiles(targetIcebergCompatVersion, target, updatedSnapshot);
        if (tuple25 == null) {
            throw new MatchError(tuple25);
        }
        long numOfAddFiles = tuple25._1$mcJ$sp();
        long numOfAddFilesWithIcebergCompatTag = tuple25._2$mcJ$sp();
        Tuple2.mcJJ.sp sp3 = new Tuple2.mcJJ.sp(numOfAddFiles, numOfAddFilesWithIcebergCompatTag);
        long numOfAddFiles2 = sp3._1$mcJ$sp();
        long numOfAddFilesWithIcebergCompatTag2 = sp3._2$mcJ$sp();
        if (mayNeedRewrite && numOfAddFilesWithIcebergCompatTag2 != numOfAddFiles2) {
            throw DeltaErrors$.MODULE$.icebergCompatReorgAddFileTagsMissingException(updatedSnapshot.version(), targetIcebergCompatVersion, numOfAddFiles2, numOfAddFilesWithIcebergCompatTag2);
        }
        if (!UniversalFormat$.MODULE$.icebergEnabled(updatedSnapshot.metadata())) {
            Map enableUniformConf = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DeltaConfigs$.MODULE$.UNIVERSAL_FORMAT_ENABLED_FORMATS().key()), (Object)UniversalFormat$.MODULE$.ICEBERG_FORMAT())}));
            new AlterTableSetPropertiesDeltaCommand(target, (Map<String, String>)enableUniformConf).run(sparkSession);
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Enabling universal format with iceberg compat version = "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " for table "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)DeltaLogKeys$.MODULE$.VERSION(), (Object)BoxesRunTime.boxToInteger((int)targetIcebergCompatVersion))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " succeeded."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)DeltaLogKeys$.MODULE$.TABLE_NAME(), target.tableIdentifier())})))));
        }
        DeltaLog x$1 = updatedSnapshot.deltaLog();
        String x$2 = "delta.upgradeUniform.success";
        Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"currIcebergCompatVersion"), (Object)currIcebergCompatVersionOpt.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetIcebergCompatVersion"), (Object)Integer.toString(targetIcebergCompatVersion)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"metrics"), (Object)metricsOpt2.toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"didUpdateIcebergCompatVersion"), (Object)Boolean.toString(didUpdateIcebergCompatVersion)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"needRewrite"), (Object)Boolean.toString(mayNeedRewrite)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"didRewrite"), (Object)Boolean.toString(didRewrite2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numOfAddFilesBefore"), (Object)Long.toString(numOfAddFilesBefore2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numOfAddFilesWithIcebergCompatTagBefore"), (Object)Long.toString(numOfAddFilesWithTagBefore2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numOfAddFilesAfter"), (Object)Long.toString(numOfAddFiles2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numOfAddFilesWithIcebergCompatTagAfter"), (Object)Long.toString(numOfAddFilesWithIcebergCompatTag2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"universalFormatIcebergEnabled"), (Object)Boolean.toString(UniversalFormat$.MODULE$.icebergEnabled(target.deltaLog().update(target.deltaLog().update$default$1(), target.deltaLog().update$default$2(), target.deltaLog().update$default$3()).metadata())))}));
        Map<TagDefinition, String> x$4 = this.recordDeltaEvent$default$3();
        Option<Path> x$5 = this.recordDeltaEvent$default$5();
        this.recordDeltaEvent(x$1, "delta.upgradeUniform.success", x$4, x$3, x$5);
        return (Seq)metricsOpt2.getOrElse((Function0 & Serializable)() -> (Seq)package$.MODULE$.Seq().empty());
    }

    public static /* synthetic */ Seq upgradeUniformIcebergCompatVersion$(ReorgTableForUpgradeUniformHelper $this, DeltaTableV2 target, SparkSession sparkSession, int targetIcebergCompatVersion) {
        return $this.upgradeUniformIcebergCompatVersion(target, sparkSession, targetIcebergCompatVersion);
    }

    default public Seq<Row> upgradeUniformIcebergCompatVersion(DeltaTableV2 target, SparkSession sparkSession, int targetIcebergCompatVersion) {
        Seq<Row> seq;
        try {
            seq = this.doRewrite(target, sparkSession, targetIcebergCompatVersion);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (NonFatal$.MODULE$.apply(throwable2)) {
                DeltaLog x$1 = target.deltaLog();
                String x$2 = "delta.upgradeUniform.exception";
                Map x$3 = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetIcebergCompatVersion"), (Object)Integer.toString(targetIcebergCompatVersion)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"exception"), (Object)throwable2.toString())}));
                Map<TagDefinition, String> x$4 = this.recordDeltaEvent$default$3();
                Option<Path> x$5 = this.recordDeltaEvent$default$5();
                this.recordDeltaEvent(x$1, "delta.upgradeUniform.exception", x$4, x$3, x$5);
                throw throwable2;
            }
            throw throwable;
        }
        return seq;
    }

    private /* synthetic */ Seq liftedTree1$1(SparkSession sparkSession$1, int targetIcebergCompatVersion$1) {
        Seq<Row> seq;
        try {
            seq = this.optimizeByReorg(sparkSession$1);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (NonFatal$.MODULE$.apply(throwable2)) {
                throw DeltaErrors$.MODULE$.icebergCompatDataFileRewriteFailedException(targetIcebergCompatVersion$1, throwable2);
            }
            throw throwable;
        }
        return seq;
    }

    public static void $init$(ReorgTableForUpgradeUniformHelper $this) {
        $this.org$apache$spark$sql$delta$commands$ReorgTableForUpgradeUniformHelper$_setter_$org$apache$spark$sql$delta$commands$ReorgTableForUpgradeUniformHelper$$rewriteCheckTable_$eq((Map<Object, Set<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{2, 3})))}))));
    }
}

