/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.commands;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import java.sql.Timestamp;
import java.time.ZoneId;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.trees.LeafLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.delta.CheckpointInstance;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaOperations;
import org.apache.spark.sql.delta.DeltaOptions;
import org.apache.spark.sql.delta.DeltaTimeTravelSpec;
import org.apache.spark.sql.delta.DomainMetadataUtils$;
import org.apache.spark.sql.delta.IdentityColumn$;
import org.apache.spark.sql.delta.NumRecordsStats;
import org.apache.spark.sql.delta.OptimisticTransaction;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.actions.Action;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.delta.actions.DeletionVectorDescriptor;
import org.apache.spark.sql.delta.actions.DeletionVectorDescriptor$;
import org.apache.spark.sql.delta.actions.Format;
import org.apache.spark.sql.delta.actions.Metadata;
import org.apache.spark.sql.delta.actions.Protocol;
import org.apache.spark.sql.delta.actions.RemoveFile;
import org.apache.spark.sql.delta.actions.SetTransaction;
import org.apache.spark.sql.delta.catalog.DeltaTableV2;
import org.apache.spark.sql.delta.commands.DeletionVectorUtils$;
import org.apache.spark.sql.delta.commands.DeltaCommand;
import org.apache.spark.sql.delta.commands.DeltaCommandInvariants;
import org.apache.spark.sql.delta.commands.RestoreTableCommand$;
import org.apache.spark.sql.delta.commands.RestoreTableCommandBase;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.util.DeltaFileOperations$;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.execution.command.LeafRunnableCommand;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.SerializableConfiguration;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\t5c\u0001\u0002\u000f\u001e\u0001*B\u0001B\u0016\u0001\u0003\u0016\u0004%\ta\u0016\u0005\t=\u0002\u0011\t\u0012)A\u00051\")q\f\u0001C\u0001A\"91\r\u0001b\u0001\n\u0003\"\u0007B\u00028\u0001A\u0003%Q\rC\u0003p\u0001\u0011\u0005\u0003\u000fC\u0003{\u0001\u0011%1\u0010C\u0004\u00022\u0001!I!a\r\t\u000f\u00055\u0003\u0001\"\u0003\u0002P!9\u00111\u0012\u0001\u0005\n\u00055\u0005bBAT\u0001\u0011%\u0011\u0011\u0016\u0005\n\u0003W\u0003\u0011\u0011!C\u0001\u0003[C\u0011\"!-\u0001#\u0003%\t!a-\t\u0013\u0005%\u0007!!A\u0005B\u0005-\u0007\"CAl\u0001\u0005\u0005I\u0011AAm\u0011%\t\t\u000fAA\u0001\n\u0003\t\u0019\u000fC\u0005\u0002j\u0002\t\t\u0011\"\u0011\u0002l\"I\u0011\u0011 \u0001\u0002\u0002\u0013\u0005\u00111 \u0005\n\u0005\u000b\u0001\u0011\u0011!C!\u0005\u000fA\u0011Ba\u0003\u0001\u0003\u0003%\tE!\u0004\b\u0013\tEQ$!A\t\u0002\tMa\u0001\u0003\u000f\u001e\u0003\u0003E\tA!\u0006\t\r}3B\u0011\u0001B\u0017\u0011%\u0011yCFA\u0001\n\u000b\u0012\t\u0004C\u0005\u00034Y\t\t\u0011\"!\u00036!I!\u0011\b\f\u0002\u0002\u0013\u0005%1\b\u0005\n\u0005\u00072\u0012\u0011!C\u0005\u0005\u000b\u00121CU3ti>\u0014X\rV1cY\u0016\u001cu.\\7b]\u0012T!AH\u0010\u0002\u0011\r|W.\\1oINT!\u0001I\u0011\u0002\u000b\u0011,G\u000e^1\u000b\u0005\t\u001a\u0013aA:rY*\u0011A%J\u0001\u0006gB\f'o\u001b\u0006\u0003M\u001d\na!\u00199bG\",'\"\u0001\u0015\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000f\u0001YS'P!E\u0015B\u0011AfM\u0007\u0002[)\u0011afL\u0001\bY><\u0017nY1m\u0015\t\u0001\u0014'A\u0003qY\u0006t7O\u0003\u00023C\u0005A1-\u0019;bYf\u001cH/\u0003\u00025[\tYAj\\4jG\u0006d\u0007\u000b\\1o!\t14(D\u00018\u0015\tA\u0014(A\u0004d_6l\u0017M\u001c3\u000b\u0005i\n\u0013!C3yK\u000e,H/[8o\u0013\tatGA\nMK\u00064'+\u001e8oC\ndWmQ8n[\u0006tG\r\u0005\u0002?\u007f5\tQ$\u0003\u0002A;\taA)\u001a7uC\u000e{W.\\1oIB\u0011aHQ\u0005\u0003\u0007v\u0011qCU3ti>\u0014X\rV1cY\u0016\u001cu.\\7b]\u0012\u0014\u0015m]3\u0011\u0005\u0015CU\"\u0001$\u000b\u0003\u001d\u000bQa]2bY\u0006L!!\u0013$\u0003\u000fA\u0013x\u000eZ;diB\u00111j\u0015\b\u0003\u0019Fs!!\u0014)\u000e\u00039S!aT\u0015\u0002\rq\u0012xn\u001c;?\u0013\u00059\u0015B\u0001*G\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001V+\u0003\u0019M+'/[1mSj\f'\r\\3\u000b\u0005I3\u0015aC:pkJ\u001cW\rV1cY\u0016,\u0012\u0001\u0017\t\u00033rk\u0011A\u0017\u0006\u00037~\tqaY1uC2|w-\u0003\u0002^5\naA)\u001a7uCR\u000b'\r\\3We\u0005a1o\\;sG\u0016$\u0016M\u00197fA\u00051A(\u001b8jiz\"\"!\u00192\u0011\u0005y\u0002\u0001\"\u0002,\u0004\u0001\u0004A\u0016AB8viB,H/F\u0001f!\rYe\r[\u0005\u0003OV\u00131aU3r!\tIG.D\u0001k\u0015\tY\u0017'A\u0006fqB\u0014Xm]:j_:\u001c\u0018BA7k\u0005%\tE\u000f\u001e:jEV$X-A\u0004pkR\u0004X\u000f\u001e\u0011\u0002\u0007I,h\u000e\u0006\u0002rmB\u00191J\u001a:\u0011\u0005M$X\"A\u0011\n\u0005U\f#a\u0001*po\")AE\u0002a\u0001oB\u00111\u000f_\u0005\u0003s\u0006\u0012Ab\u00159be.\u001cVm]:j_:\fqb^5uQ\u0012+7o\u0019:jaRLwN\\\u000b\u0004y\u0006\u0005AcA?\u0002\u001eQ\u0019a0a\u0005\u0011\u0007}\f\t\u0001\u0004\u0001\u0005\u000f\u0005\rqA1\u0001\u0002\u0006\t\tA+\u0005\u0003\u0002\b\u00055\u0001cA#\u0002\n%\u0019\u00111\u0002$\u0003\u000f9{G\u000f[5oOB\u0019Q)a\u0004\n\u0007\u0005EaIA\u0002B]fD\u0001\"!\u0006\b\t\u0003\u0007\u0011qC\u0001\u0002MB!Q)!\u0007\u007f\u0013\r\tYB\u0012\u0002\ty\tLh.Y7f}!9\u0011qD\u0004A\u0002\u0005\u0005\u0012AB1di&|g\u000e\u0005\u0003\u0002$\u0005-b\u0002BA\u0013\u0003O\u0001\"!\u0014$\n\u0007\u0005%b)\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003[\tyC\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003S1\u0015a\u00049beN,7\u000b\u001e:j]\u001e$v\u000eV:\u0015\t\u0005U\u00121\t\t\u0005\u0003o\ty$\u0004\u0002\u0002:)\u0019!%a\u000f\u000b\u0005\u0005u\u0012\u0001\u00026bm\u0006LA!!\u0011\u0002:\tIA+[7fgR\fW\u000e\u001d\u0005\b\u0003\u000bB\u0001\u0019AA$\u0003%!\u0018.\\3ti\u0006l\u0007\u000fE\u0003F\u0003\u0013\n\t#C\u0002\u0002L\u0019\u0013aa\u00149uS>t\u0017AD2p[B,H/Z'fiJL7m\u001d\u000b\t\u0003#\ni&a\u001d\u0002\u0000AA\u00111EA*\u0003C\t9&\u0003\u0003\u0002V\u0005=\"aA'baB\u0019Q)!\u0017\n\u0007\u0005mcI\u0001\u0003M_:<\u0007bBA0\u0013\u0001\u0007\u0011\u0011M\u0001\u0006i>\fE\r\u001a\t\u0006g\u0006\r\u0014qM\u0005\u0004\u0003K\n#a\u0002#bi\u0006\u001cX\r\u001e\t\u0005\u0003S\ny'\u0004\u0002\u0002l)\u0019\u0011QN\u0010\u0002\u000f\u0005\u001cG/[8og&!\u0011\u0011OA6\u0005\u001d\tE\r\u001a$jY\u0016Dq!!\u001e\n\u0001\u0004\t9(\u0001\u0005u_J+Wn\u001c<f!\u0015\u0019\u00181MA=!\u0011\tI'a\u001f\n\t\u0005u\u00141\u000e\u0002\u000b%\u0016lwN^3GS2,\u0007bBAA\u0013\u0001\u0007\u00111Q\u0001\tg:\f\u0007o\u001d5piB!\u0011QQAD\u001b\u0005y\u0012bAAE?\tA1K\\1qg\"|G/\u0001\u0010dQ\u0016\u001c7n\u00158baNDw\u000e\u001e$jY\u0016\u001c\u0018I^1jY\u0006\u0014\u0017\u000e\\5usRA\u0011qRAK\u0003?\u000b\u0019\u000bE\u0002F\u0003#K1!a%G\u0005\u0011)f.\u001b;\t\u000f\u0005]%\u00021\u0001\u0002\u001a\u0006AA-\u001a7uC2{w\r\u0005\u0003\u0002\u0006\u0006m\u0015bAAO?\tAA)\u001a7uC2{w\rC\u0004\u0002\"*\u0001\r!!\u0019\u0002\u000b\u0019LG.Z:\t\u000f\u0005\u0015&\u00021\u0001\u0002X\u00059a/\u001a:tS>t\u0017\u0001D4fiRKW.Z:uC6\u0004HCAA$\u0003\u0011\u0019w\u000e]=\u0015\u0007\u0005\fy\u000bC\u0004W\u0019A\u0005\t\u0019\u0001-\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011Q\u0017\u0016\u00041\u0006]6FAA]!\u0011\tY,!2\u000e\u0005\u0005u&\u0002BA`\u0003\u0003\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\rg)\u0001\u0006b]:|G/\u0019;j_:LA!a2\u0002>\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\ti\r\u0005\u0003\u0002P\u0006UWBAAi\u0015\u0011\t\u0019.a\u000f\u0002\t1\fgnZ\u0005\u0005\u0003[\t\t.\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002\\B\u0019Q)!8\n\u0007\u0005}gIA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\u000e\u0005\u0015\b\"CAt!\u0005\u0005\t\u0019AAn\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011Q\u001e\t\u0007\u0003_\f)0!\u0004\u000e\u0005\u0005E(bAAz\r\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005]\u0018\u0011\u001f\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002~\n\r\u0001cA#\u0002\u0000&\u0019!\u0011\u0001$\u0003\u000f\t{w\u000e\\3b]\"I\u0011q\u001d\n\u0002\u0002\u0003\u0007\u0011QB\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002N\n%\u0001\"CAt'\u0005\u0005\t\u0019AAn\u0003\u0019)\u0017/^1mgR!\u0011Q B\b\u0011%\t9\u000fFA\u0001\u0002\u0004\ti!A\nSKN$xN]3UC\ndWmQ8n[\u0006tG\r\u0005\u0002?-M)aCa\u0006\u0003$A1!\u0011\u0004B\u00101\u0006l!Aa\u0007\u000b\u0007\tua)A\u0004sk:$\u0018.\\3\n\t\t\u0005\"1\u0004\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\f\u0004\u0003\u0002B\u0013\u0005Wi!Aa\n\u000b\t\t%\u00121H\u0001\u0003S>L1\u0001\u0016B\u0014)\t\u0011\u0019\"\u0001\u0005u_N#(/\u001b8h)\t\ti-A\u0003baBd\u0017\u0010F\u0002b\u0005oAQAV\rA\u0002a\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003>\t}\u0002\u0003B#\u0002JaC\u0001B!\u0011\u001b\u0003\u0003\u0005\r!Y\u0001\u0004q\u0012\u0002\u0014\u0001D<sSR,'+\u001a9mC\u000e,GC\u0001B$!\u0011\tyM!\u0013\n\t\t-\u0013\u0011\u001b\u0002\u0007\u001f\nTWm\u0019;")
public class RestoreTableCommand
extends LogicalPlan
implements LeafRunnableCommand,
DeltaCommand,
RestoreTableCommandBase,
Serializable {
    private final DeltaTableV2 sourceTable;
    private final Seq<Attribute> output;
    private String TABLE_SIZE_AFTER_RESTORE;
    private String NUM_OF_FILES_AFTER_RESTORE;
    private String NUM_REMOVED_FILES;
    private String NUM_RESTORED_FILES;
    private String REMOVED_FILES_SIZE;
    private String RESTORED_FILES_SIZE;
    private String org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_TABLE_SIZE_AFTER_RESTORE;
    private String org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_NUM_OF_FILES_AFTER_RESTORE;
    private String org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_NUM_REMOVED_FILES;
    private String org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_NUM_RESTORED_FILES;
    private String org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_REMOVED_FILES_SIZE;
    private String org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_RESTORED_FILES_SIZE;
    private Seq<Attribute> outputSchema;
    private Map<String, SQLMetric> metrics;
    private Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;

    public static Option<DeltaTableV2> unapply(RestoreTableCommand x$0) {
        return RestoreTableCommand$.MODULE$.unapply(x$0);
    }

    public static <A> Function1<DeltaTableV2, A> andThen(Function1<RestoreTableCommand, A> g) {
        return RestoreTableCommand$.MODULE$.andThen(g);
    }

    public static <A> Function1<A, RestoreTableCommand> compose(Function1<A, DeltaTableV2> g) {
        return RestoreTableCommand$.MODULE$.compose(g);
    }

    @Override
    public Seq<Expression> parsePredicates(SparkSession spark, String predicate) {
        return DeltaCommand.parsePredicates$(this, spark, predicate);
    }

    @Override
    public void verifyPartitionPredicates(SparkSession spark, Seq<String> partitionColumns, Seq<Expression> predicates) {
        DeltaCommand.verifyPartitionPredicates$(this, spark, partitionColumns, predicates);
    }

    @Override
    public Map<String, AddFile> generateCandidateFileMap(Path basePath, Seq<AddFile> candidateFiles) {
        return DeltaCommand.generateCandidateFileMap$(this, basePath, candidateFiles);
    }

    @Override
    public Seq<RemoveFile> removeFilesFromPaths(DeltaLog deltaLog, Map<String, AddFile> nameToAddFileMap, Seq<String> filesToRewrite, long operationTimestamp) {
        return DeltaCommand.removeFilesFromPaths$(this, deltaLog, nameToAddFileMap, filesToRewrite, operationTimestamp);
    }

    @Override
    public HadoopFsRelation buildBaseRelation(SparkSession spark, OptimisticTransaction txn, String actionType, Path rootPath, Seq<String> inputLeafFiles, Map<String, AddFile> nameToAddFileMap) {
        return DeltaCommand.buildBaseRelation$(this, spark, txn, actionType, rootPath, inputLeafFiles, nameToAddFileMap);
    }

    @Override
    public AddFile getTouchedFile(Path basePath, String escapedFilePath, Map<String, AddFile> nameToAddFileMap) {
        return DeltaCommand.getTouchedFile$(this, basePath, escapedFilePath, nameToAddFileMap);
    }

    @Override
    public LogicalPlan resolveIdentifier(Analyzer analyzer, TableIdentifier identifier) {
        return DeltaCommand.resolveIdentifier$(this, analyzer, identifier);
    }

    @Override
    public boolean isCatalogTable(Analyzer analyzer, TableIdentifier tableIdent) {
        return DeltaCommand.isCatalogTable$(this, analyzer, tableIdent);
    }

    @Override
    public boolean isPathIdentifier(TableIdentifier tableIdent) {
        return DeltaCommand.isPathIdentifier$(this, tableIdent);
    }

    @Override
    public DeltaLog getDeltaLog(SparkSession spark, Option<String> path, Option<TableIdentifier> tableIdentifier, String operationName, Map<String, String> hadoopConf) {
        return DeltaCommand.getDeltaLog$(this, spark, path, tableIdentifier, operationName, hadoopConf);
    }

    @Override
    public Map<String, String> getDeltaLog$default$5() {
        return DeltaCommand.getDeltaLog$default$5$(this);
    }

    @Override
    public void sendDriverMetrics(SparkSession spark, Map<String, SQLMetric> metrics) {
        DeltaCommand.sendDriverMetrics$(this, spark, metrics);
    }

    @Override
    public DeltaTableV2 getDeltaTable(LogicalPlan target, String cmd) {
        return DeltaCommand.getDeltaTable$(this, target, cmd);
    }

    @Override
    public Option<CatalogTable> getTableCatalogTable(LogicalPlan target, String cmd) {
        return DeltaCommand.getTableCatalogTable$(this, target, cmd);
    }

    @Override
    public Tuple2<Option<TableIdentifier>, Option<String>> getDeltaTablePathOrIdentifier(LogicalPlan target, String cmd) {
        return DeltaCommand.getDeltaTablePathOrIdentifier$(this, target, cmd);
    }

    @Override
    public Tuple2<Option<TableIdentifier>, Option<String>> getTablePathOrIdentifier(LogicalPlan target, String cmd) {
        return DeltaCommand.getTablePathOrIdentifier$(this, target, cmd);
    }

    @Override
    public boolean hasBeenExecuted(OptimisticTransaction txn, SparkSession sparkSession, Option<DeltaOptions> options) {
        return DeltaCommand.hasBeenExecuted$(this, txn, sparkSession, options);
    }

    @Override
    public Option<DeltaOptions> hasBeenExecuted$default$3() {
        return DeltaCommand.hasBeenExecuted$default$3$(this);
    }

    @Override
    public Option<SetTransaction> createSetTransaction(SparkSession sparkSession, DeltaLog deltaLog, Option<DeltaOptions> options) {
        return DeltaCommand.createSetTransaction$(this, sparkSession, deltaLog, options);
    }

    @Override
    public Option<DeltaOptions> createSetTransaction$default$3() {
        return DeltaCommand.createSetTransaction$default$3$(this);
    }

    @Override
    public void logNumRecordsMismatch(DeltaLog deltaLog, Seq<Action> actions, NumRecordsStats stats, DeltaOperations.Operation op) {
        DeltaCommand.logNumRecordsMismatch$(this, deltaLog, actions, stats, op);
    }

    @Override
    public void checkCommandInvariant(Function0<Object> invariant, String label, DeltaOperations.Operation op, DeltaLog deltaLog, Function0<Map<String, Object>> parameters, Function0<Map<String, String>> additionalInfo) {
        DeltaCommandInvariants.checkCommandInvariant$(this, invariant, label, op, deltaLog, parameters, additionalInfo);
    }

    @Override
    public Map<String, String> checkCommandInvariant$default$6() {
        return DeltaCommandInvariants.checkCommandInvariant$default$6$(this);
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data, Option<Path> path) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data, path);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public Option<Path> recordDeltaEvent$default$5() {
        return DeltaLogging.recordDeltaEvent$default$5$(this);
    }

    @Override
    public <A> A recordDeltaOperationForTablePath(String tablePath, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperationForTablePath$(this, tablePath, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperationForTablePath$default$3() {
        return DeltaLogging.recordDeltaOperationForTablePath$default$3$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public void deltaAssert(Function0<Object> check, String name, String msg, DeltaLog deltaLog, Object data, Option<Path> path) {
        DeltaLogging.deltaAssert$(this, check, name, msg, deltaLog, data, path);
    }

    @Override
    public DeltaLog deltaAssert$default$4() {
        return DeltaLogging.deltaAssert$default$4$(this);
    }

    @Override
    public Object deltaAssert$default$5() {
        return DeltaLogging.deltaAssert$default$5$(this);
    }

    @Override
    public Option<Path> deltaAssert$default$6() {
        return DeltaLogging.deltaAssert$default$6$(this);
    }

    @Override
    public <T> T recordFrameProfile(String group, String name, Function0<T> thunk) {
        return (T)DeltaLogging.recordFrameProfile$(this, group, name, thunk);
    }

    @Override
    public Map<TagDefinition, String> getCommonTags(DeltaLog deltaLog, String tahoeId) {
        return DeltaLogging.getCommonTags$(this, deltaLog, tahoeId);
    }

    @Override
    public Map<String, Object> getErrorData(Throwable e) {
        return DeltaLogging.getErrorData$(this, e);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public void recordProductUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordProductUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordProductUsage$default$3() {
        return DatabricksLogging.recordProductUsage$default$3$(this);
    }

    @Override
    public String recordProductUsage$default$4() {
        return DatabricksLogging.recordProductUsage$default$4$(this);
    }

    @Override
    public boolean recordProductUsage$default$5() {
        return DatabricksLogging.recordProductUsage$default$5$(this);
    }

    @Override
    public boolean recordProductUsage$default$6() {
        return DatabricksLogging.recordProductUsage$default$6$(this);
    }

    @Override
    public boolean recordProductUsage$default$7() {
        return DatabricksLogging.recordProductUsage$default$7$(this);
    }

    @Override
    public void recordProductEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordProductEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordProductEvent$default$2() {
        return DatabricksLogging.recordProductEvent$default$2$(this);
    }

    @Override
    public String recordProductEvent$default$3() {
        return DatabricksLogging.recordProductEvent$default$3$(this);
    }

    @Override
    public boolean recordProductEvent$default$4() {
        return DatabricksLogging.recordProductEvent$default$4$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    public final Seq<LogicalPlan> children() {
        return LeafLike.children$((LeafLike)this);
    }

    public final TreeNode mapChildren(Function1 f) {
        return LeafLike.mapChildren$((LeafLike)this, (Function1)f);
    }

    public TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return LeafLike.withNewChildrenInternal$((LeafLike)this, (IndexedSeq)newChildren);
    }

    public AttributeSet producedAttributes() {
        return Command.producedAttributes$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    @Override
    public String TABLE_SIZE_AFTER_RESTORE() {
        return this.TABLE_SIZE_AFTER_RESTORE;
    }

    @Override
    public String NUM_OF_FILES_AFTER_RESTORE() {
        return this.NUM_OF_FILES_AFTER_RESTORE;
    }

    @Override
    public String NUM_REMOVED_FILES() {
        return this.NUM_REMOVED_FILES;
    }

    @Override
    public String NUM_RESTORED_FILES() {
        return this.NUM_RESTORED_FILES;
    }

    @Override
    public String REMOVED_FILES_SIZE() {
        return this.REMOVED_FILES_SIZE;
    }

    @Override
    public String RESTORED_FILES_SIZE() {
        return this.RESTORED_FILES_SIZE;
    }

    @Override
    public String org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_TABLE_SIZE_AFTER_RESTORE() {
        return this.org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_TABLE_SIZE_AFTER_RESTORE;
    }

    @Override
    public String org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_NUM_OF_FILES_AFTER_RESTORE() {
        return this.org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_NUM_OF_FILES_AFTER_RESTORE;
    }

    @Override
    public String org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_NUM_REMOVED_FILES() {
        return this.org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_NUM_REMOVED_FILES;
    }

    @Override
    public String org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_NUM_RESTORED_FILES() {
        return this.org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_NUM_RESTORED_FILES;
    }

    @Override
    public String org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_REMOVED_FILES_SIZE() {
        return this.org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_REMOVED_FILES_SIZE;
    }

    @Override
    public String org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_RESTORED_FILES_SIZE() {
        return this.org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_RESTORED_FILES_SIZE;
    }

    @Override
    public Seq<Attribute> outputSchema() {
        return this.outputSchema;
    }

    @Override
    public void org$apache$spark$sql$delta$commands$RestoreTableCommandBase$_setter_$TABLE_SIZE_AFTER_RESTORE_$eq(String x$1) {
        this.TABLE_SIZE_AFTER_RESTORE = x$1;
    }

    @Override
    public void org$apache$spark$sql$delta$commands$RestoreTableCommandBase$_setter_$NUM_OF_FILES_AFTER_RESTORE_$eq(String x$1) {
        this.NUM_OF_FILES_AFTER_RESTORE = x$1;
    }

    @Override
    public void org$apache$spark$sql$delta$commands$RestoreTableCommandBase$_setter_$NUM_REMOVED_FILES_$eq(String x$1) {
        this.NUM_REMOVED_FILES = x$1;
    }

    @Override
    public void org$apache$spark$sql$delta$commands$RestoreTableCommandBase$_setter_$NUM_RESTORED_FILES_$eq(String x$1) {
        this.NUM_RESTORED_FILES = x$1;
    }

    @Override
    public void org$apache$spark$sql$delta$commands$RestoreTableCommandBase$_setter_$REMOVED_FILES_SIZE_$eq(String x$1) {
        this.REMOVED_FILES_SIZE = x$1;
    }

    @Override
    public void org$apache$spark$sql$delta$commands$RestoreTableCommandBase$_setter_$RESTORED_FILES_SIZE_$eq(String x$1) {
        this.RESTORED_FILES_SIZE = x$1;
    }

    @Override
    public final void org$apache$spark$sql$delta$commands$RestoreTableCommandBase$_setter_$org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_TABLE_SIZE_AFTER_RESTORE_$eq(String x$1) {
        this.org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_TABLE_SIZE_AFTER_RESTORE = x$1;
    }

    @Override
    public final void org$apache$spark$sql$delta$commands$RestoreTableCommandBase$_setter_$org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_NUM_OF_FILES_AFTER_RESTORE_$eq(String x$1) {
        this.org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_NUM_OF_FILES_AFTER_RESTORE = x$1;
    }

    @Override
    public final void org$apache$spark$sql$delta$commands$RestoreTableCommandBase$_setter_$org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_NUM_REMOVED_FILES_$eq(String x$1) {
        this.org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_NUM_REMOVED_FILES = x$1;
    }

    @Override
    public final void org$apache$spark$sql$delta$commands$RestoreTableCommandBase$_setter_$org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_NUM_RESTORED_FILES_$eq(String x$1) {
        this.org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_NUM_RESTORED_FILES = x$1;
    }

    @Override
    public final void org$apache$spark$sql$delta$commands$RestoreTableCommandBase$_setter_$org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_REMOVED_FILES_SIZE_$eq(String x$1) {
        this.org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_REMOVED_FILES_SIZE = x$1;
    }

    @Override
    public final void org$apache$spark$sql$delta$commands$RestoreTableCommandBase$_setter_$org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_RESTORED_FILES_SIZE_$eq(String x$1) {
        this.org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_RESTORED_FILES_SIZE = x$1;
    }

    @Override
    public void org$apache$spark$sql$delta$commands$RestoreTableCommandBase$_setter_$outputSchema_$eq(Seq<Attribute> x$1) {
        this.outputSchema = x$1;
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        RestoreTableCommand restoreTableCommand = this;
        synchronized (restoreTableCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$((RunnableCommand)this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    public Map<String, SQLMetric> metrics() {
        if (!this.bitmap$0) {
            return this.metrics$lzycompute();
        }
        return this.metrics;
    }

    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    public final void org$apache$spark$sql$catalyst$plans$logical$Command$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public DeltaTableV2 sourceTable() {
        return this.sourceTable;
    }

    public Seq<Attribute> output() {
        return this.output;
    }

    public Seq<Row> run(SparkSession spark) {
        DeltaLog deltaLog = this.sourceTable().deltaLog();
        Option<CatalogTable> catalogTableOpt = this.sourceTable().catalogTable();
        Option<Object> version = ((DeltaTimeTravelSpec)this.sourceTable().timeTravelOpt().get()).version();
        Option<String> timestamp = this.getTimestamp();
        return (Seq)this.recordDeltaOperation(deltaLog, "delta.restore", this.recordDeltaOperation$default$3(), (Function0 & Serializable)() -> {
            Predef$.MODULE$.require(version.isEmpty() ^ timestamp.isEmpty(), (Function0 & Serializable)() -> "Either the version or timestamp should be provided for restore");
            long versionToRestore = BoxesRunTime.unboxToLong((Object)version.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> deltaLog.history().getActiveCommitAtTime(this.parseStringToTs(timestamp), catalogTableOpt, true, deltaLog.history().getActiveCommitAtTime$default$4(), deltaLog.history().getActiveCommitAtTime$default$5()).version()));
            Option x$1 = catalogTableOpt;
            boolean x$2 = deltaLog.update$default$1();
            Option<Object> x$3 = deltaLog.update$default$2();
            long latestVersion = deltaLog.update(x$2, x$3, (Option<CatalogTable>)x$1).version();
            Predef$.MODULE$.require(versionToRestore < latestVersion, (Function0 & Serializable)() -> new StringBuilder(66).append("Version to restore (").append(versionToRestore).append(")").append("should be less then last available version (").append(latestVersion).append(")").toString());
            return (Seq)deltaLog.withNewTransaction(catalogTableOpt, deltaLog.withNewTransaction$default$2(), (Function1 & Serializable)txn -> {
                Snapshot latestSnapshot = txn.snapshot();
                long x$4 = versionToRestore;
                Option<CatalogTable> x$5 = txn.catalogTable();
                Option<CheckpointInstance> x$6 = deltaLog.getSnapshotAt$default$2();
                Snapshot snapshotToRestore = deltaLog.getSnapshotAt(x$4, x$6, x$5);
                Dataset<AddFile> latestSnapshotFiles = latestSnapshot.allFiles();
                Dataset<AddFile> snapshotToRestoreFiles = snapshotToRestore.allFiles();
                boolean targetMayHaveDVs = DeletionVectorUtils$.MODULE$.deletionVectorsReadable(latestSnapshot, DeletionVectorUtils$.MODULE$.deletionVectorsReadable$default$2(), DeletionVectorUtils$.MODULE$.deletionVectorsReadable$default$3());
                boolean sourceMayHaveDVs = DeletionVectorUtils$.MODULE$.deletionVectorsReadable(snapshotToRestore, DeletionVectorUtils$.MODULE$.deletionVectorsReadable$default$2(), DeletionVectorUtils$.MODULE$.deletionVectorsReadable$default$3());
                Dataset normalizedSourceWithoutDVs = snapshotToRestoreFiles.mapPartitions((Function1 & Serializable)files -> files.map((Function1 & Serializable)file -> new Tuple2(file, (Object)file.path())), org.apache.spark.sql.delta.implicits.package$.MODULE$.addFileWithSourcePathEncoder()).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"srcAddFile", "srcPath"}));
                Dataset normalizedTargetWithoutDVs = latestSnapshotFiles.mapPartitions((Function1 & Serializable)files -> files.map((Function1 & Serializable)file -> new Tuple2(file, (Object)file.path())), org.apache.spark.sql.delta.implicits.package$.MODULE$.addFileWithSourcePathEncoder()).toDF((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"tgtAddFile", "tgtPath"}));
                Dataset normalizedSource = RestoreTableCommand.addDVsToNormalizedDF$1(sourceMayHaveDVs, "srcDeletionVectorId", functions$.MODULE$.column("srcAddFile.deletionVector"), normalizedSourceWithoutDVs);
                Dataset normalizedTarget = RestoreTableCommand.addDVsToNormalizedDF$1(targetMayHaveDVs, "tgtDeletionVectorId", functions$.MODULE$.column("tgtAddFile.deletionVector"), normalizedTargetWithoutDVs);
                Column joinExprs = functions$.MODULE$.column("srcPath").$eq$eq$eq((Object)functions$.MODULE$.column("tgtPath")).and(functions$.MODULE$.column("srcDeletionVectorId").$less$eq$greater((Object)functions$.MODULE$.column("tgtDeletionVectorId")));
                Dataset filesToAdd = normalizedSource.join(normalizedTarget, joinExprs, "left_anti").select(functions$.MODULE$.column("srcAddFile").as(org.apache.spark.sql.delta.implicits.package$.MODULE$.addFileEncoder())).map((Function1 & Serializable)x$1 -> {
                    boolean x$7 = true;
                    String x$8 = x$1.copy$default$1();
                    Map<String, String> x$9 = x$1.copy$default$2();
                    long x$10 = x$1.copy$default$3();
                    long x$11 = x$1.copy$default$4();
                    String x$12 = x$1.copy$default$6();
                    Map<String, String> x$13 = x$1.copy$default$7();
                    DeletionVectorDescriptor x$14 = x$1.copy$default$8();
                    Option<Object> x$15 = x$1.copy$default$9();
                    Option<Object> x$16 = x$1.copy$default$10();
                    Option<String> x$17 = x$1.copy$default$11();
                    return x$1.copy(x$8, x$9, x$10, x$11, true, x$12, x$13, x$14, x$15, x$16, x$17);
                }, org.apache.spark.sql.delta.implicits.package$.MODULE$.addFileEncoder());
                Dataset filesToRemove = normalizedTarget.join(normalizedSource, joinExprs, "left_anti").select(functions$.MODULE$.column("tgtAddFile").as(org.apache.spark.sql.delta.implicits.package$.MODULE$.addFileEncoder())).map((Function1 & Serializable)x$2 -> x$2.removeWithTimestamp(x$2.removeWithTimestamp$default$1(), x$2.removeWithTimestamp$default$2()), org.apache.spark.sql.delta.implicits.package$.MODULE$.removeFileEncoder());
                boolean ignoreMissingFiles = BoxesRunTime.unboxToBoolean((Object)spark.sessionState().conf().getConf(SQLConf$.MODULE$.IGNORE_MISSING_FILES()));
                if (!ignoreMissingFiles) {
                    this.checkSnapshotFilesAvailability(deltaLog, (Dataset<AddFile>)filesToAdd, versionToRestore);
                }
                Map metrics = (Map)this.withDescription("metrics", (Function0 & Serializable)() -> this.computeMetrics((Dataset<AddFile>)filesToAdd, (Dataset<RemoveFile>)filesToRemove, snapshotToRestore));
                Iterator addActions = (Iterator)this.withDescription("add actions", (Function0 & Serializable)() -> (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(filesToAdd.toLocalIterator()).asScala());
                Iterator removeActions = (Iterator)this.withDescription("remove actions", (Function0 & Serializable)() -> (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(filesToRemove.toLocalIterator()).asScala());
                StructType mergedSchema = IdentityColumn$.MODULE$.copySchemaWithMergedHighWaterMarks(deltaLog, snapshotToRestore.metadata().schema(), latestSnapshot.metadata().schema());
                Metadata qual$1 = snapshotToRestore.metadata();
                String x$18 = mergedSchema.json();
                String x$19 = qual$1.copy$default$1();
                String x$20 = qual$1.copy$default$2();
                String x$21 = qual$1.copy$default$3();
                Format x$22 = qual$1.copy$default$4();
                Seq<String> x$23 = qual$1.copy$default$6();
                Map<String, String> x$24 = qual$1.copy$default$7();
                Option<Object> x$25 = qual$1.copy$default$8();
                txn.updateMetadata(qual$1.copy(x$19, x$20, x$21, x$22, x$18, x$23, x$24, x$25), txn.updateMetadata$default$2());
                Protocol sourceProtocol = snapshotToRestore.protocol();
                Protocol targetProtocol = latestSnapshot.protocol();
                boolean protocolDowngradeAllowed = BoxesRunTime.unboxToBoolean((Object)this.conf().getConf(DeltaSQLConf$.MODULE$.RESTORE_TABLE_PROTOCOL_DOWNGRADE_ALLOWED()));
                Protocol newProtocol = protocolDowngradeAllowed ? sourceProtocol : sourceProtocol.merge((Seq<Protocol>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Protocol[]{targetProtocol}));
                Iterator actions = addActions.$plus$plus((Function0 & Serializable)() -> removeActions).$plus$plus((Function0 & Serializable)() -> DomainMetadataUtils$.MODULE$.handleDomainMetadataForRestoreTable(snapshotToRestore, latestSnapshot));
                txn.commitLarge(spark, (Iterator<Action>)actions, (Option<Protocol>)new Some((Object)newProtocol), new DeltaOperations.Restore(version, timestamp), (Map<String, String>)Predef$.MODULE$.Map().empty(), (Map<String, String>)metrics.mapValues((Function1 & Serializable)x$3 -> RestoreTableCommand.$anonfun$run$17(BoxesRunTime.unboxToLong((Object)x$3))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
                return new .colon.colon((Object)Row$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{metrics.get((Object)this.TABLE_SIZE_AFTER_RESTORE()), metrics.get((Object)this.NUM_OF_FILES_AFTER_RESTORE()), metrics.get((Object)this.NUM_REMOVED_FILES()), metrics.get((Object)this.NUM_RESTORED_FILES()), metrics.get((Object)this.REMOVED_FILES_SIZE()), metrics.get((Object)this.RESTORED_FILES_SIZE())})), (List)Nil$.MODULE$);
            });
        });
    }

    private <T> T withDescription(String action, Function0<T> f) {
        return this.withStatusCode("DELTA", new StringBuilder(44).append("RestoreTableCommand: compute ").append(action).append("  (table path ").append(this.sourceTable().deltaLog().dataPath()).append(")").toString(), this.withStatusCode$default$3(), f);
    }

    private Timestamp parseStringToTs(Option<String> timestamp) {
        Success success;
        Option option;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> timestamp.flatMap((Function1 & Serializable)tsStr -> {
            ZoneId tz = DateTimeUtils$.MODULE$.getZoneId(SQLConf$.MODULE$.get().sessionLocalTimeZone());
            UTF8String utfStr = UTF8String.fromString((String)tsStr);
            return DateTimeUtils$.MODULE$.stringToTimestamp(utfStr, tz);
        }));
        if (try_ instanceof Success && (option = (Option)(success = (Success)try_).value()) instanceof Some) {
            Some some = (Some)option;
            long tsMicroseconds = BoxesRunTime.unboxToLong((Object)some.value());
            return new Timestamp(tsMicroseconds / 1000L);
        }
        throw DeltaErrors$.MODULE$.timestampInvalid((Expression)Literal$.MODULE$.apply(timestamp.get()));
    }

    private Map<String, Object> computeMetrics(Dataset<AddFile> toAdd, Dataset<RemoveFile> toRemove, Snapshot snapshot) {
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(RestoreTableCommand.class.getClassLoader());
        public final class Org_apache_spark_sql_delta_commands_RestoreTableCommand$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Option"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_delta_commands_RestoreTableCommand$$typecreator5$1(RestoreTableCommand $outer) {
            }
        }
        Tuple2 tuple2 = (Tuple2)toAdd.agg(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"size"), (Object)"count"), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"size"), (Object)"sum")})).as(toAdd.sparkSession().implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_delta_commands_RestoreTableCommand$$typecreator5$1(null)))).head();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long numRestoredFiles = tuple2._1$mcJ$sp();
        Option restoredFilesSize = (Option)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)numRestoredFiles), (Object)restoredFilesSize);
        long numRestoredFiles2 = tuple22._1$mcJ$sp();
        Option restoredFilesSize2 = (Option)tuple22._2();
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(RestoreTableCommand.class.getClassLoader());
        public final class Org_apache_spark_sql_delta_commands_RestoreTableCommand$$typecreator10$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Option"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_delta_commands_RestoreTableCommand$$typecreator10$1(RestoreTableCommand $outer) {
            }
        }
        Tuple2 tuple23 = (Tuple2)toRemove.agg(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"size"), (Object)"count"), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"size"), (Object)"sum")})).as(toAdd.sparkSession().implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_delta_commands_RestoreTableCommand$$typecreator10$1(null)))).head();
        if (tuple23 == null) {
            throw new MatchError((Object)tuple23);
        }
        long numRemovedFiles = tuple23._1$mcJ$sp();
        Option removedFilesSize = (Option)tuple23._2();
        Tuple2 tuple24 = new Tuple2((Object)BoxesRunTime.boxToLong((long)numRemovedFiles), (Object)removedFilesSize);
        long numRemovedFiles2 = tuple24._1$mcJ$sp();
        Option removedFilesSize2 = (Option)tuple24._2();
        return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.NUM_RESTORED_FILES()), (Object)BoxesRunTime.boxToLong((long)numRestoredFiles2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.RESTORED_FILES_SIZE()), restoredFilesSize2.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.NUM_REMOVED_FILES()), (Object)BoxesRunTime.boxToLong((long)numRemovedFiles2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.REMOVED_FILES_SIZE()), removedFilesSize2.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.NUM_OF_FILES_AFTER_RESTORE()), (Object)BoxesRunTime.boxToLong((long)snapshot.numOfFiles())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.TABLE_SIZE_AFTER_RESTORE()), (Object)BoxesRunTime.boxToLong((long)snapshot.sizeInBytes()))}));
    }

    private void checkSnapshotFilesAvailability(DeltaLog deltaLog, Dataset<AddFile> files, long version) {
        this.withDescription("missing files validation", (Function0)(JFunction0.mcV.sp & Serializable)() -> {
            Broadcast hadoopConf;
            SparkSession spark = files.sparkSession();
            String pathString = deltaLog.dataPath().toString();
            String[] missedFiles = (String[])files.mapPartitions(arg_0 -> RestoreTableCommand.$anonfun$checkSnapshotFilesAvailability$2(pathString, hadoopConf = spark.sparkContext().broadcast((Object)new SerializableConfiguration(deltaLog.newDeltaHadoopConf()), ClassTag$.MODULE$.apply(SerializableConfiguration.class)), arg_0), org.apache.spark.sql.delta.implicits.package$.MODULE$.addFileEncoder()).map((Function1 & Serializable)x$6 -> x$6.path(), org.apache.spark.sql.delta.implicits.package$.MODULE$.stringEncoder()).head(100);
            if (ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])missedFiles))) {
                throw DeltaErrors$.MODULE$.restoreMissedDataFilesError(missedFiles, version);
            }
        });
    }

    private Option<String> getTimestamp() {
        if (((DeltaTimeTravelSpec)this.sourceTable().timeTravelOpt().get()).timestamp().isDefined()) {
            return new Some((Object)((DeltaTimeTravelSpec)this.sourceTable().timeTravelOpt().get()).getTimestamp(this.conf()).toString());
        }
        return None$.MODULE$;
    }

    public RestoreTableCommand copy(DeltaTableV2 sourceTable) {
        return new RestoreTableCommand(sourceTable);
    }

    public DeltaTableV2 copy$default$1() {
        return this.sourceTable();
    }

    public String productPrefix() {
        return "RestoreTableCommand";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.sourceTable();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof RestoreTableCommand;
    }

    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "sourceTable";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof RestoreTableCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        RestoreTableCommand restoreTableCommand = (RestoreTableCommand)x$1;
        DeltaTableV2 deltaTableV2 = this.sourceTable();
        DeltaTableV2 deltaTableV22 = restoreTableCommand.sourceTable();
        if (deltaTableV2 == null) {
            if (deltaTableV22 != null) {
                return false;
            }
        } else if (!deltaTableV2.equals(deltaTableV22)) return false;
        if (!restoreTableCommand.canEqual(this)) return false;
        return true;
    }

    private static final Dataset addDVsToNormalizedDF$1(boolean mayHaveDVs, String dvIdColumnName, Column dvAccessColumn, Dataset normalizedDf) {
        if (mayHaveDVs) {
            return normalizedDf.withColumn(dvIdColumnName, DeletionVectorDescriptor$.MODULE$.uniqueIdExpression(dvAccessColumn));
        }
        return normalizedDf.withColumn(dvIdColumnName, functions$.MODULE$.lit(null));
    }

    public static final /* synthetic */ String $anonfun$run$17(long x$3) {
        return Long.toString(x$3);
    }

    public static final /* synthetic */ Iterator $anonfun$checkSnapshotFilesAvailability$2(String pathString$1, Broadcast hadoopConf$1, Iterator files) {
        Path path = new Path(pathString$1);
        FileSystem fs = path.getFileSystem(((SerializableConfiguration)hadoopConf$1.value()).value());
        return files.filterNot((Function1 & Serializable)f -> BoxesRunTime.boxToBoolean((boolean)fs.exists(DeltaFileOperations$.MODULE$.absolutePath(pathString$1, f.path()))));
    }

    public RestoreTableCommand(DeltaTableV2 sourceTable) {
        this.sourceTable = sourceTable;
        Command.$init$((Command)this);
        RunnableCommand.$init$((RunnableCommand)this);
        LeafLike.$init$((LeafLike)this);
        DeltaProgressReporter.$init$(this);
        DatabricksLogging.$init$(this);
        DeltaLogging.$init$(this);
        DeltaCommandInvariants.$init$(this);
        DeltaCommand.$init$(this);
        RestoreTableCommandBase.$init$(this);
        this.output = this.outputSchema();
        Statics.releaseFence();
    }
}

