/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.commands.convert;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.TimeZone;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.delta.DeltaColumnMapping$;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.SerializableFileStatus;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.delta.actions.AddFile$;
import org.apache.spark.sql.delta.commands.convert.ConvertTargetFile;
import org.apache.spark.sql.delta.commands.convert.ConvertTargetTable;
import org.apache.spark.sql.delta.commands.convert.ParquetTable;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.schema.SchemaMergingUtils$;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.util.DateFormatter;
import org.apache.spark.sql.delta.util.DateFormatter$;
import org.apache.spark.sql.delta.util.DeltaFileOperations$;
import org.apache.spark.sql.delta.util.PartitionUtils;
import org.apache.spark.sql.delta.util.PartitionUtils$;
import org.apache.spark.sql.delta.util.TimestampFormatter;
import org.apache.spark.sql.delta.util.TimestampFormatter$;
import org.apache.spark.sql.execution.datasources.PartitioningUtils$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.util.SerializableConfiguration;
import org.apache.spark.util.Utils$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005mga\u0002\t\u0012!\u0003\r\t\u0001\t\u0005\u0006[\u0001!\tA\f\u0005\be\u0001\u0011\r\u0011\"\u00014\u0011\u001da\u0004\u00011A\u0005\u0002MBq!\u0010\u0001A\u0002\u0013\u0005a\bC\u0004B\u0001\u0001\u0007I\u0011A\u001a\t\u000f\t\u0003\u0001\u0019!C\u0001\u0007\")Q\t\u0001C\u0001\r\")!\u000f\u0001C\u0001g\"I\u0011\u0011\u0004\u0001\u0012\u0002\u0013\u0005\u00111\u0004\u0005\b\u0003c\u0001A\u0011AA\u001a\u0011\u001d\tY\u0005\u0001C\u0001\u0003\u001bB\u0011\"a\"\u0001#\u0003%\t!a\u0007\t\u000f\u0005%\u0005\u0001\"\u0001\u0002\f\"9\u0011\u0011\u0013\u0001\u0005\u0002\u0005M\u0005bBAg\u0001\u0011\u0005\u0011q\u001a\u0002\u0011\u0007>tg/\u001a:u+RLGn\u001d\"bg\u0016T!AE\n\u0002\u000f\r|gN^3si*\u0011A#F\u0001\tG>lW.\u00198eg*\u0011acF\u0001\u0006I\u0016dG/\u0019\u0006\u00031e\t1a]9m\u0015\tQ2$A\u0003ta\u0006\u00148N\u0003\u0002\u001d;\u00051\u0011\r]1dQ\u0016T\u0011AH\u0001\u0004_J<7\u0001A\n\u0004\u0001\u0005:\u0003C\u0001\u0012&\u001b\u0005\u0019#\"\u0001\u0013\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0019\u001a#AB!osJ+g\r\u0005\u0002)W5\t\u0011F\u0003\u0002++\u0005AQ.\u001a;fe&tw-\u0003\u0002-S\taA)\u001a7uC2{wmZ5oO\u00061A%\u001b8ji\u0012\"\u0012a\f\t\u0003EAJ!!M\u0012\u0003\tUs\u0017\u000e^\u0001\u001ai&lWm\u001d;b[B\u0004\u0016M\u001d;ji&|g\u000eU1ui\u0016\u0014h.F\u00015!\t)$(D\u00017\u0015\t9\u0004(\u0001\u0003mC:<'\"A\u001d\u0002\t)\fg/Y\u0005\u0003wY\u0012aa\u0015;sS:<\u0017AG5dK\n,'oZ*qCJ\\G+\u00192mK\u000ec\u0017m]:QCRD\u0017AH5dK\n,'oZ*qCJ\\G+\u00192mK\u000ec\u0017m]:QCRDw\fJ3r)\tys\bC\u0004A\t\u0005\u0005\t\u0019\u0001\u001b\u0002\u0007a$\u0013'\u0001\rjG\u0016\u0014WM]4MS\n$\u0016M\u00197f\u00072\f7o\u001d)bi\"\fA$[2fE\u0016\u0014x\rT5c)\u0006\u0014G.Z\"mCN\u001c\b+\u0019;i?\u0012*\u0017\u000f\u0006\u00020\t\"9\u0001IBA\u0001\u0002\u0004!\u0014aD4fiB\u000b'/];fiR\u000b'\r\\3\u0015\u000b\u001d[\u0005\u000bX5\u0011\u0005!KU\"A\t\n\u0005)\u000b\"AE\"p]Z,'\u000f\u001e+be\u001e,G\u000fV1cY\u0016DQAG\u0004A\u00021\u0003\"!\u0014(\u000e\u0003]I!aT\f\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\t\u000bE;\u0001\u0019\u0001*\u0002\u0013Q\f'oZ3u\t&\u0014\bCA*[\u001d\t!\u0006\f\u0005\u0002VG5\taK\u0003\u0002X?\u00051AH]8pizJ!!W\u0012\u0002\rA\u0013X\rZ3g\u0013\tY4L\u0003\u0002ZG!)Ql\u0002a\u0001=\u0006a1-\u0019;bY><G+\u00192mKB\u0019!eX1\n\u0005\u0001\u001c#AB(qi&|g\u000e\u0005\u0002cO6\t1M\u0003\u0002eK\u000691-\u0019;bY><'B\u00014\u0018\u0003!\u0019\u0017\r^1msN$\u0018B\u00015d\u00051\u0019\u0015\r^1m_\u001e$\u0016M\u00197f\u0011\u0015Qw\u00011\u0001l\u0003=\u0001\u0018M\u001d;ji&|gnU2iK6\f\u0007c\u0001\u0012`YB\u0011Q\u000e]\u0007\u0002]*\u0011qnF\u0001\u0006if\u0004Xm]\u0005\u0003c:\u0014!b\u0015;sk\u000e$H+\u001f9f\u0003=9W\r^%dK\n,'o\u001a+bE2,G\u0003C$ukZ\f\t!a\u0004\t\u000biA\u0001\u0019\u0001'\t\u000bEC\u0001\u0019\u0001*\t\u000b]D\u0001\u0019\u0001=\u0002\u0015M\u0004\u0018M]6UC\ndW\rE\u0002#?f\u0004\"A\u001f@\u000e\u0003mT!\u0001\u001a?\u000b\u0005u<\u0012!C2p]:,7\r^8s\u0013\ty8PA\u0003UC\ndW\rC\u0004\u0002\u0004!\u0001\r!!\u0002\u0002\u001b\u0011,G\u000e^1T]\u0006\u00048\u000f[8u!\u0011\u0011s,a\u0002\u0011\t\u0005%\u00111B\u0007\u0002+%\u0019\u0011QB\u000b\u0003\u0011Ms\u0017\r]:i_RD\u0011\"!\u0005\t!\u0003\u0005\r!a\u0005\u0002\u0019\r|G\u000e\\3diN#\u0018\r^:\u0011\u0007\t\n)\"C\u0002\u0002\u0018\r\u0012qAQ8pY\u0016\fg.A\rhKRL5-\u001a2fe\u001e$\u0016M\u00197fI\u0011,g-Y;mi\u0012*TCAA\u000fU\u0011\t\u0019\"a\b,\u0005\u0005\u0005\u0002\u0003BA\u0012\u0003[i!!!\n\u000b\t\u0005\u001d\u0012\u0011F\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u000b$\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003_\t)CA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f\u0001cZ3u#V\fG.\u001b4jK\u0012\u0004\u0016\r\u001e5\u0015\r\u0005U\u0012QIA$!\u0011\t9$!\u0011\u000e\u0005\u0005e\"\u0002BA\u001e\u0003{\t!AZ:\u000b\u0007\u0005}2$\u0001\u0004iC\u0012|w\u000e]\u0005\u0005\u0003\u0007\nID\u0001\u0003QCRD\u0007\"\u0002\u000e\u000b\u0001\u0004a\u0005bBA%\u0015\u0001\u0007\u0011QG\u0001\u0005a\u0006$\b.A\u0007de\u0016\fG/Z!eI\u001aKG.\u001a\u000b\u000f\u0003\u001f\nY&!\u001a\u0002j\u0005E\u0014\u0011QAB!\u0011\t\t&a\u0016\u000e\u0005\u0005M#bAA++\u00059\u0011m\u0019;j_:\u001c\u0018\u0002BA-\u0003'\u0012q!\u00113e\r&dW\rC\u0004\u0002^-\u0001\r!a\u0018\u0002\u0015Q\f'oZ3u\r&dW\rE\u0002I\u0003CJ1!a\u0019\u0012\u0005E\u0019uN\u001c<feR$\u0016M]4fi\u001aKG.\u001a\u0005\b\u0003OZ\u0001\u0019AA\u001b\u0003!\u0011\u0017m]3QCRD\u0007bBA\u001e\u0017\u0001\u0007\u00111\u000e\t\u0005\u0003o\ti'\u0003\u0003\u0002p\u0005e\"A\u0003$jY\u0016\u001c\u0016p\u001d;f[\"9\u00111O\u0006A\u0002\u0005U\u0014\u0001B2p]\u001a\u0004B!a\u001e\u0002~5\u0011\u0011\u0011\u0010\u0006\u0004\u0003w:\u0012\u0001C5oi\u0016\u0014h.\u00197\n\t\u0005}\u0014\u0011\u0010\u0002\b'Fc5i\u001c8g\u0011\u0015Q7\u00021\u0001l\u0011%\t)i\u0003I\u0001\u0002\u0004\t\u0019\"A\bvg\u0016\f%m]8mkR,\u0007+\u0019;i\u0003]\u0019'/Z1uK\u0006#GMR5mK\u0012\"WMZ1vYR$c'A\u0007eSJt\u0015-\\3GS2$XM\u001d\u000b\u0005\u0003'\ti\t\u0003\u0004\u0002\u00106\u0001\rAU\u0001\bI&\u0014h*Y7f\u0003Ia\u0017n\u001d;ESJ\u001c\u0018J\u001c)be\u0006dG.\u001a7\u0015\u0015\u0005U\u0015\u0011UAR\u0003O\u000bi\fE\u0003N\u0003/\u000bY*C\u0002\u0002\u001a^\u0011q\u0001R1uCN,G\u000f\u0005\u0003\u0002\n\u0005u\u0015bAAP+\t12+\u001a:jC2L'0\u00192mK\u001aKG.Z*uCR,8\u000fC\u0003\u001b\u001d\u0001\u0007A\n\u0003\u0004\u0002&:\u0001\rAU\u0001\be>|G\u000fR5s\u0011\u001d\tIK\u0004a\u0001\u0003W\u000bA\u0001Z5sgB)\u0011QVA\\%:!\u0011qVAZ\u001d\r)\u0016\u0011W\u0005\u0002I%\u0019\u0011QW\u0012\u0002\u000fA\f7m[1hK&!\u0011\u0011XA^\u0005\r\u0019V-\u001d\u0006\u0004\u0003k\u001b\u0003bBA`\u001d\u0001\u0007\u0011\u0011Y\u0001\u0011g\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\"p]\u001a\u0004B!a1\u0002J6\u0011\u0011Q\u0019\u0006\u0004\u0003\u000fL\u0012\u0001B;uS2LA!a3\u0002F\nI2+\u001a:jC2L'0\u00192mK\u000e{gNZ5hkJ\fG/[8o\u0003YiWM]4f'\u000eDW-\\1t\u0013:\u0004\u0016M]1mY\u0016dGc\u00027\u0002R\u0006M\u0017Q\u001b\u0005\u00065=\u0001\r\u0001\u0014\u0005\u0006U>\u0001\r\u0001\u001c\u0005\b\u0003/|\u0001\u0019AAm\u0003I\u0019wN\u001c<feR$\u0016M]4fi\u001aKG.Z:\u0011\u000b5\u000b9*a\u0018")
public interface ConvertUtilsBase
extends DeltaLogging {
    public void org$apache$spark$sql$delta$commands$convert$ConvertUtilsBase$_setter_$timestampPartitionPattern_$eq(String var1);

    public String timestampPartitionPattern();

    public String icebergSparkTableClassPath();

    public void icebergSparkTableClassPath_$eq(String var1);

    public String icebergLibTableClassPath();

    public void icebergLibTableClassPath_$eq(String var1);

    public static /* synthetic */ ConvertTargetTable getParquetTable$(ConvertUtilsBase $this, SparkSession spark, String targetDir, Option catalogTable, Option partitionSchema) {
        return $this.getParquetTable(spark, targetDir, (Option<CatalogTable>)catalogTable, (Option<StructType>)partitionSchema);
    }

    default public ConvertTargetTable getParquetTable(SparkSession spark, String targetDir, Option<CatalogTable> catalogTable, Option<StructType> partitionSchema) {
        String qualifiedDir = this.getQualifiedPath(spark, new Path(targetDir)).toString();
        return new ParquetTable(spark, qualifiedDir, catalogTable, partitionSchema);
    }

    public static /* synthetic */ ConvertTargetTable getIcebergTable$(ConvertUtilsBase $this, SparkSession spark, String targetDir, Option sparkTable, Option deltaSnapshot, boolean collectStats) {
        return $this.getIcebergTable(spark, targetDir, (Option<Table>)sparkTable, (Option<Snapshot>)deltaSnapshot, collectStats);
    }

    default public ConvertTargetTable getIcebergTable(SparkSession spark, String targetDir, Option<Table> sparkTable, Option<Snapshot> deltaSnapshot, boolean collectStats) {
        ConvertTargetTable convertTargetTable;
        try {
            boolean convertIcebergStats = collectStats && BoxesRunTime.unboxToBoolean((Object)spark.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_CONVERT_ICEBERG_STATS()));
            Class clazz = Utils$.MODULE$.classForName(this.icebergSparkTableClassPath(), Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3());
            if (sparkTable.isDefined()) {
                Constructor constFromTable = clazz.getConstructor(SparkSession.class, Utils$.MODULE$.classForName(this.icebergLibTableClassPath(), Utils$.MODULE$.classForName$default$2(), Utils$.MODULE$.classForName$default$3()), Option.class, Boolean.TYPE);
                Method method = sparkTable.get().getClass().getMethod("table", new Class[0]);
                convertTargetTable = (ConvertTargetTable)constFromTable.newInstance(spark, method.invoke(sparkTable.get(), new Object[0]), deltaSnapshot, convertIcebergStats);
            } else {
                String baseDir = this.getQualifiedPath(spark, new Path(targetDir)).toString();
                Constructor constFromPath = clazz.getConstructor(SparkSession.class, String.class, Option.class, Boolean.TYPE);
                convertTargetTable = (ConvertTargetTable)constFromPath.newInstance(spark, baseDir, deltaSnapshot, convertIcebergStats);
            }
        }
        catch (ClassNotFoundException e) {
            this.logError(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to find Iceberg class"}))).log((Seq)Nil$.MODULE$)), e);
            throw DeltaErrors$.MODULE$.icebergClassMissing(spark.sparkContext().getConf(), e);
        }
        catch (InvocationTargetException e) {
            this.logError(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Got error when creating an Iceberg Converter"}))).log((Seq)Nil$.MODULE$)), e);
            throw ExceptionUtils.getRootCause((Throwable)e);
        }
        return convertTargetTable;
    }

    public static /* synthetic */ boolean getIcebergTable$default$5$(ConvertUtilsBase $this) {
        return $this.getIcebergTable$default$5();
    }

    default public boolean getIcebergTable$default$5() {
        return true;
    }

    public static /* synthetic */ Path getQualifiedPath$(ConvertUtilsBase $this, SparkSession spark, Path path) {
        return $this.getQualifiedPath(spark, path);
    }

    default public Path getQualifiedPath(SparkSession spark, Path path) {
        Path qualifiedPath;
        Configuration sessionHadoopConf = spark.sessionState().newHadoopConf();
        FileSystem fs = path.getFileSystem(sessionHadoopConf);
        if (!fs.exists(qualifiedPath = fs.makeQualified(path))) {
            throw DeltaErrors$.MODULE$.directoryNotFoundException(qualifiedPath.toString());
        }
        return qualifiedPath;
    }

    public static /* synthetic */ AddFile createAddFile$(ConvertUtilsBase $this, ConvertTargetFile targetFile, Path basePath, FileSystem fs, SQLConf conf, Option partitionSchema, boolean useAbsolutePath) {
        return $this.createAddFile(targetFile, basePath, fs, conf, (Option<StructType>)partitionSchema, useAbsolutePath);
    }

    default public AddFile createAddFile(ConvertTargetFile targetFile, Path basePath, FileSystem fs, SQLConf conf, Option<StructType> partitionSchema, boolean useAbsolutePath) {
        String string;
        Seq partitionFields = (Seq)partitionSchema.map((Function1 & Serializable)x$1 -> ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])x$1.fields()))).getOrElse((Function0 & Serializable)() -> Nil$.MODULE$);
        Seq partitionColNames = (Seq)partitionSchema.map((Function1 & Serializable)x$2 -> ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])x$2.fieldNames()))).getOrElse((Function0 & Serializable)() -> Nil$.MODULE$);
        Seq physicalPartitionColNames = (Seq)partitionSchema.map((Function1 & Serializable)x$3 -> (Seq)x$3.map((Function1 & Serializable)f -> DeltaColumnMapping$.MODULE$.getPhysicalName((StructField)f))).getOrElse((Function0 & Serializable)() -> Nil$.MODULE$);
        SerializableFileStatus file = targetFile.fileStatus();
        Path path = file.getHadoopPath();
        Map partition = (Map)targetFile.partitionValues().getOrElse((Function0 & Serializable)() -> {
            String pathStr = file.getHadoopPath().toUri().toString();
            DateFormatter dateFormatter = DateFormatter$.MODULE$.apply();
            TimestampFormatter timestampFormatter = TimestampFormatter$.MODULE$.apply(this.timestampPartitionPattern(), TimeZone.getDefault());
            Function2 resolver = conf.resolver();
            Path dir = file.isDir() ? file.getHadoopPath() : file.getHadoopPath().getParent();
            Tuple2<Option<PartitionUtils.PartitionValues>, Option<Path>> tuple2 = PartitionUtils$.MODULE$.parsePartition(dir, false, (Set<Path>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Path[]{basePath}))), (Map<String, DataType>)Predef$.MODULE$.Map().empty(), false, TimeZone.getDefault(), dateFormatter, timestampFormatter, PartitionUtils$.MODULE$.parsePartition$default$9());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Option partitionOpt = (Option)tuple2._1();
            Option partitionOpt2 = partitionOpt;
            return (Map)partitionOpt2.map((Function1 & Serializable)partValues -> {
                if (partitionColNames.size() != partValues.columnNames().size()) {
                    throw DeltaErrors$.MODULE$.unexpectedNumPartitionColumnsFromFileNameException(pathStr, partValues.columnNames(), (Seq<String>)partitionColNames);
                }
                Option tz = Option$.MODULE$.apply((Object)conf.sessionLocalTimeZone());
                if (!BoxesRunTime.unboxToBoolean((Object)conf.getConf(DeltaSQLConf$.MODULE$.DELTA_CONVERT_PARTITION_VALUES_IGNORE_CAST_FAILURE()))) {
                    ((IterableOnceOps)partValues.literals().zip((IterableOnce)partitionFields)).foreach((Function1 & Serializable)x0$1 -> {
                        ConvertUtilsBase.$anonfun$createAddFile$10(tz, x0$1);
                        return BoxedUnit.UNIT;
                    });
                }
                Seq values = (Seq)((IterableOps)partValues.literals().map((Function1 & Serializable)l -> {
                    Cast qual$3 = Cast$.MODULE$.apply((Expression)l, (DataType)StringType$.MODULE$, tz, false);
                    InternalRow x$3 = qual$3.eval$default$1();
                    return qual$3.eval(x$3);
                })).map((Function1 & Serializable)x$5 -> (String)Option$.MODULE$.apply(x$5).map((Function1 & Serializable)x$6 -> x$6.toString()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
                ((IterableOnceOps)partitionColNames.zip(partValues.columnNames())).foreach((Function1 & Serializable)x0$2 -> {
                    ConvertUtilsBase.$anonfun$createAddFile$15(resolver, pathStr, x0$2);
                    return BoxedUnit.UNIT;
                });
                return ((IterableOnceOps)physicalPartitionColNames.zip((IterableOnce)values)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            }).getOrElse((Function0 & Serializable)() -> {
                if (partitionColNames.nonEmpty()) {
                    throw DeltaErrors$.MODULE$.unexpectedNumPartitionColumnsFromFileNameException(pathStr, (Seq<String>)((Seq)package$.MODULE$.Seq().empty()), (Seq<String>)partitionColNames);
                }
                return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
            });
        });
        if (!useAbsolutePath) {
            Path relativePath = DeltaFileOperations$.MODULE$.tryRelativizePath(fs, basePath, path, DeltaFileOperations$.MODULE$.tryRelativizePath$default$4());
            Predef$.MODULE$.assert(!relativePath.isAbsolute(), (Function0 & Serializable)() -> new StringBuilder(44).append("Fail to relativize path ").append(path).append(" against base path ").append(basePath).append(".").toString());
            string = relativePath.toUri().toString();
        } else {
            string = path.toUri().toString();
        }
        String pathStrForAddFile = string;
        return new AddFile(pathStrForAddFile, (Map<String, String>)partition, file.length(), file.modificationTime(), true, (String)targetFile.stats().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()), AddFile$.MODULE$.apply$default$7(), AddFile$.MODULE$.apply$default$8(), AddFile$.MODULE$.apply$default$9(), AddFile$.MODULE$.apply$default$10(), AddFile$.MODULE$.apply$default$11());
    }

    public static /* synthetic */ boolean createAddFile$default$6$(ConvertUtilsBase $this) {
        return $this.createAddFile$default$6();
    }

    default public boolean createAddFile$default$6() {
        return false;
    }

    public static /* synthetic */ boolean dirNameFilter$(ConvertUtilsBase $this, String dirName) {
        return $this.dirNameFilter(dirName);
    }

    default public boolean dirNameFilter(String dirName) {
        return DeltaFileOperations$.MODULE$.defaultHiddenFileFilter(dirName) && !dirName.contains("=");
    }

    public static /* synthetic */ Dataset listDirsInParallel$(ConvertUtilsBase $this, SparkSession spark, String rootDir, Seq dirs, SerializableConfiguration serializableConf) {
        return $this.listDirsInParallel(spark, rootDir, (Seq<String>)dirs, serializableConf);
    }

    default public Dataset<SerializableFileStatus> listDirsInParallel(SparkSession spark, String rootDir, Seq<String> dirs, SerializableConfiguration serializableConf) {
        Broadcast conf = spark.sparkContext().broadcast((Object)serializableConf, ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        int parallelism = spark.sessionState().conf().parallelPartitionDiscoveryParallelism();
        RDD qual$1 = spark.sparkContext().parallelize(dirs, scala.math.package$.MODULE$.min(parallelism, dirs.length()), ClassTag$.MODULE$.apply(String.class));
        Function1 & Serializable x$1 = (Function1 & Serializable)batch -> batch.flatMap((Function1 & Serializable)dir -> DeltaFileOperations$.MODULE$.localListDirs(((SerializableConfiguration)conf.value()).value(), (Seq<String>)new .colon.colon(dir, (List)Nil$.MODULE$), false, DeltaFileOperations$.MODULE$.localListDirs$default$4(), DeltaFileOperations$.MODULE$.localListDirs$default$5()).filter((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ConvertUtilsBase.$anonfun$listDirsInParallel$3(x$7))));
        boolean x$2 = qual$1.mapPartitions$default$2();
        RDD rdd = qual$1.mapPartitions((Function1)x$1, x$2, ClassTag$.MODULE$.apply(SerializableFileStatus.class));
        return spark.createDataset(rdd, org.apache.spark.sql.delta.implicits.package$.MODULE$.serializableFileStatusEncoder());
    }

    public static /* synthetic */ StructType mergeSchemasInParallel$(ConvertUtilsBase $this, SparkSession spark, StructType partitionSchema, Dataset convertTargetFiles) {
        return $this.mergeSchemasInParallel(spark, partitionSchema, (Dataset<ConvertTargetFile>)convertTargetFiles);
    }

    default public StructType mergeSchemasInParallel(SparkSession spark, StructType partitionSchema, Dataset<ConvertTargetFile> convertTargetFiles) {
        String[] partiallyMergedSchemas = (String[])this.recordFrameProfile("Delta", "ConvertUtils.mergeSchemasInParallel", (Function0 & Serializable)() -> (String[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])convertTargetFiles.mapPartitions((Function1 & Serializable)iterator -> {
            ObjectRef dataSchema = ObjectRef.create((Object)StructType$.MODULE$.apply((Seq)Nil$.MODULE$));
            iterator.foreach((Function1 & Serializable)file -> {
                ConvertUtilsBase.$anonfun$mergeSchemasInParallel$3(dataSchema, file);
                return BoxedUnit.UNIT;
            });
            return package$.MODULE$.Iterator().single((Object)((StructType)dataSchema.elem).toDDL());
        }, org.apache.spark.sql.delta.implicits.package$.MODULE$.stringEncoder()).collect()), (Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(x$8)))));
        if (ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])partiallyMergedSchemas))) {
            throw DeltaErrors$.MODULE$.failedInferSchema();
        }
        ObjectRef mergedSchema = ObjectRef.create((Object)StructType$.MODULE$.apply((Seq)Nil$.MODULE$));
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])partiallyMergedSchemas), (Function1 & Serializable)schema -> {
            mergedSchema.elem = SchemaMergingUtils$.MODULE$.mergeSchemas((StructType)mergedSchema.elem, StructType$.MODULE$.fromDDL(schema), SchemaMergingUtils$.MODULE$.mergeSchemas$default$3(), SchemaMergingUtils$.MODULE$.mergeSchemas$default$4(), SchemaMergingUtils$.MODULE$.mergeSchemas$default$5(), SchemaMergingUtils$.MODULE$.mergeSchemas$default$6());
            return BoxedUnit.UNIT;
        });
        return (StructType)PartitioningUtils$.MODULE$.mergeDataAndPartitionSchema((StructType)mergedSchema.elem, StructType$.MODULE$.apply(ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])partitionSchema.fields()))), spark.sessionState().conf().caseSensitiveAnalysis())._1();
    }

    public static /* synthetic */ void $anonfun$createAddFile$10(Option tz$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            InternalRow x$1;
            Cast qual$1;
            Literal literal = (Literal)tuple2._1();
            StructField field = (StructField)tuple2._2();
            if (literal.eval(literal.eval$default$1()) != null && (qual$1 = Cast$.MODULE$.apply((Expression)literal, field.dataType(), tz$1, false)).eval(x$1 = qual$1.eval$default$1()) == null) {
                Cast qual$2 = Cast$.MODULE$.apply((Expression)literal, (DataType)StringType$.MODULE$, tz$1, false);
                InternalRow x$2 = qual$2.eval$default$1();
                Object partitionValue = qual$2.eval(x$2);
                String partitionValueStr = (String)Option$.MODULE$.apply(partitionValue).map((Function1 & Serializable)x$4 -> x$4.toString()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
                throw DeltaErrors$.MODULE$.castPartitionValueException(partitionValueStr, field.dataType());
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static /* synthetic */ void $anonfun$createAddFile$15(Function2 resolver$1, String pathStr$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            String parsed;
            String expected = (String)tuple2._1();
            if (!BoxesRunTime.unboxToBoolean((Object)resolver$1.apply((Object)expected, (Object)(parsed = (String)tuple2._2())))) {
                throw DeltaErrors$.MODULE$.unexpectedPartitionColumnFromFileNameException(pathStr$1, parsed, expected);
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static /* synthetic */ boolean $anonfun$listDirsInParallel$3(SerializableFileStatus x$7) {
        return !x$7.isDir();
    }

    public static /* synthetic */ void $anonfun$mergeSchemasInParallel$3(ObjectRef dataSchema$1, ConvertTargetFile file) {
        try {
            dataSchema$1.elem = SchemaMergingUtils$.MODULE$.mergeSchemas((StructType)dataSchema$1.elem, StructType$.MODULE$.fromDDL((String)file.parquetSchemaDDL().get()).asNullable(), SchemaMergingUtils$.MODULE$.mergeSchemas$default$3(), SchemaMergingUtils$.MODULE$.mergeSchemas$default$4(), SchemaMergingUtils$.MODULE$.mergeSchemas$default$5(), SchemaMergingUtils$.MODULE$.mergeSchemas$default$6());
        }
        catch (AnalysisException cause) {
            throw DeltaErrors$.MODULE$.failedMergeSchemaFile(file.fileStatus().path(), StructType$.MODULE$.fromDDL((String)file.parquetSchemaDDL().get()).treeString(), cause);
        }
    }

    public static void $init$(ConvertUtilsBase $this) {
        $this.org$apache$spark$sql$delta$commands$convert$ConvertUtilsBase$_setter_$timestampPartitionPattern_$eq("yyyy-MM-dd HH:mm:ss[.S]");
        $this.icebergSparkTableClassPath_$eq("org.apache.spark.sql.delta.commands.convert.IcebergTable");
        $this.icebergLibTableClassPath_$eq("org.apache.iceberg.Table");
    }
}

