/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.deletionvectors;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.spark.sql.delta.deletionvectors.RoaringBitmapArraySerializationFormat;
import org.roaringbitmap.RoaringBitmap;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class NativeRoaringBitmapArraySerializationFormat$
implements RoaringBitmapArraySerializationFormat {
    public static final NativeRoaringBitmapArraySerializationFormat$ MODULE$ = new NativeRoaringBitmapArraySerializationFormat$();
    private static final int MAGIC_NUMBER = 1681511376;

    @Override
    public int MAGIC_NUMBER() {
        return MAGIC_NUMBER;
    }

    @Override
    public long serializedSizeInBytes(RoaringBitmap[] bitmaps) {
        int roaringBitmapsCountSize = 4;
        int roaringBitmapLengthSize = 4;
        long roaringBitmapsSize = BoxesRunTime.unboxToLong((Object)ArrayOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.refArrayOps((Object[])bitmaps), (Object)BoxesRunTime.boxToLong((long)0L), (Function2 & Serializable)(sum, bitmap) -> BoxesRunTime.boxToLong((long)NativeRoaringBitmapArraySerializationFormat$.$anonfun$serializedSizeInBytes$1(roaringBitmapLengthSize, BoxesRunTime.unboxToLong((Object)sum), bitmap))));
        return (long)roaringBitmapsCountSize + roaringBitmapsSize;
    }

    @Override
    public void serialize(RoaringBitmap[] bitmaps, ByteBuffer buffer) {
        buffer.putInt(bitmaps.length);
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])bitmaps), (Function1 & Serializable)bitmap -> {
            int placeholderPos = buffer.position();
            buffer.putInt(-1);
            int startPos = placeholderPos + 4;
            bitmap.serialize(buffer);
            int endPos = buffer.position();
            int writtenBytes = endPos - startPos;
            return buffer.putInt(placeholderPos, writtenBytes);
        });
    }

    @Override
    public RoaringBitmap[] deserialize(ByteBuffer buffer) {
        int numberOfBitmaps = buffer.getInt();
        if (numberOfBitmaps < 0) {
            throw new IOException(new StringBuilder(40).append("Invalid RoaringBitmapArray length").append(" (").append(numberOfBitmaps).append(" < 0)").toString());
        }
        RoaringBitmap[] bitmaps = (RoaringBitmap[])Array$.MODULE$.fill(numberOfBitmaps, (Function0 & Serializable)() -> new RoaringBitmap(), ClassTag$.MODULE$.apply(RoaringBitmap.class));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numberOfBitmaps).foreach((Function1 & Serializable)index -> NativeRoaringBitmapArraySerializationFormat$.$anonfun$deserialize$3(buffer, bitmaps, BoxesRunTime.unboxToInt((Object)index)));
        return bitmaps;
    }

    public static final /* synthetic */ long $anonfun$serializedSizeInBytes$1(int roaringBitmapLengthSize$1, long sum, RoaringBitmap bitmap) {
        return sum + (long)bitmap.serializedSizeInBytes() + (long)roaringBitmapLengthSize$1;
    }

    public static final /* synthetic */ ByteBuffer $anonfun$deserialize$3(ByteBuffer buffer$2, RoaringBitmap[] bitmaps$1, int index) {
        int bitmapSize = buffer$2.getInt();
        bitmaps$1[index].deserialize(buffer$2);
        return buffer$2.position(buffer$2.position() + bitmapSize);
    }

    private NativeRoaringBitmapArraySerializationFormat$() {
    }
}

