/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.deletionvectors;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.spark.sql.delta.deletionvectors.RoaringBitmapArraySerializationFormat;
import org.roaringbitmap.RoaringBitmap;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.mutable.ArrayBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichLong;

public final class PortableRoaringBitmapArraySerializationFormat$
implements RoaringBitmapArraySerializationFormat {
    public static final PortableRoaringBitmapArraySerializationFormat$ MODULE$ = new PortableRoaringBitmapArraySerializationFormat$();
    private static final int MAGIC_NUMBER = 1681511377;

    @Override
    public int MAGIC_NUMBER() {
        return MAGIC_NUMBER;
    }

    @Override
    public long serializedSizeInBytes(RoaringBitmap[] bitmaps) {
        int bitmapCountSize = 8;
        int individualBitmapKeySize = 4;
        long bitmapSizes = BoxesRunTime.unboxToLong((Object)ArrayOps$.MODULE$.foldLeft$extension(Predef$.MODULE$.refArrayOps((Object[])bitmaps), (Object)BoxesRunTime.boxToLong((long)0L), (Function2 & Serializable)(sum, bitmap) -> BoxesRunTime.boxToLong((long)PortableRoaringBitmapArraySerializationFormat$.$anonfun$serializedSizeInBytes$2(individualBitmapKeySize, BoxesRunTime.unboxToLong((Object)sum), bitmap))));
        return (long)bitmapCountSize + bitmapSizes;
    }

    @Override
    public void serialize(RoaringBitmap[] bitmaps, ByteBuffer buffer) {
        buffer.putLong(bitmaps.length);
        ArrayOps$.MODULE$.withFilter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])bitmaps))), (Function1 & Serializable)check$ifrefutable$5 -> BoxesRunTime.boxToBoolean((boolean)PortableRoaringBitmapArraySerializationFormat$.$anonfun$serialize$3(check$ifrefutable$5))).foreach((Function1 & Serializable)x$10 -> {
            PortableRoaringBitmapArraySerializationFormat$.$anonfun$serialize$4(buffer, x$10);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public RoaringBitmap[] deserialize(ByteBuffer buffer) {
        long numberOfBitmaps = buffer.getLong();
        if (numberOfBitmaps < 0L) {
            throw new IOException(new StringBuilder(40).append("Invalid RoaringBitmapArray length (").append(numberOfBitmaps).append(" < 0)").toString());
        }
        if (numberOfBitmaps > Integer.MAX_VALUE) {
            throw new IOException(new StringBuilder(59).append("Invalid RoaringBitmapArray length (").append(numberOfBitmaps).append(" > ").append(Integer.MAX_VALUE).append(")").toString());
        }
        int minimumArraySize = (int)numberOfBitmaps;
        ArrayBuilder bitmaps = Array$.MODULE$.newBuilder(ClassTag$.MODULE$.apply(RoaringBitmap.class));
        bitmaps.sizeHint(minimumArraySize);
        IntRef lastIndex = IntRef.create((int)0);
        new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)numberOfBitmaps)).foreach((Function1 & Serializable)x$11 -> PortableRoaringBitmapArraySerializationFormat$.$anonfun$deserialize$4(buffer, lastIndex, bitmaps, BoxesRunTime.unboxToLong((Object)x$11)));
        return (RoaringBitmap[])bitmaps.result();
    }

    public static final /* synthetic */ long $anonfun$serializedSizeInBytes$2(int individualBitmapKeySize$1, long sum, RoaringBitmap bitmap) {
        return sum + (long)bitmap.serializedSizeInBytes() + (long)individualBitmapKeySize$1;
    }

    public static final /* synthetic */ boolean $anonfun$serialize$3(Tuple2 check$ifrefutable$5) {
        Tuple2 tuple2 = check$ifrefutable$5;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$serialize$4(ByteBuffer buffer$3, Tuple2 x$10) {
        Tuple2 tuple2 = x$10;
        if (tuple2 != null) {
            RoaringBitmap bitmap = (RoaringBitmap)tuple2._1();
            int index = tuple2._2$mcI$sp();
            buffer$3.putInt(index);
            bitmap.serialize(buffer$3);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ ByteBuffer $anonfun$deserialize$4(ByteBuffer buffer$4, IntRef lastIndex$1, ArrayBuilder bitmaps$2, long x$11) {
        long l = x$11;
        int key = buffer$4.getInt();
        if ((long)key < 0L) {
            throw new IOException(new StringBuilder(47).append("Invalid unsigned entry in RoaringBitmapArray (").append(key).append(")").toString());
        }
        Predef$.MODULE$.assert(key >= lastIndex$1.elem, (Function0 & Serializable)() -> "Keys are required to be sorted in ascending order.");
        while (lastIndex$1.elem < key) {
            bitmaps$2.$plus$eq((Object)new RoaringBitmap());
            ++lastIndex$1.elem;
        }
        RoaringBitmap bitmap = new RoaringBitmap();
        bitmap.deserialize(buffer$4);
        bitmaps$2.$plus$eq((Object)bitmap);
        ++lastIndex$1.elem;
        return buffer$4.position(buffer$4.position() + bitmap.serializedSizeInBytes());
    }

    private PortableRoaringBitmapArraySerializationFormat$() {
    }
}

