/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.files;

import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.spark.TaskOutputFileAlreadyExistException;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.LoggingShims;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.io.FileCommitProtocol;
import org.apache.spark.internal.io.SparkHadoopWriterUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.shuffle.FetchFailedException;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.expressions.Ascending$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.AttributeSet$;
import org.apache.spark.sql.catalyst.expressions.BindReferences$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.FileSourceMetadataAttribute$;
import org.apache.spark.sql.catalyst.expressions.SortDirection;
import org.apache.spark.sql.catalyst.expressions.SortOrder$;
import org.apache.spark.sql.catalyst.expressions.package$;
import org.apache.spark.sql.catalyst.plans.QueryPlan;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap;
import org.apache.spark.sql.catalyst.util.CaseInsensitiveMap$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.connector.write.WriterCommitMessage;
import org.apache.spark.sql.delta.ClassicColumnConversions$;
import org.apache.spark.sql.delta.DeltaOptions$;
import org.apache.spark.sql.delta.files.DeltaFileFormatWriter;
import org.apache.spark.sql.delta.logging.DeltaLogKeys$;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.execution.ProjectExec;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.execution.SortExec;
import org.apache.spark.sql.execution.SortExec$;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.adaptive.AdaptiveSparkPlanExec;
import org.apache.spark.sql.execution.datasources.DataSourceUtils$;
import org.apache.spark.sql.execution.datasources.DynamicPartitionDataConcurrentWriter;
import org.apache.spark.sql.execution.datasources.DynamicPartitionDataConcurrentWriter$;
import org.apache.spark.sql.execution.datasources.DynamicPartitionDataSingleWriter;
import org.apache.spark.sql.execution.datasources.DynamicPartitionDataSingleWriter$;
import org.apache.spark.sql.execution.datasources.EmptyDirectoryDataWriter;
import org.apache.spark.sql.execution.datasources.EmptyDirectoryDataWriter$;
import org.apache.spark.sql.execution.datasources.FileFormat;
import org.apache.spark.sql.execution.datasources.FileFormatDataWriter;
import org.apache.spark.sql.execution.datasources.FileFormatWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.SingleDirectoryDataWriter;
import org.apache.spark.sql.execution.datasources.SingleDirectoryDataWriter$;
import org.apache.spark.sql.execution.datasources.V1WritesUtils$;
import org.apache.spark.sql.execution.datasources.WriteFilesSpec;
import org.apache.spark.sql.execution.datasources.WriteJobDescription;
import org.apache.spark.sql.execution.datasources.WriteJobStatsTracker;
import org.apache.spark.sql.execution.datasources.WriteTaskResult;
import org.apache.spark.sql.execution.datasources.WriteTaskStats;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.SerializableConfiguration;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class DeltaFileFormatWriter$
implements LoggingShims {
    public static final DeltaFileFormatWriter$ MODULE$ = new DeltaFileFormatWriter$();
    private static boolean outputOrderingMatched;
    private static Option<SparkPlan> executedPlan;
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        outputOrderingMatched = false;
        executedPlan = None$.MODULE$;
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private boolean outputOrderingMatched() {
        return outputOrderingMatched;
    }

    private void outputOrderingMatched_$eq(boolean x$1) {
        outputOrderingMatched = x$1;
    }

    private Option<SparkPlan> executedPlan() {
        return executedPlan;
    }

    private void executedPlan_$eq(Option<SparkPlan> x$1) {
        executedPlan = x$1;
    }

    public Set<String> write(SparkSession sparkSession, SparkPlan plan2, FileFormat fileFormat, FileCommitProtocol committer, FileFormatWriter.OutputSpec outputSpec, Configuration hadoopConf, Seq<Attribute> partitionColumns, Option<BucketSpec> bucketSpec, Seq<WriteJobStatsTracker> statsTrackers, scala.collection.immutable.Map<String, String> options, int numStaticPartitionCols) {
        Predef$.MODULE$.require(partitionColumns.size() >= numStaticPartitionCols);
        Job job = Job.getInstance((Configuration)hadoopConf);
        job.setOutputKeyClass(Void.class);
        job.setOutputValueClass(InternalRow.class);
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(outputSpec.outputPath()));
        AttributeSet partitionSet = AttributeSet$.MODULE$.apply(partitionColumns);
        Seq x$12 = (Seq)outputSpec.outputColumns().map((Function1 & Serializable)attr -> FileSourceMetadataAttribute$.MODULE$.cleanupFileSourceMetadataInformation(attr));
        String x$22 = outputSpec.copy$default$1();
        scala.collection.immutable.Map x$32 = outputSpec.copy$default$2();
        FileFormatWriter.OutputSpec finalOutputSpec = outputSpec.copy(x$22, x$32, x$12);
        Seq dataColumns = (Seq)finalOutputSpec.outputColumns().filterNot((Function1 & Serializable)elem -> BoxesRunTime.boxToBoolean((boolean)partitionSet.contains(elem)));
        Option writerBucketSpec = V1WritesUtils$.MODULE$.getWriterBucketSpec(bucketSpec, dataColumns, options);
        Seq sortColumns = V1WritesUtils$.MODULE$.getBucketSortColumns(bucketSpec, dataColumns);
        CaseInsensitiveMap caseInsensitiveOptions = CaseInsensitiveMap$.MODULE$.apply(options);
        StructType dataSchema = package$.MODULE$.AttributeSeq(dataColumns).toStructType();
        DataSourceUtils$.MODULE$.verifySchema(fileFormat, dataSchema);
        DataSourceUtils$.MODULE$.checkFieldNames(fileFormat, dataSchema);
        Seq outputDataColumns = caseInsensitiveOptions.get(DeltaOptions$.MODULE$.WRITE_PARTITION_COLUMNS()).contains((Object)"true") ? (Seq)dataColumns.$plus$plus(partitionColumns) : dataColumns;
        OutputWriterFactory outputWriterFactory = fileFormat.prepareWrite(sparkSession, job, (scala.collection.immutable.Map)caseInsensitiveOptions, package$.MODULE$.AttributeSeq(outputDataColumns).toStructType());
        WriteJobDescription description = new WriteJobDescription(UUID.randomUUID().toString(), new SerializableConfiguration(job.getConfiguration()), outputWriterFactory, finalOutputSpec.outputColumns(), outputDataColumns, partitionColumns, writerBucketSpec, finalOutputSpec.outputPath(), finalOutputSpec.customPartitionLocations(), BoxesRunTime.unboxToLong((Object)caseInsensitiveOptions.get("maxRecordsPerFile").map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(x$1)))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> sparkSession.sessionState().conf().maxRecordsPerFile())), (String)caseInsensitiveOptions.get(DateTimeUtils$.MODULE$.TIMEZONE_OPTION()).getOrElse((Function0 & Serializable)() -> sparkSession.sessionState().conf().sessionLocalTimeZone()), statsTrackers);
        Seq requiredOrdering = (Seq)((IterableOps)((IterableOps)partitionColumns.drop(numStaticPartitionCols)).$plus$plus((IterableOnce)writerBucketSpec.map((Function1 & Serializable)x$2 -> x$2.bucketIdExpression()))).$plus$plus((IterableOnce)sortColumns);
        Option writeFilesOpt = V1WritesUtils$.MODULE$.getWriteFilesOpt(plan2);
        Seq actualOrdering = ((QueryPlan)writeFilesOpt.map((Function1 & Serializable)x$3 -> (SparkPlan)x$3.child()).getOrElse((Function0 & Serializable)() -> DeltaFileFormatWriter$.materializeAdaptiveSparkPlan$1(plan2))).outputOrdering();
        boolean orderingMatched = V1WritesUtils$.MODULE$.isOrderingMatched(requiredOrdering, actualOrdering);
        SQLExecution$.MODULE$.checkSQLExecutionId(ClassicColumnConversions$.MODULE$.castToImpl(sparkSession));
        job.getConfiguration().set("spark.sql.sources.writeJobUUID", description.uuid());
        if (org.apache.spark.sql.delta.util.Utils$.MODULE$.isTesting()) {
            this.outputOrderingMatched_$eq(orderingMatched);
        }
        if (writeFilesOpt.isDefined()) {
            Function1 & Serializable concurrentOutputWriterSpecFunc = (Function1 & Serializable)plan -> {
                SortExec sortPlan = MODULE$.createSortPlan((SparkPlan)plan, (Seq<Expression>)requiredOrdering, outputSpec);
                return MODULE$.createConcurrentOutputWriterSpec(sparkSession, sortPlan, (Seq<Attribute>)sortColumns);
            };
            WriteFilesSpec writeSpec = new WriteFilesSpec(description, committer, (Function1)concurrentOutputWriterSpecFunc);
            return this.executeWrite(sparkSession, plan2, writeSpec, job);
        }
        return this.executeWrite(sparkSession, plan2, job, description, committer, outputSpec, (Seq<Expression>)requiredOrdering, partitionColumns, (Seq<Attribute>)sortColumns, orderingMatched);
    }

    public int write$default$11() {
        return 0;
    }

    private Set<String> executeWrite(SparkSession sparkSession, SparkPlan plan, Job job, WriteJobDescription description, FileCommitProtocol committer, FileFormatWriter.OutputSpec outputSpec, Seq<Expression> requiredOrdering, Seq<Attribute> partitionColumns, Seq<Attribute> sortColumns, boolean orderingMatched) {
        Seq projectList = V1WritesUtils$.MODULE$.convertEmptyToNull(plan.output(), partitionColumns);
        SparkPlan empty2NullPlan = projectList.nonEmpty() ? new ProjectExec(projectList, plan) : plan;
        return this.writeAndCommit(job, description, committer, (Function0<WriteTaskResult[]>)(Function0 & Serializable)() -> {
            RDD rdd;
            SortExec sortPlan;
            Option<FileFormatWriter.ConcurrentOutputWriterSpec> concurrentOutputWriterSpec;
            Tuple2 tuple2;
            Tuple2 tuple22 = orderingMatched ? new Tuple2((Object)empty2NullPlan, (Object)None$.MODULE$) : (tuple2 = (concurrentOutputWriterSpec = MODULE$.createConcurrentOutputWriterSpec(sparkSession, sortPlan = MODULE$.createSortPlan(empty2NullPlan, requiredOrdering, outputSpec), sortColumns)).isDefined() ? new Tuple2((Object)empty2NullPlan, concurrentOutputWriterSpec) : new Tuple2((Object)sortPlan, concurrentOutputWriterSpec));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            SparkPlan planToExecute = (SparkPlan)tuple2._1();
            Option concurrentOutputWriterSpec2 = (Option)tuple2._2();
            Tuple2 tuple23 = new Tuple2((Object)planToExecute, (Object)concurrentOutputWriterSpec2);
            SparkPlan planToExecute2 = (SparkPlan)tuple23._1();
            Option concurrentOutputWriterSpec3 = (Option)tuple23._2();
            if (org.apache.spark.sql.delta.util.Utils$.MODULE$.isTesting()) {
                MODULE$.executedPlan_$eq((Option<SparkPlan>)new Some((Object)planToExecute2));
            }
            RDD rddWithNonEmptyPartitions = (rdd = planToExecute2.execute()).partitions().length == 0 ? sparkSession.sparkContext().parallelize((Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq(Array$.MODULE$.empty(ClassTag$.MODULE$.apply(InternalRow.class))), 1, ClassTag$.MODULE$.apply(InternalRow.class)) : rdd;
            String jobTrackerID = SparkHadoopWriterUtils$.MODULE$.createJobTrackerID(new Date());
            WriteTaskResult[] ret = new WriteTaskResult[rddWithNonEmptyPartitions.partitions().length];
            scala.collection.immutable.Map partitionColumnToDataType = ((IterableOnceOps)description.partitionColumns().map((Function1 & Serializable)attr -> new Tuple2((Object)attr.name(), (Object)attr.dataType()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            sparkSession.sparkContext().runJob(rddWithNonEmptyPartitions, (Function2 & Serializable)(taskContext, iter) -> MODULE$.executeTask(description, jobTrackerID, taskContext.stageId(), taskContext.partitionId(), (int)taskContext.taskAttemptId() & Integer.MAX_VALUE, committer, (Iterator<InternalRow>)iter, (Option<FileFormatWriter.ConcurrentOutputWriterSpec>)concurrentOutputWriterSpec3, (scala.collection.immutable.Map<String, DataType>)partitionColumnToDataType), (Seq)ArrayOps$.MODULE$.indices$extension(Predef$.MODULE$.refArrayOps((Object[])rddWithNonEmptyPartitions.partitions())), (Function2 & Serializable)(index, res) -> {
                DeltaFileFormatWriter$.$anonfun$executeWrite$4(committer, ret, BoxesRunTime.unboxToInt((Object)index), res);
                return BoxedUnit.UNIT;
            }, ClassTag$.MODULE$.apply(WriteTaskResult.class));
            return ret;
        });
    }

    private Set<String> writeAndCommit(Job job, WriteJobDescription description, FileCommitProtocol committer, Function0<WriteTaskResult[]> f) {
        Set set;
        committer.setupJob((JobContext)job);
        try {
            WriteTaskResult[] ret = (WriteTaskResult[])f.apply();
            FileCommitProtocol.TaskCommitMessage[] commitMsgs = (FileCommitProtocol.TaskCommitMessage[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ret), (Function1 & Serializable)x$5 -> x$5.commitMsg(), ClassTag$.MODULE$.apply(FileCommitProtocol.TaskCommitMessage.class));
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Start to commit write Job ", "."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)DeltaLogKeys$.MODULE$.JOB_ID(), (Object)description.uuid())}))));
            Tuple2 tuple2 = Utils$.MODULE$.timeTakenMs((Function0)(JFunction0.mcV.sp & Serializable)() -> committer.commitJob((JobContext)job, (Seq)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)commitMsgs)));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            long duration = tuple2._2$mcJ$sp();
            long duration2 = duration;
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Write Job ", " committed. "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)DeltaLogKeys$.MODULE$.JOB_ID(), (Object)description.uuid())})).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Elapsed time: ", " ms."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)DeltaLogKeys$.MODULE$.DURATION(), (Object)BoxesRunTime.boxToLong((long)duration2))})))));
            this.processStats((Seq<WriteJobStatsTracker>)description.statsTrackers(), (Seq<Seq<WriteTaskStats>>)Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ret), (Function1 & Serializable)x$6 -> x$6.summary().stats(), ClassTag$.MODULE$.apply(Seq.class))), duration2);
            this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Finished processing stats for write job "}))).log((Seq)Nil$.MODULE$).$plus(MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", "."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)DeltaLogKeys$.MODULE$.JOB_ID(), (Object)description.uuid())})))));
            set = (Set)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ret), (Function1 & Serializable)x$7 -> x$7.summary().updatedPartitions(), ClassTag$.MODULE$.apply(Set.class))).reduceOption((Function2 & Serializable)(x$8, x$9) -> (Set)x$8.$plus$plus((IterableOnce)x$9)).getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Set().empty());
        }
        catch (Throwable cause) {
            this.logError(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Aborting job ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)DeltaLogKeys$.MODULE$.JOB_ID(), (Object)description.uuid())}))), cause);
            committer.abortJob((JobContext)job);
            throw cause;
        }
        return set;
    }

    private Set<String> executeWrite(SparkSession session, SparkPlan planForWrites, WriteFilesSpec writeFilesSpec, Job job) {
        WriteJobDescription description;
        FileCommitProtocol committer;
        block0: {
            committer = writeFilesSpec.committer();
            description = writeFilesSpec.description();
            if (!org.apache.spark.sql.delta.util.Utils$.MODULE$.isTesting()) break block0;
            this.executedPlan_$eq((Option<SparkPlan>)new Some((Object)planForWrites));
        }
        return this.writeAndCommit(job, description, committer, (Function0<WriteTaskResult[]>)(Function0 & Serializable)() -> {
            RDD rdd = planForWrites.executeWrite(writeFilesSpec);
            WriteTaskResult[] ret = new WriteTaskResult[rdd.partitions().length];
            session.sparkContext().runJob(rdd, (Function2 & Serializable)(context, iter) -> {
                Predef$.MODULE$.assert(iter.hasNext());
                WriterCommitMessage commitMessage = (WriterCommitMessage)iter.next();
                Predef$.MODULE$.assert(!iter.hasNext());
                return commitMessage;
            }, (Seq)ArrayOps$.MODULE$.indices$extension(Predef$.MODULE$.refArrayOps((Object[])rdd.partitions())), (Function2 & Serializable)(index, res) -> {
                DeltaFileFormatWriter$.$anonfun$executeWrite$7(committer, ret, BoxesRunTime.unboxToInt((Object)index), res);
                return BoxedUnit.UNIT;
            }, ClassTag$.MODULE$.apply(WriterCommitMessage.class));
            return ret;
        });
    }

    private SortExec createSortPlan(SparkPlan plan, Seq<Expression> requiredOrdering, FileFormatWriter.OutputSpec outputSpec) {
        Seq orderingExpr = BindReferences$.MODULE$.bindReferences((Seq)requiredOrdering.map((Function1 & Serializable)x$10 -> SortOrder$.MODULE$.apply(x$10, (SortDirection)Ascending$.MODULE$, SortOrder$.MODULE$.apply$default$3())), package$.MODULE$.AttributeSeq(outputSpec.outputColumns()));
        return new SortExec(orderingExpr, false, plan, SortExec$.MODULE$.apply$default$4());
    }

    private Option<FileFormatWriter.ConcurrentOutputWriterSpec> createConcurrentOutputWriterSpec(SparkSession sparkSession, SortExec sortPlan, Seq<Attribute> sortColumns) {
        boolean concurrentWritersEnabled;
        int maxWriters = sparkSession.sessionState().conf().maxConcurrentOutputFileWriters();
        boolean bl = concurrentWritersEnabled = maxWriters > 0 && sortColumns.isEmpty();
        if (concurrentWritersEnabled) {
            return new Some((Object)new FileFormatWriter.ConcurrentOutputWriterSpec(maxWriters, (Function0 & Serializable)() -> sortPlan.createSorter()));
        }
        return None$.MODULE$;
    }

    private WriteTaskResult executeTask(WriteJobDescription description, String jobTrackerID, int sparkStageId, int sparkPartitionId, int sparkAttemptNumber, FileCommitProtocol committer, Iterator<InternalRow> iterator, Option<FileFormatWriter.ConcurrentOutputWriterSpec> concurrentOutputWriterSpec, scala.collection.immutable.Map<String, DataType> partitionColumnToDataType) {
        WriteTaskResult writeTaskResult;
        EmptyDirectoryDataWriter emptyDirectoryDataWriter;
        JobID jobId = SparkHadoopWriterUtils$.MODULE$.createJobID(jobTrackerID, sparkStageId);
        TaskID taskId = new TaskID((org.apache.hadoop.mapreduce.JobID)jobId, TaskType.MAP, sparkPartitionId);
        TaskAttemptID taskAttemptId = new TaskAttemptID(taskId, sparkAttemptNumber);
        Configuration hadoopConf = description.serializableHadoopConf().value();
        hadoopConf.set("mapreduce.job.id", jobId.toString());
        hadoopConf.set("mapreduce.task.id", taskAttemptId.getTaskID().toString());
        hadoopConf.set("mapreduce.task.attempt.id", taskAttemptId.toString());
        hadoopConf.setBoolean("mapreduce.task.ismap", true);
        hadoopConf.setInt("mapreduce.task.partition", 0);
        TaskAttemptContextImpl taskAttemptContext = partitionColumnToDataType.isEmpty() ? new TaskAttemptContextImpl(hadoopConf, taskAttemptId) : new DeltaFileFormatWriter.PartitionedTaskAttemptContextImpl(hadoopConf, taskAttemptId, partitionColumnToDataType);
        committer.setupTask((TaskAttemptContext)taskAttemptContext);
        if (sparkPartitionId != 0 && !iterator.hasNext()) {
            emptyDirectoryDataWriter = new EmptyDirectoryDataWriter(description, (TaskAttemptContext)taskAttemptContext, committer, EmptyDirectoryDataWriter$.MODULE$.$lessinit$greater$default$4());
        } else if (description.partitionColumns().isEmpty() && description.bucketSpec().isEmpty()) {
            emptyDirectoryDataWriter = new SingleDirectoryDataWriter(description, (TaskAttemptContext)taskAttemptContext, committer, SingleDirectoryDataWriter$.MODULE$.$lessinit$greater$default$4());
        } else {
            Option<FileFormatWriter.ConcurrentOutputWriterSpec> option = concurrentOutputWriterSpec;
            if (option instanceof Some) {
                Some some = (Some)option;
                FileFormatWriter.ConcurrentOutputWriterSpec spec = (FileFormatWriter.ConcurrentOutputWriterSpec)some.value();
                emptyDirectoryDataWriter = new DynamicPartitionDataConcurrentWriter(description, (TaskAttemptContext)taskAttemptContext, committer, spec, DynamicPartitionDataConcurrentWriter$.MODULE$.$lessinit$greater$default$5());
            } else {
                emptyDirectoryDataWriter = new DynamicPartitionDataSingleWriter(description, (TaskAttemptContext)taskAttemptContext, committer, DynamicPartitionDataSingleWriter$.MODULE$.$lessinit$greater$default$4());
            }
        }
        EmptyDirectoryDataWriter dataWriter = emptyDirectoryDataWriter;
        try {
            writeTaskResult = (WriteTaskResult)Utils$.MODULE$.tryWithSafeFinallyAndFailureCallbacks(() -> DeltaFileFormatWriter$.$anonfun$executeTask$1((FileFormatDataWriter)dataWriter, iterator), (Function0)((JFunction0.mcV.sp & Serializable)() -> DeltaFileFormatWriter$.$anonfun$executeTask$2((FileFormatDataWriter)dataWriter, jobId)), (Function0)((JFunction0.mcV.sp & Serializable)() -> DeltaFileFormatWriter$.$anonfun$executeTask$4((FileFormatDataWriter)dataWriter)));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof FetchFailedException) {
                FetchFailedException fetchFailedException = (FetchFailedException)throwable2;
                throw fetchFailedException;
            }
            if (throwable2 instanceof FileAlreadyExistsException) {
                FileAlreadyExistsException fileAlreadyExistsException = (FileAlreadyExistsException)throwable2;
                if (SQLConf$.MODULE$.get().fastFailFileFormatOutput()) {
                    throw new TaskOutputFileAlreadyExistException((Throwable)fileAlreadyExistsException);
                }
            }
            if (throwable2 != null) {
                Throwable throwable3 = throwable2;
                throw QueryExecutionErrors$.MODULE$.taskFailedWhileWritingRowsError(description.path(), throwable3);
            }
            throw throwable;
        }
        return writeTaskResult;
    }

    private void processStats(Seq<WriteJobStatsTracker> statsTrackers, Seq<Seq<WriteTaskStats>> statsPerTask, long jobCommitDuration) {
        int numStatsTrackers = statsTrackers.length();
        Predef$.MODULE$.assert(statsPerTask.forall((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)DeltaFileFormatWriter$.$anonfun$processStats$1(numStatsTrackers, x$11))), (Function0 & Serializable)() -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(178).append("Every WriteTask should have produced one `WriteTaskStats` object for every tracker.\n         |There are ").append(numStatsTrackers).append(" statsTrackers, but some task returned\n         |").append(((SeqOps)statsPerTask.find((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)DeltaFileFormatWriter$.$anonfun$processStats$3(numStatsTrackers, x$12))).get()).length()).append(" results instead.\n       ").toString())));
        Seq statsPerTracker = statsPerTask.nonEmpty() ? (Seq)statsPerTask.transpose(Predef$.MODULE$.$conforms()) : (Seq)statsTrackers.map((Function1 & Serializable)x$13 -> (Seq)scala.package$.MODULE$.Seq().empty());
        ((IterableOnceOps)statsTrackers.zip((IterableOnce)statsPerTracker)).foreach((Function1 & Serializable)x0$1 -> {
            DeltaFileFormatWriter$.$anonfun$processStats$5(jobCommitDuration, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private static final SparkPlan materializeAdaptiveSparkPlan$1(SparkPlan plan2) {
        SparkPlan sparkPlan = plan2;
        if (sparkPlan instanceof AdaptiveSparkPlanExec) {
            AdaptiveSparkPlanExec adaptiveSparkPlanExec = (AdaptiveSparkPlanExec)sparkPlan;
            return adaptiveSparkPlanExec.finalPhysicalPlan();
        }
        if (sparkPlan != null) {
            SparkPlan sparkPlan2 = sparkPlan;
            return (SparkPlan)sparkPlan2.withNewChildren((Seq)sparkPlan2.children().map((Function1 & Serializable)plan -> DeltaFileFormatWriter$.materializeAdaptiveSparkPlan$1(plan)));
        }
        throw new MatchError((Object)sparkPlan);
    }

    public static final /* synthetic */ void $anonfun$executeWrite$4(FileCommitProtocol committer$1, WriteTaskResult[] ret$1, int index, WriteTaskResult res) {
        committer$1.onTaskCommit(res.commitMsg());
        ret$1[index] = res;
    }

    public static final /* synthetic */ void $anonfun$executeWrite$7(FileCommitProtocol committer$3, WriteTaskResult[] ret$2, int index, WriterCommitMessage res) {
        Predef$.MODULE$.assert(res instanceof WriteTaskResult);
        WriteTaskResult writeTaskResult = (WriteTaskResult)res;
        committer$3.onTaskCommit(writeTaskResult.commitMsg());
        ret$2[index] = writeTaskResult;
    }

    public static final /* synthetic */ WriteTaskResult $anonfun$executeTask$1(FileFormatDataWriter dataWriter$1, Iterator iterator$1) {
        dataWriter$1.writeWithIterator(iterator$1);
        return dataWriter$1.commit();
    }

    public static final /* synthetic */ void $anonfun$executeTask$2(FileFormatDataWriter dataWriter$1, JobID jobId$1) {
        dataWriter$1.abort();
        MODULE$.logError(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Job ", " aborted."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)DeltaLogKeys$.MODULE$.JOB_ID(), (Object)jobId$1)}))));
    }

    public static final /* synthetic */ void $anonfun$executeTask$4(FileFormatDataWriter dataWriter$1) {
        dataWriter$1.close();
    }

    public static final /* synthetic */ boolean $anonfun$processStats$1(int numStatsTrackers$1, Seq x$11) {
        return x$11.length() == numStatsTrackers$1;
    }

    public static final /* synthetic */ boolean $anonfun$processStats$3(int numStatsTrackers$1, Seq x$12) {
        return x$12.length() != numStatsTrackers$1;
    }

    public static final /* synthetic */ void $anonfun$processStats$5(long jobCommitDuration$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            WriteJobStatsTracker statsTracker = (WriteJobStatsTracker)tuple2._1();
            Seq stats = (Seq)tuple2._2();
            statsTracker.processStats(stats, jobCommitDuration$1);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private DeltaFileFormatWriter$() {
    }
}

