/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.sources;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Map;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaHistoryManager;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaOptions;
import org.apache.spark.sql.delta.DeltaUnsupportedTableFeatureException;
import org.apache.spark.sql.delta.SnapshotDescriptor;
import org.apache.spark.sql.delta.actions.Action;
import org.apache.spark.sql.delta.actions.Action$;
import org.apache.spark.sql.delta.logging.DeltaLogKeys$;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.sources.DeltaSource;
import org.apache.spark.sql.delta.sources.DeltaSourceMetadataTrackingLog;
import org.apache.spark.sql.delta.storage.ClosableIterator;
import org.apache.spark.sql.delta.storage.ClosableIterator$;
import org.apache.spark.sql.delta.storage.ClosableIterator$ClosableWrapper$;
import org.apache.spark.sql.delta.storage.ClosableIterator$IteratorCloseOps$;
import org.apache.spark.sql.delta.util.DateTimeUtils$;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.delta.util.TimestampFormatter;
import org.apache.spark.sql.delta.util.TimestampFormatter$;
import org.slf4j.Logger;
import scala.;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple7;
import scala.collection.BufferedIterator;
import scala.collection.Factory;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Stepper;
import scala.collection.StepperShape;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

public final class DeltaSource$
implements DeltaLogging,
Serializable {
    public static final DeltaSource$ MODULE$ = new DeltaSource$();
    private static transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        Logging.$init$((Logging)MODULE$);
        DeltaProgressReporter.$init$(MODULE$);
        DatabricksLogging.$init$(MODULE$);
        DeltaLogging.$init$(MODULE$);
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, scala.collection.immutable.Map<TagDefinition, String> tags, Object data, Option<Path> path) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data, path);
    }

    @Override
    public scala.collection.immutable.Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public Option<Path> recordDeltaEvent$default$5() {
        return DeltaLogging.recordDeltaEvent$default$5$(this);
    }

    @Override
    public <A> A recordDeltaOperationForTablePath(String tablePath, String opType, scala.collection.immutable.Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperationForTablePath$(this, tablePath, opType, tags, thunk);
    }

    @Override
    public <A> scala.collection.immutable.Map<TagDefinition, String> recordDeltaOperationForTablePath$default$3() {
        return DeltaLogging.recordDeltaOperationForTablePath$default$3$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, scala.collection.immutable.Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> scala.collection.immutable.Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public void deltaAssert(Function0<Object> check, String name, String msg, DeltaLog deltaLog, Object data, Option<Path> path) {
        DeltaLogging.deltaAssert$(this, check, name, msg, deltaLog, data, path);
    }

    @Override
    public DeltaLog deltaAssert$default$4() {
        return DeltaLogging.deltaAssert$default$4$(this);
    }

    @Override
    public Object deltaAssert$default$5() {
        return DeltaLogging.deltaAssert$default$5$(this);
    }

    @Override
    public Option<Path> deltaAssert$default$6() {
        return DeltaLogging.deltaAssert$default$6$(this);
    }

    @Override
    public <T> T recordFrameProfile(String group, String name, Function0<T> thunk) {
        return (T)DeltaLogging.recordFrameProfile$(this, group, name, thunk);
    }

    @Override
    public scala.collection.immutable.Map<TagDefinition, String> getCommonTags(DeltaLog deltaLog, String tahoeId) {
        return DeltaLogging.getCommonTags$(this, deltaLog, tahoeId);
    }

    @Override
    public scala.collection.immutable.Map<String, Object> getErrorData(Throwable e) {
        return DeltaLogging.getErrorData$(this, e);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, scala.collection.immutable.Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public scala.collection.immutable.Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, scala.collection.immutable.Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public scala.collection.immutable.Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, scala.collection.immutable.Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public void recordProductUsage(MetricDefinition metric, double quantity, scala.collection.immutable.Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordProductUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public scala.collection.immutable.Map<TagDefinition, String> recordProductUsage$default$3() {
        return DatabricksLogging.recordProductUsage$default$3$(this);
    }

    @Override
    public String recordProductUsage$default$4() {
        return DatabricksLogging.recordProductUsage$default$4$(this);
    }

    @Override
    public boolean recordProductUsage$default$5() {
        return DatabricksLogging.recordProductUsage$default$5$(this);
    }

    @Override
    public boolean recordProductUsage$default$6() {
        return DatabricksLogging.recordProductUsage$default$6$(this);
    }

    @Override
    public boolean recordProductUsage$default$7() {
        return DatabricksLogging.recordProductUsage$default$7$(this);
    }

    @Override
    public void recordProductEvent(MetricDefinition metric, scala.collection.immutable.Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordProductEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public scala.collection.immutable.Map<TagDefinition, String> recordProductEvent$default$2() {
        return DatabricksLogging.recordProductEvent$default$2$(this);
    }

    @Override
    public String recordProductEvent$default$3() {
        return DatabricksLogging.recordProductEvent$default$3$(this);
    }

    @Override
    public boolean recordProductEvent$default$4() {
        return DatabricksLogging.recordProductEvent$default$4$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, scala.collection.immutable.Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> scala.collection.immutable.Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Option<DeltaSourceMetadataTrackingLog> $lessinit$greater$default$6() {
        return None$.MODULE$;
    }

    public Seq<Expression> $lessinit$greater$default$7() {
        return Nil$.MODULE$;
    }

    public boolean validateProtocolAt(SparkSession spark, DeltaLog deltaLog, long version) {
        boolean alwaysValidateProtocol = BoxesRunTime.unboxToBoolean((Object)spark.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.FAST_DROP_FEATURE_STREAMING_ALWAYS_VALIDATE_PROTOCOL()));
        if (!alwaysValidateProtocol) {
            return false;
        }
        try {
            deltaLog.getSnapshotAt(version, deltaLog.getSnapshotAt$default$2(), deltaLog.getSnapshotAt$default$3());
            return true;
        }
        catch (DeltaUnsupportedTableFeatureException deltaUnsupportedTableFeatureException) {
            DeltaLog x$1 = deltaLog;
            String x$2 = "dropFeature.validateProtocolAt.unsupportedFeatureFound";
            scala.collection.immutable.Map x$3 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), (Object)deltaUnsupportedTableFeatureException.getMessage())}));
            scala.collection.immutable.Map<TagDefinition, String> x$4 = this.recordDeltaEvent$default$3();
            Option<Path> x$5 = this.recordDeltaEvent$default$5();
            this.recordDeltaEvent(x$1, "dropFeature.validateProtocolAt.unsupportedFeatureFound", x$4, x$3, x$5);
            throw deltaUnsupportedTableFeatureException;
        }
        catch (Throwable throwable) {
            if (!NonFatal$.MODULE$.apply(throwable)) {
                throw throwable;
            }
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> MODULE$.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Protocol validation failed with '", "'."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)DeltaLogKeys$.MODULE$.EXCEPTION(), (Object)throwable)}))));
            DeltaLog x$6 = deltaLog;
            String x$7 = "dropFeature.validateProtocolAt.error";
            scala.collection.immutable.Map x$8 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"message"), (Object)throwable.getMessage())}));
            scala.collection.immutable.Map<TagDefinition, String> x$9 = this.recordDeltaEvent$default$3();
            Option<Path> x$10 = this.recordDeltaEvent$default$5();
            this.recordDeltaEvent(x$6, "dropFeature.validateProtocolAt.error", x$9, x$8, x$10);
            return false;
        }
    }

    public long getStartingVersionFromTimestamp(SparkSession spark, DeltaLog deltaLog, Timestamp timestamp, boolean canExceedLatest) {
        boolean latestNotExceeded;
        String tz = spark.sessionState().conf().sessionLocalTimeZone();
        DeltaHistoryManager.Commit commit = deltaLog.history().getActiveCommitAtTime(timestamp, (Option<CatalogTable>)None$.MODULE$, true, false, true);
        if (commit.timestamp() >= timestamp.getTime()) {
            this.validateProtocolAt(spark, deltaLog, commit.version());
            return commit.version();
        }
        boolean bl = latestNotExceeded = commit.version() + 1L <= deltaLog.unsafeVolatileSnapshot().version();
        if (latestNotExceeded || canExceedLatest) {
            Object object = latestNotExceeded ? BoxesRunTime.boxToBoolean((boolean)this.validateProtocolAt(spark, deltaLog, commit.version() + 1L)) : BoxedUnit.UNIT;
            return commit.version() + 1L;
        }
        Timestamp commitTs = new Timestamp(commit.timestamp());
        TimestampFormatter timestampFormatter = TimestampFormatter$.MODULE$.apply(DateTimeUtils$.MODULE$.getTimeZone(tz));
        String tsString = DateTimeUtils$.MODULE$.timestampToString(timestampFormatter, DateTimeUtils$.MODULE$.fromJavaTimestamp(commitTs));
        throw DeltaErrors$.MODULE$.timestampGreaterThanLatestCommit(timestamp, commitTs, tsString);
    }

    public boolean getStartingVersionFromTimestamp$default$4() {
        return false;
    }

    public ClosableIterator<Action> createRewindableActionIterator(SparkSession spark, DeltaLog deltaLog, FileStatus fileStatus) {
        LazyRef actions$lzy = new LazyRef();
        long threshold = BoxesRunTime.unboxToLong((Object)spark.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.LOG_SIZE_IN_MEMORY_THRESHOLD()));
        boolean shouldLoadIntoMemory = fileStatus.getLen() < threshold;
        return new ClosableIterator<Action>(shouldLoadIntoMemory, deltaLog, fileStatus, actions$lzy){
            private ClosableIterator<Action> delegatedIterator;
            private final boolean shouldLoadIntoMemory$1;
            private final DeltaLog deltaLog$1;
            private final FileStatus fileStatus$1;
            private final LazyRef actions$lzy$1;

            public <R> R processAndClose(Function1<Iterator<Action>, R> f) {
                return (R)ClosableIterator.processAndClose$(this, f);
            }

            public final boolean hasDefiniteSize() {
                return Iterator.hasDefiniteSize$((Iterator)this);
            }

            public final Iterator<Action> iterator() {
                return Iterator.iterator$((Iterator)this);
            }

            public Option<Action> nextOption() {
                return Iterator.nextOption$((Iterator)this);
            }

            public boolean contains(Object elem) {
                return Iterator.contains$((Iterator)this, (Object)elem);
            }

            public BufferedIterator<Action> buffered() {
                return Iterator.buffered$((Iterator)this);
            }

            public <B> Iterator<B> padTo(int len, B elem) {
                return Iterator.padTo$((Iterator)this, (int)len, elem);
            }

            public Tuple2<Iterator<Action>, Iterator<Action>> partition(Function1<Action, Object> p) {
                return Iterator.partition$((Iterator)this, p);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.grouped$((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.sliding$((Iterator)this, (int)size, (int)step);
            }

            public <B> int sliding$default$2() {
                return Iterator.sliding$default$2$((Iterator)this);
            }

            public <B$> Iterator<B$> scanLeft(B$ z, Function2<B$, Action, B$> op) {
                return Iterator.scanLeft$((Iterator)this, z, op);
            }

            public <B$> Iterator<B$> scanRight(B$ z, Function2<Action, B$, B$> op) {
                return Iterator.scanRight$((Iterator)this, z, op);
            }

            public int indexWhere(Function1<Action, Object> p, int from) {
                return Iterator.indexWhere$((Iterator)this, p, (int)from);
            }

            public int indexWhere$default$2() {
                return Iterator.indexWhere$default$2$((Iterator)this);
            }

            public <B> int indexOf(B elem) {
                return Iterator.indexOf$((Iterator)this, elem);
            }

            public <B> int indexOf(B elem, int from) {
                return Iterator.indexOf$((Iterator)this, elem, (int)from);
            }

            public final int length() {
                return Iterator.length$((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.isEmpty$((Iterator)this);
            }

            public Iterator<Action> filter(Function1<Action, Object> p) {
                return Iterator.filter$((Iterator)this, p);
            }

            public Iterator<Action> filterNot(Function1<Action, Object> p) {
                return Iterator.filterNot$((Iterator)this, p);
            }

            public Iterator<Action> filterImpl(Function1<Action, Object> p, boolean isFlipped) {
                return Iterator.filterImpl$((Iterator)this, p, (boolean)isFlipped);
            }

            public Iterator<Action> withFilter(Function1<Action, Object> p) {
                return Iterator.withFilter$((Iterator)this, p);
            }

            public <B$> Iterator<B$> collect(PartialFunction<Action, B$> pf) {
                return Iterator.collect$((Iterator)this, pf);
            }

            public Iterator<Action> distinct() {
                return Iterator.distinct$((Iterator)this);
            }

            public <B$> Iterator<Action> distinctBy(Function1<Action, B$> f) {
                return Iterator.distinctBy$((Iterator)this, f);
            }

            public <B$> Iterator<B$> map(Function1<Action, B$> f) {
                return Iterator.map$((Iterator)this, f);
            }

            public <B$> Iterator<B$> flatMap(Function1<Action, IterableOnce<B$>> f) {
                return Iterator.flatMap$((Iterator)this, f);
            }

            public <B$> Iterator<B$> flatten(Function1<Action, IterableOnce<B$>> ev) {
                return Iterator.flatten$((Iterator)this, ev);
            }

            public <B> Iterator<B> concat(Function0<IterableOnce<B>> xs) {
                return Iterator.concat$((Iterator)this, xs);
            }

            public final <B> Iterator<B> $plus$plus(Function0<IterableOnce<B>> xs) {
                return Iterator.$plus$plus$((Iterator)this, xs);
            }

            public Iterator<Action> take(int n) {
                return Iterator.take$((Iterator)this, (int)n);
            }

            public Iterator<Action> takeWhile(Function1<Action, Object> p) {
                return Iterator.takeWhile$((Iterator)this, p);
            }

            public Iterator<Action> drop(int n) {
                return Iterator.drop$((Iterator)this, (int)n);
            }

            public Iterator<Action> dropWhile(Function1<Action, Object> p) {
                return Iterator.dropWhile$((Iterator)this, p);
            }

            public Tuple2<Iterator<Action>, Iterator<Action>> span(Function1<Action, Object> p) {
                return Iterator.span$((Iterator)this, p);
            }

            public Iterator<Action> slice(int from, int until) {
                return Iterator.slice$((Iterator)this, (int)from, (int)until);
            }

            public Iterator<Action> sliceIterator(int from, int until) {
                return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
            }

            public <B$> Iterator<Tuple2<Action, B$>> zip(IterableOnce<B$> that) {
                return Iterator.zip$((Iterator)this, that);
            }

            public <A1, B> Iterator<Tuple2<A1, B>> zipAll(IterableOnce<B> that, A1 thisElem, B thatElem) {
                return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
            }

            public Iterator<Tuple2<Action, Object>> zipWithIndex() {
                return Iterator.zipWithIndex$((Iterator)this);
            }

            public <B> boolean sameElements(IterableOnce<B> that) {
                return Iterator.sameElements$((Iterator)this, that);
            }

            public Tuple2<Iterator<Action>, Iterator<Action>> duplicate() {
                return Iterator.duplicate$((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <U> Iterator<Action> tapEach(Function1<Action, U> f) {
                return Iterator.tapEach$((Iterator)this, f);
            }

            public String toString() {
                return Iterator.toString$((Iterator)this);
            }

            public Iterator<Action> seq() {
                return Iterator.seq$((Iterator)this);
            }

            public Tuple2<Iterator<Action>, Iterator<Action>> splitAt(int n) {
                return IterableOnceOps.splitAt$((IterableOnceOps)this, (int)n);
            }

            public boolean isTraversableAgain() {
                return IterableOnceOps.isTraversableAgain$((IterableOnceOps)this);
            }

            public <U> void foreach(Function1<Action, U> f) {
                IterableOnceOps.foreach$((IterableOnceOps)this, f);
            }

            public boolean forall(Function1<Action, Object> p) {
                return IterableOnceOps.forall$((IterableOnceOps)this, p);
            }

            public boolean exists(Function1<Action, Object> p) {
                return IterableOnceOps.exists$((IterableOnceOps)this, p);
            }

            public int count(Function1<Action, Object> p) {
                return IterableOnceOps.count$((IterableOnceOps)this, p);
            }

            public Option<Action> find(Function1<Action, Object> p) {
                return IterableOnceOps.find$((IterableOnceOps)this, p);
            }

            public <B$> B$ foldLeft(B$ z, Function2<B$, Action, B$> op) {
                return (B$)IterableOnceOps.foldLeft$((IterableOnceOps)this, z, op);
            }

            public <B$> B$ foldRight(B$ z, Function2<Action, B$, B$> op) {
                return (B$)IterableOnceOps.foldRight$((IterableOnceOps)this, z, op);
            }

            public final <B$> B$ $div$colon(B$ z, Function2<B$, Action, B$> op) {
                return (B$)IterableOnceOps.$div$colon$((IterableOnceOps)this, z, op);
            }

            public final <B$> B$ $colon$bslash(B$ z, Function2<Action, B$, B$> op) {
                return (B$)IterableOnceOps.$colon$bslash$((IterableOnceOps)this, z, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)IterableOnceOps.fold$((IterableOnceOps)this, z, op);
            }

            public <B> B reduce(Function2<B, B, B> op) {
                return (B)IterableOnceOps.reduce$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceOption(Function2<B, B, B> op) {
                return IterableOnceOps.reduceOption$((IterableOnceOps)this, op);
            }

            public <B> B reduceLeft(Function2<B, Action, B> op) {
                return (B)IterableOnceOps.reduceLeft$((IterableOnceOps)this, op);
            }

            public <B> B reduceRight(Function2<Action, B, B> op) {
                return (B)IterableOnceOps.reduceRight$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, Action, B> op) {
                return IterableOnceOps.reduceLeftOption$((IterableOnceOps)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<Action, B, B> op) {
                return IterableOnceOps.reduceRightOption$((IterableOnceOps)this, op);
            }

            public boolean nonEmpty() {
                return IterableOnceOps.nonEmpty$((IterableOnceOps)this);
            }

            public int size() {
                return IterableOnceOps.size$((IterableOnceOps)this);
            }

            public final <B> void copyToBuffer(Buffer<B> dest) {
                IterableOnceOps.copyToBuffer$((IterableOnceOps)this, dest);
            }

            public <B> int copyToArray(Object xs) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs);
            }

            public <B> int copyToArray(Object xs, int start) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start);
            }

            public <B> int copyToArray(Object xs, int start, int len) {
                return IterableOnceOps.copyToArray$((IterableOnceOps)this, (Object)xs, (int)start, (int)len);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)IterableOnceOps.sum$((IterableOnceOps)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)IterableOnceOps.product$((IterableOnceOps)this, num);
            }

            public Object min(Ordering ord) {
                return IterableOnceOps.min$((IterableOnceOps)this, (Ordering)ord);
            }

            public <B> Option<Action> minOption(Ordering<B> ord) {
                return IterableOnceOps.minOption$((IterableOnceOps)this, ord);
            }

            public Object max(Ordering ord) {
                return IterableOnceOps.max$((IterableOnceOps)this, (Ordering)ord);
            }

            public <B> Option<Action> maxOption(Ordering<B> ord) {
                return IterableOnceOps.maxOption$((IterableOnceOps)this, ord);
            }

            public Object maxBy(Function1 f, Ordering ord) {
                return IterableOnceOps.maxBy$((IterableOnceOps)this, (Function1)f, (Ordering)ord);
            }

            public <B$> Option<Action> maxByOption(Function1<Action, B$> f, Ordering<B$> ord) {
                return IterableOnceOps.maxByOption$((IterableOnceOps)this, f, ord);
            }

            public Object minBy(Function1 f, Ordering ord) {
                return IterableOnceOps.minBy$((IterableOnceOps)this, (Function1)f, (Ordering)ord);
            }

            public <B$> Option<Action> minByOption(Function1<Action, B$> f, Ordering<B$> ord) {
                return IterableOnceOps.minByOption$((IterableOnceOps)this, f, ord);
            }

            public <B$> Option<B$> collectFirst(PartialFunction<Action, B$> pf) {
                return IterableOnceOps.collectFirst$((IterableOnceOps)this, pf);
            }

            public <B$> B$ aggregate(Function0<B$> z, Function2<B$, Action, B$> seqop, Function2<B$, B$, B$> combop) {
                return (B$)IterableOnceOps.aggregate$((IterableOnceOps)this, z, seqop, combop);
            }

            public <B$> boolean corresponds(IterableOnce<B$> that, Function2<Action, B$, Object> p) {
                return IterableOnceOps.corresponds$((IterableOnceOps)this, that, p);
            }

            public final String mkString(String start, String sep, String end) {
                return IterableOnceOps.mkString$((IterableOnceOps)this, (String)start, (String)sep, (String)end);
            }

            public final String mkString(String sep) {
                return IterableOnceOps.mkString$((IterableOnceOps)this, (String)sep);
            }

            public final String mkString() {
                return IterableOnceOps.mkString$((IterableOnceOps)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public final StringBuilder addString(StringBuilder b, String sep) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b, (String)sep);
            }

            public final StringBuilder addString(StringBuilder b) {
                return IterableOnceOps.addString$((IterableOnceOps)this, (StringBuilder)b);
            }

            public <C1> C1 to(Factory<Action, C1> factory) {
                return (C1)IterableOnceOps.to$((IterableOnceOps)this, factory);
            }

            public final Iterator<Action> toIterator() {
                return IterableOnceOps.toIterator$((IterableOnceOps)this);
            }

            public List<Action> toList() {
                return IterableOnceOps.toList$((IterableOnceOps)this);
            }

            public Vector<Action> toVector() {
                return IterableOnceOps.toVector$((IterableOnceOps)this);
            }

            public <K, V> scala.collection.immutable.Map<K, V> toMap(.less.colon.less<Action, Tuple2<K, V>> ev) {
                return IterableOnceOps.toMap$((IterableOnceOps)this, ev);
            }

            public <B> Set<B> toSet() {
                return IterableOnceOps.toSet$((IterableOnceOps)this);
            }

            public Seq<Action> toSeq() {
                return IterableOnceOps.toSeq$((IterableOnceOps)this);
            }

            public IndexedSeq<Action> toIndexedSeq() {
                return IterableOnceOps.toIndexedSeq$((IterableOnceOps)this);
            }

            public final Stream<Action> toStream() {
                return IterableOnceOps.toStream$((IterableOnceOps)this);
            }

            public final <B> Buffer<B> toBuffer() {
                return IterableOnceOps.toBuffer$((IterableOnceOps)this);
            }

            public <B> Object toArray(ClassTag<B> evidence$2) {
                return IterableOnceOps.toArray$((IterableOnceOps)this, evidence$2);
            }

            public Iterable<Action> reversed() {
                return IterableOnceOps.reversed$((IterableOnceOps)this);
            }

            public <S extends Stepper<?>> S stepper(StepperShape<Action, S> shape) {
                return (S)IterableOnce.stepper$((IterableOnce)this, shape);
            }

            public int knownSize() {
                return IterableOnce.knownSize$((IterableOnce)this);
            }

            private ClosableIterator<Action> delegatedIterator() {
                return this.delegatedIterator;
            }

            private void delegatedIterator_$eq(ClosableIterator<Action> x$1) {
                this.delegatedIterator = x$1;
            }

            public boolean hasNext() {
                return this.delegatedIterator().hasNext();
            }

            public Action next() {
                return (Action)this.delegatedIterator().next();
            }

            public void close() {
                this.delegatedIterator().close();
            }

            public void rewind() {
                this.delegatedIterator_$eq(DeltaSource$.org$apache$spark$sql$delta$sources$DeltaSource$$createClosableIterator$1(this.shouldLoadIntoMemory$1, this.deltaLog$1, this.fileStatus$1, this.actions$lzy$1));
            }
            {
                this.shouldLoadIntoMemory$1 = shouldLoadIntoMemory$1;
                this.deltaLog$1 = deltaLog$1;
                this.fileStatus$1 = fileStatus$1;
                this.actions$lzy$1 = actions$lzy$1;
                IterableOnce.$init$((IterableOnce)this);
                IterableOnceOps.$init$((IterableOnceOps)this);
                Iterator.$init$((Iterator)this);
                ClosableIterator.$init$(this);
                this.delegatedIterator = DeltaSource$.org$apache$spark$sql$delta$sources$DeltaSource$$createClosableIterator$1(shouldLoadIntoMemory$1, deltaLog$1, fileStatus$1, actions$lzy$1);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public <T> Option<T> iteratorLast(ClosableIterator<T> iter) {
        void v0;
        try {
            void var2_2;
            None$ last = None$.MODULE$;
            while (iter.hasNext()) {
                last = new Some(iter.next());
            }
            v0 = var2_2;
        }
        finally {
            iter.close();
        }
        return v0;
    }

    public DeltaSource apply(SparkSession spark, DeltaLog deltaLog, DeltaOptions options, SnapshotDescriptor snapshotAtSourceInit, String metadataPath, Option<DeltaSourceMetadataTrackingLog> metadataTrackingLog, Seq<Expression> filters) {
        return new DeltaSource(spark, deltaLog, options, snapshotAtSourceInit, metadataPath, metadataTrackingLog, filters);
    }

    public Option<DeltaSourceMetadataTrackingLog> apply$default$6() {
        return None$.MODULE$;
    }

    public Seq<Expression> apply$default$7() {
        return Nil$.MODULE$;
    }

    public Option<Tuple7<SparkSession, DeltaLog, DeltaOptions, SnapshotDescriptor, String, Option<DeltaSourceMetadataTrackingLog>, Seq<Expression>>> unapply(DeltaSource x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple7((Object)x$0.spark(), (Object)x$0.deltaLog(), (Object)x$0.options(), (Object)x$0.snapshotAtSourceInit(), (Object)x$0.metadataPath(), x$0.metadataTrackingLog(), x$0.filters()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DeltaSource$.class);
    }

    private static final /* synthetic */ Seq actions$lzycompute$1(LazyRef actions$lzy$1, DeltaLog deltaLog$1, FileStatus fileStatus$1) {
        Seq seq;
        LazyRef lazyRef = actions$lzy$1;
        synchronized (lazyRef) {
            seq = actions$lzy$1.initialized() ? (Seq)actions$lzy$1.value() : (Seq)actions$lzy$1.initialize(deltaLog$1.store().read(fileStatus$1, deltaLog$1.newDeltaHadoopConf()).map((Function1 & Serializable)json -> Action$.MODULE$.fromJson((String)json)));
        }
        return seq;
    }

    private static final Seq actions$1(LazyRef actions$lzy$1, DeltaLog deltaLog$1, FileStatus fileStatus$1) {
        if (actions$lzy$1.initialized()) {
            return (Seq)actions$lzy$1.value();
        }
        return DeltaSource$.actions$lzycompute$1(actions$lzy$1, deltaLog$1, fileStatus$1);
    }

    public static final ClosableIterator org$apache$spark$sql$delta$sources$DeltaSource$$createClosableIterator$1(boolean shouldLoadIntoMemory$1, DeltaLog deltaLog$1, FileStatus fileStatus$1, LazyRef actions$lzy$1) {
        if (shouldLoadIntoMemory$1) {
            return ClosableIterator$ClosableWrapper$.MODULE$.toClosable$extension(ClosableIterator$.MODULE$.ClosableWrapper(DeltaSource$.actions$1(actions$lzy$1, deltaLog$1, fileStatus$1).toIterator()));
        }
        return ClosableIterator$IteratorCloseOps$.MODULE$.withClose$extension(ClosableIterator$.MODULE$.IteratorCloseOps(deltaLog$1.store().readAsIterator(fileStatus$1, deltaLog$1.newDeltaHadoopConf())), (Function1 & Serializable)x$28 -> x$28.map((Function1 & Serializable)json -> Action$.MODULE$.fromJson((String)json)));
    }

    private DeltaSource$() {
    }
}

