/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.sources;

import java.io.Serializable;
import java.sql.Timestamp;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.delta.actions.Action;
import org.apache.spark.sql.delta.actions.AddCDCFile;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.delta.actions.CommitInfo;
import org.apache.spark.sql.delta.actions.CommitInfo$;
import org.apache.spark.sql.delta.actions.DeletionVectorDescriptor;
import org.apache.spark.sql.delta.actions.DomainMetadata;
import org.apache.spark.sql.delta.actions.FileAction;
import org.apache.spark.sql.delta.actions.JobInfo;
import org.apache.spark.sql.delta.actions.Metadata;
import org.apache.spark.sql.delta.actions.NotebookInfo;
import org.apache.spark.sql.delta.actions.Protocol;
import org.apache.spark.sql.delta.actions.RemoveFile;
import org.apache.spark.sql.delta.actions.SetTransaction;
import org.apache.spark.sql.delta.commands.cdc.CDCReader$;
import org.apache.spark.sql.delta.logging.DeltaLogKeys$;
import org.apache.spark.sql.delta.sources.DeltaSource;
import org.apache.spark.sql.delta.sources.DeltaSourceBase;
import org.apache.spark.sql.delta.sources.DeltaSourceMetadataEvolutionSupport;
import org.apache.spark.sql.delta.sources.DeltaSourceOffset;
import org.apache.spark.sql.delta.sources.DeltaSourceOffset$;
import org.apache.spark.sql.delta.sources.IndexedFile;
import org.apache.spark.sql.delta.sources.IndexedFile$;
import org.apache.spark.util.Utils$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple5;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dg!\u0003\f\u0018!\u0003\r\t\u0001JAc\u0011\u0015Y\u0003\u0001\"\u0001-\r\u0011\u0001\u0004\u0001A\u0019\t\u0011I\u0012!\u0011!Q\u0001\nMB\u0001b\u0011\u0002\u0003\u0002\u0003\u0006I\u0001\u0012\u0005\u0006\u000f\n!\t\u0001\u0013\u0005\u0006\u001b\n!IA\u0014\u0005\u00061\n!I!\u0017\u0005\u0006G\n!I\u0001\u001a\u0005\u0006M\n!Ia\u001a\u0005\u0006S\n!IA\u001b\u0005\u0006Y\n!I!\u001c\u0005\u0006_\n!I\u0001\u001d\u0005\u0006e\n!Ia\u001d\u0005\u0006q\n!\t!\u001f\u0005\n\u0003\u0017\u0011\u0011\u0013!C\u0001\u0003\u001bAq!a\t\u0001\t#\t)\u0003C\u0004\u0002P\u0001!\t\"!\u0015\t\u0013\u0005]\u0004!%A\u0005\u0012\u0005e\u0004bBA?\u0001\u0011%\u0011q\u0010\u0005\n\u0003{\u0003\u0011\u0013!C\u0005\u0003\u007fC\u0011\"a1\u0001#\u0003%I!!\u001f\u0003+\u0011+G\u000e^1T_V\u00148-Z\"E\u0007N+\b\u000f]8si*\u0011\u0001$G\u0001\bg>,(oY3t\u0015\tQ2$A\u0003eK2$\u0018M\u0003\u0002\u001d;\u0005\u00191/\u001d7\u000b\u0005yy\u0012!B:qCJ\\'B\u0001\u0011\"\u0003\u0019\t\u0007/Y2iK*\t!%A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001KA\u0011a%K\u0007\u0002O)\t\u0001&A\u0003tG\u0006d\u0017-\u0003\u0002+O\t1\u0011I\\=SK\u001a\fa\u0001J5oSR$C#A\u0017\u0011\u0005\u0019r\u0013BA\u0018(\u0005\u0011)f.\u001b;\u0003)%sG-\u001a=fI\u000eC\u0017M\\4f\r&dWmU3r'\t\u0011Q%\u0001\bgS2,\u0017i\u0019;j_:\u001c\u0018\n\u001e:\u0011\u0007QbtH\u0004\u00026u9\u0011a'O\u0007\u0002o)\u0011\u0001hI\u0001\u0007yI|w\u000e\u001e \n\u0003!J!aO\u0014\u0002\u000fA\f7m[1hK&\u0011QH\u0010\u0002\t\u0013R,'/\u0019;pe*\u00111h\n\t\u0003\u0001\u0006k\u0011aF\u0005\u0003\u0005^\u00111\"\u00138eKb,GMR5mK\u0006\t\u0012n]%oSRL\u0017\r\\*oCB\u001c\bn\u001c;\u0011\u0005\u0019*\u0015B\u0001$(\u0005\u001d\u0011un\u001c7fC:\fa\u0001P5oSRtDcA%L\u0019B\u0011!JA\u0007\u0002\u0001!)!'\u0002a\u0001g!)1)\u0002a\u0001\t\u0006aQn\u001c:f)\"\fgN\u0012:p[R!AiT)W\u0011\u0015\u0001f\u00011\u0001@\u0003-Ig\u000eZ3yK\u00124\u0015\u000e\\3\t\u000bI3\u0001\u0019A*\u0002\u0017\u0019\u0014x.\u001c,feNLwN\u001c\t\u0003MQK!!V\u0014\u0003\t1{gn\u001a\u0005\u0006/\u001a\u0001\raU\u0001\nMJ|W.\u00138eKb\f1\u0002\\3tgRC\u0017M\\#oIR\u0019AIW.\t\u000bA;\u0001\u0019A \t\u000bq;\u0001\u0019A/\u0002\u0013\u0015tGm\u00144gg\u0016$\bc\u0001\u0014_A&\u0011ql\n\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005\u0001\u000b\u0017B\u00012\u0018\u0005E!U\r\u001c;b'>,(oY3PM\u001a\u001cX\r^\u0001\u000f]>l\u0015\r^2iKN\u0014VmZ3y)\t!U\rC\u0003Q\u0011\u0001\u0007q(A\u0007iCN4\u0015\u000e\\3BGRLwN\u001c\u000b\u0003\t\"DQ\u0001U\u0005A\u0002}\n\u0011\u0005[1t\u001d>4\u0015\u000e\\3BGRLwN\\!oIN#\u0018M\u001d;Pe\u0016sG-\u00138eKb$\"\u0001R6\t\u000bAS\u0001\u0019A \u0002!!\f7/\u00113eg>\u0013(+Z7pm\u0016\u001cHC\u0001#o\u0011\u0015\u00016\u00021\u0001@\u0003eI7oU2iK6\f7\t[1oO\u0016Le\u000eZ3yK\u00124\u0015\u000e\\3\u0015\u0005\u0011\u000b\b\"\u0002)\r\u0001\u0004y\u0014AE5t-\u0006d\u0017\u000eZ%oI\u0016DX\r\u001a$jY\u0016$R\u0001\u0012;vm^DQ\u0001U\u0007A\u0002}BQAU\u0007A\u0002MCQaV\u0007A\u0002MCQ\u0001X\u0007A\u0002u\u000b1BZ5mi\u0016\u0014h)\u001b7fgR11G_>}\u0003\u0013AQA\u0015\bA\u0002MCQa\u0016\bA\u0002MCQ! \bA\u0002y\fa\u0001\\5nSR\u001c\bc\u0001\u0014_\u007fB\u0019!*!\u0001\n\t\u0005\r\u0011Q\u0001\u0002\u0010\u0003\u0012l\u0017n]:j_:d\u0015.\\5ug&\u0019\u0011qA\f\u0003\u0017\u0011+G\u000e^1T_V\u00148-\u001a\u0005\b9:\u0001\n\u00111\u0001^\u0003U1\u0017\u000e\u001c;fe\u001aKG.Z:%I\u00164\u0017-\u001e7uIQ*\"!a\u0004+\u0007u\u000b\tb\u000b\u0002\u0002\u0014A!\u0011QCA\u0010\u001b\t\t9B\u0003\u0003\u0002\u001a\u0005m\u0011!C;oG\",7m[3e\u0015\r\tibJ\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0011\u0003/\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003\r:W\r^\"E\u0007\u001aKG.Z\"iC:<Wm]!oI\u000e\u0013X-\u0019;f\t\u0006$\u0018M\u0012:b[\u0016$\"\"a\n\u0002D\u0005\u001d\u00131JA'!\u0011\tI#!\u0010\u000f\t\u0005-\u00121\b\b\u0005\u0003[\tID\u0004\u0003\u00020\u0005]b\u0002BA\u0019\u0003kq1ANA\u001a\u0013\u0005\u0011\u0013B\u0001\u0011\"\u0013\tqr$\u0003\u0002\u001d;%\u00111hG\u0005\u0005\u0003\u007f\t\tEA\u0005ECR\fgI]1nK*\u00111h\u0007\u0005\u0007\u0003\u000b\u0002\u0002\u0019A*\u0002\u0019M$\u0018M\u001d;WKJ\u001c\u0018n\u001c8\t\r\u0005%\u0003\u00031\u0001T\u0003)\u0019H/\u0019:u\u0013:$W\r\u001f\u0005\u0006\u0007B\u0001\r\u0001\u0012\u0005\u00069B\u0001\r\u0001Y\u0001\u0015O\u0016$h)\u001b7f\u0007\"\fgnZ3t\r>\u00148\tR\"\u0015\u001d\u0005M\u0013\u0011NA6\u0003[\ny'!\u001d\u0002tA!A\u0007PA+!\u001d1\u0013qK*4\u00037J1!!\u0017(\u0005\u0019!V\u000f\u001d7fgA!aEXA/!\u0011\ty&!\u001a\u000e\u0005\u0005\u0005$bAA23\u00059\u0011m\u0019;j_:\u001c\u0018\u0002BA4\u0003C\u0012!bQ8n[&$\u0018J\u001c4p\u0011\u0015\u0011\u0016\u00031\u0001T\u0011\u00159\u0016\u00031\u0001T\u0011\u0015\u0019\u0015\u00031\u0001E\u0011\u0015i\u0018\u00031\u0001\u007f\u0011\u0015a\u0016\u00031\u0001^\u0011!\t)(\u0005I\u0001\u0002\u0004!\u0015\u0001\u0006<fe&4\u00170T3uC\u0012\fG/Y!di&|g.\u0001\u0010hKR4\u0015\u000e\\3DQ\u0006tw-Z:G_J\u001cEi\u0011\u0013eK\u001a\fW\u000f\u001c;%mU\u0011\u00111\u0010\u0016\u0004\t\u0006E\u0011\u0001\u00054jYR,'o\u0011#D\u0003\u000e$\u0018n\u001c8t)1\t\t)a)\u0002.\u0006E\u0016QWA^!11\u00131QAD\t\u0006M\u00151TA.\u0013\r\t)i\n\u0002\u0007)V\u0004H.Z\u001b\u0011\u000bQ\nI)!$\n\u0007\u0005-eHA\u0002TKF\u0004B!a\u0018\u0002\u0010&!\u0011\u0011SA1\u0005)1\u0015\u000e\\3BGRLwN\u001c\t\u0005My\u000b)\n\u0005\u0003\u0002`\u0005]\u0015\u0002BAM\u0003C\u0012\u0001\"T3uC\u0012\fG/\u0019\t\u0005My\u000bi\n\u0005\u0003\u0002`\u0005}\u0015\u0002BAQ\u0003C\u0012\u0001\u0002\u0015:pi>\u001cw\u000e\u001c\u0005\b\u0003G\u001a\u0002\u0019AAS!\u0015!\u0014\u0011RAT!\u0011\ty&!+\n\t\u0005-\u0016\u0011\r\u0002\u0007\u0003\u000e$\u0018n\u001c8\t\r\u0005=6\u00031\u0001T\u0003\u001d1XM]:j_:Da!a-\u0014\u0001\u0004\u0019\u0016!\u00052bi\u000eD7\u000b^1siZ+'o]5p]\"I\u0011qW\n\u0011\u0002\u0003\u0007\u0011\u0011X\u0001\u0013E\u0006$8\r[#oIZ+'o]5p]>\u0003H\u000fE\u0002'=NC\u0001\"!\u001e\u0014!\u0003\u0005\r\u0001R\u0001\u001bM&dG/\u001a:D\t\u000e\u000b5\r^5p]N$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003\u0003TC!!/\u0002\u0012\u0005Qb-\u001b7uKJ\u001cEiQ!di&|gn\u001d\u0013eK\u001a\fW\u000f\u001c;%kA\u0019\u0001)!\u0002")
public interface DeltaSourceCDCSupport {
    public static /* synthetic */ Dataset getCDCFileChangesAndCreateDataFrame$(DeltaSourceCDCSupport $this, long startVersion, long startIndex, boolean isInitialSnapshot, DeltaSourceOffset endOffset) {
        return $this.getCDCFileChangesAndCreateDataFrame(startVersion, startIndex, isInitialSnapshot, endOffset);
    }

    default public Dataset<Row> getCDCFileChangesAndCreateDataFrame(long startVersion, long startIndex, boolean isInitialSnapshot, DeltaSourceOffset endOffset) {
        Iterator<Tuple3<Object, Iterator<IndexedFile>, Option<CommitInfo>>> changes = this.getFileChangesForCDC(startVersion, startIndex, isInitialSnapshot, (Option<DeltaSource.AdmissionLimits>)None$.MODULE$, (Option<DeltaSourceOffset>)new Some((Object)endOffset), this.getFileChangesForCDC$default$6());
        Iterator groupedFileAndCommitInfoActions = changes.map((Function1 & Serializable)x0$1 -> {
            Tuple3 tuple3 = x0$1;
            if (tuple3 != null) {
                long v = BoxesRunTime.unboxToLong((Object)tuple3._1());
                Iterator indexFiles = (Iterator)tuple3._2();
                Option commitInfoOpt = (Option)tuple3._3();
                return new Tuple2((Object)BoxesRunTime.boxToLong((long)v), indexFiles.filter((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)x$11.hasFileAction())).map((Function1 & Serializable)x$12 -> x$12.getFileAction()).toSeq().$plus$plus((IterableOnce)commitInfoOpt));
            }
            throw new MatchError((Object)tuple3);
        });
        Tuple2 tuple2 = Utils$.MODULE$.timeTakenMs((Function0 & Serializable)() -> CDCReader$.MODULE$.changesToDF(((DeltaSourceBase)((Object)this)).readSnapshotDescriptor(), startVersion, endOffset.reservoirVersion(), (Iterator<Tuple2<Object, Seq<Action>>>)groupedFileAndCommitInfoActions, ((DeltaSource)this).spark(), true, CDCReader$.MODULE$.changesToDF$default$7(), CDCReader$.MODULE$.changesToDF$default$8()).fileChangeDf());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Dataset result = (Dataset)tuple2._1();
        long duration = tuple2._2$mcJ$sp();
        Tuple2 tuple22 = new Tuple2((Object)result, (Object)BoxesRunTime.boxToLong((long)duration));
        Dataset result2 = (Dataset)tuple22._1();
        long duration2 = tuple22._2$mcJ$sp();
        ((Logging)this).logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> ((Logging)this).LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Getting CDC dataFrame for delta_log_path="}))).log((Seq)Nil$.MODULE$).$plus(((Logging)this).LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " with "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)DeltaLogKeys$.MODULE$.PATH(), (Object)((DeltaSource)this).deltaLog().logPath())}))).$plus(((Logging)this).LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"startVersion=", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)DeltaLogKeys$.MODULE$.START_VERSION(), (Object)BoxesRunTime.boxToLong((long)startVersion))}))).$plus(((Logging)this).LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"startIndex=", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)DeltaLogKeys$.MODULE$.START_INDEX(), (Object)BoxesRunTime.boxToLong((long)startIndex))}))).$plus(((Logging)this).LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"isInitialSnapshot=", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)DeltaLogKeys$.MODULE$.IS_INIT_SNAPSHOT(), (Object)BoxesRunTime.boxToBoolean((boolean)isInitialSnapshot))}))).$plus(((Logging)this).LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"endOffset=", " took timeMs="}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)DeltaLogKeys$.MODULE$.END_OFFSET(), (Object)endOffset)}))).$plus(((Logging)this).LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " ms"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)DeltaLogKeys$.MODULE$.DURATION(), (Object)BoxesRunTime.boxToLong((long)duration2))})))));
        return result2;
    }

    public static /* synthetic */ Iterator getFileChangesForCDC$(DeltaSourceCDCSupport $this, long fromVersion, long fromIndex, boolean isInitialSnapshot, Option limits, Option endOffset, boolean verifyMetadataAction) {
        return $this.getFileChangesForCDC(fromVersion, fromIndex, isInitialSnapshot, (Option<DeltaSource.AdmissionLimits>)limits, (Option<DeltaSourceOffset>)endOffset, verifyMetadataAction);
    }

    default public Iterator<Tuple3<Object, Iterator<IndexedFile>, Option<CommitInfo>>> getFileChangesForCDC(long fromVersion, long fromIndex, boolean isInitialSnapshot, Option<DeltaSource.AdmissionLimits> limits, Option<DeltaSourceOffset> endOffset, boolean verifyMetadataAction) {
        Tuple2 tuple2 = Utils$.MODULE$.timeTakenMs((Function0 & Serializable)() -> {
            Iterator iterator;
            if (isInitialSnapshot) {
                Tuple2<Iterator<IndexedFile>, Option<Object>> tuple2 = ((DeltaSource)this).getSnapshotAt(fromVersion);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                Iterator unprocessedSnapshot = (Iterator)tuple2._1();
                Option snapshotInCommitTimestampOpt = (Option)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)unprocessedSnapshot, (Object)snapshotInCommitTimestampOpt);
                Iterator unprocessedSnapshot2 = (Iterator)tuple22._1();
                Option snapshotInCommitTimestampOpt2 = (Option)tuple22._2();
                Iterator snapshot = unprocessedSnapshot2.map((Function1 & Serializable)m -> {
                    if (m.add() != null) {
                        boolean x$1 = true;
                        String x$2 = m.add().copy$default$1();
                        Map<String, String> x$3 = m.add().copy$default$2();
                        long x$4 = m.add().copy$default$3();
                        long x$5 = m.add().copy$default$4();
                        String x$6 = m.add().copy$default$6();
                        Map<String, String> x$7 = m.add().copy$default$7();
                        DeletionVectorDescriptor x$8 = m.add().copy$default$8();
                        Option<Object> x$9 = m.add().copy$default$9();
                        Option<Object> x$10 = m.add().copy$default$10();
                        Option<String> x$11 = m.add().copy$default$11();
                        AddFile x$12 = m.add().copy(x$2, x$3, x$4, x$5, true, x$6, x$7, x$8, x$9, x$10, x$11);
                        long x$13 = m.copy$default$1();
                        long x$14 = m.copy$default$2();
                        RemoveFile x$15 = m.copy$default$4();
                        AddCDCFile x$16 = m.copy$default$5();
                        boolean x$17 = m.copy$default$6();
                        return m.copy(x$13, x$14, x$12, x$15, x$16, x$17);
                    }
                    return m;
                });
                CommitInfo qual$1 = CommitInfo$.MODULE$.empty((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)-1L)));
                Option x$18 = snapshotInCommitTimestampOpt2;
                Option<Object> x$19 = qual$1.copy$default$1();
                Timestamp x$20 = qual$1.copy$default$3();
                Option<String> x$21 = qual$1.copy$default$4();
                Option<String> x$22 = qual$1.copy$default$5();
                String x$23 = qual$1.copy$default$6();
                Map<String, String> x$24 = qual$1.copy$default$7();
                Option<JobInfo> x$25 = qual$1.copy$default$8();
                Option<NotebookInfo> x$26 = qual$1.copy$default$9();
                Option<String> x$27 = qual$1.copy$default$10();
                Option<Object> x$28 = qual$1.copy$default$11();
                Option<String> x$29 = qual$1.copy$default$12();
                Option<Object> x$30 = qual$1.copy$default$13();
                Option<Map<String, String>> x$31 = qual$1.copy$default$14();
                Option<String> x$32 = qual$1.copy$default$15();
                Option<Map<String, String>> x$33 = qual$1.copy$default$16();
                Option<String> x$34 = qual$1.copy$default$17();
                Option<String> x$35 = qual$1.copy$default$18();
                Some ictOnlyCommitInfo = new Some((Object)qual$1.copy(x$19, (Option<Object>)x$18, x$20, x$21, x$22, x$23, x$24, x$25, x$26, x$27, x$28, x$29, x$30, x$31, x$32, x$33, x$34, x$35));
                Iterator snapshotItr = package$.MODULE$.Iterator().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple3[]{new Tuple3((Object)BoxesRunTime.boxToLong((long)fromVersion), (Object)new IndexedChangeFileSeq((DeltaSource)this, (Iterator<IndexedFile>)snapshot, true), (Object)ictOnlyCommitInfo)}));
                iterator = snapshotItr.$plus$plus((Function0 & Serializable)() -> this.filterAndIndexDeltaLogs$1(fromVersion + 1L, fromVersion, endOffset, verifyMetadataAction));
            } else {
                iterator = this.filterAndIndexDeltaLogs$1(fromVersion, fromVersion, endOffset, verifyMetadataAction);
            }
            Iterator iter = iterator;
            return iter.takeWhile((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DeltaSourceCDCSupport.$anonfun$getFileChangesForCDC$9(limits, endOffset, x0$1))).map((Function1 & Serializable)x0$2 -> {
                Tuple3 tuple3 = x0$2;
                if (tuple3 != null) {
                    long version = BoxesRunTime.unboxToLong((Object)tuple3._1());
                    IndexedChangeFileSeq indexItr = (IndexedChangeFileSeq)tuple3._2();
                    Option ci = (Option)tuple3._3();
                    return new Tuple3((Object)BoxesRunTime.boxToLong((long)version), indexItr.filterFiles(fromVersion, fromIndex, limits, endOffset), (Object)ci);
                }
                throw new MatchError((Object)tuple3);
            });
        });
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Iterator result = (Iterator)tuple2._1();
        long duration = tuple2._2$mcJ$sp();
        Tuple2 tuple22 = new Tuple2((Object)result, (Object)BoxesRunTime.boxToLong((long)duration));
        Iterator result2 = (Iterator)tuple22._1();
        long duration2 = tuple22._2$mcJ$sp();
        ((Logging)this).logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> ((Logging)this).LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Getting CDC file changes for delta_log_path="}))).log((Seq)Nil$.MODULE$).$plus(((Logging)this).LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " with "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)DeltaLogKeys$.MODULE$.PATH(), (Object)((DeltaSource)this).deltaLog().logPath())}))).$plus(((Logging)this).LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"fromVersion=", ", fromIndex="}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)DeltaLogKeys$.MODULE$.START_VERSION(), (Object)BoxesRunTime.boxToLong((long)fromVersion))}))).$plus(((Logging)this).LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ", "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)DeltaLogKeys$.MODULE$.START_INDEX(), (Object)BoxesRunTime.boxToLong((long)fromIndex))}))).$plus(((Logging)this).LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"isInitialSnapshot=", " took timeMs="}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)DeltaLogKeys$.MODULE$.IS_INIT_SNAPSHOT(), (Object)BoxesRunTime.boxToBoolean((boolean)isInitialSnapshot))}))).$plus(((Logging)this).LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " ms"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)DeltaLogKeys$.MODULE$.DURATION(), (Object)BoxesRunTime.boxToLong((long)duration2))})))));
        return result2;
    }

    public static /* synthetic */ boolean getFileChangesForCDC$default$6$(DeltaSourceCDCSupport $this) {
        return $this.getFileChangesForCDC$default$6();
    }

    default public boolean getFileChangesForCDC$default$6() {
        return true;
    }

    private Tuple5<Seq<FileAction>, Object, Option<Metadata>, Option<Protocol>, Option<CommitInfo>> filterCDCActions(Seq<Action> actions, long version, long batchStartVersion, Option<Object> batchEndVersionOpt, boolean verifyMetadataAction) {
        BooleanRef shouldSkipIndexedFile = BooleanRef.create((boolean)false);
        ObjectRef metadataAction = ObjectRef.create((Object)None$.MODULE$);
        ObjectRef protocolAction = ObjectRef.create((Object)None$.MODULE$);
        ObjectRef commitInfoAction = ObjectRef.create((Object)None$.MODULE$);
        if (actions.exists((Function1 & Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)DeltaSourceCDCSupport.$anonfun$filterCDCActions$2(x$19)))) {
            return new Tuple5((Object)((Seq)actions.filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DeltaSourceCDCSupport.$anonfun$filterCDCActions$3(this, commitInfoAction, protocolAction, verifyMetadataAction, version, batchStartVersion, batchEndVersionOpt, metadataAction, x0$1)))), (Object)BoxesRunTime.boxToBoolean((boolean)shouldSkipIndexedFile.elem), (Object)((Option)metadataAction.elem), (Object)((Option)protocolAction.elem), (Object)((Option)commitInfoAction.elem));
        }
        return new Tuple5((Object)((Seq)actions.filter((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)DeltaSourceCDCSupport.$anonfun$filterCDCActions$4(this, protocolAction, shouldSkipIndexedFile, commitInfoAction, verifyMetadataAction, version, batchStartVersion, batchEndVersionOpt, metadataAction, x0$2)))), (Object)BoxesRunTime.boxToBoolean((boolean)shouldSkipIndexedFile.elem), (Object)((Option)metadataAction.elem), (Object)((Option)protocolAction.elem), (Object)((Option)commitInfoAction.elem));
    }

    private Option<Object> filterCDCActions$default$4() {
        return None$.MODULE$;
    }

    private boolean filterCDCActions$default$5() {
        return true;
    }

    private Iterator filterAndIndexDeltaLogs$1(long startVersion, long fromVersion$2, Option endOffset$3, boolean verifyMetadataAction$1) {
        Predef$.MODULE$.require(((DeltaSource)this).options().failOnDataLoss() || !((DeltaSourceMetadataEvolutionSupport)((Object)this)).trackingMetadataChange(), (Function0 & Serializable)() -> "Using schema from schema tracking log cannot tolerate missing commit files.");
        return ((DeltaSource)this).deltaLog().getChanges(startVersion, ((DeltaSource)this).options().failOnDataLoss()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                long version = tuple2._1$mcJ$sp();
                Seq actions = (Seq)tuple2._2();
                Tuple5<Seq<FileAction>, Object, Option<Metadata>, Option<Protocol>, Option<CommitInfo>> tuple5 = this.filterCDCActions((Seq<Action>)actions, version, fromVersion$2, (Option<Object>)endOffset$3.map((Function1 & Serializable)x$14 -> BoxesRunTime.boxToLong((long)x$14.reservoirVersion())), verifyMetadataAction$1 && !((DeltaSourceMetadataEvolutionSupport)((Object)this)).trackingMetadataChange());
                if (tuple5 == null) {
                    throw new MatchError(tuple5);
                }
                Seq fileActions = (Seq)tuple5._1();
                boolean skipIndexedFile = BoxesRunTime.unboxToBoolean((Object)tuple5._2());
                Option metadataOpt = (Option)tuple5._3();
                Option protocolOpt = (Option)tuple5._4();
                Option commitInfoOpt = (Option)tuple5._5();
                Tuple5 tuple52 = new Tuple5((Object)fileActions, (Object)BoxesRunTime.boxToBoolean((boolean)skipIndexedFile), (Object)metadataOpt, (Object)protocolOpt, (Object)commitInfoOpt);
                Seq fileActions2 = (Seq)tuple52._1();
                boolean skipIndexedFile2 = BoxesRunTime.unboxToBoolean((Object)tuple52._2());
                Option metadataOpt2 = (Option)tuple52._3();
                Option protocolOpt2 = (Option)tuple52._4();
                Option commitInfoOpt2 = (Option)tuple52._5();
                Iterator<IndexedFile> itr = ((DeltaSource)this).addBeginAndEndIndexOffsetsForVersion(version, (Iterator<IndexedFile>)((DeltaSourceMetadataEvolutionSupport)((Object)this)).getMetadataOrProtocolChangeIndexedFileIterator((Option<Metadata>)metadataOpt2, (Option<Protocol>)protocolOpt2, version).$plus$plus((Function0 & Serializable)() -> (Seq)((IterableOps)fileActions2.zipWithIndex()).map((Function1 & Serializable)x0$2 -> {
                    Tuple2 tuple2 = x0$2;
                    if (tuple2 != null) {
                        FileAction action = (FileAction)tuple2._1();
                        int index = tuple2._2$mcI$sp();
                        if (action instanceof AddFile) {
                            AddFile addFile = (AddFile)action;
                            long x$1 = version;
                            long x$2 = index;
                            AddFile x$3 = addFile;
                            boolean x$4 = skipIndexedFile2;
                            RemoveFile x$5 = IndexedFile$.MODULE$.apply$default$4();
                            AddCDCFile x$6 = IndexedFile$.MODULE$.apply$default$5();
                            return new IndexedFile(x$1, x$2, x$3, x$5, x$6, x$4);
                        }
                    }
                    if (tuple2 != null) {
                        FileAction cdcFile = (FileAction)tuple2._1();
                        int index = tuple2._2$mcI$sp();
                        if (cdcFile instanceof AddCDCFile) {
                            AddCDCFile addCDCFile = (AddCDCFile)cdcFile;
                            long x$7 = version;
                            long x$8 = index;
                            Object x$9 = null;
                            AddCDCFile x$10 = addCDCFile;
                            boolean x$11 = skipIndexedFile2;
                            RemoveFile x$12 = IndexedFile$.MODULE$.apply$default$4();
                            return new IndexedFile(x$7, x$8, null, x$12, x$10, x$11);
                        }
                    }
                    if (tuple2 != null) {
                        FileAction remove = (FileAction)tuple2._1();
                        int index = tuple2._2$mcI$sp();
                        if (remove instanceof RemoveFile) {
                            RemoveFile removeFile = (RemoveFile)remove;
                            long x$13 = version;
                            long x$14 = index;
                            Object x$15 = null;
                            RemoveFile x$16 = removeFile;
                            boolean x$17 = skipIndexedFile2;
                            AddCDCFile x$18 = IndexedFile$.MODULE$.apply$default$5();
                            return new IndexedFile(x$13, x$14, null, x$16, x$18, x$17);
                        }
                    }
                    throw new MatchError((Object)tuple2);
                })));
                return new Tuple3((Object)BoxesRunTime.boxToLong((long)version), (Object)new IndexedChangeFileSeq((DeltaSource)this, itr, false), (Object)commitInfoOpt2);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    private static boolean versionLessThanEndOffset$1(long version, Option endOffset) {
        Option option = endOffset;
        if (option instanceof Some) {
            Some some = (Some)option;
            DeltaSourceOffset eo = (DeltaSourceOffset)some.value();
            return version <= eo.reservoirVersion();
        }
        if (None$.MODULE$.equals(option)) {
            return true;
        }
        throw new MatchError((Object)option);
    }

    public static /* synthetic */ boolean $anonfun$getFileChangesForCDC$9(Option limits$1, Option endOffset$3, Tuple3 x0$1) {
        Tuple3 tuple3 = x0$1;
        if (tuple3 != null) {
            long version = BoxesRunTime.unboxToLong((Object)tuple3._1());
            return limits$1.forall((Function1 & Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)x$17.hasCapacity())) && DeltaSourceCDCSupport.versionLessThanEndOffset$1(version, endOffset$3);
        }
        throw new MatchError((Object)tuple3);
    }

    private void checkAndCacheMetadata$1(Metadata m, boolean verifyMetadataAction$2, long version$2, long batchStartVersion$1, Option batchEndVersionOpt$1, ObjectRef metadataAction$1) {
        if (verifyMetadataAction$2) {
            ((DeltaSourceBase)((Object)this)).checkReadIncompatibleSchemaChanges(m, version$2, batchStartVersion$1, (Option<Object>)batchEndVersionOpt$1, ((DeltaSourceBase)((Object)this)).checkReadIncompatibleSchemaChanges$default$5());
        }
        Predef$.MODULE$.assert(((Option)metadataAction$1.elem).isEmpty(), (Function0 & Serializable)() -> "Should not encounter two metadata actions in the same commit");
        metadataAction$1.elem = new Some((Object)m);
    }

    public static /* synthetic */ boolean $anonfun$filterCDCActions$2(Action x$19) {
        return x$19 instanceof AddCDCFile;
    }

    public static /* synthetic */ boolean $anonfun$filterCDCActions$3(DeltaSourceCDCSupport $this, ObjectRef commitInfoAction$1, ObjectRef protocolAction$1, boolean verifyMetadataAction$2, long version$2, long batchStartVersion$1, Option batchEndVersionOpt$1, ObjectRef metadataAction$1, Action x0$1) {
        Action action = x0$1;
        if (action instanceof AddCDCFile) {
            return true;
        }
        if (action instanceof CommitInfo) {
            CommitInfo commitInfo = (CommitInfo)action;
            commitInfoAction$1.elem = new Some((Object)commitInfo);
            return false;
        }
        if (action instanceof Metadata) {
            Metadata metadata = (Metadata)action;
            $this.checkAndCacheMetadata$1(metadata, verifyMetadataAction$2, version$2, batchStartVersion$1, batchEndVersionOpt$1, metadataAction$1);
            return false;
        }
        if (action instanceof Protocol) {
            Protocol protocol = (Protocol)action;
            protocolAction$1.elem = new Some((Object)protocol);
            return false;
        }
        return false;
    }

    public static /* synthetic */ boolean $anonfun$filterCDCActions$4(DeltaSourceCDCSupport $this, ObjectRef protocolAction$1, BooleanRef shouldSkipIndexedFile$1, ObjectRef commitInfoAction$1, boolean verifyMetadataAction$2, long version$2, long batchStartVersion$1, Option batchEndVersionOpt$1, ObjectRef metadataAction$1, Action x0$2) {
        Action action = x0$2;
        if (action instanceof AddFile) {
            AddFile addFile = (AddFile)action;
            return addFile.dataChange();
        }
        if (action instanceof RemoveFile) {
            RemoveFile removeFile = (RemoveFile)action;
            return removeFile.dataChange();
        }
        if (action instanceof Metadata) {
            Metadata metadata = (Metadata)action;
            $this.checkAndCacheMetadata$1(metadata, verifyMetadataAction$2, version$2, batchStartVersion$1, batchEndVersionOpt$1, metadataAction$1);
            return false;
        }
        if (action instanceof Protocol) {
            Protocol protocol = (Protocol)action;
            ((DeltaSource)$this).deltaLog().protocolRead(protocol);
            Predef$.MODULE$.assert(((Option)protocolAction$1.elem).isEmpty(), (Function0 & Serializable)() -> "Should not encounter two protocol actions in the same commit");
            protocolAction$1.elem = new Some((Object)protocol);
            return false;
        }
        if (action instanceof CommitInfo) {
            CommitInfo commitInfo = (CommitInfo)action;
            shouldSkipIndexedFile$1.elem = CDCReader$.MODULE$.shouldSkipFileActionsInCommit(commitInfo);
            commitInfoAction$1.elem = new Some((Object)commitInfo);
            return false;
        }
        if (action instanceof AddCDCFile ? true : (action instanceof SetTransaction ? true : action instanceof DomainMetadata)) {
            return false;
        }
        if (action == null) {
            return false;
        }
        throw new MatchError((Object)action);
    }

    public static void $init$(DeltaSourceCDCSupport $this) {
    }

    public class IndexedChangeFileSeq {
        private final Iterator<IndexedFile> fileActionsItr;
        private final boolean isInitialSnapshot;
        public final /* synthetic */ DeltaSource $outer;

        private boolean moreThanFrom(IndexedFile indexedFile, long fromVersion, long fromIndex) {
            return indexedFile.version() > fromVersion || indexedFile.index() > fromIndex;
        }

        private boolean lessThanEnd(IndexedFile indexedFile, Option<DeltaSourceOffset> endOffset) {
            if (endOffset.isEmpty()) {
                return true;
            }
            return indexedFile.version() < ((DeltaSourceOffset)endOffset.get()).reservoirVersion() || indexedFile.version() <= ((DeltaSourceOffset)endOffset.get()).reservoirVersion() && indexedFile.index() <= ((DeltaSourceOffset)endOffset.get()).index();
        }

        private boolean noMatchesRegex(IndexedFile indexedFile) {
            if (this.hasNoFileActionAndStartOrEndIndex(indexedFile)) {
                return true;
            }
            return this.org$apache$spark$sql$delta$sources$DeltaSourceCDCSupport$IndexedChangeFileSeq$$$outer().excludeRegex().forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)IndexedChangeFileSeq.$anonfun$noMatchesRegex$1(indexedFile, x$1)));
        }

        private boolean hasFileAction(IndexedFile indexedFile) {
            return indexedFile.getFileAction() != null;
        }

        private boolean hasNoFileActionAndStartOrEndIndex(IndexedFile indexedFile) {
            return !indexedFile.hasFileAction() && (indexedFile.index() == DeltaSourceOffset$.MODULE$.BASE_INDEX() || indexedFile.index() == DeltaSourceOffset$.MODULE$.END_INDEX());
        }

        private boolean hasAddsOrRemoves(IndexedFile indexedFile) {
            return indexedFile.add() != null || indexedFile.remove() != null;
        }

        private boolean isSchemaChangeIndexedFile(IndexedFile indexedFile) {
            return indexedFile.index() == DeltaSourceOffset$.MODULE$.METADATA_CHANGE_INDEX() || indexedFile.index() == DeltaSourceOffset$.MODULE$.POST_METADATA_CHANGE_INDEX();
        }

        private boolean isValidIndexedFile(IndexedFile indexedFile, long fromVersion, long fromIndex, Option<DeltaSourceOffset> endOffset) {
            return !indexedFile.shouldSkip() && (this.hasFileAction(indexedFile) || this.hasNoFileActionAndStartOrEndIndex(indexedFile) || this.isSchemaChangeIndexedFile(indexedFile)) && this.moreThanFrom(indexedFile, fromVersion, fromIndex) && this.lessThanEnd(indexedFile, endOffset) && this.noMatchesRegex(indexedFile) && this.lessThanEnd(indexedFile, this.org$apache$spark$sql$delta$sources$DeltaSourceCDCSupport$IndexedChangeFileSeq$$$outer().lastOffsetForTriggerAvailableNow());
        }

        public Iterator<IndexedFile> filterFiles(long fromVersion, long fromIndex, Option<DeltaSource.AdmissionLimits> limits, Option<DeltaSourceOffset> endOffset) {
            if (limits.isEmpty()) {
                return this.fileActionsItr.filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)this.isValidIndexedFile(x$2, fromVersion, fromIndex, (Option<DeltaSourceOffset>)endOffset)));
            }
            DeltaSource.AdmissionLimits admissionControl = (DeltaSource.AdmissionLimits)limits.get();
            if (this.isInitialSnapshot) {
                return this.fileActionsItr.filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)this.isValidIndexedFile(x$3, fromVersion, fromIndex, (Option<DeltaSourceOffset>)endOffset))).takeWhile((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)admissionControl.admit(x$4)));
            }
            Seq fileActions = this.fileActionsItr.toSeq();
            Option option = fileActions.find((Function1 & Serializable)indexedFile -> BoxesRunTime.boxToBoolean((boolean)this.isSchemaChangeIndexedFile(indexedFile)));
            if (option instanceof Some) {
                Some some = (Some)option;
                IndexedFile schemaChangeBarrier = (IndexedFile)some.value();
                return new .colon.colon((Object)schemaChangeBarrier, (List)Nil$.MODULE$).toIterator();
            }
            Seq cdcFiles = (Seq)fileActions.filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)IndexedChangeFileSeq.$anonfun$filterFiles$5(x$5)));
            if (cdcFiles.nonEmpty()) {
                Seq filteredFiles = (Seq)cdcFiles.filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)this.isValidIndexedFile(x$6, fromVersion, fromIndex, (Option<DeltaSourceOffset>)endOffset)));
                if (admissionControl.admit((Seq<IndexedFile>)filteredFiles)) {
                    return filteredFiles.toIterator();
                }
                return package$.MODULE$.Iterator().apply((Seq)Nil$.MODULE$);
            }
            Seq filteredFiles = (Seq)((IterableOps)fileActions.filter((Function1 & Serializable)indexedFile -> BoxesRunTime.boxToBoolean((boolean)IndexedChangeFileSeq.$anonfun$filterFiles$7(this, indexedFile)))).filter((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)this.isValidIndexedFile(x$7, fromVersion, fromIndex, (Option<DeltaSourceOffset>)endOffset)));
            boolean hasDeletionVectors = ((IterableOnceOps)((IterableOps)fileActions.filter((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)x$8.hasFileAction()))).map((Function1 & Serializable)x$9 -> x$9.getFileAction())).exists((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)IndexedChangeFileSeq.$anonfun$filterFiles$11(x0$1)));
            if (hasDeletionVectors) {
                if (admissionControl.admit((Seq<IndexedFile>)filteredFiles)) {
                    return filteredFiles.toIterator();
                }
                return package$.MODULE$.Iterator().apply((Seq)Nil$.MODULE$);
            }
            return ((IterableOnceOps)filteredFiles.takeWhile((Function1 & Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)admissionControl.admit(x$10)))).toIterator();
        }

        public Option<DeltaSourceOffset> filterFiles$default$4() {
            return None$.MODULE$;
        }

        public /* synthetic */ DeltaSource org$apache$spark$sql$delta$sources$DeltaSourceCDCSupport$IndexedChangeFileSeq$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ boolean $anonfun$noMatchesRegex$1(IndexedFile indexedFile$1, Regex x$1) {
            return x$1.findFirstIn((CharSequence)indexedFile$1.getFileAction().path()).isEmpty();
        }

        public static final /* synthetic */ boolean $anonfun$filterFiles$5(IndexedFile x$5) {
            return x$5.cdc() != null;
        }

        public static final /* synthetic */ boolean $anonfun$filterFiles$7(IndexedChangeFileSeq $this, IndexedFile indexedFile) {
            return $this.hasAddsOrRemoves(indexedFile) || $this.hasNoFileActionAndStartOrEndIndex(indexedFile);
        }

        public static final /* synthetic */ boolean $anonfun$filterFiles$11(FileAction x0$1) {
            FileAction fileAction = x0$1;
            if (fileAction instanceof AddFile) {
                AddFile addFile = (AddFile)fileAction;
                return addFile.deletionVector() != null;
            }
            if (fileAction instanceof RemoveFile) {
                RemoveFile removeFile = (RemoveFile)fileAction;
                return removeFile.deletionVector() != null;
            }
            return false;
        }

        public IndexedChangeFileSeq(DeltaSource $outer, Iterator<IndexedFile> fileActionsItr, boolean isInitialSnapshot) {
            this.fileActionsItr = fileActionsItr;
            this.isInitialSnapshot = isInitialSnapshot;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
        }
    }
}

