/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.sources;

import java.io.Serializable;
import java.util.Locale;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.delta.DeltaColumnMapping$;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaOptions;
import org.apache.spark.sql.delta.DroppedColumn;
import org.apache.spark.sql.delta.RenamedColumn;
import org.apache.spark.sql.delta.TypeChange;
import org.apache.spark.sql.delta.TypeWideningMetadata$;
import org.apache.spark.sql.delta.TypeWideningMode;
import org.apache.spark.sql.delta.TypeWideningMode$AllTypeWidening$;
import org.apache.spark.sql.delta.TypeWideningMode$NoTypeWidening$;
import org.apache.spark.sql.delta.schema.SchemaUtils$;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.sources.DeltaSourceMetadataEvolutionSupport;
import org.apache.spark.sql.delta.sources.PersistedMetadata;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class DeltaSourceMetadataEvolutionSupport$ {
    public static final DeltaSourceMetadataEvolutionSupport$ MODULE$ = new DeltaSourceMetadataEvolutionSupport$();
    private static final String SQL_CONF_PREFIX = new StringBuilder(10).append(DeltaSQLConf$.MODULE$.SQL_CONF_PREFIX()).append(".streaming").toString();
    private static final String org$apache$spark$sql$delta$sources$DeltaSourceMetadataEvolutionSupport$$SQL_CONF_UNBLOCK_RENAME_DROP = new StringBuilder(31).append(MODULE$.SQL_CONF_PREFIX()).append(".allowSourceColumnRenameAndDrop").toString();
    private static final String org$apache$spark$sql$delta$sources$DeltaSourceMetadataEvolutionSupport$$SQL_CONF_UNBLOCK_RENAME = new StringBuilder(24).append(MODULE$.SQL_CONF_PREFIX()).append(".allowSourceColumnRename").toString();
    private static final String org$apache$spark$sql$delta$sources$DeltaSourceMetadataEvolutionSupport$$SQL_CONF_UNBLOCK_DROP = new StringBuilder(22).append(MODULE$.SQL_CONF_PREFIX()).append(".allowSourceColumnDrop").toString();
    private static final String org$apache$spark$sql$delta$sources$DeltaSourceMetadataEvolutionSupport$$SQL_CONF_UNBLOCK_TYPE_CHANGE = new StringBuilder(28).append(MODULE$.SQL_CONF_PREFIX()).append(".allowSourceColumnTypeChange").toString();

    private String SQL_CONF_PREFIX() {
        return SQL_CONF_PREFIX;
    }

    public final String org$apache$spark$sql$delta$sources$DeltaSourceMetadataEvolutionSupport$$SQL_CONF_UNBLOCK_RENAME_DROP() {
        return org$apache$spark$sql$delta$sources$DeltaSourceMetadataEvolutionSupport$$SQL_CONF_UNBLOCK_RENAME_DROP;
    }

    public final String org$apache$spark$sql$delta$sources$DeltaSourceMetadataEvolutionSupport$$SQL_CONF_UNBLOCK_RENAME() {
        return org$apache$spark$sql$delta$sources$DeltaSourceMetadataEvolutionSupport$$SQL_CONF_UNBLOCK_RENAME;
    }

    public final String org$apache$spark$sql$delta$sources$DeltaSourceMetadataEvolutionSupport$$SQL_CONF_UNBLOCK_DROP() {
        return org$apache$spark$sql$delta$sources$DeltaSourceMetadataEvolutionSupport$$SQL_CONF_UNBLOCK_DROP;
    }

    public final String org$apache$spark$sql$delta$sources$DeltaSourceMetadataEvolutionSupport$$SQL_CONF_UNBLOCK_TYPE_CHANGE() {
        return org$apache$spark$sql$delta$sources$DeltaSourceMetadataEvolutionSupport$$SQL_CONF_UNBLOCK_TYPE_CHANGE;
    }

    private Option<DeltaSourceMetadataEvolutionSupport.SchemaChangeType> buildSchemaChangeDescriptor(Seq<RenamedColumn> renamedColumns, Seq<DroppedColumn> droppedColumns, Seq<TypeChange> widenedColumns) {
        Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)renamedColumns.nonEmpty()), (Object)BoxesRunTime.boxToBoolean((boolean)droppedColumns.nonEmpty()), (Object)BoxesRunTime.boxToBoolean((boolean)widenedColumns.nonEmpty()));
        if (tuple3 != null) {
            boolean bl = BoxesRunTime.unboxToBoolean((Object)tuple3._1());
            boolean bl2 = BoxesRunTime.unboxToBoolean((Object)tuple3._2());
            boolean bl3 = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
            if (bl && !bl2 && !bl3) {
                return new Some((Object)new DeltaSourceMetadataEvolutionSupport.SchemaChangeRename(renamedColumns));
            }
        }
        if (tuple3 != null) {
            boolean bl = BoxesRunTime.unboxToBoolean((Object)tuple3._1());
            boolean bl4 = BoxesRunTime.unboxToBoolean((Object)tuple3._2());
            boolean bl5 = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
            if (!bl && bl4 && !bl5) {
                return new Some((Object)new DeltaSourceMetadataEvolutionSupport.SchemaChangeDrop(droppedColumns));
            }
        }
        if (tuple3 != null) {
            boolean bl = BoxesRunTime.unboxToBoolean((Object)tuple3._1());
            boolean bl6 = BoxesRunTime.unboxToBoolean((Object)tuple3._2());
            boolean bl7 = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
            if (!bl && !bl6 && bl7) {
                return new Some((Object)new DeltaSourceMetadataEvolutionSupport.SchemaChangeTypeWidening(widenedColumns));
            }
        }
        if (tuple3 != null) {
            boolean bl = BoxesRunTime.unboxToBoolean((Object)tuple3._1());
            boolean bl8 = BoxesRunTime.unboxToBoolean((Object)tuple3._2());
            boolean bl9 = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
            if (bl && bl8 && !bl9) {
                return new Some((Object)new DeltaSourceMetadataEvolutionSupport.SchemaChangeRenameAndDrop(renamedColumns, droppedColumns));
            }
        }
        if (tuple3 != null) {
            boolean bl = BoxesRunTime.unboxToBoolean((Object)tuple3._1());
            boolean bl10 = BoxesRunTime.unboxToBoolean((Object)tuple3._2());
            boolean bl11 = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
            if (bl && !bl10 && bl11) {
                return new Some((Object)new DeltaSourceMetadataEvolutionSupport.SchemaChangeRenameAndTypeWidening(renamedColumns, widenedColumns));
            }
        }
        if (tuple3 != null) {
            boolean bl = BoxesRunTime.unboxToBoolean((Object)tuple3._1());
            boolean bl12 = BoxesRunTime.unboxToBoolean((Object)tuple3._2());
            boolean bl13 = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
            if (!bl && bl12 && bl13) {
                return new Some((Object)new DeltaSourceMetadataEvolutionSupport.SchemaChangeDropAndTypeWidening(droppedColumns, widenedColumns));
            }
        }
        if (tuple3 != null) {
            boolean bl = BoxesRunTime.unboxToBoolean((Object)tuple3._1());
            boolean bl14 = BoxesRunTime.unboxToBoolean((Object)tuple3._2());
            boolean bl15 = BoxesRunTime.unboxToBoolean((Object)tuple3._3());
            if (bl && bl14 && bl15) {
                return new Some((Object)new DeltaSourceMetadataEvolutionSupport.SchemaChangeRenameAndDropAndTypeWidening(renamedColumns, droppedColumns, widenedColumns));
            }
        }
        return None$.MODULE$;
    }

    private Option<DeltaSourceMetadataEvolutionSupport.SchemaChangeType> determineNonAdditiveSchemaChangeType(SparkSession spark, StructType newSchema, StructType oldSchema) {
        Seq<RenamedColumn> renamedColumns = DeltaColumnMapping$.MODULE$.collectRenamedColumns(newSchema, oldSchema);
        Seq<DroppedColumn> droppedColumns = DeltaColumnMapping$.MODULE$.collectDroppedColumns(newSchema, oldSchema);
        StructType oldPhysicalSchema = DeltaColumnMapping$.MODULE$.renameColumns(oldSchema);
        StructType newPhysicalSchema = DeltaColumnMapping$.MODULE$.renameColumns(newSchema);
        Seq<TypeChange> typeWideningChanges = this.allowTypeWidening(spark) && !this.bypassTypeChangeCheck(spark) ? TypeWideningMetadata$.MODULE$.collectTypeChanges(oldPhysicalSchema, newPhysicalSchema) : (Seq<TypeChange>)package$.MODULE$.Seq().empty();
        return this.buildSchemaChangeDescriptor(renamedColumns, droppedColumns, typeWideningChanges);
    }

    private boolean isChangeUnblocked(SparkSession spark, DeltaSourceMetadataEvolutionSupport.SchemaChangeType change, DeltaOptions options, int checkpointHash, long schemaChangeVersion) {
        boolean isBlockedRename = change.isRename() && !DeltaSourceMetadataEvolutionSupport$.isUnblockedByReaderOption$1(options.allowSourceColumnRename(), schemaChangeVersion) && !DeltaSourceMetadataEvolutionSupport$.isUnblockedBySQLConf$1(this.org$apache$spark$sql$delta$sources$DeltaSourceMetadataEvolutionSupport$$SQL_CONF_UNBLOCK_RENAME(), spark, checkpointHash, schemaChangeVersion) && !DeltaSourceMetadataEvolutionSupport$.isUnblockedBySQLConf$1(this.org$apache$spark$sql$delta$sources$DeltaSourceMetadataEvolutionSupport$$SQL_CONF_UNBLOCK_RENAME_DROP(), spark, checkpointHash, schemaChangeVersion);
        boolean isBlockedDrop = change.isDrop() && !DeltaSourceMetadataEvolutionSupport$.isUnblockedByReaderOption$1(options.allowSourceColumnDrop(), schemaChangeVersion) && !DeltaSourceMetadataEvolutionSupport$.isUnblockedBySQLConf$1(this.org$apache$spark$sql$delta$sources$DeltaSourceMetadataEvolutionSupport$$SQL_CONF_UNBLOCK_DROP(), spark, checkpointHash, schemaChangeVersion) && !DeltaSourceMetadataEvolutionSupport$.isUnblockedBySQLConf$1(this.org$apache$spark$sql$delta$sources$DeltaSourceMetadataEvolutionSupport$$SQL_CONF_UNBLOCK_RENAME_DROP(), spark, checkpointHash, schemaChangeVersion);
        boolean isBlockedTypeChange = change.isTypeWidening() && !DeltaSourceMetadataEvolutionSupport$.isUnblockedByReaderOption$1(options.allowSourceColumnTypeChange(), schemaChangeVersion) && !DeltaSourceMetadataEvolutionSupport$.isUnblockedBySQLConf$1(this.org$apache$spark$sql$delta$sources$DeltaSourceMetadataEvolutionSupport$$SQL_CONF_UNBLOCK_TYPE_CHANGE(), spark, checkpointHash, schemaChangeVersion);
        return !isBlockedRename && !isBlockedDrop && !isBlockedTypeChange;
    }

    public int getCheckpointHash(String path) {
        return path.hashCode();
    }

    public boolean allowTypeWidening(SparkSession spark) {
        return BoxesRunTime.unboxToBoolean((Object)spark.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_ALLOW_TYPE_WIDENING_STREAMING_SOURCE()));
    }

    public boolean bypassTypeChangeCheck(SparkSession spark) {
        return BoxesRunTime.unboxToBoolean((Object)spark.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.DELTA_TYPE_WIDENING_BYPASS_STREAMING_TYPE_CHANGE_CHECK()));
    }

    public void validateIfSchemaChangeCanBeUnblocked(SparkSession spark, Map<String, String> parameters, String metadataPath, PersistedMetadata currentSchema, PersistedMetadata previousSchema) {
        DeltaOptions options = new DeltaOptions(parameters, spark.sessionState().conf());
        int checkpointHash = this.getCheckpointHash(metadataPath);
        long previousSchemaChangeVersion = previousSchema.deltaCommitVersion();
        long currentSchemaChangeVersion = currentSchema.deltaCommitVersion();
        this.checkIncompatibleSchemaChange(spark, previousSchema.dataSchema(), currentSchema.dataSchema(), currentSchemaChangeVersion);
        this.determineNonAdditiveSchemaChangeType(spark, currentSchema.dataSchema(), previousSchema.dataSchema()).foreach((Function1 & Serializable)change -> {
            DeltaSourceMetadataEvolutionSupport$.$anonfun$validateIfSchemaChangeCanBeUnblocked$1(spark, options, checkpointHash, currentSchemaChangeVersion, previousSchemaChangeVersion, change);
            return BoxedUnit.UNIT;
        });
    }

    private void checkIncompatibleSchemaChange(SparkSession spark, StructType previousSchema, StructType currentSchema, long currentSchemaChangeVersion) {
        boolean incompatibleSchema;
        if (this.bypassTypeChangeCheck(spark)) {
            return;
        }
        boolean bl = incompatibleSchema = !SchemaUtils$.MODULE$.isReadCompatible(DeltaColumnMapping$.MODULE$.renameColumns(previousSchema), DeltaColumnMapping$.MODULE$.renameColumns(currentSchema), true, true, (TypeWideningMode)(this.allowTypeWidening(spark) ? TypeWideningMode$AllTypeWidening$.MODULE$ : TypeWideningMode$NoTypeWidening$.MODULE$), SchemaUtils$.MODULE$.isReadCompatible$default$6(), SchemaUtils$.MODULE$.isReadCompatible$default$7());
        if (incompatibleSchema) {
            throw DeltaErrors$.MODULE$.schemaChangedException(previousSchema, currentSchema, false, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)currentSchemaChangeVersion)), false);
        }
    }

    private static final Option getConf$1(String key, SparkSession spark$1) {
        return Option$.MODULE$.apply((Object)spark$1.sessionState().conf().getConfString(key, null)).map((Function1 & Serializable)x$21 -> x$21.toLowerCase(Locale.ROOT));
    }

    public static final /* synthetic */ boolean $anonfun$isChangeUnblocked$2(SparkSession spark$1, Tuple2 p) {
        return DeltaSourceMetadataEvolutionSupport$.getConf$1((String)p._1(), spark$1).contains(p._2());
    }

    private static final boolean isUnblockedBySQLConf$1(String sqlConf, SparkSession spark$1, int checkpointHash$1, long schemaChangeVersion$1) {
        .colon.colon validConfKeysValuePair = new .colon.colon((Object)new Tuple2((Object)sqlConf, (Object)"always"), (List)new .colon.colon((Object)new Tuple2((Object)new StringBuilder(6).append(sqlConf).append(".ckpt_").append(checkpointHash$1).toString(), (Object)"always"), (List)new .colon.colon((Object)new Tuple2((Object)new StringBuilder(6).append(sqlConf).append(".ckpt_").append(checkpointHash$1).toString(), (Object)Long.toString(schemaChangeVersion$1)), (List)Nil$.MODULE$)));
        return validConfKeysValuePair.exists((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)DeltaSourceMetadataEvolutionSupport$.$anonfun$isChangeUnblocked$2(spark$1, p)));
    }

    private static final boolean isUnblockedByReaderOption$1(Option readerOption, long schemaChangeVersion$1) {
        return readerOption.contains((Object)"always") || readerOption.contains((Object)Long.toString(schemaChangeVersion$1));
    }

    public static final /* synthetic */ void $anonfun$validateIfSchemaChangeCanBeUnblocked$1(SparkSession spark$2, DeltaOptions options$1, int checkpointHash$2, long currentSchemaChangeVersion$1, long previousSchemaChangeVersion$1, DeltaSourceMetadataEvolutionSupport.SchemaChangeType change) {
        if (!MODULE$.isChangeUnblocked(spark$2, change, options$1, checkpointHash$2, currentSchemaChangeVersion$1)) {
            throw DeltaErrors$.MODULE$.cannotContinueStreamingPostSchemaEvolution(change.name(), previousSchemaChangeVersion$1, currentSchemaChangeVersion$1, checkpointHash$2, change.readerOptionsUnblock(), change.sqlConfsUnblock(), change.prettyColumnDetailsString());
        }
    }

    private DeltaSourceMetadataEvolutionSupport$() {
    }
}

