/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.streaming;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LoggingShims;
import org.apache.spark.internal.MDC;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.delta.logging.DeltaLogKeys$;
import org.apache.spark.sql.delta.streaming.PartitionAndDataSchema;
import org.apache.spark.sql.delta.streaming.SchemaSerializer;
import org.apache.spark.sql.delta.streaming.SchemaTrackingExceptions$;
import org.apache.spark.sql.execution.streaming.HDFSMetadataLog;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.reflect.Manifest;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005uc\u0001\u0002\r\u001a\u0001\u0019B\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!\u0012\u0005\t\u0013\u0002\u0011\t\u0011)A\u0005\u0015\"AQ\u000b\u0001B\u0001B\u0003%a\u000b\u0003\u0005Z\u0001\t\r\t\u0015a\u0003[\u0011!\u0001\u0007AaA!\u0002\u0017\t\u0007\"\u00023\u0001\t\u0003)\u0007bB7\u0001\u0005\u0004%IA\u001c\u0005\u0007q\u0002\u0001\u000b\u0011B8\t\u000fe\u0004\u0001\u0019!C\u0005u\"91\u0010\u0001a\u0001\n\u0013a\bbBA\u0003\u0001\u0001\u0006K!\u001e\u0005\t\u0003\u000f\u0001\u0001\u0019!C\u0005u\"I\u0011\u0011\u0002\u0001A\u0002\u0013%\u00111\u0002\u0005\b\u0003\u001f\u0001\u0001\u0015)\u0003v\u0011%\t\t\u0002\u0001a\u0001\n\u0013\t\u0019\u0002C\u0005\u0002\u0018\u0001\u0001\r\u0011\"\u0003\u0002\u001a!A\u0011Q\u0004\u0001!B\u0013\t)\u0002C\u0004\u0002 \u0001!\t!a\u0005\t\r\u0005\u0005\u0002\u0001\"\u0001{\u0011\u001d\t\u0019\u0003\u0001C\u0001\u0003KAq!a\u000b\u0001\t#\ni\u0003C\u0004\u0002D\u0001!\t&!\u0012\t\u000f\u0005U\u0003\u0001\"\u0001\u0002X\t\t2k\u00195f[\u0006$&/Y2lS:<Gj\\4\u000b\u0005iY\u0012!C:ue\u0016\fW.\u001b8h\u0015\taR$A\u0003eK2$\u0018M\u0003\u0002\u001f?\u0005\u00191/\u001d7\u000b\u0005\u0001\n\u0013!B:qCJ\\'B\u0001\u0012$\u0003\u0019\t\u0007/Y2iK*\tA%A\u0002pe\u001e\u001c\u0001!\u0006\u0002(cM\u0019\u0001\u0001\u000b \u0011\u0007%js&D\u0001+\u0015\tQ2F\u0003\u0002-;\u0005IQ\r_3dkRLwN\\\u0005\u0003])\u0012q\u0002\u0013#G'6+G/\u00193bi\u0006dun\u001a\t\u0003aEb\u0001\u0001B\u00033\u0001\t\u00071GA\u0001U#\t!$\b\u0005\u00026q5\taGC\u00018\u0003\u0015\u00198-\u00197b\u0013\tIdGA\u0004O_RD\u0017N\\4\u0011\u0005mbT\"A\r\n\u0005uJ\"A\u0006)beRLG/[8o\u0003:$G)\u0019;b'\u000eDW-\\1\u0011\u0005}\u0012U\"\u0001!\u000b\u0005\u0005{\u0012\u0001C5oi\u0016\u0014h.\u00197\n\u0005\r\u0003%\u0001\u0004'pO\u001eLgnZ*iS6\u001c\u0018\u0001D:qCJ\\7+Z:tS>t\u0007C\u0001$H\u001b\u0005i\u0012B\u0001%\u001e\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0003\u0011\u0001\u0018\r\u001e5\u0011\u0005-\u0013fB\u0001'Q!\tie'D\u0001O\u0015\tyU%\u0001\u0004=e>|GOP\u0005\u0003#Z\na\u0001\u0015:fI\u00164\u0017BA*U\u0005\u0019\u0019FO]5oO*\u0011\u0011KN\u0001\u0011g\u000eDW-\\1TKJL\u0017\r\\5{KJ\u00042aO,0\u0013\tA\u0016D\u0001\tTG\",W.Y*fe&\fG.\u001b>fe\u0006QQM^5eK:\u001cW\rJ\u001a\u0011\u0007msv&D\u0001]\u0015\tif'A\u0004sK\u001adWm\u0019;\n\u0005}c&\u0001C\"mCN\u001cH+Y4\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$C\u0007E\u0002LE>J!a\u0019+\u0003\u00115\u000bg.\u001b4fgR\fa\u0001P5oSRtD\u0003\u00024kW2$2a\u001a5j!\rY\u0004a\f\u0005\u00063\u001a\u0001\u001dA\u0017\u0005\u0006A\u001a\u0001\u001d!\u0019\u0005\u0006\t\u001a\u0001\r!\u0012\u0005\u0006\u0013\u001a\u0001\rA\u0013\u0005\u0006+\u001a\u0001\rAV\u0001\u0019g\u000eDW-\\1B]\u0012\u001cV-\u001d(v[\u0006#Hj\\4J]&$X#A8\u0011\u0007U\u0002(/\u0003\u0002rm\t1q\n\u001d;j_:\u0004B!N:v_%\u0011AO\u000e\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0005U2\u0018BA<7\u0005\u0011auN\\4\u00023M\u001c\u0007.Z7b\u0003:$7+Z9Ok6\fE\u000fT8h\u0013:LG\u000fI\u0001\u000eGV\u0014(/\u001a8u'\u0016\fh*^7\u0016\u0003U\f\u0011cY;se\u0016tGoU3r\u001dVlw\fJ3r)\ri\u0018\u0011\u0001\t\u0003kyL!a \u001c\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003\u0007Q\u0011\u0011!a\u0001k\u0006\u0019\u0001\u0010J\u0019\u0002\u001d\r,(O]3oiN+\u0017OT;nA\u0005\tb.\u001a=u'\u0016\fh*^7U_^\u0013\u0018\u000e^3\u0002+9,\u0007\u0010^*fc:+X\u000eV8Xe&$Xm\u0018\u0013fcR\u0019Q0!\u0004\t\u0011\u0005\rQ\"!AA\u0002U\f!C\\3yiN+\u0017OT;n)><&/\u001b;fA\u0005!2-\u001e:sK:$HK]1dW\u0016$7k\u00195f[\u0006,\"!!\u0006\u0011\u0007U\u0002x&\u0001\rdkJ\u0014XM\u001c;Ue\u0006\u001c7.\u001a3TG\",W.Y0%KF$2!`A\u000e\u0011%\t\u0019\u0001EA\u0001\u0002\u0004\t)\"A\u000bdkJ\u0014XM\u001c;Ue\u0006\u001c7.\u001a3TG\",W.\u0019\u0011\u0002/\u001d,GoQ;se\u0016tG\u000f\u0016:bG.,GmU2iK6\f\u0017aF4fi\u000e+(O]3oiR\u0013\u0018mY6fIN+\u0017OT;n\u0003a9W\r\u001e+sC\u000e\\W\rZ*dQ\u0016l\u0017-\u0011;TKFtU/\u001c\u000b\u0005\u0003+\t9\u0003\u0003\u0004\u0002*Q\u0001\r!^\u0001\u0007g\u0016\fh*^7\u0002\u0017\u0011,7/\u001a:jC2L'0\u001a\u000b\u0004_\u0005=\u0002bBA\u0019+\u0001\u0007\u00111G\u0001\u0003S:\u0004B!!\u000e\u0002@5\u0011\u0011q\u0007\u0006\u0005\u0003s\tY$\u0001\u0002j_*\u0011\u0011QH\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002B\u0005]\"aC%oaV$8\u000b\u001e:fC6\f\u0011b]3sS\u0006d\u0017N_3\u0015\u000bu\f9%a\u0013\t\r\u0005%c\u00031\u00010\u0003!iW\r^1eCR\f\u0007bBA'-\u0001\u0007\u0011qJ\u0001\u0004_V$\b\u0003BA\u001b\u0003#JA!a\u0015\u00028\taq*\u001e;qkR\u001cFO]3b[\u0006q\u0011\r\u001a3TG\",W.\u0019+p\u0019><GcA\u0018\u0002Z!1\u00111L\fA\u0002=\n\u0011B\\3x'\u000eDW-\\1")
public class SchemaTrackingLog<T extends PartitionAndDataSchema>
extends HDFSMetadataLog<T>
implements LoggingShims {
    private final SchemaSerializer<T> schemaSerializer;
    private final Option<Tuple2<Object, T>> schemaAndSeqNumAtLogInit;
    private long currentSeqNum;
    private long nextSeqNumToWrite;
    private Option<T> currentTrackedSchema;

    private Option<Tuple2<Object, T>> schemaAndSeqNumAtLogInit() {
        return this.schemaAndSeqNumAtLogInit;
    }

    private long currentSeqNum() {
        return this.currentSeqNum;
    }

    private void currentSeqNum_$eq(long x$1) {
        this.currentSeqNum = x$1;
    }

    private long nextSeqNumToWrite() {
        return this.nextSeqNumToWrite;
    }

    private void nextSeqNumToWrite_$eq(long x$1) {
        this.nextSeqNumToWrite = x$1;
    }

    private Option<T> currentTrackedSchema() {
        return this.currentTrackedSchema;
    }

    private void currentTrackedSchema_$eq(Option<T> x$1) {
        this.currentTrackedSchema = x$1;
    }

    public Option<T> getCurrentTrackedSchema() {
        return this.currentTrackedSchema();
    }

    public long getCurrentTrackedSeqNum() {
        return this.currentSeqNum();
    }

    public Option<T> getTrackedSchemaAtSeqNum(long seqNum) {
        return this.get(seqNum);
    }

    public T deserialize(InputStream in) {
        return this.schemaSerializer.deserialize(in);
    }

    public void serialize(T metadata, OutputStream out) {
        this.schemaSerializer.serialize(metadata, out);
    }

    public T addSchemaToLog(T newSchema) {
        this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Writing a new metadata version "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " in the metadata log"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)DeltaLogKeys$.MODULE$.VERSION(), (Object)BoxesRunTime.boxToLong((long)this.nextSeqNumToWrite()))})))));
        if (this.currentTrackedSchema().contains(newSchema)) {
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Schema didn't change after schema evolution. "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"currentSchema = ", "."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{new MDC((LogKey)DeltaLogKeys$.MODULE$.SCHEMA(), this.currentTrackedSchema())})))));
            return newSchema;
        }
        if (!this.add(this.nextSeqNumToWrite(), newSchema)) {
            throw SchemaTrackingExceptions$.MODULE$.FailedToEvolveSchema();
        }
        this.currentTrackedSchema_$eq((Option<T>)new Some(newSchema));
        this.currentSeqNum_$eq(this.nextSeqNumToWrite());
        this.nextSeqNumToWrite_$eq(this.nextSeqNumToWrite() + 1L);
        return newSchema;
    }

    public SchemaTrackingLog(SparkSession sparkSession, String path, SchemaSerializer<T> schemaSerializer, ClassTag<T> evidence$3, Manifest<T> evidence$4) {
        this.schemaSerializer = schemaSerializer;
        super(sparkSession, path, evidence$4);
        this.schemaAndSeqNumAtLogInit = this.getLatest();
        this.currentSeqNum = BoxesRunTime.unboxToLong((Object)this.schemaAndSeqNumAtLogInit().map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)x$1._1$mcJ$sp())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> -1L));
        this.nextSeqNumToWrite = this.currentSeqNum() + 1L;
        this.currentTrackedSchema = this.schemaAndSeqNumAtLogInit().map((Function1 & Serializable)x$2 -> (PartitionAndDataSchema)x$2._2());
    }
}

