/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.util;

import java.io.Serializable;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.delta.util.FileNames$BackfilledDeltaFile$;
import org.apache.spark.sql.delta.util.FileNames$CheckpointFile$;
import org.apache.spark.sql.delta.util.FileNames$ChecksumFile$;
import org.apache.spark.sql.delta.util.FileNames$CompactedDeltaFile$;
import org.apache.spark.sql.delta.util.FileNames$DeltaFile$;
import org.apache.spark.sql.delta.util.FileNames$UnbackfilledDeltaFile$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

public final class FileNames$ {
    public static final FileNames$ MODULE$ = new FileNames$();
    private static final Regex deltaFileRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(\\d+)\\.json"));
    private static final Regex uuidDeltaFileRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(\\d+)\\.([^.]+)\\.json"));
    private static final Regex compactedDeltaFileRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(\\d+).(\\d+).compacted.json"));
    private static final Regex checksumFileRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(\\d+)\\.crc"));
    private static final Regex checkpointFileRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(\\d+)\\.checkpoint((\\.\\d+\\.\\d+)?\\.parquet|\\.[^.]+\\.(json|parquet))"));
    private static final Pattern compactedDeltaFilePattern = MODULE$.compactedDeltaFileRegex().pattern();
    private static final Pattern checksumFilePattern = MODULE$.checksumFileRegex().pattern();
    private static final Pattern checkpointFilePattern = MODULE$.checkpointFileRegex().pattern();
    private static final String SIDECAR_SUBDIR = "_sidecars";
    private static final String COMMIT_SUBDIR = "_staged_commits";

    public Regex deltaFileRegex() {
        return deltaFileRegex;
    }

    public Regex uuidDeltaFileRegex() {
        return uuidDeltaFileRegex;
    }

    public Regex compactedDeltaFileRegex() {
        return compactedDeltaFileRegex;
    }

    public Regex checksumFileRegex() {
        return checksumFileRegex;
    }

    public Regex checkpointFileRegex() {
        return checkpointFileRegex;
    }

    private Pattern compactedDeltaFilePattern() {
        return compactedDeltaFilePattern;
    }

    private Pattern checksumFilePattern() {
        return checksumFilePattern;
    }

    private Pattern checkpointFilePattern() {
        return checkpointFilePattern;
    }

    public Path unsafeDeltaFile(Path path, long version) {
        return new Path(path, StringOps$.MODULE$.format$extension("%020d.json", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)version)})));
    }

    public Path unbackfilledDeltaFile(Path logPath, long version, Option<String> uuidString) {
        Path basePath = this.commitDirPath(logPath);
        String uuid = (String)uuidString.getOrElse((Function0 & Serializable)() -> UUID.randomUUID().toString());
        return new Path(basePath, StringOps$.MODULE$.format$extension("%020d.%s.json", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)version), uuid})));
    }

    public Option<String> unbackfilledDeltaFile$default$3() {
        return None$.MODULE$;
    }

    public Path sampleFile(Path path, long version) {
        return new Path(path, StringOps$.MODULE$.format$extension("%020d", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)version)})));
    }

    public Path checksumFile(Path path, long version) {
        return new Path(path, StringOps$.MODULE$.format$extension("%020d.crc", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)version)})));
    }

    public Path compactedDeltaFile(Path path, long fromVersion, long toVersion) {
        return new Path(path, StringOps$.MODULE$.format$extension("%020d.%020d.compacted.json", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)fromVersion), BoxesRunTime.boxToLong((long)toVersion)})));
    }

    public long deltaVersion(Path path) {
        return StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(path.getName().split("\\.")[0]));
    }

    public long deltaVersion(FileStatus file) {
        return this.deltaVersion(file.getPath());
    }

    public long checksumVersion(Path path) {
        return StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(path.getName()), ".crc")));
    }

    public long checksumVersion(FileStatus file) {
        return this.checksumVersion(file.getPath());
    }

    public Tuple2<Object, Object> compactedDeltaVersions(Path path) {
        String[] parts = path.getName().split("\\.");
        return new Tuple2.mcJJ.sp(StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(parts[0])), StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(parts[1])));
    }

    public Tuple2<Object, Object> compactedDeltaVersions(FileStatus file) {
        return this.compactedDeltaVersions(file.getPath());
    }

    public Path listingPrefix(Path path, long version) {
        return new Path(path, StringOps$.MODULE$.format$extension("%020d.", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)version)})));
    }

    public Path checkpointFileSingular(Path path, long version) {
        return new Path(path, StringOps$.MODULE$.format$extension("%020d.checkpoint.parquet", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)version)})));
    }

    public Seq<Path> checkpointFileWithParts(Path path, long version, int numParts) {
        return package$.MODULE$.Range().apply(1, numParts + 1).map((Function1 & Serializable)i -> FileNames$.$anonfun$checkpointFileWithParts$1(path, version, numParts, BoxesRunTime.unboxToInt((Object)i)));
    }

    public Option<Object> numCheckpointParts(Path path) {
        String[] segments = path.getName().split("\\.");
        if (ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.refArrayOps((Object[])segments)) != 5) {
            return None$.MODULE$;
        }
        return new Some((Object)BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(segments[3]))));
    }

    public boolean isCheckpointFile(Path path) {
        return this.checkpointFilePattern().matcher(path.getName()).matches();
    }

    public boolean isCheckpointFile(FileStatus file) {
        return this.isCheckpointFile(file.getPath());
    }

    public boolean isDeltaFile(Path path) {
        return FileNames$DeltaFile$.MODULE$.unapply(path).isDefined();
    }

    public boolean isDeltaFile(FileStatus file) {
        return this.isDeltaFile(file.getPath());
    }

    public boolean isUnbackfilledDeltaFile(Path path) {
        return FileNames$UnbackfilledDeltaFile$.MODULE$.unapply(path).isDefined();
    }

    public boolean isUnbackfilledDeltaFile(FileStatus file) {
        return this.isUnbackfilledDeltaFile(file.getPath());
    }

    public boolean isBackfilledDeltaFile(Path path) {
        return FileNames$BackfilledDeltaFile$.MODULE$.unapply(path).isDefined();
    }

    public boolean isBackfilledDeltaFile(FileStatus file) {
        return this.isBackfilledDeltaFile(file.getPath());
    }

    public boolean isChecksumFile(Path path) {
        return this.checksumFilePattern().matcher(path.getName()).matches();
    }

    public boolean isChecksumFile(FileStatus file) {
        return this.isChecksumFile(file.getPath());
    }

    public boolean isCompactedDeltaFile(Path path) {
        return this.compactedDeltaFilePattern().matcher(path.getName()).matches();
    }

    public boolean isCompactedDeltaFile(FileStatus file) {
        return this.isCompactedDeltaFile(file.getPath());
    }

    public long checkpointVersion(Path path) {
        return StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(path.getName().split("\\.")[0]));
    }

    public long checkpointVersion(FileStatus file) {
        return this.checkpointVersion(file.getPath());
    }

    public Option<Object> getFileVersionOpt(Path path) {
        Option<Tuple3<Path, Object, Object>> option;
        Option<Tuple2<Path, Object>> option2;
        Option<Tuple2<Path, Object>> option3;
        Option<Tuple2<Path, Object>> option4;
        Path path2 = path;
        if (path2 != null && !(option4 = FileNames$DeltaFile$.MODULE$.unapply(path2)).isEmpty()) {
            long version = ((Tuple2)option4.get())._2$mcJ$sp();
            return new Some((Object)BoxesRunTime.boxToLong((long)version));
        }
        if (path2 != null && !(option3 = FileNames$ChecksumFile$.MODULE$.unapply(path2)).isEmpty()) {
            long version = ((Tuple2)option3.get())._2$mcJ$sp();
            return new Some((Object)BoxesRunTime.boxToLong((long)version));
        }
        if (path2 != null && !(option2 = FileNames$CheckpointFile$.MODULE$.unapply(path2)).isEmpty()) {
            long version = ((Tuple2)option2.get())._2$mcJ$sp();
            return new Some((Object)BoxesRunTime.boxToLong((long)version));
        }
        if (path2 != null && !(option = FileNames$CompactedDeltaFile$.MODULE$.unapply(path2)).isEmpty()) {
            long endVersion = BoxesRunTime.unboxToLong((Object)((Tuple3)option.get())._3());
            return new Some((Object)BoxesRunTime.boxToLong((long)endVersion));
        }
        return None$.MODULE$;
    }

    public long getFileVersion(Path path) {
        return BoxesRunTime.unboxToLong((Object)this.getFileVersionOpt(path).getOrElse((Function0 & Serializable)() -> {
            throw new AssertionError((Object)new StringBuilder(47).append("Unexpected file type found in transaction log: ").append(path).toString());
        }));
    }

    public long getFileVersion(FileStatus file) {
        return this.getFileVersion(file.getPath());
    }

    public Path newV2CheckpointJsonFile(Path path, long version) {
        return new Path(path, StringOps$.MODULE$.format$extension("%020d.checkpoint.%s.json", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)version), UUID.randomUUID().toString()})));
    }

    public Path newV2CheckpointParquetFile(Path path, long version) {
        return new Path(path, StringOps$.MODULE$.format$extension("%020d.checkpoint.%s.parquet", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)version), UUID.randomUUID().toString()})));
    }

    public Path newV2CheckpointSidecarFile(Path logPath, long version, int numParts, int currentPart) {
        Path basePath = this.sidecarDirPath(logPath);
        String uuid = UUID.randomUUID().toString();
        return new Path(basePath, StringOps$.MODULE$.format$extension("%020d.checkpoint.%010d.%010d.%s.parquet", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)version), BoxesRunTime.boxToInteger((int)currentPart), BoxesRunTime.boxToInteger((int)numParts), uuid})));
    }

    public String SIDECAR_SUBDIR() {
        return SIDECAR_SUBDIR;
    }

    public Path sidecarDirPath(Path logPath) {
        return new Path(logPath, this.SIDECAR_SUBDIR());
    }

    public String COMMIT_SUBDIR() {
        return COMMIT_SUBDIR;
    }

    public Path commitDirPath(Path logPath) {
        return new Path(logPath, this.COMMIT_SUBDIR());
    }

    public static final /* synthetic */ Path $anonfun$checkpointFileWithParts$1(Path path$1, long version$1, int numParts$1, int i) {
        return new Path(path$1, StringOps$.MODULE$.format$extension("%020d.checkpoint.%010d.%010d.parquet", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)version$1), BoxesRunTime.boxToInteger((int)i), BoxesRunTime.boxToInteger((int)numParts$1)})));
    }

    private FileNames$() {
    }
}

