/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.util.threads;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkException;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.delta.util.threads.DeltaThreadPool;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u000514A\u0001C\u0005\u00011!Aa\u0005\u0001B\u0001B\u0003%q\u0005\u0003\u0005,\u0001\t\u0005\t\u0015!\u0003-\u0011\u0015q\u0004\u0001\"\u0001@\u0011\u001d!\u0005\u00011A\u0005\n\u0015Cq!\u0016\u0001A\u0002\u0013%a\u000b\u0003\u0004]\u0001\u0001\u0006KA\u0012\u0005\u0006C\u0002!\tA\u0019\u0002\u0015\u001d>tg)\u0019;f'\"\f'/\u001b8h\rV$XO]3\u000b\u0005)Y\u0011a\u0002;ie\u0016\fGm\u001d\u0006\u0003\u00195\tA!\u001e;jY*\u0011abD\u0001\u0006I\u0016dG/\u0019\u0006\u0003!E\t1a]9m\u0015\t\u00112#A\u0003ta\u0006\u00148N\u0003\u0002\u0015+\u00051\u0011\r]1dQ\u0016T\u0011AF\u0001\u0004_J<7\u0001A\u000b\u00033U\u001a2\u0001\u0001\u000e!!\tYb$D\u0001\u001d\u0015\u0005i\u0012!B:dC2\f\u0017BA\u0010\u001d\u0005\u0019\te.\u001f*fMB\u0011\u0011\u0005J\u0007\u0002E)\u00111%D\u0001\t[\u0016$XM]5oO&\u0011QE\t\u0002\r\t\u0016dG/\u0019'pO\u001eLgnZ\u0001\u0005a>|G\u000e\u0005\u0002)S5\t\u0011\"\u0003\u0002+\u0013\tyA)\u001a7uCRC'/Z1e!>|G.A\u0001g!\u0011YRfL\u001a\n\u00059b\"!\u0003$v]\u000e$\u0018n\u001c82!\t\u0001\u0014'D\u0001\u0010\u0013\t\u0011tB\u0001\u0007Ta\u0006\u00148nU3tg&|g\u000e\u0005\u00025k1\u0001A!\u0002\u001c\u0001\u0005\u00049$!\u0001+\u0012\u0005aZ\u0004CA\u000e:\u0013\tQDDA\u0004O_RD\u0017N\\4\u0011\u0005ma\u0014BA\u001f\u001d\u0005\r\te._\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u0001\u001bECA!C!\rA\u0003a\r\u0005\u0006W\r\u0001\r\u0001\f\u0005\u0006M\r\u0001\raJ\u0001\nMV$XO]3PaR,\u0012A\u0012\t\u00047\u001dK\u0015B\u0001%\u001d\u0005\u0019y\u0005\u000f^5p]B!1DS\u0018M\u0013\tYED\u0001\u0004UkBdWM\r\t\u0004\u001bN\u001bT\"\u0001(\u000b\u0005=\u0003\u0016AC2p]\u000e,(O]3oi*\u0011A\"\u0015\u0006\u0002%\u0006!!.\u0019<b\u0013\t!fJ\u0001\u0004GkR,(/Z\u0001\u000eMV$XO]3PaR|F%Z9\u0015\u0005]S\u0006CA\u000eY\u0013\tIFD\u0001\u0003V]&$\bbB.\u0006\u0003\u0003\u0005\rAR\u0001\u0004q\u0012\n\u0014A\u00034viV\u0014Xm\u00149uA!\u0012aA\u0018\t\u00037}K!\u0001\u0019\u000f\u0003\u0011Y|G.\u0019;jY\u0016\f1aZ3u)\t\u00194\rC\u0003e\u000f\u0001\u0007Q-A\u0004uS6,w.\u001e;\u0011\u0005\u0019TW\"A4\u000b\u0005!L\u0017\u0001\u00033ve\u0006$\u0018n\u001c8\u000b\u0005=c\u0012BA6h\u0005!!UO]1uS>t\u0007")
public class NonFateSharingFuture<T>
implements DeltaLogging {
    private final DeltaThreadPool pool;
    private final Function1<SparkSession, T> f;
    private volatile Option<Tuple2<SparkSession, Future<T>>> futureOpt;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data, Option<Path> path) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data, path);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public Option<Path> recordDeltaEvent$default$5() {
        return DeltaLogging.recordDeltaEvent$default$5$(this);
    }

    @Override
    public <A> A recordDeltaOperationForTablePath(String tablePath, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperationForTablePath$(this, tablePath, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperationForTablePath$default$3() {
        return DeltaLogging.recordDeltaOperationForTablePath$default$3$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public void deltaAssert(Function0<Object> check, String name, String msg, DeltaLog deltaLog, Object data, Option<Path> path) {
        DeltaLogging.deltaAssert$(this, check, name, msg, deltaLog, data, path);
    }

    @Override
    public DeltaLog deltaAssert$default$4() {
        return DeltaLogging.deltaAssert$default$4$(this);
    }

    @Override
    public Object deltaAssert$default$5() {
        return DeltaLogging.deltaAssert$default$5$(this);
    }

    @Override
    public Option<Path> deltaAssert$default$6() {
        return DeltaLogging.deltaAssert$default$6$(this);
    }

    @Override
    public <T> T recordFrameProfile(String group, String name, Function0<T> thunk) {
        return (T)DeltaLogging.recordFrameProfile$(this, group, name, thunk);
    }

    @Override
    public Map<TagDefinition, String> getCommonTags(DeltaLog deltaLog, String tahoeId) {
        return DeltaLogging.getCommonTags$(this, deltaLog, tahoeId);
    }

    @Override
    public Map<String, Object> getErrorData(Throwable e) {
        return DeltaLogging.getErrorData$(this, e);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public void recordProductUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordProductUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordProductUsage$default$3() {
        return DatabricksLogging.recordProductUsage$default$3$(this);
    }

    @Override
    public String recordProductUsage$default$4() {
        return DatabricksLogging.recordProductUsage$default$4$(this);
    }

    @Override
    public boolean recordProductUsage$default$5() {
        return DatabricksLogging.recordProductUsage$default$5$(this);
    }

    @Override
    public boolean recordProductUsage$default$6() {
        return DatabricksLogging.recordProductUsage$default$6$(this);
    }

    @Override
    public boolean recordProductUsage$default$7() {
        return DatabricksLogging.recordProductUsage$default$7$(this);
    }

    @Override
    public void recordProductEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordProductEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordProductEvent$default$2() {
        return DatabricksLogging.recordProductEvent$default$2$(this);
    }

    @Override
    public String recordProductEvent$default$3() {
        return DatabricksLogging.recordProductEvent$default$3$(this);
    }

    @Override
    public boolean recordProductEvent$default$4() {
        return DatabricksLogging.recordProductEvent$default$4$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(java.util.Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Option<Tuple2<SparkSession, Future<T>>> futureOpt() {
        return this.futureOpt;
    }

    private void futureOpt_$eq(Option<Tuple2<SparkSession, Future<T>>> x$1) {
        this.futureOpt = x$1;
    }

    public T get(Duration timeout) {
        Option futureResult = this.futureOpt().flatMap((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                None$ none$;
                SparkSession ownerSession = (SparkSession)tuple2._1();
                Future future = (Future)tuple2._2();
                try {
                    Some result = new Some(ThreadUtils$.MODULE$.awaitResult(future, timeout));
                    this.futureOpt_$eq((Option)new Some((Object)new Tuple2(null, (Object)future)));
                    none$ = result;
                }
                catch (SparkException sparkException) {
                    ExecutionException executionException;
                    Throwable throwable = sparkException.getCause();
                    if (throwable instanceof CancellationException) {
                        this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Future was cancelled"}))).log((Seq)Nil$.MODULE$)));
                        this.futureOpt_$eq((Option)None$.MODULE$);
                        none$ = None$.MODULE$;
                    }
                    if (throwable instanceof ExecutionException && (executionException = (ExecutionException)throwable).getCause() != null) {
                        Throwable throwable2 = executionException.getCause();
                        if (NonFatal$.MODULE$.apply(throwable2)) {
                            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Future threw non-fatal exception"}))).log((Seq)Nil$.MODULE$)), throwable2);
                            this.futureOpt_$eq((Option)None$.MODULE$);
                            none$ = None$.MODULE$;
                        }
                        if (throwable2 != null) {
                            Throwable throwable3 = throwable2;
                            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Future threw fatal error"}))).log((Seq)Nil$.MODULE$)), throwable3);
                            if (ownerSession == SparkSession$.MODULE$.active()) {
                                this.futureOpt_$eq((Option)None$.MODULE$);
                                throw throwable3;
                            }
                            none$ = None$.MODULE$;
                        }
                        throw new MatchError((Object)throwable2);
                    }
                    throw new MatchError((Object)throwable);
                }
                catch (TimeoutException timeoutException) {
                    this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Timed out waiting for future"}))).log((Seq)Nil$.MODULE$)));
                    none$ = None$.MODULE$;
                }
                catch (Throwable throwable) {
                    if (NonFatal$.MODULE$.apply(throwable)) {
                        this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown failure while waiting for future"}))).log((Seq)Nil$.MODULE$)), throwable);
                        none$ = None$.MODULE$;
                    }
                    throw throwable;
                }
                return none$;
            }
            throw new MatchError((Object)tuple2);
        });
        return (T)futureResult.getOrElse((Function0 & Serializable)() -> {
            Option option = SparkSession$.MODULE$.getActiveSession();
            if (option instanceof Some) {
                Some some = (Some)option;
                SparkSession spark = (SparkSession)some.value();
                return $this.f.apply((Object)spark);
            }
            throw DeltaErrors$.MODULE$.sparkSessionNotSetException();
        });
    }

    public NonFateSharingFuture(DeltaThreadPool pool, Function1<SparkSession, T> f) {
        this.pool = pool;
        this.f = f;
        Logging.$init$((Logging)this);
        DeltaProgressReporter.$init$(this);
        DatabricksLogging.$init$(this);
        DeltaLogging.$init$(this);
        this.futureOpt = SparkSession$.MODULE$.getActiveSession().map((Function1 & Serializable)spark -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(spark), $this.pool.submit((SparkSession)spark, (Function0 & Serializable)() -> $this.f.apply(spark))));
    }
}

