/*
 * Decompiled with CFR 0.152.
 */
package io.delta.standalone;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class Operation {
    @Nonnull
    private final Name name;
    @Nullable
    private final Map<String, String> parameters;
    @Nullable
    private final Map<String, String> metrics;
    @Nonnull
    private final Optional<String> userMetadata;

    public Operation(@Nonnull Name name) {
        this(name, Collections.emptyMap(), Collections.emptyMap(), Optional.empty());
    }

    public Operation(@Nonnull Name name, @Nullable Map<String, String> map2) {
        this(name, map2, Collections.emptyMap(), Optional.empty());
    }

    public Operation(@Nonnull Name name, @Nullable Map<String, String> map2, @Nullable Map<String, String> map3) {
        this(name, map2, map3, Optional.empty());
    }

    public Operation(@Nonnull Name name, @Nullable Map<String, String> map2, @Nullable Map<String, String> map3, @Nonnull Optional<String> optional) {
        this.name = name;
        this.parameters = map2;
        this.metrics = map3;
        this.userMetadata = optional;
    }

    @Nonnull
    public Name getName() {
        return this.name;
    }

    @Nullable
    public Map<String, String> getParameters() {
        return this.parameters != null ? Collections.unmodifiableMap(this.parameters) : null;
    }

    @Nullable
    public Map<String, String> getMetrics() {
        return this.metrics != null ? Collections.unmodifiableMap(this.metrics) : null;
    }

    @Nonnull
    public Optional<String> getUserMetadata() {
        return this.userMetadata;
    }

    public static class Metrics {
        public static final String numFiles = "numFiles";
        public static final String numOutputBytes = "numOutputBytes";
        public static final String numOutputRows = "numOutputRows";
        public static final String numAddedFiles = "numAddedFiles";
        public static final String numRemovedFiles = "numRemovedFiles";
        public static final String numDeletedRows = "numDeletedRows";
        public static final String numCopiedRows = "numCopiedRows";
        public static final String executionTimeMs = "executionTimeMs";
        public static final String scanTimeMs = "scanTimeMs";
        public static final String rewriteTimeMs = "rewriteTimeMs";
        public static final String numConvertedFiles = "numConvertedFiles";
        public static final String numSourceRows = "numSourceRows";
        public static final String numTargetRowsInserted = "numTargetRowsInserted";
        public static final String numTargetRowsUpdated = "numTargetRowsUpdated";
        public static final String numTargetRowsDeleted = "numTargetRowsDeleted";
        public static final String numTargetRowsCopied = "numTargetRowsCopied";
        public static final String numTargetFilesAdded = "numTargetFilesAdded";
        public static final String numTargetFilesRemoved = "numTargetFilesRemoved";
        public static final String numUpdatedRows = "numUpdatedRows";
    }

    public static enum Name {
        WRITE("WRITE"),
        STREAMING_UPDATE("STREAMING UPDATE"),
        DELETE("DELETE"),
        TRUNCATE("TRUNCATE"),
        CONVERT("CONVERT"),
        MERGE("MERGE"),
        UPDATE("UPDATE"),
        CREATE_TABLE("CREATE TABLE"),
        REPLACE_TABLE("REPLACE TABLE"),
        SET_TABLE_PROPERTIES("SET TBLPROPERTIES"),
        UNSET_TABLE_PROPERTIES("UNSET TBLPROPERTIES"),
        ADD_COLUMNS("ADD COLUMNS"),
        CHANGE_COLUMN("CHANGE COLUMN"),
        REPLACE_COLUMNS("REPLACE COLUMNS"),
        UPGRADE_PROTOCOL("UPGRADE PROTOCOL"),
        UPGRADE_SCHEMA("UPDATE SCHEMA"),
        MANUAL_UPDATE("Manual Update");

        private final String logStr;

        private Name(String string2) {
            this.logStr = string2;
        }

        public String toString() {
            return this.logStr;
        }
    }
}

