/*
 * Decompiled with CFR 0.152.
 */
package io.delta.standalone.actions;

import io.delta.standalone.actions.FileAction;
import io.delta.standalone.actions.RemoveFile;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class AddFile
implements FileAction {
    @Nonnull
    private final String path;
    @Nonnull
    private final Map<String, String> partitionValues;
    private final long size;
    private final long modificationTime;
    private final boolean dataChange;
    @Nullable
    private final String stats;
    @Nullable
    private final Map<String, String> tags;

    public AddFile(@Nonnull String string, @Nonnull Map<String, String> map2, long l, long l2, boolean bl, @Nullable String string2, @Nullable Map<String, String> map3) {
        this.path = string;
        this.partitionValues = map2;
        this.size = l;
        this.modificationTime = l2;
        this.dataChange = bl;
        this.stats = string2;
        this.tags = map3;
    }

    @Nonnull
    public RemoveFile remove() {
        return this.remove(System.currentTimeMillis(), this.dataChange);
    }

    @Nonnull
    public RemoveFile remove(long l) {
        return this.remove(l, this.dataChange);
    }

    @Nonnull
    public RemoveFile remove(boolean bl) {
        return this.remove(System.currentTimeMillis(), bl);
    }

    @Nonnull
    public RemoveFile remove(long l, boolean bl) {
        return new RemoveFile(this.path, Optional.of(l), bl, true, this.partitionValues, Optional.of(this.size), this.tags);
    }

    @Override
    @Nonnull
    public String getPath() {
        return this.path;
    }

    @Nonnull
    public Map<String, String> getPartitionValues() {
        return Collections.unmodifiableMap(this.partitionValues);
    }

    public long getSize() {
        return this.size;
    }

    public long getModificationTime() {
        return this.modificationTime;
    }

    @Override
    public boolean isDataChange() {
        return this.dataChange;
    }

    @Nullable
    public String getStats() {
        return this.stats;
    }

    @Nullable
    public Map<String, String> getTags() {
        return this.tags != null ? Collections.unmodifiableMap(this.tags) : null;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        AddFile addFile = (AddFile)object;
        return this.size == addFile.size && this.modificationTime == addFile.modificationTime && this.dataChange == addFile.dataChange && Objects.equals(this.path, addFile.path) && Objects.equals(this.partitionValues, addFile.partitionValues) && Objects.equals(this.stats, addFile.stats) && Objects.equals(this.tags, addFile.tags);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.partitionValues, this.size, this.modificationTime, this.dataChange, this.stats, this.tags);
    }

    public static Builder builder(String string, Map<String, String> map2, long l, long l2, boolean bl) {
        return new Builder(string, map2, l, l2, bl);
    }

    public static final class Builder {
        private final String path;
        private final Map<String, String> partitionValues;
        private final long size;
        private final long modificationTime;
        private final boolean dataChange;
        private String stats;
        private Map<String, String> tags;

        public Builder(String string, Map<String, String> map2, long l, long l2, boolean bl) {
            this.path = string;
            this.partitionValues = map2;
            this.size = l;
            this.modificationTime = l2;
            this.dataChange = bl;
        }

        public Builder stats(String string) {
            this.stats = string;
            return this;
        }

        public Builder tags(Map<String, String> map2) {
            this.tags = map2;
            return this;
        }

        public AddFile build() {
            AddFile addFile = new AddFile(this.path, this.partitionValues, this.size, this.modificationTime, this.dataChange, this.stats, this.tags);
            return addFile;
        }
    }
}

