/*
 * Decompiled with CFR 0.152.
 */
package io.delta.standalone.expressions;

import io.delta.standalone.data.RowRecord;
import io.delta.standalone.expressions.LeafExpression;
import io.delta.standalone.types.ArrayType;
import io.delta.standalone.types.BinaryType;
import io.delta.standalone.types.BooleanType;
import io.delta.standalone.types.ByteType;
import io.delta.standalone.types.DataType;
import io.delta.standalone.types.DateType;
import io.delta.standalone.types.DecimalType;
import io.delta.standalone.types.DoubleType;
import io.delta.standalone.types.FloatType;
import io.delta.standalone.types.IntegerType;
import io.delta.standalone.types.LongType;
import io.delta.standalone.types.MapType;
import io.delta.standalone.types.NullType;
import io.delta.standalone.types.ShortType;
import io.delta.standalone.types.StringType;
import io.delta.standalone.types.StructType;
import io.delta.standalone.types.TimestampType;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.Objects;

public final class Literal
extends LeafExpression {
    public static final Literal True = Literal.of(true);
    public static final Literal False = Literal.of(false);
    private final Object value;
    private final DataType dataType;

    private Literal(Object object, DataType dataType) {
        this.value = object;
        this.dataType = dataType;
    }

    public Object value() {
        return this.value;
    }

    @Override
    public Object eval(RowRecord rowRecord) {
        return this.value;
    }

    @Override
    public DataType dataType() {
        return this.dataType;
    }

    @Override
    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Literal literal2 = (Literal)object;
        return Objects.equals(this.value, literal2.value) && Objects.equals(this.dataType, literal2.dataType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.value, this.dataType);
    }

    public static Literal of(int n) {
        return new Literal(n, new IntegerType());
    }

    public static Literal of(boolean bl) {
        return new Literal(bl, new BooleanType());
    }

    public static Literal of(byte[] byArray) {
        return new Literal(byArray, new BinaryType());
    }

    public static Literal of(Date date) {
        return new Literal(date, new DateType());
    }

    public static Literal of(BigDecimal bigDecimal) {
        return new Literal(bigDecimal, new DecimalType(bigDecimal.precision(), bigDecimal.scale()));
    }

    public static Literal of(double d) {
        return new Literal(d, new DoubleType());
    }

    public static Literal of(float f) {
        return new Literal(Float.valueOf(f), new FloatType());
    }

    public static Literal of(long l) {
        return new Literal(l, new LongType());
    }

    public static Literal of(short s) {
        return new Literal(s, new ShortType());
    }

    public static Literal of(String string) {
        return new Literal(string, new StringType());
    }

    public static Literal of(Timestamp timestamp) {
        return new Literal(timestamp, new TimestampType());
    }

    public static Literal of(byte by) {
        return new Literal(by, new ByteType());
    }

    public static Literal ofNull(DataType dataType) {
        if (dataType instanceof NullType || dataType instanceof ArrayType || dataType instanceof MapType || dataType instanceof StructType) {
            throw new IllegalArgumentException(dataType.getTypeName() + " is an invalid data type for Literal.");
        }
        return new Literal(null, dataType);
    }
}

