/*
 * Decompiled with CFR 0.152.
 */
package io.delta.standalone.internal;

import io.delta.standalone.internal.DeltaConfig;
import io.delta.standalone.internal.actions.Protocol;
import io.delta.standalone.internal.exception.DeltaErrors$;
import io.delta.standalone.internal.logging.Logging;
import io.delta.standalone.internal.logging.Logging$class;
import io.delta.standalone.internal.util.CalendarInterval;
import io.delta.standalone.internal.util.DateTimeConstants$;
import io.delta.standalone.internal.util.IntervalUtils$;
import java.util.HashMap;
import java.util.Locale;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.Nothing$;

public final class DeltaConfigs$
implements Logging {
    public static final DeltaConfigs$ MODULE$;
    private final String hadoopConfPrefix;
    private final HashMap<String, DeltaConfig<?>> io$delta$standalone$internal$DeltaConfigs$$entries;
    private final DeltaConfig<CalendarInterval> LOG_RETENTION;
    private final DeltaConfig<CalendarInterval> TOMBSTONE_RETENTION;
    private final DeltaConfig<Object> CHECKPOINT_INTERVAL;
    private final DeltaConfig<Object> ENABLE_EXPIRED_LOG_CLEANUP;
    private final DeltaConfig<Object> IS_APPEND_ONLY;
    private transient Logger io$delta$standalone$internal$logging$Logging$$log_;

    static {
        new DeltaConfigs$();
    }

    @Override
    public Logger io$delta$standalone$internal$logging$Logging$$log_() {
        return this.io$delta$standalone$internal$logging$Logging$$log_;
    }

    @Override
    public void io$delta$standalone$internal$logging$Logging$$log__$eq(Logger x$1) {
        this.io$delta$standalone$internal$logging$Logging$$log_ = x$1;
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    public CalendarInterval parseCalendarInterval(String s) {
        if (s == null || s.trim().isEmpty()) {
            throw new IllegalArgumentException("Interval cannot be null or blank.");
        }
        String sInLowerCase = s.trim().toLowerCase(Locale.ROOT);
        String interval = sInLowerCase.startsWith("interval ") ? sInLowerCase : new StringBuilder().append((Object)"interval ").append((Object)sInLowerCase).toString();
        CalendarInterval cal = IntervalUtils$.MODULE$.safeStringToInterval(interval);
        if (cal == null) {
            throw new IllegalArgumentException(new StringBuilder().append((Object)"Invalid interval: ").append((Object)s).toString());
        }
        return cal;
    }

    public String hadoopConfPrefix() {
        return this.hadoopConfPrefix;
    }

    public HashMap<String, DeltaConfig<?>> io$delta$standalone$internal$DeltaConfigs$$entries() {
        return this.io$delta$standalone$internal$DeltaConfigs$$entries;
    }

    public <T> DeltaConfig<T> buildConfig(String key, String defaultValue2, Function1<String, T> fromString, Function1<T, Object> validationFunction, String helpMessage, Option<Protocol> minimumProtocolVersion, boolean userConfigurable) {
        DeltaConfig<T> deltaConfig = new DeltaConfig<T>(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"delta.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key})), defaultValue2, fromString, validationFunction, helpMessage, minimumProtocolVersion, userConfigurable);
        this.io$delta$standalone$internal$DeltaConfigs$$entries().put(key.toLowerCase(Locale.ROOT), deltaConfig);
        return deltaConfig;
    }

    public <T> Option<Protocol> buildConfig$default$6() {
        return None$.MODULE$;
    }

    public <T> boolean buildConfig$default$7() {
        return true;
    }

    public Map<String, String> validateConfigurations(Map<String, String> configurations) {
        return (Map)configurations.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String> apply(Tuple2<String, String> x0$1) {
                Tuple2 tuple2;
                block7: {
                    Tuple2 tuple22;
                    block6: {
                        block5: {
                            String key;
                            tuple2 = x0$1;
                            if (tuple2 != null && (key = (String)tuple2._1()).toLowerCase(Locale.ROOT).startsWith("delta.constraints.")) {
                                throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported CHECK constraint configuration ", " set"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{key})));
                            }
                            if (tuple2 == null) break block5;
                            String key2 = (String)tuple2._1();
                            String value = (String)tuple2._2();
                            if (!key2.toLowerCase(Locale.ROOT).startsWith("delta.")) break block5;
                            tuple22 = (Tuple2)Option$.MODULE$.apply(DeltaConfigs$.MODULE$.io$delta$standalone$internal$DeltaConfigs$$entries().get(new StringOps(Predef$.MODULE$.augmentString(key2.toLowerCase(Locale.ROOT))).stripPrefix("delta."))).map((Function1)new Serializable(this, value){
                                public static final long serialVersionUID = 0L;
                                private final String value$1;

                                public final Tuple2<String, String> apply(DeltaConfig<Object> x$1) {
                                    return x$1.apply(this.value$1);
                                }
                                {
                                    this.value$1 = value$1;
                                }
                            }).getOrElse((Function0)new Serializable(this, key2){
                                public static final long serialVersionUID = 0L;
                                private final String key$1;

                                public final Nothing$ apply() {
                                    throw DeltaErrors$.MODULE$.unknownConfigurationKeyException(this.key$1);
                                }
                                {
                                    this.key$1 = key$1;
                                }
                            });
                            break block6;
                        }
                        if (tuple2 == null) break block7;
                        String key = (String)tuple2._1();
                        if (DeltaConfigs$.MODULE$.io$delta$standalone$internal$DeltaConfigs$$entries().containsKey(key.toLowerCase(Locale.ROOT))) {
                            DeltaConfigs$.MODULE$.logWarning((Function0<String>)new Serializable(this, key){
                                public static final long serialVersionUID = 0L;
                                private final String key$2;

                                public final String apply() {
                                    return new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |You are trying to set a property the key of which is the same as Delta config: ", ".\n             |If you are trying to set a Delta config, prefix it with \"delta.\", e.g. 'delta.", "'.\n             |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.key$2, this.key$2})))).stripMargin();
                                }
                                {
                                    this.key$2 = key$2;
                                }
                            });
                        }
                        tuple22 = tuple2;
                    }
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Map$.MODULE$.canBuildFrom());
    }

    public Map<String, String> mergeGlobalConfigs(Configuration hadoopConf, Map<String, String> tableConf) {
        scala.collection.mutable.Map globalConfs = (scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.io$delta$standalone$internal$DeltaConfigs$$entries()).asScala()).flatMap((Function1)new Serializable(hadoopConf){
            public static final long serialVersionUID = 0L;
            private final Configuration hadoopConf$1;

            public final Iterable<Tuple2<String, String>> apply(Tuple2<String, DeltaConfig<?>> x0$2) {
                Tuple2<String, DeltaConfig<?>> tuple2 = x0$2;
                if (tuple2 != null) {
                    Iterable iterable;
                    DeltaConfig config = (DeltaConfig)tuple2._2();
                    String hadoopConfKey = new StringBuilder().append((Object)DeltaConfigs$.MODULE$.hadoopConfPrefix()).append((Object)new StringOps(Predef$.MODULE$.augmentString(config.key())).stripPrefix("delta.")).toString();
                    Option option = Option$.MODULE$.apply((Object)this.hadoopConf$1.get(hadoopConfKey, null));
                    if (option instanceof Some) {
                        Some some = (Some)option;
                        String string = (String)some.x();
                        iterable = Option$.MODULE$.option2Iterable((Option)new Some(config.apply(string)));
                    } else {
                        iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                    }
                    Iterable iterable2 = iterable;
                    return iterable2;
                }
                throw new MatchError(tuple2);
            }
            {
                this.hadoopConf$1 = hadoopConf$1;
            }
        }, scala.collection.mutable.Map$.MODULE$.canBuildFrom());
        return globalConfs.toMap(Predef$.MODULE$.$conforms()).$plus$plus(tableConf);
    }

    public long getMilliSeconds(CalendarInterval i) {
        return this.getMicroSeconds(i) / 1000L;
    }

    private long getMicroSeconds(CalendarInterval i) {
        Predef$.MODULE$.assert(i.months() == 0);
        return (long)i.days() * DateTimeConstants$.MODULE$.MICROS_PER_DAY() + i.microseconds();
    }

    public boolean isValidIntervalConfigValue(CalendarInterval i) {
        return i.months() == 0 && this.getMicroSeconds(i) >= 0L;
    }

    public DeltaConfig<CalendarInterval> LOG_RETENTION() {
        return this.LOG_RETENTION;
    }

    public DeltaConfig<CalendarInterval> TOMBSTONE_RETENTION() {
        return this.TOMBSTONE_RETENTION;
    }

    public DeltaConfig<Object> CHECKPOINT_INTERVAL() {
        return this.CHECKPOINT_INTERVAL;
    }

    public DeltaConfig<Object> ENABLE_EXPIRED_LOG_CLEANUP() {
        return this.ENABLE_EXPIRED_LOG_CLEANUP;
    }

    public DeltaConfig<Object> IS_APPEND_ONLY() {
        return this.IS_APPEND_ONLY;
    }

    private DeltaConfigs$() {
        MODULE$ = this;
        Logging$class.$init$(this);
        this.hadoopConfPrefix = "spark.databricks.delta.properties.defaults.";
        this.io$delta$standalone$internal$DeltaConfigs$$entries = new HashMap();
        this.LOG_RETENTION = this.buildConfig("logRetentionDuration", "interval 30 days", (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final CalendarInterval apply(String s) {
                return DeltaConfigs$.MODULE$.parseCalendarInterval(s);
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(CalendarInterval i) {
                return DeltaConfigs$.MODULE$.isValidIntervalConfigValue(i);
            }
        }, "needs to be provided as a calendar interval such as '2 weeks'. Months and years are not accepted. You may specify '365 days' for a year instead.", this.buildConfig$default$6(), this.buildConfig$default$7());
        this.TOMBSTONE_RETENTION = this.buildConfig("deletedFileRetentionDuration", "interval 1 week", (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final CalendarInterval apply(String s) {
                return DeltaConfigs$.MODULE$.parseCalendarInterval(s);
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(CalendarInterval i) {
                return DeltaConfigs$.MODULE$.isValidIntervalConfigValue(i);
            }
        }, "needs to be provided as a calendar interval such as '2 weeks'. Months and years are not accepted. You may specify '365 days' for a year instead.", this.buildConfig$default$6(), this.buildConfig$default$7());
        this.CHECKPOINT_INTERVAL = this.buildConfig("checkpointInterval", "10", (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$2) {
                return new StringOps(Predef$.MODULE$.augmentString(x$2)).toInt();
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(int x$3) {
                return this.apply$mcZI$sp(x$3);
            }

            public boolean apply$mcZI$sp(int x$3) {
                return x$3 > 0;
            }
        }, "needs to be a positive integer.", this.buildConfig$default$6(), this.buildConfig$default$7());
        this.ENABLE_EXPIRED_LOG_CLEANUP = this.buildConfig("enableExpiredLogCleanup", "true", (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$4) {
                return new StringOps(Predef$.MODULE$.augmentString(x$4)).toBoolean();
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(boolean x$5) {
                return true;
            }
        }, "needs to be a boolean.", this.buildConfig$default$6(), this.buildConfig$default$7());
        this.IS_APPEND_ONLY = this.buildConfig("appendOnly", "false", (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$6) {
                return new StringOps(Predef$.MODULE$.augmentString(x$6)).toBoolean();
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(boolean x$7) {
                return true;
            }
        }, "needs to be a boolean.", (Option<Protocol>)new Some((Object)new Protocol(0, 2)), this.buildConfig$default$7());
    }
}

