/*
 * Decompiled with CFR 0.152.
 */
package io.delta.standalone.internal;

import io.delta.standalone.internal.BufferingLogDeletionIterator;
import io.delta.standalone.internal.CheckpointMetaData;
import io.delta.standalone.internal.DeltaConfigs$;
import io.delta.standalone.internal.DeltaLogImpl;
import io.delta.standalone.internal.util.FileNames$;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;

public abstract class MetadataCleanup$class {
    public static boolean enableExpiredLogCleanup(DeltaLogImpl $this) {
        return BoxesRunTime.unboxToBoolean((Object)DeltaConfigs$.MODULE$.ENABLE_EXPIRED_LOG_CLEANUP().fromMetadata($this.metadata()));
    }

    public static long deltaRetentionMillis(DeltaLogImpl $this) {
        return DeltaConfigs$.MODULE$.getMilliSeconds(DeltaConfigs$.MODULE$.LOG_RETENTION().fromMetadata($this.metadata()));
    }

    public static void doLogCleanup(DeltaLogImpl $this) {
        if ($this.enableExpiredLogCleanup()) {
            $this.cleanUpExpiredLogs();
        }
    }

    public static void cleanUpExpiredLogs(DeltaLogImpl $this) {
        ObjectRef formattedDate$lzy = ObjectRef.zero();
        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
        Date fileCutOffTime = MetadataCleanup$class.truncateDay($this, $this.clock().getTimeMillis() - $this.deltaRetentionMillis()).getTime();
        $this.logInfo((Function0<String>)new Serializable($this, fileCutOffTime, formattedDate$lzy, bitmap$0){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeltaLogImpl $outer;
            private final Date fileCutOffTime$1;
            private final ObjectRef formattedDate$lzy$1;
            private final VolatileByteRef bitmap$0$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Starting the deletion of log files older than ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{MetadataCleanup$class.formattedDate$1(this.$outer, this.fileCutOffTime$1, this.formattedDate$lzy$1, this.bitmap$0$1)}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.fileCutOffTime$1 = fileCutOffTime$1;
                this.formattedDate$lzy$1 = formattedDate$lzy$1;
                this.bitmap$0$1 = bitmap$0$1;
            }
        });
        IntRef numDeleted = IntRef.create((int)0);
        MetadataCleanup$class.listExpiredDeltaLogs($this, fileCutOffTime.getTime()).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Path apply(FileStatus x$1) {
                return x$1.getPath();
            }
        }).foreach((Function1)new Serializable($this, numDeleted){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeltaLogImpl $outer;
            private final IntRef numDeleted$1;

            public final void apply(Path path2) {
                if (this.$outer.fs().delete(path2, false)) {
                    ++this.numDeleted$1.elem;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.numDeleted$1 = numDeleted$1;
            }
        });
        $this.logInfo((Function0<String>)new Serializable($this, fileCutOffTime, formattedDate$lzy, numDeleted, bitmap$0){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeltaLogImpl $outer;
            private final Date fileCutOffTime$1;
            private final ObjectRef formattedDate$lzy$1;
            private final IntRef numDeleted$1;
            private final VolatileByteRef bitmap$0$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleted ", " log files older than ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numDeleted$1.elem), MetadataCleanup$class.formattedDate$1(this.$outer, this.fileCutOffTime$1, this.formattedDate$lzy$1, this.bitmap$0$1)}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.fileCutOffTime$1 = fileCutOffTime$1;
                this.formattedDate$lzy$1 = formattedDate$lzy$1;
                this.numDeleted$1 = numDeleted$1;
                this.bitmap$0$1 = bitmap$0$1;
            }
        });
    }

    private static Iterator listExpiredDeltaLogs(DeltaLogImpl $this, long fileCutOffTime) {
        Option<CheckpointMetaData> latestCheckpoint = $this.lastCheckpoint();
        if (latestCheckpoint.isEmpty()) {
            return package$.MODULE$.Iterator().empty();
        }
        long threshold = ((CheckpointMetaData)latestCheckpoint.get()).version() - 1L;
        Iterator files2 = ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter($this.store().listFrom(FileNames$.MODULE$.checkpointPrefix($this.logPath(), 0L), $this.hadoopConf())).asScala()).filter((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(FileStatus f) {
                return FileNames$.MODULE$.isCheckpointFile(f.getPath()) || FileNames$.MODULE$.isDeltaFile(f.getPath());
            }
        });
        return new BufferingLogDeletionIterator((Iterator<FileStatus>)files2, fileCutOffTime, threshold, (Function1<Path, Object>)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeltaLogImpl $outer;

            public final long apply(Path filePath) {
                return MetadataCleanup$class.getVersion$1(this.$outer, filePath);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    private static Calendar truncateDay(DeltaLogImpl $this, long timeMillis) {
        Calendar date = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        date.setTimeInMillis(timeMillis);
        return DateUtils.truncate((Calendar)date, (int)5);
    }

    private static final String formattedDate$lzycompute$1(DeltaLogImpl $this, Date fileCutOffTime$1, ObjectRef formattedDate$lzy$1, VolatileByteRef bitmap$0$1) {
        DeltaLogImpl deltaLogImpl = $this;
        synchronized (deltaLogImpl) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                formattedDate$lzy$1.elem = fileCutOffTime$1.toGMTString();
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (String)formattedDate$lzy$1.elem;
        }
    }

    public static final String formattedDate$1(DeltaLogImpl $this, Date fileCutOffTime$1, ObjectRef formattedDate$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? MetadataCleanup$class.formattedDate$lzycompute$1($this, fileCutOffTime$1, formattedDate$lzy$1, bitmap$0$1) : (String)formattedDate$lzy$1.elem;
    }

    public static final long getVersion$1(DeltaLogImpl $this, Path filePath) {
        return FileNames$.MODULE$.isCheckpointFile(filePath) ? FileNames$.MODULE$.checkpointVersion(filePath) : FileNames$.MODULE$.deltaVersion(filePath);
    }

    public static void $init$(DeltaLogImpl $this) {
    }
}

