/*
 * Decompiled with CFR 0.152.
 */
package io.delta.standalone.internal;

import io.delta.standalone.internal.CheckpointInstance;
import io.delta.standalone.internal.CheckpointInstance$;
import io.delta.standalone.internal.CheckpointMetaData;
import io.delta.standalone.internal.DeltaHistoryManager;
import io.delta.standalone.internal.DeltaLogImpl;
import io.delta.standalone.internal.InitialSnapshotImpl;
import io.delta.standalone.internal.LogSegment;
import io.delta.standalone.internal.SnapshotImpl;
import io.delta.standalone.internal.exception.DeltaErrors$;
import io.delta.standalone.internal.util.FileNames$;
import java.io.FileNotFoundException;
import java.sql.Timestamp;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.NumericRange;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong;

public abstract class SnapshotManagement$class {
    public static SnapshotImpl snapshot(DeltaLogImpl $this) {
        return $this.currentSnapshot();
    }

    public static SnapshotImpl update(DeltaLogImpl $this) {
        return (SnapshotImpl)$this.lockInterruptibly(new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeltaLogImpl $outer;

            public final SnapshotImpl apply() {
                return SnapshotManagement$class.io$delta$standalone$internal$SnapshotManagement$$updateInternal(this.$outer);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static SnapshotImpl getSnapshotForVersionAsOf(DeltaLogImpl $this, long version) {
        $this.history().checkVersionExists(version);
        return SnapshotManagement$class.getSnapshotAt($this, version);
    }

    public static SnapshotImpl getSnapshotForTimestampAsOf(DeltaLogImpl $this, long timestamp) {
        DeltaHistoryManager.Commit latestCommit = $this.history().getActiveCommitAtTime(new Timestamp(timestamp), $this.history().getActiveCommitAtTime$default$2(), $this.history().getActiveCommitAtTime$default$3(), $this.history().getActiveCommitAtTime$default$4());
        return SnapshotManagement$class.getSnapshotAt($this, latestCommit.version());
    }

    public static SnapshotImpl io$delta$standalone$internal$SnapshotManagement$$updateInternal(DeltaLogImpl $this) {
        try {
            LogSegment segment;
            LogSegment logSegment = segment = $this.getLogSegmentForVersion($this.currentSnapshot().logSegment().checkpointVersion(), $this.getLogSegmentForVersion$default$2());
            LogSegment logSegment2 = $this.currentSnapshot().logSegment();
            if (logSegment == null ? logSegment2 != null : !((Object)logSegment).equals(logSegment2)) {
                String startingFrom = (String)segment.checkpointVersion().map((Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(long v) {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" starting from checkpoint version ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)v)}));
                    }
                }).getOrElse((Function0)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return ".";
                    }
                });
                $this.logInfo((Function0<String>)new Serializable($this, segment, startingFrom){
                    public static final long serialVersionUID = 0L;
                    private final LogSegment segment$1;
                    private final String startingFrom$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loading version ", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.segment$1.version()), this.startingFrom$1}));
                    }
                    {
                        this.segment$1 = segment$1;
                        this.startingFrom$1 = startingFrom$1;
                    }
                });
                SnapshotImpl newSnapshot = SnapshotManagement$class.createSnapshot($this, segment, segment.lastCommitTimestamp());
                if ($this.currentSnapshot().version() > -1L) {
                    String string = $this.currentSnapshot().metadataScala().id();
                    String string2 = newSnapshot.metadataScala().id();
                    if (string == null ? string2 != null : !string.equals(string2)) {
                        $this.logError((Function0<String>)new Serializable($this, newSnapshot){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ DeltaLogImpl $outer;
                            private final SnapshotImpl newSnapshot$1;

                            public final String apply() {
                                return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Change in the table id detected while updating snapshot. "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\nPrevious snapshot = ", "\\nNew snapshot = ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.currentSnapshot(), this.newSnapshot$1}))).toString();
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.newSnapshot$1 = newSnapshot$1;
                            }
                        });
                    }
                }
                $this.logInfo((Function0<String>)new Serializable($this, newSnapshot){
                    public static final long serialVersionUID = 0L;
                    private final SnapshotImpl newSnapshot$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Updated snapshot to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.newSnapshot$1}));
                    }
                    {
                        this.newSnapshot$1 = newSnapshot$1;
                    }
                });
                $this.currentSnapshot_$eq(newSnapshot);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (Option$.MODULE$.apply((Object)fileNotFoundException.getMessage()).exists((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String x$1) {
                    return x$1.contains("reconstruct state at version");
                }
            })) {
                throw fileNotFoundException;
            }
            $this.logInfo((Function0<String>)new Serializable($this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ DeltaLogImpl $outer;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No delta log found for the Delta table at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.logPath()}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            $this.currentSnapshot_$eq(new InitialSnapshotImpl($this.hadoopConf(), $this.logPath(), $this));
        }
        return $this.currentSnapshot();
    }

    public static LogSegment getLogSegmentForVersion(DeltaLogImpl $this, Option startCheckpoint, Option versionToLoad) {
        FileStatus[] newFiles = (FileStatus[])((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter($this.store().listFrom(FileNames$.MODULE$.checkpointPrefix($this.logPath(), BoxesRunTime.unboxToLong((Object)startCheckpoint.getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final long apply() {
                return this.apply$mcJ$sp();
            }

            public long apply$mcJ$sp() {
                return 0L;
            }
        }))), $this.hadoopConf())).asScala()).filter((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(FileStatus file) {
                return FileNames$.MODULE$.isCheckpointFile(file.getPath()) || FileNames$.MODULE$.isDeltaFile(file.getPath());
            }
        }).filterNot((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(FileStatus file) {
                return FileNames$.MODULE$.isCheckpointFile(file.getPath()) && file.getLen() == 0L;
            }
        }).takeWhile((Function1)new Serializable($this, versionToLoad){
            public static final long serialVersionUID = 0L;
            private final Option versionToLoad$1;

            public final boolean apply(FileStatus f) {
                return this.versionToLoad$1.forall((Function1)new Serializable(this, f){
                    public static final long serialVersionUID = 0L;
                    private final FileStatus f$1;

                    public final boolean apply(long v) {
                        return this.apply$mcZJ$sp(v);
                    }

                    public boolean apply$mcZJ$sp(long v) {
                        return FileNames$.MODULE$.getFileVersion(this.f$1.getPath()) <= v;
                    }
                    {
                        this.f$1 = f$1;
                    }
                });
            }
            {
                this.versionToLoad$1 = versionToLoad$1;
            }
        }).toArray(ClassTag$.MODULE$.apply(FileStatus.class));
        if (Predef$.MODULE$.refArrayOps((Object[])newFiles).isEmpty() && startCheckpoint.isEmpty()) {
            throw DeltaErrors$.MODULE$.emptyDirectoryException($this.logPath().toString());
        }
        if (Predef$.MODULE$.refArrayOps((Object[])newFiles).isEmpty()) {
            return $this.getLogSegmentForVersion((Option<Object>)None$.MODULE$, (Option<Object>)versionToLoad);
        }
        Tuple2 tuple2 = Predef$.MODULE$.refArrayOps((Object[])newFiles).partition((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(FileStatus f) {
                return FileNames$.MODULE$.isCheckpointFile(f.getPath());
            }
        });
        if (tuple2 != null) {
            LogSegment logSegment;
            Tuple2 tuple22;
            FileStatus[] checkpoints = (FileStatus[])tuple2._1();
            FileStatus[] deltas = (FileStatus[])tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)checkpoints, (Object)deltas);
            FileStatus[] checkpoints2 = (FileStatus[])tuple23._1();
            FileStatus[] deltas2 = (FileStatus[])tuple23._2();
            CheckpointInstance lastCheckpoint = (CheckpointInstance)versionToLoad.map((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final CheckpointInstance apply(long x$3) {
                    return new CheckpointInstance(x$3, (Option<Object>)None$.MODULE$);
                }
            }).getOrElse((Function0)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final CheckpointInstance apply() {
                    return CheckpointInstance$.MODULE$.MaxValue();
                }
            });
            CheckpointInstance[] checkpointFiles = (CheckpointInstance[])Predef$.MODULE$.refArrayOps((Object[])checkpoints2).map((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final CheckpointInstance apply(FileStatus f) {
                    return CheckpointInstance$.MODULE$.apply(f.getPath());
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(CheckpointInstance.class)));
            Option<CheckpointInstance> newCheckpoint = $this.getLatestCompleteCheckpointFromList(checkpointFiles, lastCheckpoint);
            if (newCheckpoint.isDefined()) {
                long newCheckpointVersion = ((CheckpointInstance)newCheckpoint.get()).version();
                Set newCheckpointPaths = ((CheckpointInstance)newCheckpoint.get()).getCorrespondingFiles($this.logPath()).toSet();
                FileStatus[] deltasAfterCheckpoint = (FileStatus[])Predef$.MODULE$.refArrayOps((Object[])deltas2).filter((Function1)new Serializable($this, newCheckpointVersion){
                    public static final long serialVersionUID = 0L;
                    private final long newCheckpointVersion$1;

                    public final boolean apply(FileStatus file) {
                        return FileNames$.MODULE$.deltaVersion(file.getPath()) > this.newCheckpointVersion$1;
                    }
                    {
                        this.newCheckpointVersion$1 = newCheckpointVersion$1;
                    }
                });
                long[] deltaVersions = (long[])Predef$.MODULE$.refArrayOps((Object[])deltasAfterCheckpoint).map((Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(FileStatus f) {
                        return FileNames$.MODULE$.deltaVersion(f.getPath());
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()));
                if (Predef$.MODULE$.longArrayOps(deltaVersions).nonEmpty()) {
                    SnapshotManagement$class.verifyDeltaVersions($this, deltaVersions);
                    Predef$.MODULE$.require(BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longArrayOps(deltaVersions).head()) == newCheckpointVersion + 1L, (Function0)new Serializable($this, newCheckpointVersion){
                        public static final long serialVersionUID = 0L;
                        private final long newCheckpointVersion$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Did not get the first delta ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"file version: ", " to compute Snapshot"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(this.newCheckpointVersion$1 + 1L))}))).toString();
                        }
                        {
                            this.newCheckpointVersion$1 = newCheckpointVersion$1;
                        }
                    });
                    versionToLoad.foreach((Function1)new Serializable($this, deltaVersions){
                        public static final long serialVersionUID = 0L;
                        private final long[] deltaVersions$1;

                        public final void apply(long version) {
                            this.apply$mcVJ$sp(version);
                        }

                        public void apply$mcVJ$sp(long version) {
                            Predef$.MODULE$.require(BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longArrayOps(this.deltaVersions$1).last()) == version, (Function0)new Serializable(this, version){
                                public static final long serialVersionUID = 0L;
                                private final long version$1;

                                public final String apply() {
                                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Did not get the last delta file version: ", " to compute Snapshot"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.version$1)}));
                                }
                                {
                                    this.version$1 = version$1;
                                }
                            });
                        }
                        {
                            this.deltaVersions$1 = deltaVersions$1;
                        }
                    });
                }
                long newVersion = BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longArrayOps(deltaVersions).lastOption().getOrElse((Function0)new Serializable($this, newCheckpoint){
                    public static final long serialVersionUID = 0L;
                    private final Option newCheckpoint$1;

                    public final long apply() {
                        return this.apply$mcJ$sp();
                    }

                    public long apply$mcJ$sp() {
                        return ((CheckpointInstance)this.newCheckpoint$1.get()).version();
                    }
                    {
                        this.newCheckpoint$1 = newCheckpoint$1;
                    }
                }));
                FileStatus[] newCheckpointFiles = (FileStatus[])Predef$.MODULE$.refArrayOps((Object[])checkpoints2).filter((Function1)new Serializable($this, newCheckpointPaths){
                    public static final long serialVersionUID = 0L;
                    private final Set newCheckpointPaths$1;

                    public final boolean apply(FileStatus f) {
                        return this.newCheckpointPaths$1.contains((Object)f.getPath());
                    }
                    {
                        this.newCheckpointPaths$1 = newCheckpointPaths$1;
                    }
                });
                Predef$.MODULE$.assert(newCheckpointFiles.length == newCheckpointPaths.size(), (Function0)new Serializable($this, checkpoints2, newCheckpointPaths){
                    public static final long serialVersionUID = 0L;
                    private final FileStatus[] checkpoints$1;
                    private final Set newCheckpointPaths$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Failed in getting the file information for:\n").append((Object)this.newCheckpointPaths$1.mkString(" -", "\n -", "")).append((Object)"\n").append((Object)"among\n").append((Object)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.checkpoints$1).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Path apply(FileStatus x$4) {
                                return x$4.getPath();
                            }
                        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class)))).mkString(" -", "\n -", "")).toString();
                    }
                    {
                        this.checkpoints$1 = checkpoints$1;
                        this.newCheckpointPaths$1 = newCheckpointPaths$1;
                    }
                });
                long lastCommitTimestamp = ((FileStatus)Predef$.MODULE$.refArrayOps((Object[])deltas2).last()).getModificationTime();
                logSegment = new LogSegment($this.logPath(), newVersion, (Seq<FileStatus>)Predef$.MODULE$.wrapRefArray((Object[])deltasAfterCheckpoint), (Seq<FileStatus>)Predef$.MODULE$.wrapRefArray((Object[])newCheckpointFiles), (Option<Object>)newCheckpoint.map((Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(CheckpointInstance x$5) {
                        return x$5.version();
                    }
                }), lastCommitTimestamp);
            } else {
                if (startCheckpoint.isDefined()) {
                    throw DeltaErrors$.MODULE$.missingPartFilesException(BoxesRunTime.unboxToLong((Object)startCheckpoint.get()), new FileNotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Checkpoint file to load version: ", " is missing."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{startCheckpoint.get()}))));
                }
                long[] deltaVersions = (long[])Predef$.MODULE$.refArrayOps((Object[])deltas2).map((Function1)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(FileStatus f) {
                        return FileNames$.MODULE$.deltaVersion(f.getPath());
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()));
                SnapshotManagement$class.verifyDeltaVersions($this, deltaVersions);
                if (BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longArrayOps(deltaVersions).head()) != 0L) {
                    throw DeltaErrors$.MODULE$.logFileNotFoundException(FileNames$.MODULE$.deltaFile($this.logPath(), 0L), BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longArrayOps(deltaVersions).last()));
                }
                versionToLoad.foreach((Function1)new Serializable($this, deltaVersions){
                    public static final long serialVersionUID = 0L;
                    private final long[] deltaVersions$2;

                    public final void apply(long version) {
                        this.apply$mcVJ$sp(version);
                    }

                    public void apply$mcVJ$sp(long version) {
                        Predef$.MODULE$.require(BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longArrayOps(this.deltaVersions$2).last()) == version, (Function0)new Serializable(this, version){
                            public static final long serialVersionUID = 0L;
                            private final long version$2;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Did not get the last delta file version: ", " to compute Snapshot"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.version$2)}));
                            }
                            {
                                this.version$2 = version$2;
                            }
                        });
                    }
                    {
                        this.deltaVersions$2 = deltaVersions$2;
                    }
                });
                FileStatus latestCommit = (FileStatus)Predef$.MODULE$.refArrayOps((Object[])deltas2).last();
                logSegment = new LogSegment($this.logPath(), FileNames$.MODULE$.deltaVersion(latestCommit.getPath()), (Seq<FileStatus>)Predef$.MODULE$.wrapRefArray((Object[])deltas2), (Seq<FileStatus>)Nil$.MODULE$, (Option<Object>)None$.MODULE$, latestCommit.getModificationTime());
            }
            return logSegment;
        }
        throw new MatchError((Object)tuple2);
    }

    public static Option getLogSegmentForVersion$default$2(DeltaLogImpl $this) {
        return None$.MODULE$;
    }

    /*
     * WARNING - void declaration
     */
    private static SnapshotImpl getSnapshotAtInit(DeltaLogImpl $this) {
        InitialSnapshotImpl initialSnapshotImpl;
        try {
            void var3_3;
            LogSegment logSegment = $this.getLogSegmentForVersion((Option<Object>)$this.lastCheckpoint().map((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final long apply(CheckpointMetaData x$6) {
                    return x$6.version();
                }
            }), $this.getLogSegmentForVersion$default$2());
            String startCheckpoint = (String)logSegment.checkpointVersion().map((Function1)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final String apply(long v) {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" starting from checkpoint ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)v)}));
                }
            }).getOrElse((Function0)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return ".";
                }
            });
            $this.logInfo((Function0<String>)new Serializable($this, logSegment, startCheckpoint){
                public static final long serialVersionUID = 0L;
                private final LogSegment logSegment$1;
                private final String startCheckpoint$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Loading version ", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.logSegment$1.version()), this.startCheckpoint$1}));
                }
                {
                    this.logSegment$1 = logSegment$1;
                    this.startCheckpoint$1 = startCheckpoint$1;
                }
            });
            SnapshotImpl snapshot = SnapshotManagement$class.createSnapshot($this, logSegment, logSegment.lastCommitTimestamp());
            $this.logInfo((Function0<String>)new Serializable($this, snapshot){
                public static final long serialVersionUID = 0L;
                private final SnapshotImpl snapshot$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Returning initial snapshot ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.snapshot$1}));
                }
                {
                    this.snapshot$1 = snapshot$1;
                }
            });
            initialSnapshotImpl = var3_3;
        }
        catch (FileNotFoundException fileNotFoundException) {
            $this.logInfo((Function0<String>)new Serializable($this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating initial snapshot without metadata, because the directory is empty"})).s((Seq)Nil$.MODULE$);
                }
            });
            initialSnapshotImpl = new InitialSnapshotImpl($this.hadoopConf(), $this.logPath(), $this);
        }
        return initialSnapshotImpl;
    }

    private static SnapshotImpl getSnapshotAt(DeltaLogImpl $this, long version) {
        if ($this.snapshot().version() == version) {
            return $this.snapshot();
        }
        Option<CheckpointInstance> startingCheckpoint = $this.findLastCompleteCheckpoint(new CheckpointInstance(version, (Option<Object>)None$.MODULE$));
        LogSegment segment = $this.getLogSegmentForVersion((Option<Object>)startingCheckpoint.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final long apply(CheckpointInstance x$7) {
                return x$7.version();
            }
        }), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)version)));
        return SnapshotManagement$class.createSnapshot($this, segment, segment.lastCommitTimestamp());
    }

    private static SnapshotImpl createSnapshot(DeltaLogImpl $this, LogSegment segment, long lastCommitTimestamp) {
        return new SnapshotImpl($this.hadoopConf(), $this.logPath(), segment.version(), segment, $this.minFileRetentionTimestamp(), $this, lastCommitTimestamp);
    }

    private static void verifyDeltaVersions(DeltaLogImpl $this, long[] versions) {
        Vector deltaVersions = Predef$.MODULE$.longArrayOps(versions).toVector();
        if (deltaVersions.nonEmpty()) {
            NumericRange.Inclusive inclusive = new RichLong(Predef$.MODULE$.longWrapper(BoxesRunTime.unboxToLong((Object)deltaVersions.head()))).to(deltaVersions.last());
            Vector vector = deltaVersions;
            if (inclusive == null ? vector != null : !inclusive.equals(vector)) {
                throw DeltaErrors$.MODULE$.deltaVersionsNotContiguousException((Seq<Object>)deltaVersions);
            }
        }
    }

    public static void $init$(DeltaLogImpl $this) {
        $this.currentSnapshot_$eq(SnapshotManagement$class.getSnapshotAtInit($this));
    }
}

