/*
 * Decompiled with CFR 0.152.
 */
package io.delta.standalone.internal.exception;

import io.delta.standalone.exceptions.ConcurrentAppendException;
import io.delta.standalone.exceptions.ConcurrentDeleteDeleteException;
import io.delta.standalone.exceptions.ConcurrentDeleteReadException;
import io.delta.standalone.exceptions.ConcurrentTransactionException;
import io.delta.standalone.exceptions.DeltaStandaloneException;
import io.delta.standalone.exceptions.MetadataChangedException;
import io.delta.standalone.exceptions.ProtocolChangedException;
import io.delta.standalone.internal.actions.CommitInfo;
import io.delta.standalone.internal.util.JsonUtils$;
import io.delta.standalone.types.DataType;
import io.delta.standalone.types.StructType;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Timestamp;
import org.apache.hadoop.fs.Path;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxesRunTime;

public final class DeltaErrors$ {
    public static final DeltaErrors$ MODULE$;
    private final String EmptyCheckpointErrorMessage;

    static {
        new DeltaErrors$();
    }

    public RuntimeException illegalExpressionValueType(String exprName, String expectedType, String ... realTypes) {
        return this.illegalExpressionValueType(exprName, expectedType, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])realTypes));
    }

    public String EmptyCheckpointErrorMessage() {
        return this.EmptyCheckpointErrorMessage;
    }

    public Throwable deltaVersionsNotContiguousException(Seq<Object> deltaVersions) {
        return new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Versions (", ") are not contiguous."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{deltaVersions})));
    }

    public Throwable actionNotFoundException(String action, long version) {
        return new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |The ", " of your Delta table couldn't be recovered while Reconstructing\n         |version: ", ". Did you manually delete files in the _delta_log directory?\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{action, ((Object)BoxesRunTime.boxToLong((long)version)).toString()})))).stripMargin());
    }

    public Throwable emptyDirectoryException(String directory) {
        return new FileNotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No file found in the directory: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{directory})));
    }

    public Throwable logFileNotFoundException(Path path2, long version) {
        return new FileNotFoundException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": Unable to reconstruct state at version ", " as the "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path2, BoxesRunTime.boxToLong((long)version)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"transaction log has been truncated due to manual deletion or the log retention policy "})).s((Seq)Nil$.MODULE$)).toString());
    }

    public Throwable missingPartFilesException(long version, Exception e) {
        return new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Couldn't find all part files of the checkpoint version: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)version)})), e);
    }

    public DeltaStandaloneException noReproducibleHistoryFound(Path logPath) {
        return new DeltaStandaloneException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No reproducible commits found at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{logPath})));
    }

    public Throwable timestampEarlierThanTableFirstCommit(Timestamp userTimestamp, Timestamp commitTs) {
        return new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The provided timestamp (", ") is before the earliest version available to this\n         |table (", "). Please use a timestamp greater than or equal to ", ".\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{userTimestamp, commitTs, commitTs})))).stripMargin());
    }

    public Throwable timestampLaterThanTableLastCommit(Timestamp userTimestamp, Timestamp commitTs) {
        return new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The provided timestamp (", ") is after the latest version available to this\n         |table (", "). Please use a timestamp less than or equal to ", ".\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{userTimestamp, commitTs, commitTs})))).stripMargin());
    }

    public DeltaStandaloneException noHistoryFound(Path logPath) {
        return new DeltaStandaloneException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No commits found at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{logPath})));
    }

    public Throwable versionNotExistException(long userVersion, long earliest, long latest) {
        return new DeltaStandaloneException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot time travel Delta table to version ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)userVersion)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Available versions: [", ", ", "]."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)earliest), BoxesRunTime.boxToLong((long)latest)}))).toString());
    }

    public Throwable nullValueFoundForPrimitiveTypes(String fieldName2) {
        return new NullPointerException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Read a null value for field ", " which is a primitive type."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fieldName2})));
    }

    public Throwable nullValueFoundForNonNullSchemaField(String fieldName2, StructType schema2) {
        return new NullPointerException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Read a null value for field ", ", yet schema indicates "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fieldName2}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"that this field can't be null. Schema: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{schema2.getTreeString()}))).toString());
    }

    public Throwable fieldTypeMismatch(String fieldName2, DataType actualType, String desiredType) {
        return new ClassCastException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The data type of field ", " is ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{fieldName2, actualType.getTypeName()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot cast it to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{desiredType}))).toString());
    }

    public Throwable failOnDataLossException(long expectedVersion, long seenVersion) {
        return new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The stream from your Delta table was expecting process data from version ", ",\n         |but the earliest available version in the _delta_log directory is ", ". The files\n         |in the transaction log may have been deleted due to log cleanup.\n         |\n         |If you would like to ignore the missed data and continue your stream from where it left\n         |off, you can set the .option(\"failOnDataLoss\", \"false\") as part\n         |of your readStream statement.\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)expectedVersion), BoxesRunTime.boxToLong((long)seenVersion)})))).stripMargin());
    }

    public Throwable metadataAbsentException() {
        return new IllegalStateException("Couldn't find Metadata while committing the first version of the Delta table.");
    }

    public Throwable addFilePartitioningMismatchException(Seq<String> addFilePartitions, Seq<String> metadataPartitions) {
        return new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n         |The AddFile contains partitioning schema different from the table's partitioning schema\n         |expected: ", "\n         |actual: ", "\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.formatColumnList(metadataPartitions), this.formatColumnList(addFilePartitions)})))).stripMargin());
    }

    public Throwable modifyAppendOnlyTableException() {
        return new UnsupportedOperationException(new StringBuilder().append((Object)"This table is configured to only allow appends. If you would like to permit ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"updates or deletes, use 'ALTER TABLE <table_name> SET TBLPROPERTIES "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(appendOnly=false)'."})).s((Seq)Nil$.MODULE$)).toString());
    }

    public DeltaStandaloneException invalidColumnName(String name) {
        return new DeltaStandaloneException(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Attribute name \"", "\" contains invalid character(s) among \" ,;{}()\\\\n\\\\t=\".\n         |Please use alias to rename it.\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})))).stripMargin().split("\n")).mkString(" ").trim());
    }

    public DeltaStandaloneException invalidPartitionColumn(RuntimeException e) {
        return new DeltaStandaloneException("Found partition columns having invalid character(s) among \" ,;{}()\\n\\t=\". Please change the name to your partition columns. This check can be turned off by setting spark.conf.set(\"spark.databricks.delta.partitionColumnValidity.enabled\", false) however this is not recommended as other features of Delta may not work properly.", e);
    }

    public Throwable incorrectLogStoreImplementationException(Throwable cause) {
        return new IOException(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n     |The error typically occurs when the default LogStore implementation, that\n     |is, HDFSLogStore, is used to write into a Delta table on a non-HDFS storage system.\n     |In order to get the transactional ACID guarantees on table updates, you have to use the\n     |correct implementation of LogStore that is appropriate for your storage system.\n     |See https://docs.delta.io/latest/delta-storage.html for details.\n      "})).s((Seq)Nil$.MODULE$))).stripMargin(), cause);
    }

    public String concurrentModificationExceptionMsg(String baseMessage, Option<CommitInfo> commit2) {
        return new StringBuilder().append((Object)baseMessage).append(commit2.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(CommitInfo ci) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\nConflicting commit: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JsonUtils$.MODULE$.toJson(ci, ManifestFactory$.MODULE$.classType(CommitInfo.class))}));
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        })).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\\nRefer to https://docs.delta.io/latest/concurrency-control.html for more details."})).s((Seq)Nil$.MODULE$)).toString();
    }

    public MetadataChangedException metadataChangedException(Option<CommitInfo> conflictingCommit) {
        String message = this.concurrentModificationExceptionMsg("The metadata of the Delta table has been changed by a concurrent update. Please try the operation again.", conflictingCommit);
        return new MetadataChangedException(message);
    }

    public ProtocolChangedException protocolChangedException(Option<CommitInfo> conflictingCommit) {
        String additionalInfo = (String)conflictingCommit.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(CommitInfo v) {
                return BoxesRunTime.equals((Object)v.version().getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply() {
                        return this.apply$mcI$sp();
                    }

                    public int apply$mcI$sp() {
                        return -1;
                    }
                }), (Object)BoxesRunTime.boxToInteger((int)0)) ? "This happens when multiple writers are writing to an empty directory. Creating the table ahead of time will avoid this conflict. " : "";
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        });
        String message = this.concurrentModificationExceptionMsg(new StringBuilder().append((Object)"The protocol version of the Delta table has been changed by a concurrent update. ").append((Object)additionalInfo).append((Object)"Please try the operation again.").toString(), conflictingCommit);
        return new ProtocolChangedException(message);
    }

    public ConcurrentAppendException concurrentAppendException(Option<CommitInfo> conflictingCommit, String partition) {
        String message = this.concurrentModificationExceptionMsg(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Files were added to ", " by a concurrent update. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partition}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Please try the operation again."})).s((Seq)Nil$.MODULE$)).toString(), conflictingCommit);
        return new ConcurrentAppendException(message);
    }

    public ConcurrentDeleteReadException concurrentDeleteReadException(Option<CommitInfo> conflictingCommit, String file) {
        String message = this.concurrentModificationExceptionMsg(new StringBuilder().append((Object)"This transaction attempted to read one or more files that were deleted").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" (for example ", ") by a concurrent update. Please try the operation again."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file}))).toString(), conflictingCommit);
        return new ConcurrentDeleteReadException(message);
    }

    public ConcurrentDeleteDeleteException concurrentDeleteDeleteException(Option<CommitInfo> conflictingCommit, String file) {
        String message = this.concurrentModificationExceptionMsg(new StringBuilder().append((Object)"This transaction attempted to delete one or more files that were deleted ").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(for example ", ") by a concurrent update. Please try the operation again."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file}))).toString(), conflictingCommit);
        return new ConcurrentDeleteDeleteException(message);
    }

    public ConcurrentTransactionException concurrentTransactionException(Option<CommitInfo> conflictingCommit) {
        String message = this.concurrentModificationExceptionMsg(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"This error occurs when multiple streaming queries are using the same checkpoint to write "})).s((Seq)Nil$.MODULE$)).append((Object)"into this table. Did you run multiple instances of the same streaming query").append((Object)" at the same time?").toString(), conflictingCommit);
        return new ConcurrentTransactionException(message);
    }

    public Throwable maxCommitRetriesExceededException(int attemptNumber, long attemptVersion, long initAttemptVersion, int numActions, long totalCommitAttemptTime) {
        return new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"This commit has failed as it has been tried ", " times but did not succeed.\n         |This can be caused by the Delta table being committed continuously by many concurrent\n         |commits.\n         |\n         |Commit started at version: ", "\n         |Commit failed at version: ", "\n         |Number of actions attempted to commit: ", "\n         |Total time spent attempting this commit: ", " ms\n       "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)attemptNumber), BoxesRunTime.boxToLong((long)initAttemptVersion), BoxesRunTime.boxToLong((long)attemptVersion), BoxesRunTime.boxToInteger((int)numActions), BoxesRunTime.boxToLong((long)totalCommitAttemptTime)})))).stripMargin());
    }

    public DeltaStandaloneException nestedNotNullConstraint(String parent, DataType nested, String nestType) {
        return new DeltaStandaloneException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The ", " type of the field ", " contains a NOT NULL "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{nestType, parent}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"constraint. Delta does not support NOT NULL constraints nested within arrays or maps. "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Parsed ", " type:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{nestType, nested.toPrettyJson()}))).toString());
    }

    public Throwable checkpointNonExistTable(Path path2) {
        return new IllegalStateException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot checkpoint a non-exist table ", ". Did you manually "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path2}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"delete files in the _delta_log directory?"})).s((Seq)Nil$.MODULE$)).toString());
    }

    public Throwable cannotModifyTableProperty(String prop) {
        throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The Delta table configuration ", " cannot be specified by the user"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{prop})));
    }

    public Throwable unknownConfigurationKeyException(String confKey) {
        return new DeltaStandaloneException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown configuration was specified: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{confKey})));
    }

    public Throwable schemaChangedException(StructType oldSchema, StructType newSchema) {
        String msg = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Detected incompatible schema change:\n        |old schema: ", "\n        |\n        |new schema: ", "\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{oldSchema.getTreeString(), newSchema.getTreeString()})))).stripMargin();
        return new IllegalStateException(msg);
    }

    public RuntimeException illegalExpressionValueType(String exprName, String expectedType, Seq<String> realTypes) {
        return new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " expression requires ", " type. But found ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{exprName, expectedType, realTypes.mkString(", ")})));
    }

    public Throwable logStoreConfConflicts(Seq<String> classConf, Seq<String> schemeConf) {
        String schemeConfStr = schemeConf.mkString(", ");
        String classConfStr = classConf.mkString(", ");
        return new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(`", "`) and (`", "`)"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{classConfStr, schemeConfStr}))).append((Object)" cannot be set at the same time. Please set only one group of them.").toString());
    }

    public Throwable inconsistentLogStoreConfs(Seq<Tuple2<String, String>> setKeys) {
        String setKeyStr = ((TraversableOnce)setKeys.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, String> x$1) {
                return x$1.productIterator().mkString(" = ");
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(", ");
        return new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"(", ") cannot be set to different values. Please only set one of them, or set them "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{setKeyStr}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"to the same value."})).s((Seq)Nil$.MODULE$)).toString());
    }

    public Throwable partitionColumnsNotFoundException(Seq<String> partCols, StructType schema2) {
        return new DeltaStandaloneException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Partition column(s) ", " not found in "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{partCols.mkString(",")}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"schema:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{schema2.getTreeString()}))).toString());
    }

    public Throwable nonPartitionColumnAbsentException() {
        return new DeltaStandaloneException("Data written into Delta needs to contain at least one non-partitioned column");
    }

    public String io$delta$standalone$internal$exception$DeltaErrors$$formatColumn(String colName) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"`", "`"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{colName}));
    }

    private String formatColumnList(Seq<String> colNames) {
        return ((TraversableOnce)colNames.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String colName) {
                return DeltaErrors$.MODULE$.io$delta$standalone$internal$exception$DeltaErrors$$formatColumn(colName);
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString("[", ", ", "]");
    }

    private DeltaErrors$() {
        MODULE$ = this;
        this.EmptyCheckpointErrorMessage = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n       |Attempted to write an empty checkpoint without any actions. This checkpoint will not be\n       |useful in recomputing the state of the table. However this might cause other checkpoints to\n       |get deleted based on retention settings.\n     "})).s((Seq)Nil$.MODULE$))).stripMargin();
    }
}

