/*
 * Decompiled with CFR 0.152.
 */
package io.delta.standalone.internal.storage;

import io.delta.standalone.internal.exception.DeltaErrors$;
import io.delta.standalone.internal.logging.Logging;
import io.delta.standalone.internal.logging.Logging$class;
import io.delta.standalone.internal.storage.HadoopFileSystemLogStore;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.EnumSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.TraitSetter;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005Ma!B\u0001\u0003\u0001\u0011a!\u0001\u0004%E\rNcunZ*u_J,'BA\u0002\u0005\u0003\u001d\u0019Ho\u001c:bO\u0016T!!\u0002\u0004\u0002\u0011%tG/\u001a:oC2T!a\u0002\u0005\u0002\u0015M$\u0018M\u001c3bY>tWM\u0003\u0002\n\u0015\u0005)A-\u001a7uC*\t1\"\u0001\u0002j_N\u0019\u0001!D\t\u0011\u00059yQ\"\u0001\u0002\n\u0005A\u0011!\u0001\u0007%bI>|\u0007OR5mKNK8\u000f^3n\u0019><7\u000b^8sKB\u0011!#F\u0007\u0002')\u0011A\u0003B\u0001\bY><w-\u001b8h\u0013\t12CA\u0004M_\u001e<\u0017N\\4\t\u0011a\u0001!Q1A\u0005Bi\ta\"\u001b8ji\"\u000bGm\\8q\u0007>tgm\u0001\u0001\u0016\u0003m\u0001\"\u0001H\u0013\u000e\u0003uQ!AH\u0010\u0002\t\r|gN\u001a\u0006\u0003A\u0005\na\u0001[1e_>\u0004(B\u0001\u0012$\u0003\u0019\t\u0007/Y2iK*\tA%A\u0002pe\u001eL!AJ\u000f\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0011%A\u0003A!A!\u0002\u0013Y\u0012&A\bj]&$\b*\u00193p_B\u001cuN\u001c4!\u0013\tAr\u0002C\u0003,\u0001\u0011\u0005A&\u0001\u0004=S:LGO\u0010\u000b\u0003[9\u0002\"A\u0004\u0001\t\u000baQ\u0003\u0019A\u000e\t\u000fA\u0002!\u0019!C\u0001c\u0005!cn\\!cgR\u0014\u0018m\u0019;GS2,7+_:uK6,\u0005pY3qi&|g.T3tg\u0006<W-F\u00013!\t\u0019\u0004(D\u00015\u0015\t)d'\u0001\u0003mC:<'\"A\u001c\u0002\t)\fg/Y\u0005\u0003sQ\u0012aa\u0015;sS:<\u0007BB\u001e\u0001A\u0003%!'A\u0013o_\u0006\u00137\u000f\u001e:bGR4\u0015\u000e\\3TsN$X-\\#yG\u0016\u0004H/[8o\u001b\u0016\u001c8/Y4fA!)Q\b\u0001C!}\u0005)qO]5uKR)q(R'\\AB\u0011\u0001iQ\u0007\u0002\u0003*\t!)A\u0003tG\u0006d\u0017-\u0003\u0002E\u0003\n!QK\\5u\u0011\u00151E\b1\u0001H\u0003\u0011\u0001\u0018\r\u001e5\u0011\u0005![U\"A%\u000b\u0005){\u0012A\u00014t\u0013\ta\u0015J\u0001\u0003QCRD\u0007\"\u0002(=\u0001\u0004y\u0015aB1di&|gn\u001d\t\u0004!N+V\"A)\u000b\u0005I3\u0014\u0001B;uS2L!\u0001V)\u0003\u0011%#XM]1u_J\u0004\"AV-\u000f\u0005\u0001;\u0016B\u0001-B\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011H\u0017\u0006\u00031\u0006CQ\u0001\u0018\u001fA\u0002u\u000b\u0011b\u001c<fe^\u0014\u0018\u000e^3\u0011\u0005Mr\u0016BA05\u0005\u001d\u0011un\u001c7fC:DQ!\u0019\u001fA\u0002m\t!\u0002[1e_>\u00048i\u001c8g\u0011\u0015\u0019\u0007\u0001\"\u0011e\u0003UI7\u000fU1si&\fGn\u0016:ji\u00164\u0016n]5cY\u0016$2!X3g\u0011\u00151%\r1\u0001H\u0011\u0015\t'\r1\u0001\u001c\u0011\u0015A\u0007\u0001\"\u0003j\u000359(/\u001b;f\u0013:$XM\u001d8bYR)qH[6xu\")ai\u001aa\u0001\u000f\")aj\u001aa\u0001YB\u0019Q.^+\u000f\u00059\u001chBA8s\u001b\u0005\u0001(BA9\u001a\u0003\u0019a$o\\8u}%\t!)\u0003\u0002u\u0003\u00069\u0001/Y2lC\u001e,\u0017B\u0001+w\u0015\t!\u0018\tC\u0003]O\u0002\u0007\u0001\u0010\u0005\u0002As&\u0011q,\u0011\u0005\u0006C\u001e\u0004\ra\u0007\u0005\u0006y\u0002!I!`\u0001\u000fO\u0016$h)\u001b7f\u0007>tG/\u001a=u)\u0015q\u00181AA\u0003!\tAu0C\u0002\u0002\u0002%\u00131BR5mK\u000e{g\u000e^3yi\")ai\u001fa\u0001\u000f\")\u0011m\u001fa\u00017!9\u0011\u0011\u0002\u0001\u0005\n\u0005-\u0011\u0001\u0005;ssJ+Wn\u001c<f\u0007J\u001cg)\u001b7f)\u0015y\u0014QBA\t\u0011\u001d\ty!a\u0002A\u0002y\f!AZ2\t\r\u0019\u000b9\u00011\u0001H\u0001")
public class HDFSLogStore
extends HadoopFileSystemLogStore
implements Logging {
    private final String noAbstractFileSystemExceptionMessage;
    private transient Logger io$delta$standalone$internal$logging$Logging$$log_;

    @Override
    public Logger io$delta$standalone$internal$logging$Logging$$log_() {
        return this.io$delta$standalone$internal$logging$Logging$$log_;
    }

    @Override
    @TraitSetter
    public void io$delta$standalone$internal$logging$Logging$$log__$eq(Logger x$1) {
        this.io$delta$standalone$internal$logging$Logging$$log_ = x$1;
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    @Override
    public Configuration initHadoopConf() {
        return super.initHadoopConf();
    }

    public String noAbstractFileSystemExceptionMessage() {
        return this.noAbstractFileSystemExceptionMessage;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void write(Path path2, java.util.Iterator<String> actions, Boolean overwrite, Configuration hadoopConf) {
        boolean isLocalFs = path2.getFileSystem(hadoopConf) instanceof RawLocalFileSystem;
        if (!isLocalFs) {
            this.writeInternal(path2, (Iterator<String>)((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(actions).asScala()), Predef$.MODULE$.Boolean2boolean(overwrite), hadoopConf);
            return;
        }
        HDFSLogStore hDFSLogStore = this;
        synchronized (hDFSLogStore) {
            this.writeInternal(path2, (Iterator<String>)((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(actions).asScala()), Predef$.MODULE$.Boolean2boolean(overwrite), hadoopConf);
            return;
        }
    }

    public Boolean isPartialWriteVisible(Path path2, Configuration hadoopConf) {
        return Predef$.MODULE$.boolean2Boolean(true);
    }

    private void writeInternal(Path path2, Iterator<String> actions, boolean overwrite, Configuration hadoopConf) {
        FileContext fc;
        try {
            fc = this.getFileContext(path2, hadoopConf);
        }
        catch (Throwable throwable) {
            IOException iOException;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof IOException && (iOException = (IOException)throwable2).getMessage().contains(this.noAbstractFileSystemExceptionMessage())) {
                Throwable newException = DeltaErrors$.MODULE$.incorrectLogStoreImplementationException(iOException);
                this.logError((Function0<String>)new Serializable(this, newException){
                    public static final long serialVersionUID = 0L;
                    private final Throwable newException$1;

                    public final String apply() {
                        return this.newException$1.getMessage();
                    }
                    {
                        this.newException$1 = newException$1;
                    }
                }, newException.getCause());
                throw newException;
            }
            throw throwable;
        }
        if (!overwrite && fc.util().exists(path2)) {
            throw new java.nio.file.FileAlreadyExistsException(path2.toString());
        }
        Path tempPath = this.createTempPath(path2);
        boolean streamClosed = false;
        boolean renameDone = false;
        FSDataOutputStream stream = fc.create(tempPath, EnumSet.of(CreateFlag.CREATE), new Options.CreateOpts[]{Options.CreateOpts.checksumParam((Options.ChecksumOpt)Options.ChecksumOpt.createDisabled())});
        try {
            actions.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(String x$1) {
                    return new StringBuilder().append((Object)x$1).append((Object)"\n").toString();
                }
            }).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final byte[] apply(String x$2) {
                    return x$2.getBytes(StandardCharsets.UTF_8);
                }
            }).foreach((Function1)new Serializable(this, stream){
                public static final long serialVersionUID = 0L;
                private final FSDataOutputStream stream$1;

                public final void apply(byte[] x$1) {
                    this.stream$1.write(x$1);
                }
                {
                    this.stream$1 = stream$1;
                }
            });
            stream.close();
            streamClosed = true;
            try {
                Options.Rename renameOpt = overwrite ? Options.Rename.OVERWRITE : Options.Rename.NONE;
                fc.rename(tempPath, path2, new Options.Rename[]{renameOpt});
                renameDone = true;
                this.tryRemoveCrcFile(fc, tempPath);
                return;
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                throw new java.nio.file.FileAlreadyExistsException(path2.toString());
            }
        }
        finally {
            if (!streamClosed) {
                stream.close();
            }
            if (!renameDone) {
                fc.delete(tempPath, false);
            }
        }
    }

    private FileContext getFileContext(Path path2, Configuration hadoopConf) {
        return FileContext.getFileContext((URI)path2.toUri(), (Configuration)hadoopConf);
    }

    private void tryRemoveCrcFile(FileContext fc, Path path2) {
        try {
            Path checksumFile = new Path(path2.getParent(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{".", ".crc"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path2.getName()})));
            if (fc.util().exists(checksumFile)) {
                fc.delete(checksumFile, true);
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public HDFSLogStore(Configuration initHadoopConf) {
        super(initHadoopConf);
        Logging$class.$init$(this);
        this.noAbstractFileSystemExceptionMessage = "No AbstractFileSystem";
    }
}

