/*
 * Decompiled with CFR 0.152.
 */
package io.delta.standalone.internal.storage;

import io.delta.standalone.internal.storage.LineCloseableIterator;
import io.delta.storage.CloseableIterator;
import io.delta.storage.LogStore;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001]4Q!\u0001\u0002\u0002\u00025\u0011\u0001\u0004S1e_>\u0004h)\u001b7f'f\u001cH/Z7M_\u001e\u001cFo\u001c:f\u0015\t\u0019A!A\u0004ti>\u0014\u0018mZ3\u000b\u0005\u00151\u0011\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005\u001dA\u0011AC:uC:$\u0017\r\\8oK*\u0011\u0011BC\u0001\u0006I\u0016dG/\u0019\u0006\u0002\u0017\u0005\u0011\u0011n\\\u0002\u0001'\t\u0001a\u0002\u0005\u0002\u0010#5\t\u0001C\u0003\u0002\u0004\u0011%\u0011!\u0003\u0005\u0002\t\u0019><7\u000b^8sK\"AA\u0003\u0001BC\u0002\u0013\u0005S#\u0001\bj]&$\b*\u00193p_B\u001cuN\u001c4\u0016\u0003Y\u0001\"a\u0006\u0011\u000e\u0003aQ!!\u0007\u000e\u0002\t\r|gN\u001a\u0006\u00037q\ta\u0001[1e_>\u0004(BA\u000f\u001f\u0003\u0019\t\u0007/Y2iK*\tq$A\u0002pe\u001eL!!\t\r\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0011!\u0019\u0003A!A!\u0002\u00131\u0012aD5oSRD\u0015\rZ8pa\u000e{gN\u001a\u0011\t\u000b\u0015\u0002A\u0011\u0001\u0014\u0002\rqJg.\u001b;?)\t9\u0013\u0006\u0005\u0002)\u00015\t!\u0001C\u0003\u0015I\u0001\u0007a\u0003C\u0003,\u0001\u0011\u0005C&\u0001\u0003sK\u0006$GcA\u0017;\u0005B\u0019qB\f\u0019\n\u0005=\u0002\"!E\"m_N,\u0017M\u00197f\u0013R,'/\u0019;peB\u0011\u0011g\u000e\b\u0003eUj\u0011a\r\u0006\u0002i\u0005)1oY1mC&\u0011agM\u0001\u0007!J,G-\u001a4\n\u0005aJ$AB*ue&twM\u0003\u00027g!)1H\u000ba\u0001y\u0005!\u0001/\u0019;i!\ti\u0004)D\u0001?\u0015\ty$$\u0001\u0002gg&\u0011\u0011I\u0010\u0002\u0005!\u0006$\b\u000eC\u0003DU\u0001\u0007a#\u0001\u0006iC\u0012|w\u000e]\"p]\u001aDQ!\u0012\u0001\u0005B\u0019\u000b\u0001\u0002\\5ti\u001a\u0013x.\u001c\u000b\u0004\u000fJ\u001b\u0006c\u0001%N\u001f6\t\u0011J\u0003\u0002K\u0017\u0006!Q\u000f^5m\u0015\u0005a\u0015\u0001\u00026bm\u0006L!AT%\u0003\u0011%#XM]1u_J\u0004\"!\u0010)\n\u0005Es$A\u0003$jY\u0016\u001cF/\u0019;vg\")1\b\u0012a\u0001y!)1\t\u0012a\u0001-!)Q\u000b\u0001C!-\u0006a\"/Z:pYZ,\u0007+\u0019;i\u001f:\u0004\u0006._:jG\u0006d7\u000b^8sC\u001e,Gc\u0001\u001fX1\")1\b\u0016a\u0001y!)1\t\u0016a\u0001-!)!\f\u0001C\t7\u0006yqO]5uK^KG\u000f\u001b*f]\u0006lW\rF\u0003]?\u0002l'\u000f\u0005\u00023;&\u0011al\r\u0002\u0005+:LG\u000fC\u0003<3\u0002\u0007A\bC\u0003b3\u0002\u0007!-A\u0004bGRLwN\\:\u0011\u0007\r\\\u0007G\u0004\u0002eS:\u0011Q\r[\u0007\u0002M*\u0011q\rD\u0001\u0007yI|w\u000e\u001e \n\u0003QJ!A[\u001a\u0002\u000fA\f7m[1hK&\u0011a\n\u001c\u0006\u0003UNBQA\\-A\u0002=\f\u0011b\u001c<fe^\u0014\u0018\u000e^3\u0011\u0005I\u0002\u0018BA94\u0005\u001d\u0011un\u001c7fC:DQaQ-A\u0002YAQ\u0001\u001e\u0001\u0005\u0012U\fab\u0019:fCR,G+Z7q!\u0006$\b\u000e\u0006\u0002=m\")1h\u001da\u0001y\u0001")
public abstract class HadoopFileSystemLogStore
extends LogStore {
    private final Configuration initHadoopConf;

    public Configuration initHadoopConf() {
        return this.initHadoopConf;
    }

    public CloseableIterator<String> read(Path path2, Configuration hadoopConf) {
        FileSystem fs = path2.getFileSystem(hadoopConf);
        FSDataInputStream stream = fs.open(path2);
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)stream, StandardCharsets.UTF_8));
        return new LineCloseableIterator(reader);
    }

    public java.util.Iterator<FileStatus> listFrom(Path path2, Configuration hadoopConf) {
        FileSystem fs = path2.getFileSystem(hadoopConf);
        if (fs.exists(path2.getParent())) {
            FileStatus[] files2 = fs.listStatus(path2.getParent());
            return (java.util.Iterator)JavaConverters$.MODULE$.asJavaIteratorConverter(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])files2).filter((Function1)new Serializable(this, path2){
                public static final long serialVersionUID = 0L;
                private final Path path$1;

                public final boolean apply(FileStatus x$1) {
                    return new StringOps(Predef$.MODULE$.augmentString(x$1.getPath().getName())).$greater$eq((Object)this.path$1.getName());
                }
                {
                    this.path$1 = path$1;
                }
            })).sortBy((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(FileStatus x$2) {
                    return x$2.getPath().getName();
                }
            }, (Ordering)Ordering.String$.MODULE$)).iterator()).asJava();
        }
        throw new FileNotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No such file or directory: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path2.getParent()})));
    }

    public Path resolvePathOnPhysicalStorage(Path path2, Configuration hadoopConf) {
        return path2.getFileSystem(hadoopConf).makeQualified(path2);
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeWithRename(Path path2, Iterator<String> actions, boolean overwrite, Configuration hadoopConf) {
        FileSystem fs = path2.getFileSystem(hadoopConf);
        if (!fs.exists(path2.getParent())) {
            throw new FileNotFoundException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"No such file or directory: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path2.getParent()})));
        }
        if (overwrite) {
            FSDataOutputStream stream = fs.create(path2, true);
            actions.map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(String x$3) {
                    return new StringBuilder().append((Object)x$3).append((Object)"\n").toString();
                }
            }).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final byte[] apply(String x$4) {
                    return x$4.getBytes(StandardCharsets.UTF_8);
                }
            }).foreach((Function1)new Serializable(this, stream){
                public static final long serialVersionUID = 0L;
                private final FSDataOutputStream stream$1;

                public final void apply(byte[] x$1) {
                    this.stream$1.write(x$1);
                }
                {
                    this.stream$1 = stream$1;
                }
            });
            stream.close();
            return;
        }
        if (fs.exists(path2)) {
            throw new java.nio.file.FileAlreadyExistsException(path2.toString());
        }
        Path tempPath = this.createTempPath(path2);
        boolean streamClosed = false;
        boolean renameDone = false;
        FSDataOutputStream stream = fs.create(tempPath);
        try {
            block15: {
                actions.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(String x$5) {
                        return new StringBuilder().append((Object)x$5).append((Object)"\n").toString();
                    }
                }).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final byte[] apply(String x$6) {
                        return x$6.getBytes(StandardCharsets.UTF_8);
                    }
                }).foreach((Function1)new Serializable(this, stream){
                    public static final long serialVersionUID = 0L;
                    private final FSDataOutputStream stream$2;

                    public final void apply(byte[] x$1) {
                        this.stream$2.write(x$1);
                    }
                    {
                        this.stream$2 = stream$2;
                    }
                });
                stream.close();
                streamClosed = true;
                try {
                    if (!fs.rename(tempPath, path2)) break block15;
                    renameDone = true;
                    return;
                }
                catch (FileAlreadyExistsException fileAlreadyExistsException) {
                    throw new java.nio.file.FileAlreadyExistsException(path2.toString());
                }
            }
            if (fs.exists(path2)) {
                throw new java.nio.file.FileAlreadyExistsException(path2.toString());
            }
            throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot rename ", " to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tempPath, path2})));
            catch (Throwable throwable) {
                void var6_6;
                var6_6.close();
                throw throwable;
            }
        }
        finally {
            if (!streamClosed) {
                stream.close();
            }
            if (!renameDone) {
                fs.delete(tempPath, false);
            }
        }
    }

    public Path createTempPath(Path path2) {
        return new Path(path2.getParent(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{".", ".", ".tmp"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path2.getName(), UUID.randomUUID()})));
    }

    public HadoopFileSystemLogStore(Configuration initHadoopConf) {
        this.initHadoopConf = initHadoopConf;
        super(initHadoopConf);
    }
}

