/*
 * Decompiled with CFR 0.152.
 */
package io.delta.standalone.internal.storage;

import io.delta.standalone.exceptions.DeltaStandaloneException;
import io.delta.standalone.internal.exception.DeltaErrors$;
import io.delta.standalone.internal.sources.StandaloneHadoopConf$;
import io.delta.standalone.internal.storage.DelegatingLogStore;
import io.delta.standalone.internal.storage.LogStoreProvider;
import io.delta.storage.LogStore;
import org.apache.hadoop.conf.Configuration;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SetLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;

public abstract class LogStoreProvider$class {
    public static String logStoreSchemeConfKey(LogStoreProvider $this, String scheme) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"delta.logStore.", ".impl"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{scheme}));
    }

    public static LogStore createLogStore(LogStoreProvider $this, Configuration hadoopConf) {
        $this.checkLogStoreConfConflicts(hadoopConf);
        $this.normalizeHadoopConf(hadoopConf);
        String logStoreClassName = hadoopConf.get($this.logStoreClassConfKey(), $this.defaultLogStoreClass());
        return $this.createLogStoreWithClassName(logStoreClassName, hadoopConf);
    }

    public static LogStore createLogStoreWithClassName(LogStoreProvider $this, String className, Configuration hadoopConf) {
        block4: {
            DelegatingLogStore delegatingLogStore;
            block3: {
                block2: {
                    String string = className;
                    String string2 = DelegatingLogStore.class.getName();
                    if (string != null ? !string.equals(string2) : string2 != null) break block2;
                    delegatingLogStore = new DelegatingLogStore(hadoopConf);
                    break block3;
                }
                Class<?> logStoreClass = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
                if (!LogStore.class.isAssignableFrom(logStoreClass)) break block4;
                delegatingLogStore = (LogStore)logStoreClass.getConstructor(Configuration.class).newInstance(hadoopConf);
            }
            return delegatingLogStore;
        }
        throw new DeltaStandaloneException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Can't instantiate a LogStore with classname "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{className}))).toString());
    }

    public static void normalizeHadoopConf(LogStoreProvider $this, Configuration hadoopConf) {
        Map schemeConfs = (Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(hadoopConf.getValByRegex($this.acceptedLogStoreSchemeConfKeyRegex())).asScala();
        ((IterableLike)schemeConfs.filter((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, String> x$1) {
                return ((String)x$1._1()).startsWith("spark.");
            }
        })).foreach((Function1)new Serializable($this, hadoopConf){
            public static final long serialVersionUID = 0L;
            private final Configuration hadoopConf$1;

            public final void apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2;
                block2: {
                    Option option;
                    block6: {
                        block5: {
                            String normalizedKey;
                            String value;
                            block3: {
                                String normalValue;
                                String key;
                                block4: {
                                    tuple2 = x0$1;
                                    if (tuple2 == null) break block2;
                                    key = (String)tuple2._1();
                                    value = (String)tuple2._2();
                                    normalizedKey = new StringOps(Predef$.MODULE$.augmentString(key)).stripPrefix("spark.");
                                    option = Option$.MODULE$.apply((Object)this.hadoopConf$1.get(normalizedKey));
                                    if (!(option instanceof Some)) break block3;
                                    Some some = (Some)option;
                                    normalValue = (String)some.x();
                                    String string = value;
                                    String string2 = normalValue;
                                    if (string != null ? !string.equals(string2) : string2 != null) break block4;
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    break block5;
                                }
                                throw DeltaErrors$.MODULE$.inconsistentLogStoreConfs((Seq<Tuple2<String, String>>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)key, (Object)value), new Tuple2((Object)normalizedKey, (Object)normalValue)}))));
                            }
                            if (!None$.MODULE$.equals(option)) break block6;
                            this.hadoopConf$1.set(normalizedKey, value);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError((Object)option);
                }
                throw new MatchError(tuple2);
            }
            {
                this.hadoopConf$1 = hadoopConf$1;
            }
        });
        Map classConfs = (Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(hadoopConf.getValByRegex($this.acceptedLogStoreClassConfKeyRegex())).asScala();
        if (classConfs.values().toSet().size() > 1) {
            throw DeltaErrors$.MODULE$.inconsistentLogStoreConfs((Seq<Tuple2<String, String>>)classConfs.iterator().toSeq());
        }
        if (classConfs.size() > 0) {
            hadoopConf.set($this.logStoreClassConfKey(), (String)classConfs.values().head());
        }
    }

    public static void checkLogStoreConfConflicts(LogStoreProvider $this, Configuration hadoopConf) {
        java.util.Map classConf = hadoopConf.getValByRegex($this.acceptedLogStoreClassConfKeyRegex());
        java.util.Map schemeConf = hadoopConf.getValByRegex($this.acceptedLogStoreSchemeConfKeyRegex());
        if (classConf.isEmpty() || schemeConf.isEmpty()) {
            return;
        }
        throw DeltaErrors$.MODULE$.logStoreConfConflicts((Seq<String>)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(classConf.keySet()).asScala()).toSeq(), (Seq<String>)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(schemeConf.keySet()).asScala()).toSeq());
    }

    public static void $init$(LogStoreProvider $this) {
        String arg$macro$1211 = StandaloneHadoopConf$.MODULE$.LOG_STORE_CLASS_KEY();
        String arg$macro$1212 = StandaloneHadoopConf$.MODULE$.LEGACY_LOG_STORE_CLASS_KEY();
        $this.io$delta$standalone$internal$storage$LogStoreProvider$_setter_$acceptedLogStoreClassConfKeyRegex_$eq(new StringBuilder().append((Object)new StringOps("((?:spark.)?%s|").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1211}))).append((Object)new StringOps("%s)").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{arg$macro$1212})).replace(".", "\\.")).toString());
        $this.io$delta$standalone$internal$storage$LogStoreProvider$_setter_$acceptedLogStoreSchemeConfKeyRegex_$eq("(?:spark\\.)?delta\\.logStore\\.\\w+\\.impl");
        $this.io$delta$standalone$internal$storage$LogStoreProvider$_setter_$logStoreClassConfKey_$eq(StandaloneHadoopConf$.MODULE$.LOG_STORE_CLASS_KEY());
        $this.io$delta$standalone$internal$storage$LogStoreProvider$_setter_$defaultLogStoreClass_$eq(DelegatingLogStore.class.getName());
    }
}

