/*
 * Decompiled with CFR 0.152.
 */
package io.delta.standalone.internal.util;

import java.net.URI;
import java.util.regex.Pattern;
import org.apache.hadoop.fs.Path;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.package$;
import scala.runtime.BoxesRunTime;

public final class FileNames$ {
    public static final FileNames$ MODULE$;
    private final Pattern deltaFilePattern;
    private final Pattern checkpointFilePattern;

    static {
        new FileNames$();
    }

    public Pattern deltaFilePattern() {
        return this.deltaFilePattern;
    }

    public Pattern checkpointFilePattern() {
        return this.checkpointFilePattern;
    }

    public Path deltaFile(Path path2, long version) {
        long arg$macro$1213 = version;
        return new Path(path2, new StringOps("%020d.json").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)arg$macro$1213)})));
    }

    public long deltaVersion(Path path2) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(path2.getName())).stripSuffix(".json"))).toLong();
    }

    public Path checkpointPrefix(Path path2, long version) {
        long arg$macro$1214 = version;
        return new Path(path2, new StringOps("%020d.checkpoint").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)arg$macro$1214)})));
    }

    public Path checkpointFileSingular(Path path2, long version) {
        long arg$macro$1215 = version;
        return new Path(path2, new StringOps("%020d.checkpoint.parquet").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)arg$macro$1215)})));
    }

    public Seq<Path> checkpointFileWithParts(Path path2, long version, int numParts) {
        return (Seq)package$.MODULE$.Range().apply(1, numParts + 1).map((Function1)new Serializable(path2, version, numParts){
            public static final long serialVersionUID = 0L;
            private final Path path$1;
            private final long version$1;
            private final int numParts$1;

            public final Path apply(int i) {
                long arg$macro$1216 = this.version$1;
                int arg$macro$1217 = i;
                int arg$macro$1218 = this.numParts$1;
                return new Path(this.path$1, new StringOps("%020d.checkpoint.%010d.%010d.parquet").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)arg$macro$1216), BoxesRunTime.boxToInteger((int)arg$macro$1217), BoxesRunTime.boxToInteger((int)arg$macro$1218)})));
            }
            {
                this.path$1 = path$1;
                this.version$1 = version$1;
                this.numParts$1 = numParts$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    public Option<Object> numCheckpointParts(Path path2) {
        String[] segments = path2.getName().split("\\.");
        return Predef$.MODULE$.refArrayOps((Object[])segments).size() != 5 ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(segments[3])).toInt()));
    }

    public boolean isCheckpointFile(Path path2) {
        return this.checkpointFilePattern().matcher(path2.getName()).matches();
    }

    public boolean isDeltaFile(Path path2) {
        return this.deltaFilePattern().matcher(path2.getName()).matches();
    }

    public long checkpointVersion(Path path2) {
        return new StringOps(Predef$.MODULE$.augmentString(path2.getName().split("\\.")[0])).toLong();
    }

    public long getFileVersion(Path path2) {
        block4: {
            long l;
            block3: {
                block2: {
                    if (!this.isCheckpointFile(path2)) break block2;
                    l = this.checkpointVersion(path2);
                    break block3;
                }
                if (!this.isDeltaFile(path2)) break block4;
                l = this.deltaVersion(path2);
            }
            return l;
        }
        throw new AssertionError((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected file type found in transaction log: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path2})));
    }

    public Path absolutePath(Path parentDir, String child) {
        Path p = new Path(new URI(child));
        return p.isAbsolute() ? p : new Path(parentDir, p);
    }

    private FileNames$() {
        MODULE$ = this;
        this.deltaFilePattern = new StringOps(Predef$.MODULE$.augmentString("\\d+\\.json")).r().pattern();
        this.checkpointFilePattern = new StringOps(Predef$.MODULE$.augmentString("\\d+\\.checkpoint(\\.\\d+\\.\\d+)?\\.parquet")).r().pattern();
    }
}

