/*
 * Decompiled with CFR 0.152.
 */
package io.delta.standalone.internal.util;

import io.delta.standalone.internal.util.CalendarInterval;
import io.delta.standalone.internal.util.DateTimeConstants$;
import io.delta.standalone.internal.util.IntervalUtils$IntervalUnit$;
import io.delta.standalone.internal.util.IntervalUtils$ParseState$;
import java.nio.charset.StandardCharsets;
import scala.Enumeration;
import scala.MatchError;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;

public final class IntervalUtils$ {
    public static final IntervalUtils$ MODULE$;
    private final String intervalStr;
    private final String yearStr;
    private final String monthStr;
    private final String weekStr;
    private final String dayStr;
    private final String hourStr;
    private final String minuteStr;
    private final String secondStr;
    private final String millisStr;
    private final String microsStr;

    static {
        new IntervalUtils$();
    }

    private final String intervalStr() {
        return "interval";
    }

    private String unitToUtf8(Enumeration.Value unit2) {
        return unit2.toString();
    }

    private final String yearStr() {
        return this.yearStr;
    }

    private final String monthStr() {
        return this.monthStr;
    }

    private final String weekStr() {
        return this.weekStr;
    }

    private final String dayStr() {
        return this.dayStr;
    }

    private final String hourStr() {
        return this.hourStr;
    }

    private final String minuteStr() {
        return this.minuteStr;
    }

    private final String secondStr() {
        return this.secondStr;
    }

    private final String millisStr() {
        return this.millisStr;
    }

    private final String microsStr() {
        return this.microsStr;
    }

    public CalendarInterval safeStringToInterval(String input) {
        CalendarInterval calendarInterval;
        try {
            calendarInterval = this.stringToInterval(input);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            calendarInterval = null;
        }
        return calendarInterval;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CalendarInterval stringToInterval(String input) {
        if (input == null) {
            throw this.throwIAE$1("interval string cannot be null", this.throwIAE$default$2$1(), input);
        }
        s = input.trim().toLowerCase();
        bytes = s.getBytes(StandardCharsets.UTF_8);
        if (Predef$.MODULE$.byteArrayOps(bytes).isEmpty()) {
            throw this.throwIAE$1("interval string cannot be empty", this.throwIAE$default$2$1(), input);
        }
        state = ObjectRef.create((Object)IntervalUtils$ParseState$.MODULE$.PREFIX());
        i = IntRef.create((int)0);
        currentValue = 0L;
        isNegative = false;
        months = 0;
        days = 0;
        microseconds = 0L;
        fractionScale = 0;
        initialFractionScale = (int)(DateTimeConstants$.MODULE$.NANOS_PER_SECOND() / 10L);
        fraction = 0;
        pointPrefixed = false;
        block16: while (i.elem < bytes.length) {
            block71: {
                block72: {
                    block67: {
                        block70: {
                            block69: {
                                block68: {
                                    b = bytes[i.elem];
                                    var18_16 = (Enumeration.Value)state.elem;
                                    v0 = IntervalUtils$ParseState$.MODULE$.PREFIX();
                                    var19_17 = var18_16;
                                    if (!(v0 != null ? v0.equals(var19_17) == false : var19_17 != null)) {
                                        if (s.startsWith("interval")) {
                                            if (s.length() == "interval".length()) {
                                                throw this.throwIAE$1("interval string cannot be empty", this.throwIAE$default$2$1(), input);
                                            }
                                            if (!Character.isWhitespace(bytes[i.elem + "interval".length()])) {
                                                throw this.throwIAE$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalid interval prefix ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.currentWord$1(s, i)})), this.throwIAE$default$2$1(), input);
                                            }
                                            i.elem += "interval".length() + 1;
                                        }
                                        state.elem = IntervalUtils$ParseState$.MODULE$.TRIM_BEFORE_SIGN();
                                        var20_18 = BoxedUnit.UNIT;
                                        continue;
                                    }
                                    v1 = IntervalUtils$ParseState$.MODULE$.TRIM_BEFORE_SIGN();
                                    var21_19 = var18_16;
                                    if (!(v1 != null ? v1.equals(var21_19) == false : var21_19 != null)) {
                                        this.trimToNextState$1(b, IntervalUtils$ParseState$.MODULE$.SIGN(), state, i);
                                        var20_18 = BoxedUnit.UNIT;
                                        continue;
                                    }
                                    v2 = IntervalUtils$ParseState$.MODULE$.SIGN();
                                    var22_20 = var18_16;
                                    if (!(v2 != null ? v2.equals(var22_20) == false : var22_20 != null)) {
                                        currentValue = 0L;
                                        fraction = 0;
                                        state.elem = IntervalUtils$ParseState$.MODULE$.TRIM_BEFORE_VALUE();
                                        fractionScale = -1;
                                        pointPrefixed = false;
                                        var23_21 = b;
                                        if (45 == var23_21) {
                                            isNegative = true;
                                            ++i.elem;
                                            var24_22 = BoxedUnit.UNIT;
                                        } else if (43 == var23_21) {
                                            isNegative = false;
                                            ++i.elem;
                                            var24_22 = BoxedUnit.UNIT;
                                        } else if (48 <= b && b <= 57) {
                                            isNegative = false;
                                            var24_22 = BoxedUnit.UNIT;
                                        } else {
                                            if (46 != var23_21) {
                                                throw this.throwIAE$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"unrecognized number '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.currentWord$1(s, i)})), this.throwIAE$default$2$1(), input);
                                            }
                                            isNegative = false;
                                            fractionScale = initialFractionScale;
                                            pointPrefixed = true;
                                            ++i.elem;
                                            state.elem = IntervalUtils$ParseState$.MODULE$.VALUE_FRACTIONAL_PART();
                                            var24_22 = BoxedUnit.UNIT;
                                        }
                                        var20_18 = BoxedUnit.UNIT;
                                        continue;
                                    }
                                    v3 = IntervalUtils$ParseState$.MODULE$.TRIM_BEFORE_VALUE();
                                    var25_23 = var18_16;
                                    if (!(v3 != null ? v3.equals(var25_23) == false : var25_23 != null)) {
                                        this.trimToNextState$1(b, IntervalUtils$ParseState$.MODULE$.VALUE(), state, i);
                                        var20_18 = BoxedUnit.UNIT;
                                        continue;
                                    }
                                    v4 = IntervalUtils$ParseState$.MODULE$.VALUE();
                                    var26_24 = var18_16;
                                    if (!(v4 != null ? v4.equals(var26_24) == false : var26_24 != null)) {
                                        var27_25 = b;
                                        if (48 <= b && b <= 57) {
                                            currentValue = Math.addExact(Math.multiplyExact(10L, currentValue), (long)(b - 48));
                                            var28_26 = BoxedUnit.UNIT;
                                        }
                                        if (Character.isWhitespace(b)) {
                                            state.elem = IntervalUtils$ParseState$.MODULE$.TRIM_BEFORE_UNIT();
                                            var28_26 = BoxedUnit.UNIT;
                                        } else {
                                            if (46 != var27_25) {
                                                throw this.throwIAE$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalid value '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.currentWord$1(s, i)})), this.throwIAE$default$2$1(), input);
                                            }
                                            fractionScale = initialFractionScale;
                                            state.elem = IntervalUtils$ParseState$.MODULE$.VALUE_FRACTIONAL_PART();
                                            var28_26 = BoxedUnit.UNIT;
                                        }
                                        ++i.elem;
                                        var20_18 = BoxedUnit.UNIT;
                                        continue;
                                    }
                                    v5 = IntervalUtils$ParseState$.MODULE$.VALUE_FRACTIONAL_PART();
                                    var30_27 = var18_16;
                                    if (v5 != null ? v5.equals(var30_27) == false : var30_27 != null) break block67;
                                    if (48 > b || b > 57 || fractionScale <= 0) break block68;
                                    fraction += (b - 48) * fractionScale;
                                    fractionScale /= 10;
                                    break block69;
                                }
                                if (!Character.isWhitespace(b) || pointPrefixed && fractionScale >= initialFractionScale) break block70;
                                fraction /= (int)DateTimeConstants$.MODULE$.NANOS_PER_MICROS();
                                state.elem = IntervalUtils$ParseState$.MODULE$.TRIM_BEFORE_UNIT();
                            }
                            ++i.elem;
                            var20_18 = BoxedUnit.UNIT;
                            continue;
                        }
                        if (48 <= b && b <= 57) {
                            v6 = this.throwIAE$1(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"interval can only support nanosecond precision, '", "' is out"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.currentWord$1(s, i)}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" of range"})).s((Seq)Nil$.MODULE$)).toString(), this.throwIAE$default$2$1(), input);
                            throw v6;
                        }
                        v6 = this.throwIAE$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalid value '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.currentWord$1(s, i)})), this.throwIAE$default$2$1(), input);
                        throw v6;
                    }
                    v7 = IntervalUtils$ParseState$.MODULE$.TRIM_BEFORE_UNIT();
                    var31_28 = var18_16;
                    if (!(v7 != null ? v7.equals(var31_28) == false : var31_28 != null)) {
                        this.trimToNextState$1(b, IntervalUtils$ParseState$.MODULE$.UNIT_BEGIN(), state, i);
                        var20_18 = BoxedUnit.UNIT;
                        continue;
                    }
                    v8 = IntervalUtils$ParseState$.MODULE$.UNIT_BEGIN();
                    var32_29 = var18_16;
                    if (v8 != null ? v8.equals(var32_29) == false : var32_29 != null) break block71;
                    if (b != 115 && fractionScale >= 0) {
                        throw this.throwIAE$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "' cannot have fractional part"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.currentWord$1(s, i)})), this.throwIAE$default$2$1(), input);
                    }
                    if (isNegative) {
                        currentValue = -currentValue;
                        fraction = -fraction;
                    }
                    try {}
                    catch (ArithmeticException var33_52) {
                        throw this.throwIAE$1(var33_52.getMessage(), var33_52, input);
                    }
                    break block72;
                    catch (ArithmeticException var29_51) {
                        throw this.throwIAE$1(var29_51.getMessage(), var29_51, input);
                    }
                }
                var34_30 = b;
                switch (var34_30) {
                    case 109: {
                        if (!this.matchAt$1(i.elem, this.monthStr(), s)) ** GOTO lbl149
                        months = Math.addExact(months, Math.toIntExact(currentValue));
                        i.elem += this.monthStr().length();
                        ** GOTO lbl192
lbl149:
                        // 1 sources

                        if (!this.matchAt$1(i.elem, this.minuteStr(), s)) ** GOTO lbl154
                        minutesUs = Math.multiplyExact(currentValue, DateTimeConstants$.MODULE$.MICROS_PER_MINUTE());
                        microseconds = Math.addExact(microseconds, minutesUs);
                        i.elem += this.minuteStr().length();
                        ** GOTO lbl192
lbl154:
                        // 1 sources

                        if (this.matchAt$1(i.elem, this.millisStr(), s)) {
                            millisUs = Math.multiplyExact(currentValue, DateTimeConstants$.MODULE$.MICROS_PER_MILLIS());
                            microseconds = Math.addExact(microseconds, millisUs);
                            i.elem += this.millisStr().length();
                        } else {
                            if (!this.matchAt$1(i.elem, this.microsStr(), s)) {
                                throw this.throwIAE$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalid unit '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.currentWord$1(s, i)})), this.throwIAE$default$2$1(), input);
                            }
                            microseconds = Math.addExact(microseconds, currentValue);
                            i.elem += this.microsStr().length();
                        }
                        ** GOTO lbl192
                    }
                    case 115: {
                        if (!this.matchAt$1(i.elem, this.secondStr(), s)) throw this.throwIAE$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalid unit '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.currentWord$1(s, i)})), this.throwIAE$default$2$1(), input);
                        secondsUs = Math.multiplyExact(currentValue, DateTimeConstants$.MODULE$.MICROS_PER_SECOND());
                        microseconds = Math.addExact(Math.addExact(microseconds, secondsUs), (long)fraction);
                        i.elem += this.secondStr().length();
                        ** GOTO lbl192
                    }
                    case 104: {
                        if (!this.matchAt$1(i.elem, this.hourStr(), s)) throw this.throwIAE$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalid unit '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.currentWord$1(s, i)})), this.throwIAE$default$2$1(), input);
                        hoursUs = Math.multiplyExact(currentValue, DateTimeConstants$.MODULE$.MICROS_PER_HOUR());
                        microseconds = Math.addExact(microseconds, hoursUs);
                        i.elem += this.hourStr().length();
                        ** GOTO lbl192
                    }
                    case 100: {
                        if (!this.matchAt$1(i.elem, this.dayStr(), s)) throw this.throwIAE$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalid unit '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.currentWord$1(s, i)})), this.throwIAE$default$2$1(), input);
                        days = Math.addExact(days, Math.toIntExact(currentValue));
                        i.elem += this.dayStr().length();
                        ** GOTO lbl192
                    }
                    case 119: {
                        if (!this.matchAt$1(i.elem, this.weekStr(), s)) throw this.throwIAE$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalid unit '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.currentWord$1(s, i)})), this.throwIAE$default$2$1(), input);
                        daysInWeeks = Math.multiplyExact((long)DateTimeConstants$.MODULE$.DAYS_PER_WEEK(), currentValue);
                        days = Math.toIntExact(Math.addExact((long)days, daysInWeeks));
                        i.elem += this.weekStr().length();
                        ** GOTO lbl192
                    }
                    case 121: {
                        if (!this.matchAt$1(i.elem, this.yearStr(), s)) throw this.throwIAE$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalid unit '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.currentWord$1(s, i)})), this.throwIAE$default$2$1(), input);
                        monthsInYears = Math.multiplyExact((long)DateTimeConstants$.MODULE$.MONTHS_PER_YEAR(), currentValue);
                        months = Math.toIntExact(Math.addExact((long)months, monthsInYears));
                        i.elem += this.yearStr().length();
lbl192:
                        // 9 sources

                        state.elem = IntervalUtils$ParseState$.MODULE$.UNIT_SUFFIX();
                        var20_18 = BoxedUnit.UNIT;
                        continue block16;
                    }
                }
                {
                    throw this.throwIAE$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalid unit '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.currentWord$1(s, i)})), this.throwIAE$default$2$1(), input);
                }
            }
            v9 = IntervalUtils$ParseState$.MODULE$.UNIT_SUFFIX();
            var47_37 = var18_16;
            if (!(v9 != null ? v9.equals(var47_37) == false : var47_37 != null)) {
                var48_38 = b;
                switch (var48_38) {
                    default: {
                        if (!Character.isWhitespace(b)) {
                            throw this.throwIAE$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalid unit '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.currentWord$1(s, i)})), this.throwIAE$default$2$1(), input);
                        }
                        state.elem = IntervalUtils$ParseState$.MODULE$.TRIM_BEFORE_SIGN();
                        break;
                    }
                    case 115: {
                        state.elem = IntervalUtils$ParseState$.MODULE$.UNIT_END();
                    }
                }
                ++i.elem;
                var20_18 = BoxedUnit.UNIT;
                continue;
            }
            v10 = IntervalUtils$ParseState$.MODULE$.UNIT_END();
            var49_39 = var18_16;
            if (v10 == null) {
                if (var49_39 != null) {
                    throw new MatchError((Object)var18_16);
                }
            } else if (v10.equals(var49_39) == false) throw new MatchError((Object)var18_16);
            if (!Character.isWhitespace(b)) {
                throw this.throwIAE$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalid unit '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.currentWord$1(s, i)})), this.throwIAE$default$2$1(), input);
            }
            ++i.elem;
            state.elem = IntervalUtils$ParseState$.MODULE$.TRIM_BEFORE_SIGN();
            var20_18 = BoxedUnit.UNIT;
        }
        var51_40 = (Enumeration.Value)state.elem;
        v11 = IntervalUtils$ParseState$.MODULE$.UNIT_SUFFIX();
        var52_41 = var51_40;
        if (!(v11 != null ? v11.equals(var52_41) == false : var52_41 != null)) {
            var53_42 = true;
        } else {
            v12 = IntervalUtils$ParseState$.MODULE$.UNIT_END();
            var54_43 = var51_40;
            if (!(v12 != null ? v12.equals(var54_43) == false : var54_43 != null)) {
                var53_42 = true;
            } else {
                v13 = IntervalUtils$ParseState$.MODULE$.TRIM_BEFORE_SIGN();
                var55_44 = var51_40;
                var53_42 = !(v13 != null ? v13.equals(var55_44) == false : var55_44 != null);
            }
        }
        if (var53_42) {
            var56_45 = new CalendarInterval(months, days, microseconds);
            return var56_45;
        }
        v14 = IntervalUtils$ParseState$.MODULE$.TRIM_BEFORE_VALUE();
        var57_47 = var51_40;
        if (!(v14 != null ? v14.equals(var57_47) == false : var57_47 != null)) {
            throw this.throwIAE$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expect a number after '", "' but hit EOL"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.currentWord$1((String)var2_2, (IntRef)var5_5)})), this.throwIAE$default$2$1(), input);
        }
        v15 = IntervalUtils$ParseState$.MODULE$.VALUE();
        var58_48 = var51_40;
        if (!(v15 != null ? v15.equals(var58_48) == false : var58_48 != null)) {
            var59_49 = true;
        } else {
            v16 = IntervalUtils$ParseState$.MODULE$.VALUE_FRACTIONAL_PART();
            var60_50 = var51_40;
            var59_49 = !(v16 != null ? v16.equals(var60_50) == false : var60_50 != null);
        }
        if (!var59_49) throw this.throwIAE$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"unknown error when parsing '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.currentWord$1((String)var2_2, (IntRef)var5_5)})), this.throwIAE$default$2$1(), input);
        throw this.throwIAE$1(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"expect a unit name after '", "' but hit EOL"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.currentWord$1((String)var2_2, (IntRef)var5_5)})), this.throwIAE$default$2$1(), input);
    }

    private final Nothing$ throwIAE$1(String msg, Exception e, String input$1) {
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error parsing '", "' to interval, ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{input$1, msg})), e);
    }

    private final Exception throwIAE$default$2$1() {
        return null;
    }

    private final void trimToNextState$1(byte b, Enumeration.Value next2, ObjectRef state$1, IntRef i$1) {
        if (Character.isWhitespace(b)) {
            ++i$1.elem;
        } else {
            state$1.elem = next2;
        }
    }

    private final String currentWord$1(String s$1, IntRef i$1) {
        String sep = "\\s+";
        String[] strings = s$1.split(sep);
        int lenRight = s$1.substring(i$1.elem, s$1.length()).split(sep).length;
        return strings[strings.length - lenRight];
    }

    private final boolean matchAt$1(int i, String str, String s$1) {
        boolean bl;
        if (i + str.length() > s$1.length()) {
            bl = false;
        } else {
            String string = s$1.substring(i, i + str.length());
            String string2 = str;
            bl = !(string != null ? !string.equals(string2) : string2 != null);
        }
        return bl;
    }

    private IntervalUtils$() {
        MODULE$ = this;
        this.yearStr = this.unitToUtf8(IntervalUtils$IntervalUnit$.MODULE$.YEAR());
        this.monthStr = this.unitToUtf8(IntervalUtils$IntervalUnit$.MODULE$.MONTH());
        this.weekStr = this.unitToUtf8(IntervalUtils$IntervalUnit$.MODULE$.WEEK());
        this.dayStr = this.unitToUtf8(IntervalUtils$IntervalUnit$.MODULE$.DAY());
        this.hourStr = this.unitToUtf8(IntervalUtils$IntervalUnit$.MODULE$.HOUR());
        this.minuteStr = this.unitToUtf8(IntervalUtils$IntervalUnit$.MODULE$.MINUTE());
        this.secondStr = this.unitToUtf8(IntervalUtils$IntervalUnit$.MODULE$.SECOND());
        this.millisStr = this.unitToUtf8(IntervalUtils$IntervalUnit$.MODULE$.MILLISECOND());
        this.microsStr = this.unitToUtf8(IntervalUtils$IntervalUnit$.MODULE$.MICROSECOND());
    }
}

