/*
 * Decompiled with CFR 0.152.
 */
package io.delta.standalone.internal.util;

import io.delta.standalone.internal.exception.DeltaErrors$;
import io.delta.standalone.internal.util.CaseInsensitiveMap$;
import io.delta.standalone.internal.util.SchemaUtils$ParquetSchemaConverter$;
import io.delta.standalone.types.ArrayType;
import io.delta.standalone.types.DataType;
import io.delta.standalone.types.MapType;
import io.delta.standalone.types.StructField;
import io.delta.standalone.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;

public final class SchemaUtils$ {
    public static final SchemaUtils$ MODULE$;

    static {
        new SchemaUtils$();
    }

    public void checkFieldNames(Seq<String> names) {
        SchemaUtils$ParquetSchemaConverter$.MODULE$.checkFieldNames(names);
        names.find((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$1) {
                return x$1.contains("\n");
            }
        }).foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply(String col) {
                throw DeltaErrors$.MODULE$.invalidColumnName(col);
            }
        });
    }

    public void checkUnenforceableNotNullConstraints(StructType schema2) {
        this.io$delta$standalone$internal$util$SchemaUtils$$traverseColumns$1((Seq)Seq$.MODULE$.empty(), schema2);
    }

    public boolean isWriteCompatible(StructType existingSchema, StructType newSchema) {
        return this.isStructWriteCompatible$1(existingSchema, newSchema);
    }

    private Map<String, StructField> toFieldMap(Seq<StructField> fields) {
        return CaseInsensitiveMap$.MODULE$.apply(((TraversableOnce)fields.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, StructField> apply(StructField field) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)field.getName()), (Object)field);
            }
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()));
    }

    public boolean io$delta$standalone$internal$util$SchemaUtils$$matchesNullableType(DataType dt) {
        boolean bl;
        block12: {
            block13: {
                boolean bl2;
                block14: {
                    block15: {
                        while (true) {
                            DataType s2;
                            DataType s1;
                            DataType dataType;
                            if ((dataType = dt) instanceof StructType) {
                                StructType structType = (StructType)dataType;
                                bl = Predef$.MODULE$.refArrayOps((Object[])structType.getFields()).forall((Function1)new Serializable(){
                                    public static final long serialVersionUID = 0L;

                                    public final boolean apply(StructField field) {
                                        return field.isNullable() && SchemaUtils$.MODULE$.io$delta$standalone$internal$util$SchemaUtils$$matchesNullableType(field.getDataType());
                                    }
                                });
                                break block12;
                            }
                            if (dataType instanceof ArrayType) {
                                boolean bl3;
                                ArrayType arrayType = (ArrayType)dataType;
                                DataType dataType2 = arrayType.getElementType();
                                if (dataType2 instanceof StructType) {
                                    StructType structType = (StructType)dataType2;
                                    if (arrayType.containsNull()) {
                                        dt = structType;
                                        continue;
                                    }
                                    bl3 = false;
                                } else {
                                    bl3 = arrayType.containsNull();
                                }
                                bl = bl3;
                                break block12;
                            }
                            if (!(dataType instanceof MapType)) break block13;
                            MapType mapType = (MapType)dataType;
                            Tuple2 tuple2 = new Tuple2((Object)mapType.getKeyType(), (Object)mapType.getValueType());
                            if (tuple2 != null) {
                                DataType s12 = (DataType)tuple2._1();
                                DataType s22 = (DataType)tuple2._2();
                                if (s12 instanceof StructType) {
                                    StructType structType = (StructType)s12;
                                    if (s22 instanceof StructType) {
                                        StructType structType2 = (StructType)s22;
                                        if (mapType.valueContainsNull() && this.io$delta$standalone$internal$util$SchemaUtils$$matchesNullableType(structType)) {
                                            dt = structType2;
                                            continue;
                                        }
                                        bl2 = false;
                                        break block14;
                                    }
                                }
                            }
                            if (tuple2 != null && (s1 = (DataType)tuple2._1()) instanceof StructType) {
                                StructType structType = (StructType)s1;
                                if (mapType.valueContainsNull()) {
                                    dt = structType;
                                    continue;
                                }
                                bl2 = false;
                                break block14;
                            }
                            if (tuple2 == null || !((s2 = (DataType)tuple2._2()) instanceof StructType)) break block15;
                            StructType structType = (StructType)s2;
                            if (!mapType.valueContainsNull()) break;
                            dt = structType;
                        }
                        bl2 = false;
                        break block14;
                    }
                    bl2 = true;
                }
                bl = bl2;
                break block12;
            }
            bl = true;
        }
        return bl;
    }

    private String prettyFieldName(Seq<String> columnPath) {
        return ((TraversableOnce)columnPath.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String n) {
                return n.contains(".") ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"`", "`"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{n})) : n;
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(".");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void io$delta$standalone$internal$util$SchemaUtils$$checkField$1(Seq path2, StructField f) {
        DataType dataType = f.getDataType();
        if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            if (!this.io$delta$standalone$internal$util$SchemaUtils$$matchesNullableType(arrayType.getElementType())) throw DeltaErrors$.MODULE$.nestedNotNullConstraint(this.prettyFieldName((Seq<String>)((Seq)path2.$colon$plus((Object)f.getName(), Seq$.MODULE$.canBuildFrom()))), arrayType.getElementType(), "element");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        } else if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            boolean keyTypeNullable = this.io$delta$standalone$internal$util$SchemaUtils$$matchesNullableType(mapType.getKeyType());
            boolean valueTypeNullable = this.io$delta$standalone$internal$util$SchemaUtils$$matchesNullableType(mapType.getValueType());
            if (!keyTypeNullable) throw DeltaErrors$.MODULE$.nestedNotNullConstraint(this.prettyFieldName((Seq<String>)((Seq)path2.$colon$plus((Object)f.getName(), Seq$.MODULE$.canBuildFrom()))), mapType.getKeyType(), "key");
            if (!valueTypeNullable) throw DeltaErrors$.MODULE$.nestedNotNullConstraint(this.prettyFieldName((Seq<String>)((Seq)path2.$colon$plus((Object)f.getName(), Seq$.MODULE$.canBuildFrom()))), mapType.getValueType(), "value");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public final void io$delta$standalone$internal$util$SchemaUtils$$traverseColumns$1(Seq path2, DataType dt) {
        DataType dataType = dt;
        if (dataType instanceof StructType) {
            StructType structType = (StructType)dataType;
            Predef$.MODULE$.refArrayOps((Object[])structType.getFields()).foreach((Function1)new Serializable(path2){
                public static final long serialVersionUID = 0L;
                private final Seq path$1;

                public final void apply(StructField field) {
                    SchemaUtils$.MODULE$.io$delta$standalone$internal$util$SchemaUtils$$checkField$1(this.path$1, field);
                    SchemaUtils$.MODULE$.io$delta$standalone$internal$util$SchemaUtils$$traverseColumns$1((Seq)this.path$1.$colon$plus((Object)field.getName(), Seq$.MODULE$.canBuildFrom()), field.getDataType());
                }
                {
                    this.path$1 = path$1;
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (dataType instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)dataType;
            this.io$delta$standalone$internal$util$SchemaUtils$$traverseColumns$1((Seq)path2.$colon$plus((Object)"element", Seq$.MODULE$.canBuildFrom()), arrayType.getElementType());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            this.io$delta$standalone$internal$util$SchemaUtils$$traverseColumns$1((Seq)path2.$colon$plus((Object)"key", Seq$.MODULE$.canBuildFrom()), mapType.getKeyType());
            this.io$delta$standalone$internal$util$SchemaUtils$$traverseColumns$1((Seq)path2.$colon$plus((Object)"value", Seq$.MODULE$.canBuildFrom()), mapType.getValueType());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public final boolean io$delta$standalone$internal$util$SchemaUtils$$isDatatypeWriteCompatible$1(DataType _existingType, DataType _newType) {
        Tuple2 tuple2;
        block13: {
            boolean bl;
            block11: {
                block12: {
                    while (true) {
                        if ((tuple2 = new Tuple2((Object)_existingType, (Object)_newType)) != null) {
                            DataType e = (DataType)tuple2._1();
                            DataType n = (DataType)tuple2._2();
                            if (e instanceof StructType) {
                                StructType structType = (StructType)e;
                                if (n instanceof StructType) {
                                    StructType structType2 = (StructType)n;
                                    bl = this.isWriteCompatible(structType, structType2);
                                    break block11;
                                }
                            }
                        }
                        if (tuple2 != null) {
                            DataType e = (DataType)tuple2._1();
                            DataType n = (DataType)tuple2._2();
                            if (e instanceof ArrayType) {
                                ArrayType arrayType = (ArrayType)e;
                                if (n instanceof ArrayType) {
                                    ArrayType arrayType2 = (ArrayType)n;
                                    if (arrayType.containsNull() && !arrayType2.containsNull()) {
                                        bl = false;
                                        break block11;
                                    }
                                    _newType = arrayType2.getElementType();
                                    _existingType = arrayType.getElementType();
                                    continue;
                                }
                            }
                        }
                        if (tuple2 == null) break block12;
                        DataType e = (DataType)tuple2._1();
                        DataType n = (DataType)tuple2._2();
                        if (!(e instanceof MapType)) break block12;
                        MapType mapType = (MapType)e;
                        if (!(n instanceof MapType)) break block12;
                        MapType mapType2 = (MapType)n;
                        if (mapType.valueContainsNull() && !mapType2.valueContainsNull() || !this.io$delta$standalone$internal$util$SchemaUtils$$isDatatypeWriteCompatible$1(mapType.getKeyType(), mapType2.getKeyType())) break;
                        _newType = mapType2.getValueType();
                        _existingType = mapType.getValueType();
                    }
                    bl = false;
                    break block11;
                }
                if (tuple2 == null) break block13;
                DataType a = (DataType)tuple2._1();
                DataType b = (DataType)tuple2._2();
                DataType dataType = a;
                DataType dataType2 = b;
                bl = !(dataType != null ? !((Object)dataType).equals(dataType2) : dataType2 != null);
            }
            return bl;
        }
        throw new MatchError((Object)tuple2);
    }

    private final boolean isStructWriteCompatible$1(StructType _existingSchema, StructType _newSchema) {
        Map<String, StructField> existing = this.toFieldMap((Seq<StructField>)Predef$.MODULE$.wrapRefArray((Object[])_existingSchema.getFields()));
        Set existingFieldNames = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])_existingSchema.getFieldNames()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$2) {
                return x$2.toLowerCase();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toSet();
        Predef$.MODULE$.assert(existingFieldNames.size() == _existingSchema.length(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Delta tables don't allow field names that only differ by case";
            }
        });
        Set newFields = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])_newSchema.getFieldNames()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$3) {
                return x$3.toLowerCase();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toSet();
        Predef$.MODULE$.assert(newFields.size() == _newSchema.length(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Delta tables don't allow field names that only differ by case";
            }
        });
        if (existingFieldNames.subsetOf((GenSet)newFields)) {
            return Predef$.MODULE$.refArrayOps((Object[])_newSchema.getFields()).forall((Function1)new Serializable(existing){
                public static final long serialVersionUID = 0L;
                private final Map existing$1;

                public final boolean apply(StructField newField) {
                    return this.existing$1.get((Object)newField.getName()).forall((Function1)new Serializable(this, newField){
                        public static final long serialVersionUID = 0L;
                        private final StructField newField$1;

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final boolean apply(StructField existingField) {
                            String string = existingField.getName();
                            String string2 = this.newField$1.getName();
                            if (string == null) {
                                if (string2 != null) {
                                    return false;
                                }
                            } else if (!string.equals(string2)) return false;
                            if (existingField.isNullable()) {
                                if (!this.newField$1.isNullable()) return false;
                            }
                            if (!SchemaUtils$.MODULE$.io$delta$standalone$internal$util$SchemaUtils$$isDatatypeWriteCompatible$1(existingField.getDataType(), this.newField$1.getDataType())) return false;
                            return true;
                        }
                        {
                            this.newField$1 = newField$1;
                        }
                    });
                }
                {
                    this.existing$1 = existing$1;
                }
            });
        }
        return false;
    }

    private SchemaUtils$() {
        MODULE$ = this;
    }
}

