/*
 * Decompiled with CFR 0.152.
 */
package shadedelta.com.fasterxml.jackson.databind.deser.impl;

import java.io.IOException;
import shadedelta.com.fasterxml.jackson.core.JsonProcessingException;
import shadedelta.com.fasterxml.jackson.databind.deser.SettableAnyProperty;
import shadedelta.com.fasterxml.jackson.databind.deser.SettableBeanProperty;

public abstract class PropertyValue {
    public final PropertyValue next;
    public final Object value;

    protected PropertyValue(PropertyValue next2, Object value) {
        this.next = next2;
        this.value = value;
    }

    public abstract void assign(Object var1) throws IOException, JsonProcessingException;

    static final class Map
    extends PropertyValue {
        final Object _key;

        public Map(PropertyValue next2, Object value, Object key) {
            super(next2, value);
            this._key = key;
        }

        @Override
        public void assign(Object bean) throws IOException, JsonProcessingException {
            ((java.util.Map)bean).put(this._key, this.value);
        }
    }

    static final class Any
    extends PropertyValue {
        final SettableAnyProperty _property;
        final String _propertyName;

        public Any(PropertyValue next2, Object value, SettableAnyProperty prop, String propName) {
            super(next2, value);
            this._property = prop;
            this._propertyName = propName;
        }

        @Override
        public void assign(Object bean) throws IOException, JsonProcessingException {
            this._property.set(bean, this._propertyName, this.value);
        }
    }

    static final class Regular
    extends PropertyValue {
        final SettableBeanProperty _property;

        public Regular(PropertyValue next2, Object value, SettableBeanProperty prop) {
            super(next2, value);
            this._property = prop;
        }

        @Override
        public void assign(Object bean) throws IOException, JsonProcessingException {
            this._property.set(bean, this.value);
        }
    }
}

