/*
 * Decompiled with CFR 0.152.
 */
package shadedelta.com.github.mjakubowski84.parquet4s;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import scala.MatchError;
import shadedelta.com.github.mjakubowski84.parquet4s.BinaryValue;
import shadedelta.com.github.mjakubowski84.parquet4s.BinaryValue$;
import shadedelta.com.github.mjakubowski84.parquet4s.IntValue;
import shadedelta.com.github.mjakubowski84.parquet4s.Value;
import shadedelta.com.github.mjakubowski84.parquet4s.ValueCodecConfiguration;
import shadedelta.org.apache.parquet.io.api.Binary;

public final class TimeValueCodecs$ {
    public static final TimeValueCodecs$ MODULE$;
    private final int JulianDayOfEpoch;
    private final long MicrosPerMilli;
    private final long NanosPerMicro;
    private final long NanosPerMilli;
    private final long NanosPerDay;

    static {
        new TimeValueCodecs$();
    }

    public int JulianDayOfEpoch() {
        return this.JulianDayOfEpoch;
    }

    public long MicrosPerMilli() {
        return this.MicrosPerMilli;
    }

    public long NanosPerMicro() {
        return this.NanosPerMicro;
    }

    public long NanosPerMilli() {
        return this.NanosPerMilli;
    }

    public long NanosPerDay() {
        return this.NanosPerDay;
    }

    public LocalDateTime com$github$mjakubowski84$parquet4s$TimeValueCodecs$$decodeLocalDateTime(Value value, ValueCodecConfiguration configuration) {
        Value value2 = value;
        if (value2 instanceof BinaryValue) {
            LocalDateTime localDateTime;
            BinaryValue binaryValue = (BinaryValue)value2;
            Binary binary = binaryValue.value();
            ByteBuffer buf = ByteBuffer.wrap(binary.getBytes()).order(ByteOrder.LITTLE_ENDIAN);
            long fixedTimeInNanos = buf.getLong();
            int julianDay = buf.getInt();
            LocalDate date = LocalDate.ofEpochDay(julianDay - this.JulianDayOfEpoch());
            long fixedTimeInMillis = Math.floorDiv(fixedTimeInNanos, this.NanosPerMilli());
            long nanosLeft = Math.floorMod(fixedTimeInNanos, this.NanosPerMilli());
            long timeInMillis = fixedTimeInMillis + (long)configuration.timeZone().getRawOffset();
            long timeInNanos = timeInMillis * this.NanosPerMilli() + nanosLeft;
            if (timeInNanos >= this.NanosPerDay()) {
                LocalTime time = LocalTime.ofNanoOfDay(timeInNanos - this.NanosPerDay());
                localDateTime = LocalDateTime.of(date.plusDays(1L), time);
            } else if (timeInNanos < 0L) {
                LocalTime time = LocalTime.ofNanoOfDay(timeInNanos + this.NanosPerDay());
                localDateTime = LocalDateTime.of(date.minusDays(1L), time);
            } else {
                LocalTime time = LocalTime.ofNanoOfDay(timeInNanos);
                localDateTime = LocalDateTime.of(date, time);
            }
            LocalDateTime localDateTime2 = localDateTime;
            return localDateTime2;
        }
        throw new MatchError((Object)value2);
    }

    public Value com$github$mjakubowski84$parquet4s$TimeValueCodecs$$encodeLocalDateTime(LocalDateTime data, ValueCodecConfiguration configuration) {
        LocalDate date = data.toLocalDate();
        LocalTime time = data.toLocalTime();
        int julianDay = this.JulianDayOfEpoch() + (int)date.toEpochDay();
        long timeInNanos = time.toNanoOfDay();
        long timeInMillis = Math.floorDiv(timeInNanos, this.NanosPerMilli());
        long nanosLeft = Math.floorMod(timeInNanos, this.NanosPerMilli());
        long fixedTimeInMillis = timeInMillis - (long)configuration.timeZone().getRawOffset();
        long fixedTimeInNanos = fixedTimeInMillis * this.NanosPerMilli() + nanosLeft;
        ByteBuffer buf = ByteBuffer.allocate(12).order(ByteOrder.LITTLE_ENDIAN);
        buf.putLong(fixedTimeInNanos);
        buf.putInt(julianDay);
        return BinaryValue$.MODULE$.apply(buf.array());
    }

    public LocalDate com$github$mjakubowski84$parquet4s$TimeValueCodecs$$decodeLocalDate(Value value) {
        Value value2 = value;
        if (value2 instanceof IntValue) {
            int n;
            int epochDay = n = ((IntValue)value2).value();
            LocalDate localDate = LocalDate.ofEpochDay(epochDay);
            return localDate;
        }
        throw new MatchError((Object)value2);
    }

    public Value com$github$mjakubowski84$parquet4s$TimeValueCodecs$$encodeLocalDate(LocalDate data) {
        return new IntValue((int)data.toEpochDay());
    }

    private TimeValueCodecs$() {
        MODULE$ = this;
        this.JulianDayOfEpoch = 2440588;
        this.MicrosPerMilli = 1000L;
        this.NanosPerMicro = 1000L;
        this.NanosPerMilli = this.NanosPerMicro() * this.MicrosPerMilli();
        this.NanosPerDay = 86400000000000L;
    }
}

