/*
 * Decompiled with CFR 0.152.
 */
package shadedelta.org.apache.parquet.column.impl;

import java.util.Optional;
import java.util.PrimitiveIterator;
import shadedelta.org.apache.parquet.VersionParser;
import shadedelta.org.apache.parquet.column.ColumnDescriptor;
import shadedelta.org.apache.parquet.column.ColumnReadStore;
import shadedelta.org.apache.parquet.column.ColumnReader;
import shadedelta.org.apache.parquet.column.impl.ColumnReaderImpl;
import shadedelta.org.apache.parquet.column.impl.SynchronizingColumnReader;
import shadedelta.org.apache.parquet.column.page.PageReadStore;
import shadedelta.org.apache.parquet.column.page.PageReader;
import shadedelta.org.apache.parquet.io.api.Converter;
import shadedelta.org.apache.parquet.io.api.GroupConverter;
import shadedelta.org.apache.parquet.io.api.PrimitiveConverter;
import shadedelta.org.apache.parquet.schema.GroupType;
import shadedelta.org.apache.parquet.schema.MessageType;
import shadedelta.org.apache.parquet.schema.Type;

public class ColumnReadStoreImpl
implements ColumnReadStore {
    private final PageReadStore pageReadStore;
    private final GroupConverter recordConverter;
    private final MessageType schema;
    private final VersionParser.ParsedVersion writerVersion;

    public ColumnReadStoreImpl(PageReadStore pageReadStore, GroupConverter recordConverter, MessageType schema2, String createdBy) {
        VersionParser.ParsedVersion version;
        this.pageReadStore = pageReadStore;
        this.recordConverter = recordConverter;
        this.schema = schema2;
        try {
            version = VersionParser.parse(createdBy);
        }
        catch (RuntimeException | VersionParser.VersionParseException e) {
            version = null;
        }
        this.writerVersion = version;
    }

    @Override
    public ColumnReader getColumnReader(ColumnDescriptor path2) {
        PrimitiveConverter converter = this.getPrimitiveConverter(path2);
        PageReader pageReader = this.pageReadStore.getPageReader(path2);
        Optional<PrimitiveIterator.OfLong> rowIndexes = this.pageReadStore.getRowIndexes();
        if (rowIndexes.isPresent()) {
            return new SynchronizingColumnReader(path2, pageReader, converter, this.writerVersion, rowIndexes.get());
        }
        return new ColumnReaderImpl(path2, pageReader, converter, this.writerVersion);
    }

    private ColumnReaderImpl newMemColumnReader(ColumnDescriptor path2, PageReader pageReader) {
        PrimitiveConverter converter = this.getPrimitiveConverter(path2);
        return new ColumnReaderImpl(path2, pageReader, converter, this.writerVersion);
    }

    private PrimitiveConverter getPrimitiveConverter(ColumnDescriptor path2) {
        Type currentType = this.schema;
        Converter currentConverter = this.recordConverter;
        for (String fieldName2 : path2.getPath()) {
            GroupType groupType = currentType.asGroupType();
            int fieldIndex = groupType.getFieldIndex(fieldName2);
            currentType = groupType.getType(fieldName2);
            currentConverter = ((Converter)currentConverter).asGroupConverter().getConverter(fieldIndex);
        }
        PrimitiveConverter converter = currentConverter.asPrimitiveConverter();
        return converter;
    }
}

