/*
 * Decompiled with CFR 0.152.
 */
package shadedelta.org.apache.parquet.column.impl;

import java.io.IOException;
import shadedelta.org.apache.parquet.bytes.BytesInput;
import shadedelta.org.apache.parquet.column.ColumnDescriptor;
import shadedelta.org.apache.parquet.column.ParquetProperties;
import shadedelta.org.apache.parquet.column.impl.ColumnWriterBase;
import shadedelta.org.apache.parquet.column.page.PageWriter;
import shadedelta.org.apache.parquet.column.statistics.Statistics;
import shadedelta.org.apache.parquet.column.values.ValuesWriter;
import shadedelta.org.apache.parquet.column.values.bloomfilter.BloomFilterWriter;

final class ColumnWriterV1
extends ColumnWriterBase {
    ColumnWriterV1(ColumnDescriptor path2, PageWriter pageWriter, ParquetProperties props) {
        super(path2, pageWriter, props);
    }

    public ColumnWriterV1(ColumnDescriptor path2, PageWriter pageWriter, BloomFilterWriter bloomFilterWriter, ParquetProperties props) {
        super(path2, pageWriter, bloomFilterWriter, props);
    }

    @Override
    ValuesWriter createRLWriter(ParquetProperties props, ColumnDescriptor path2) {
        return props.newRepetitionLevelWriter(path2);
    }

    @Override
    ValuesWriter createDLWriter(ParquetProperties props, ColumnDescriptor path2) {
        return props.newDefinitionLevelWriter(path2);
    }

    @Override
    void writePage(int rowCount, int valueCount, Statistics<?> statistics, ValuesWriter repetitionLevels, ValuesWriter definitionLevels, ValuesWriter values2) throws IOException {
        this.pageWriter.writePage(BytesInput.concat(repetitionLevels.getBytes(), definitionLevels.getBytes(), values2.getBytes()), valueCount, rowCount, statistics, repetitionLevels.getEncoding(), definitionLevels.getEncoding(), values2.getEncoding());
    }
}

