/*
 * Decompiled with CFR 0.152.
 */
package shadedelta.org.apache.parquet.column.impl;

import java.io.IOException;
import shadedelta.org.apache.parquet.bytes.BytesInput;
import shadedelta.org.apache.parquet.column.ColumnDescriptor;
import shadedelta.org.apache.parquet.column.Encoding;
import shadedelta.org.apache.parquet.column.ParquetProperties;
import shadedelta.org.apache.parquet.column.impl.ColumnWriterBase;
import shadedelta.org.apache.parquet.column.page.PageWriter;
import shadedelta.org.apache.parquet.column.statistics.Statistics;
import shadedelta.org.apache.parquet.column.values.ValuesWriter;
import shadedelta.org.apache.parquet.column.values.bitpacking.DevNullValuesWriter;
import shadedelta.org.apache.parquet.column.values.bloomfilter.BloomFilterWriter;
import shadedelta.org.apache.parquet.column.values.rle.RunLengthBitPackingHybridEncoder;
import shadedelta.org.apache.parquet.column.values.rle.RunLengthBitPackingHybridValuesWriter;
import shadedelta.org.apache.parquet.io.ParquetEncodingException;

final class ColumnWriterV2
extends ColumnWriterBase {
    private static final ValuesWriter NULL_WRITER = new DevNullValuesWriter();

    ColumnWriterV2(ColumnDescriptor path2, PageWriter pageWriter, ParquetProperties props) {
        super(path2, pageWriter, props);
    }

    ColumnWriterV2(ColumnDescriptor path2, PageWriter pageWriter, BloomFilterWriter bloomFilterWriter, ParquetProperties props) {
        super(path2, pageWriter, bloomFilterWriter, props);
    }

    @Override
    ValuesWriter createRLWriter(ParquetProperties props, ColumnDescriptor path2) {
        return path2.getMaxRepetitionLevel() == 0 ? NULL_WRITER : new RLEWriterForV2(props.newRepetitionLevelEncoder(path2));
    }

    @Override
    ValuesWriter createDLWriter(ParquetProperties props, ColumnDescriptor path2) {
        return path2.getMaxDefinitionLevel() == 0 ? NULL_WRITER : new RLEWriterForV2(props.newDefinitionLevelEncoder(path2));
    }

    @Override
    void writePage(int rowCount, int valueCount, Statistics<?> statistics, ValuesWriter repetitionLevels, ValuesWriter definitionLevels, ValuesWriter values2) throws IOException {
        BytesInput bytes2 = values2.getBytes();
        Encoding encoding = values2.getEncoding();
        this.pageWriter.writePageV2(rowCount, Math.toIntExact(statistics.getNumNulls()), valueCount, repetitionLevels.getBytes(), definitionLevels.getBytes(), encoding, bytes2, statistics);
    }

    private static class RLEWriterForV2
    extends RunLengthBitPackingHybridValuesWriter {
        public RLEWriterForV2(RunLengthBitPackingHybridEncoder encoder) {
            super(encoder);
        }

        @Override
        public BytesInput getBytes() {
            try {
                return this.encoder.toBytes();
            }
            catch (IOException e) {
                throw new ParquetEncodingException(e);
            }
        }
    }
}

