/*
 * Decompiled with CFR 0.152.
 */
package shadedelta.org.apache.parquet.column.impl;

import java.util.PrimitiveIterator;
import shadedelta.org.apache.parquet.VersionParser;
import shadedelta.org.apache.parquet.column.ColumnDescriptor;
import shadedelta.org.apache.parquet.column.impl.ColumnReaderBase;
import shadedelta.org.apache.parquet.column.page.DataPage;
import shadedelta.org.apache.parquet.column.page.PageReader;
import shadedelta.org.apache.parquet.io.api.PrimitiveConverter;

class SynchronizingColumnReader
extends ColumnReaderBase {
    private final PrimitiveIterator.OfLong rowIndexes;
    private long currentRow;
    private long targetRow;
    private long lastRowInPage;
    private int valuesReadFromPage;

    SynchronizingColumnReader(ColumnDescriptor path2, PageReader pageReader, PrimitiveConverter converter, VersionParser.ParsedVersion writerVersion, PrimitiveIterator.OfLong rowIndexes) {
        super(path2, pageReader, converter, writerVersion);
        this.rowIndexes = rowIndexes;
        this.targetRow = Long.MIN_VALUE;
        this.consume();
    }

    @Override
    boolean isPageFullyConsumed() {
        return this.getPageValueCount() <= this.valuesReadFromPage || this.lastRowInPage < this.targetRow;
    }

    @Override
    boolean isFullyConsumed() {
        return !this.rowIndexes.hasNext();
    }

    @Override
    boolean skipRL(int rl) {
        ++this.valuesReadFromPage;
        if (rl == 0) {
            ++this.currentRow;
            if (this.currentRow > this.targetRow) {
                this.targetRow = this.rowIndexes.hasNext() ? this.rowIndexes.nextLong() : Long.MAX_VALUE;
            }
        }
        return this.currentRow < this.targetRow;
    }

    @Override
    protected void newPageInitialized(DataPage page) {
        long firstRowIndex = page.getFirstRowIndex().orElseThrow(() -> new IllegalArgumentException("Missing firstRowIndex for synchronizing values"));
        int rowCount = page.getIndexRowCount().orElseThrow(() -> new IllegalArgumentException("Missing rowCount for synchronizing values"));
        this.currentRow = firstRowIndex - 1L;
        this.lastRowInPage = firstRowIndex + (long)rowCount - 1L;
        this.valuesReadFromPage = 0;
    }
}

