/*
 * Decompiled with CFR 0.152.
 */
package shadedelta.org.apache.parquet.column.statistics;

import shadedelta.org.apache.parquet.bytes.BytesUtils;
import shadedelta.org.apache.parquet.column.statistics.Statistics;
import shadedelta.org.apache.parquet.schema.PrimitiveType;
import shadedelta.org.apache.parquet.schema.Types;

public class FloatStatistics
extends Statistics<Float> {
    private static final PrimitiveType DEFAULT_FAKE_TYPE = (PrimitiveType)Types.optional(PrimitiveType.PrimitiveTypeName.FLOAT).named("fake_float_type");
    private float max;
    private float min;

    @Deprecated
    public FloatStatistics() {
        this(DEFAULT_FAKE_TYPE);
    }

    FloatStatistics(PrimitiveType type) {
        super(type);
    }

    private FloatStatistics(FloatStatistics other) {
        super(other.type());
        if (other.hasNonNullValue()) {
            this.initializeStats(other.min, other.max);
        }
        this.setNumNulls(other.getNumNulls());
    }

    @Override
    public void updateStats(float value) {
        if (!this.hasNonNullValue()) {
            this.initializeStats(value, value);
        } else {
            this.updateStats(value, value);
        }
    }

    @Override
    public void mergeStatisticsMinMax(Statistics stats) {
        FloatStatistics floatStats = (FloatStatistics)stats;
        if (!this.hasNonNullValue()) {
            this.initializeStats(floatStats.getMin(), floatStats.getMax());
        } else {
            this.updateStats(floatStats.getMin(), floatStats.getMax());
        }
    }

    @Override
    public void setMinMaxFromBytes(byte[] minBytes, byte[] maxBytes) {
        this.max = Float.intBitsToFloat(BytesUtils.bytesToInt(maxBytes));
        this.min = Float.intBitsToFloat(BytesUtils.bytesToInt(minBytes));
        this.markAsNotEmpty();
    }

    @Override
    public byte[] getMaxBytes() {
        return BytesUtils.intToBytes(Float.floatToIntBits(this.max));
    }

    @Override
    public byte[] getMinBytes() {
        return BytesUtils.intToBytes(Float.floatToIntBits(this.min));
    }

    @Override
    String stringify(Float value) {
        return this.stringifier.stringify(value.floatValue());
    }

    @Override
    public boolean isSmallerThan(long size) {
        return !this.hasNonNullValue() || 8L < size;
    }

    public void updateStats(float min_value, float max_value) {
        if (this.comparator().compare(this.min, min_value) > 0) {
            this.min = min_value;
        }
        if (this.comparator().compare(this.max, max_value) < 0) {
            this.max = max_value;
        }
    }

    public void initializeStats(float min_value, float max_value) {
        this.min = min_value;
        this.max = max_value;
        this.markAsNotEmpty();
    }

    @Override
    public Float genericGetMin() {
        return Float.valueOf(this.min);
    }

    @Override
    public Float genericGetMax() {
        return Float.valueOf(this.max);
    }

    @Override
    public int compareMinToValue(float value) {
        return this.comparator().compare(this.min, value);
    }

    @Override
    public int compareMaxToValue(float value) {
        return this.comparator().compare(this.max, value);
    }

    public float getMax() {
        return this.max;
    }

    public float getMin() {
        return this.min;
    }

    public void setMinMax(float min2, float max2) {
        this.max = max2;
        this.min = min2;
        this.markAsNotEmpty();
    }

    public FloatStatistics copy() {
        return new FloatStatistics(this);
    }
}

