/*
 * Decompiled with CFR 0.152.
 */
package shadedelta.org.apache.parquet.column.values.factory;

import shadedelta.org.apache.parquet.column.ColumnDescriptor;
import shadedelta.org.apache.parquet.column.Encoding;
import shadedelta.org.apache.parquet.column.ParquetProperties;
import shadedelta.org.apache.parquet.column.values.ValuesWriter;
import shadedelta.org.apache.parquet.column.values.dictionary.DictionaryValuesWriter;
import shadedelta.org.apache.parquet.column.values.factory.DefaultV1ValuesWriterFactory;
import shadedelta.org.apache.parquet.column.values.factory.DefaultV2ValuesWriterFactory;
import shadedelta.org.apache.parquet.column.values.factory.ValuesWriterFactory;
import shadedelta.org.apache.parquet.column.values.fallback.FallbackValuesWriter;

public class DefaultValuesWriterFactory
implements ValuesWriterFactory {
    private ValuesWriterFactory delegateFactory;
    private static final ValuesWriterFactory DEFAULT_V1_WRITER_FACTORY = new DefaultV1ValuesWriterFactory();
    private static final ValuesWriterFactory DEFAULT_V2_WRITER_FACTORY = new DefaultV2ValuesWriterFactory();

    @Override
    public void initialize(ParquetProperties properties) {
        this.delegateFactory = properties.getWriterVersion() == ParquetProperties.WriterVersion.PARQUET_1_0 ? DEFAULT_V1_WRITER_FACTORY : DEFAULT_V2_WRITER_FACTORY;
        this.delegateFactory.initialize(properties);
    }

    @Override
    public ValuesWriter newValuesWriter(ColumnDescriptor descriptor) {
        return this.delegateFactory.newValuesWriter(descriptor);
    }

    static DictionaryValuesWriter dictionaryWriter(ColumnDescriptor path2, ParquetProperties properties, Encoding dictPageEncoding, Encoding dataPageEncoding) {
        switch (path2.getType()) {
            case BOOLEAN: {
                throw new IllegalArgumentException("no dictionary encoding for BOOLEAN");
            }
            case BINARY: {
                return new DictionaryValuesWriter.PlainBinaryDictionaryValuesWriter(properties.getDictionaryPageSizeThreshold(), dataPageEncoding, dictPageEncoding, properties.getAllocator());
            }
            case INT32: {
                return new DictionaryValuesWriter.PlainIntegerDictionaryValuesWriter(properties.getDictionaryPageSizeThreshold(), dataPageEncoding, dictPageEncoding, properties.getAllocator());
            }
            case INT64: {
                return new DictionaryValuesWriter.PlainLongDictionaryValuesWriter(properties.getDictionaryPageSizeThreshold(), dataPageEncoding, dictPageEncoding, properties.getAllocator());
            }
            case INT96: {
                return new DictionaryValuesWriter.PlainFixedLenArrayDictionaryValuesWriter(properties.getDictionaryPageSizeThreshold(), 12, dataPageEncoding, dictPageEncoding, properties.getAllocator());
            }
            case DOUBLE: {
                return new DictionaryValuesWriter.PlainDoubleDictionaryValuesWriter(properties.getDictionaryPageSizeThreshold(), dataPageEncoding, dictPageEncoding, properties.getAllocator());
            }
            case FLOAT: {
                return new DictionaryValuesWriter.PlainFloatDictionaryValuesWriter(properties.getDictionaryPageSizeThreshold(), dataPageEncoding, dictPageEncoding, properties.getAllocator());
            }
            case FIXED_LEN_BYTE_ARRAY: {
                return new DictionaryValuesWriter.PlainFixedLenArrayDictionaryValuesWriter(properties.getDictionaryPageSizeThreshold(), path2.getTypeLength(), dataPageEncoding, dictPageEncoding, properties.getAllocator());
            }
        }
        throw new IllegalArgumentException("Unknown type " + (Object)((Object)path2.getType()));
    }

    static ValuesWriter dictWriterWithFallBack(ColumnDescriptor path2, ParquetProperties parquetProperties, Encoding dictPageEncoding, Encoding dataPageEncoding, ValuesWriter writerToFallBackTo) {
        if (parquetProperties.isDictionaryEnabled(path2)) {
            return FallbackValuesWriter.of(DefaultValuesWriterFactory.dictionaryWriter(path2, parquetProperties, dictPageEncoding, dataPageEncoding), writerToFallBackTo);
        }
        return writerToFallBackTo;
    }
}

