/*
 * Decompiled with CFR 0.152.
 */
package shadedelta.org.apache.parquet.example.data;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shadedelta.org.apache.parquet.example.data.GroupValueSource;
import shadedelta.org.apache.parquet.example.data.simple.NanoTime;
import shadedelta.org.apache.parquet.io.api.Binary;
import shadedelta.org.apache.parquet.io.api.RecordConsumer;

public abstract class Group
extends GroupValueSource {
    private static final Logger LOG = LoggerFactory.getLogger(Group.class);

    public void add(String field, int value) {
        this.add(this.getType().getFieldIndex(field), value);
    }

    public void add(String field, long value) {
        this.add(this.getType().getFieldIndex(field), value);
    }

    public void add(String field, float value) {
        this.add(this.getType().getFieldIndex(field), value);
    }

    public void add(String field, double value) {
        this.add(this.getType().getFieldIndex(field), value);
    }

    public void add(String field, String value) {
        this.add(this.getType().getFieldIndex(field), value);
    }

    public void add(String field, NanoTime value) {
        this.add(this.getType().getFieldIndex(field), value);
    }

    public void add(String field, boolean value) {
        this.add(this.getType().getFieldIndex(field), value);
    }

    public void add(String field, Binary value) {
        this.add(this.getType().getFieldIndex(field), value);
    }

    public void add(String field, Group value) {
        this.add(this.getType().getFieldIndex(field), value);
    }

    public Group addGroup(String field) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("add group {} to {}", (Object)field, (Object)this.getType().getName());
        }
        return this.addGroup(this.getType().getFieldIndex(field));
    }

    @Override
    public Group getGroup(String field, int index) {
        return this.getGroup(this.getType().getFieldIndex(field), index);
    }

    public abstract void add(int var1, int var2);

    public abstract void add(int var1, long var2);

    public abstract void add(int var1, String var2);

    public abstract void add(int var1, boolean var2);

    public abstract void add(int var1, NanoTime var2);

    public abstract void add(int var1, Binary var2);

    public abstract void add(int var1, float var2);

    public abstract void add(int var1, double var2);

    public abstract void add(int var1, Group var2);

    public abstract Group addGroup(int var1);

    @Override
    public abstract Group getGroup(int var1, int var2);

    public Group asGroup() {
        return this;
    }

    public Group append(String fieldName2, int value) {
        this.add(fieldName2, value);
        return this;
    }

    public Group append(String fieldName2, float value) {
        this.add(fieldName2, value);
        return this;
    }

    public Group append(String fieldName2, double value) {
        this.add(fieldName2, value);
        return this;
    }

    public Group append(String fieldName2, long value) {
        this.add(fieldName2, value);
        return this;
    }

    public Group append(String fieldName2, NanoTime value) {
        this.add(fieldName2, value);
        return this;
    }

    public Group append(String fieldName2, String value) {
        this.add(fieldName2, Binary.fromString(value));
        return this;
    }

    public Group append(String fieldName2, boolean value) {
        this.add(fieldName2, value);
        return this;
    }

    public Group append(String fieldName2, Binary value) {
        this.add(fieldName2, value);
        return this;
    }

    public abstract void writeValue(int var1, int var2, RecordConsumer var3);
}

