/*
 * Decompiled with CFR 0.152.
 */
package shadedelta.org.apache.parquet.format.event;

import shadedelta.org.apache.parquet.format.event.EventBasedThriftReader;
import shadedelta.shaded.parquet.org.apache.thrift.TException;
import shadedelta.shaded.parquet.org.apache.thrift.protocol.TList;
import shadedelta.shaded.parquet.org.apache.thrift.protocol.TMap;
import shadedelta.shaded.parquet.org.apache.thrift.protocol.TProtocol;
import shadedelta.shaded.parquet.org.apache.thrift.protocol.TSet;

public abstract class TypedConsumer {
    public final byte type;

    private TypedConsumer(byte type) {
        this.type = type;
    }

    public final void read(TProtocol protocol2, EventBasedThriftReader reader, byte type) throws TException {
        if (this.type != type) {
            throw new TException("Incorrect type in stream. Expected " + this.type + " but got " + type);
        }
        this.read(protocol2, reader);
    }

    abstract void read(TProtocol var1, EventBasedThriftReader var2) throws TException;

    public static abstract class MapConsumer
    extends TypedConsumer {
        protected MapConsumer() {
            super((byte)13);
        }

        @Override
        final void read(TProtocol protocol2, EventBasedThriftReader reader) throws TException {
            this.consumeMap(protocol2, reader, protocol2.readMapBegin());
            protocol2.readMapEnd();
        }

        public void consumeMap(TProtocol protocol2, EventBasedThriftReader reader, TMap tMap) throws TException {
            reader.readMapContent(this, tMap);
        }

        public abstract void consumeEntry(TProtocol var1, EventBasedThriftReader var2, byte var3, byte var4) throws TException;
    }

    public static abstract class SetConsumer
    extends TypedConsumer {
        protected SetConsumer() {
            super((byte)14);
        }

        @Override
        final void read(TProtocol protocol2, EventBasedThriftReader reader) throws TException {
            this.consumeSet(protocol2, reader, protocol2.readSetBegin());
            protocol2.readSetEnd();
        }

        public void consumeSet(TProtocol protocol2, EventBasedThriftReader reader, TSet tSet) throws TException {
            reader.readSetContent(this, tSet);
        }

        public abstract void consumeElement(TProtocol var1, EventBasedThriftReader var2, byte var3) throws TException;
    }

    public static abstract class ListConsumer
    extends TypedConsumer {
        protected ListConsumer() {
            super((byte)15);
        }

        @Override
        final void read(TProtocol protocol2, EventBasedThriftReader reader) throws TException {
            this.consumeList(protocol2, reader, protocol2.readListBegin());
            protocol2.readListEnd();
        }

        public void consumeList(TProtocol protocol2, EventBasedThriftReader reader, TList tList) throws TException {
            reader.readListContent(this, tList);
        }

        public abstract void consumeElement(TProtocol var1, EventBasedThriftReader var2, byte var3) throws TException;
    }

    public static abstract class StructConsumer
    extends TypedConsumer {
        protected StructConsumer() {
            super((byte)12);
        }

        @Override
        final void read(TProtocol protocol2, EventBasedThriftReader reader) throws TException {
            this.consumeStruct(protocol2, reader);
        }

        public abstract void consumeStruct(TProtocol var1, EventBasedThriftReader var2) throws TException;
    }

    public static abstract class StringConsumer
    extends TypedConsumer {
        protected StringConsumer() {
            super((byte)11);
        }

        @Override
        final void read(TProtocol protocol2, EventBasedThriftReader reader) throws TException {
            this.consume(protocol2.readString());
        }

        public abstract void consume(String var1);
    }

    public static abstract class I16Consumer
    extends TypedConsumer {
        protected I16Consumer() {
            super((byte)6);
        }

        @Override
        final void read(TProtocol protocol2, EventBasedThriftReader reader) throws TException {
            this.consume(protocol2.readI16());
        }

        public abstract void consume(short var1);
    }

    public static abstract class I64Consumer
    extends TypedConsumer {
        protected I64Consumer() {
            super((byte)10);
        }

        @Override
        final void read(TProtocol protocol2, EventBasedThriftReader reader) throws TException {
            this.consume(protocol2.readI64());
        }

        public abstract void consume(long var1);
    }

    public static abstract class I32Consumer
    extends TypedConsumer {
        protected I32Consumer() {
            super((byte)8);
        }

        @Override
        final void read(TProtocol protocol2, EventBasedThriftReader reader) throws TException {
            this.consume(protocol2.readI32());
        }

        public abstract void consume(int var1);
    }

    public static abstract class BoolConsumer
    extends TypedConsumer {
        protected BoolConsumer() {
            super((byte)2);
        }

        @Override
        final void read(TProtocol protocol2, EventBasedThriftReader reader) throws TException {
            this.consume(protocol2.readBool());
        }

        public abstract void consume(boolean var1);
    }

    public static abstract class ByteConsumer
    extends TypedConsumer {
        protected ByteConsumer() {
            super((byte)3);
        }

        @Override
        final void read(TProtocol protocol2, EventBasedThriftReader reader) throws TException {
            this.consume(protocol2.readByte());
        }

        public abstract void consume(byte var1);
    }

    public static abstract class DoubleConsumer
    extends TypedConsumer {
        protected DoubleConsumer() {
            super((byte)4);
        }

        @Override
        final void read(TProtocol protocol2, EventBasedThriftReader reader) throws TException {
            this.consume(protocol2.readDouble());
        }

        public abstract void consume(double var1);
    }
}

