/*
 * Decompiled with CFR 0.152.
 */
package shadedelta.org.apache.parquet.hadoop;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shadedelta.org.apache.parquet.HadoopReadOptions;
import shadedelta.org.apache.parquet.ParquetReadOptions;
import shadedelta.org.apache.parquet.column.page.PageReadStore;
import shadedelta.org.apache.parquet.filter.UnboundRecordFilter;
import shadedelta.org.apache.parquet.filter2.compat.FilterCompat;
import shadedelta.org.apache.parquet.hadoop.ParquetFileReader;
import shadedelta.org.apache.parquet.hadoop.UnmaterializableRecordCounter;
import shadedelta.org.apache.parquet.hadoop.api.InitContext;
import shadedelta.org.apache.parquet.hadoop.api.ReadSupport;
import shadedelta.org.apache.parquet.hadoop.metadata.FileMetaData;
import shadedelta.org.apache.parquet.hadoop.util.counters.BenchmarkCounter;
import shadedelta.org.apache.parquet.io.ColumnIOFactory;
import shadedelta.org.apache.parquet.io.MessageColumnIO;
import shadedelta.org.apache.parquet.io.ParquetDecodingException;
import shadedelta.org.apache.parquet.io.RecordReader;
import shadedelta.org.apache.parquet.io.api.RecordMaterializer;
import shadedelta.org.apache.parquet.schema.MessageType;

class InternalParquetRecordReader<T> {
    private static final Logger LOG = LoggerFactory.getLogger(InternalParquetRecordReader.class);
    private ColumnIOFactory columnIOFactory = null;
    private final FilterCompat.Filter filter;
    private boolean filterRecords = true;
    private MessageType requestedSchema;
    private MessageType fileSchema;
    private int columnCount;
    private final ReadSupport<T> readSupport;
    private RecordMaterializer<T> recordConverter;
    private T currentValue;
    private long total;
    private long current = 0L;
    private int currentBlock = -1;
    private ParquetFileReader reader;
    private RecordReader<T> recordReader;
    private boolean strictTypeChecking;
    private long totalTimeSpentReadingBytes;
    private long totalTimeSpentProcessingRecords;
    private long startedAssemblingCurrentBlockAt;
    private long totalCountLoadedSoFar = 0L;
    private UnmaterializableRecordCounter unmaterializableRecordCounter;

    public InternalParquetRecordReader(ReadSupport<T> readSupport, FilterCompat.Filter filter2) {
        this.readSupport = readSupport;
        this.filter = filter2 == null ? FilterCompat.NOOP : filter2;
    }

    public InternalParquetRecordReader(ReadSupport<T> readSupport) {
        this(readSupport, FilterCompat.NOOP);
    }

    @Deprecated
    public InternalParquetRecordReader(ReadSupport<T> readSupport, UnboundRecordFilter filter2) {
        this(readSupport, FilterCompat.get(filter2));
    }

    private void checkRead() throws IOException {
        if (this.current == this.totalCountLoadedSoFar) {
            if (this.current != 0L) {
                this.totalTimeSpentProcessingRecords += System.currentTimeMillis() - this.startedAssemblingCurrentBlockAt;
                if (LOG.isInfoEnabled()) {
                    LOG.info("Assembled and processed " + this.totalCountLoadedSoFar + " records from " + this.columnCount + " columns in " + this.totalTimeSpentProcessingRecords + " ms: " + (float)this.totalCountLoadedSoFar / (float)this.totalTimeSpentProcessingRecords + " rec/ms, " + (float)this.totalCountLoadedSoFar * (float)this.columnCount / (float)this.totalTimeSpentProcessingRecords + " cell/ms");
                    long totalTime = this.totalTimeSpentProcessingRecords + this.totalTimeSpentReadingBytes;
                    if (totalTime != 0L) {
                        long percentReading = 100L * this.totalTimeSpentReadingBytes / totalTime;
                        long percentProcessing = 100L * this.totalTimeSpentProcessingRecords / totalTime;
                        LOG.info("time spent so far " + percentReading + "% reading (" + this.totalTimeSpentReadingBytes + " ms) and " + percentProcessing + "% processing (" + this.totalTimeSpentProcessingRecords + " ms)");
                    }
                }
            }
            LOG.info("at row " + this.current + ". reading next block");
            long t0 = System.currentTimeMillis();
            PageReadStore pages = this.reader.readNextFilteredRowGroup();
            if (pages == null) {
                throw new IOException("expecting more rows but reached last block. Read " + this.current + " out of " + this.total);
            }
            long timeSpentReading = System.currentTimeMillis() - t0;
            this.totalTimeSpentReadingBytes += timeSpentReading;
            BenchmarkCounter.incrementTime(timeSpentReading);
            if (LOG.isInfoEnabled()) {
                LOG.info("block read in memory in {} ms. row count = {}", (Object)timeSpentReading, (Object)pages.getRowCount());
            }
            LOG.debug("initializing Record assembly with requested schema {}", (Object)this.requestedSchema);
            MessageColumnIO columnIO = this.columnIOFactory.getColumnIO(this.requestedSchema, this.fileSchema, this.strictTypeChecking);
            this.recordReader = columnIO.getRecordReader(pages, this.recordConverter, this.filterRecords ? this.filter : FilterCompat.NOOP);
            this.startedAssemblingCurrentBlockAt = System.currentTimeMillis();
            this.totalCountLoadedSoFar += pages.getRowCount();
            ++this.currentBlock;
        }
    }

    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }

    public Void getCurrentKey() throws IOException, InterruptedException {
        return null;
    }

    public T getCurrentValue() throws IOException, InterruptedException {
        return this.currentValue;
    }

    public float getProgress() throws IOException, InterruptedException {
        return (float)this.current / (float)this.total;
    }

    public void initialize(ParquetFileReader reader, ParquetReadOptions options) {
        Configuration conf = new Configuration();
        if (options instanceof HadoopReadOptions) {
            conf = ((HadoopReadOptions)options).getConf();
        }
        for (String property : options.getPropertyNames()) {
            conf.set(property, options.getProperty(property));
        }
        this.reader = reader;
        FileMetaData parquetFileMetadata = reader.getFooter().getFileMetaData();
        this.fileSchema = parquetFileMetadata.getSchema();
        Map<String, String> fileMetadata = parquetFileMetadata.getKeyValueMetaData();
        ReadSupport.ReadContext readContext = this.readSupport.init(new InitContext(conf, InternalParquetRecordReader.toSetMultiMap(fileMetadata), this.fileSchema));
        this.columnIOFactory = new ColumnIOFactory(parquetFileMetadata.getCreatedBy());
        this.requestedSchema = readContext.getRequestedSchema();
        this.columnCount = this.requestedSchema.getPaths().size();
        reader.setRequestedSchema(this.requestedSchema);
        this.recordConverter = this.readSupport.prepareForRead(conf, fileMetadata, this.fileSchema, readContext);
        this.strictTypeChecking = options.isEnabled("parquet.strict.typing", true);
        this.total = reader.getFilteredRecordCount();
        this.unmaterializableRecordCounter = new UnmaterializableRecordCounter(options, this.total);
        this.filterRecords = options.useRecordFilter();
        LOG.info("RecordReader initialized will read a total of {} records.", (Object)this.total);
    }

    public void initialize(ParquetFileReader reader, Configuration configuration) throws IOException {
        this.reader = reader;
        FileMetaData parquetFileMetadata = reader.getFooter().getFileMetaData();
        this.fileSchema = parquetFileMetadata.getSchema();
        Map<String, String> fileMetadata = parquetFileMetadata.getKeyValueMetaData();
        ReadSupport.ReadContext readContext = this.readSupport.init(new InitContext(configuration, InternalParquetRecordReader.toSetMultiMap(fileMetadata), this.fileSchema));
        this.columnIOFactory = new ColumnIOFactory(parquetFileMetadata.getCreatedBy());
        this.requestedSchema = readContext.getRequestedSchema();
        this.columnCount = this.requestedSchema.getPaths().size();
        reader.setRequestedSchema(this.requestedSchema);
        this.recordConverter = this.readSupport.prepareForRead(configuration, fileMetadata, this.fileSchema, readContext);
        this.strictTypeChecking = configuration.getBoolean("parquet.strict.typing", true);
        this.total = reader.getFilteredRecordCount();
        this.unmaterializableRecordCounter = new UnmaterializableRecordCounter(configuration, this.total);
        this.filterRecords = configuration.getBoolean("parquet.filter.record-level.enabled", true);
        LOG.info("RecordReader initialized will read a total of {} records.", (Object)this.total);
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        boolean recordFound = false;
        while (!recordFound) {
            if (this.current >= this.total) {
                return false;
            }
            try {
                this.checkRead();
                ++this.current;
                try {
                    this.currentValue = this.recordReader.read();
                }
                catch (RecordMaterializer.RecordMaterializationException e) {
                    this.unmaterializableRecordCounter.incErrors(e);
                    LOG.debug("skipping a corrupt record");
                    continue;
                }
                if (this.recordReader.shouldSkipCurrentRecord()) {
                    LOG.debug("skipping record");
                    continue;
                }
                if (this.currentValue == null) {
                    this.current = this.totalCountLoadedSoFar;
                    LOG.debug("filtered record reader reached end of block");
                    continue;
                }
                recordFound = true;
                LOG.debug("read value: {}", this.currentValue);
            }
            catch (RuntimeException e) {
                throw new ParquetDecodingException(String.format("Can not read value at %d in block %d in file %s", this.current, this.currentBlock, this.reader.getPath()), e);
            }
        }
        return true;
    }

    private static <K, V> Map<K, Set<V>> toSetMultiMap(Map<K, V> map2) {
        HashMap<K, Set<V>> setMultiMap = new HashMap<K, Set<V>>();
        for (Map.Entry<K, V> entry2 : map2.entrySet()) {
            setMultiMap.put(entry2.getKey(), Collections.singleton(entry2.getValue()));
        }
        return Collections.unmodifiableMap(setMultiMap);
    }
}

