/*
 * Decompiled with CFR 0.152.
 */
package shadedelta.org.apache.parquet.hadoop.metadata;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import shadedelta.org.apache.parquet.hadoop.metadata.Canonicalizer;

public final class ColumnPath
implements Iterable<String>,
Serializable {
    private static Canonicalizer<ColumnPath> paths = new Canonicalizer<ColumnPath>(){

        @Override
        protected ColumnPath toCanonical(ColumnPath value) {
            String[] path2 = new String[value.p.length];
            for (int i = 0; i < value.p.length; ++i) {
                path2[i] = value.p[i].intern();
            }
            return new ColumnPath(path2);
        }
    };
    private final String[] p;

    public static ColumnPath fromDotString(String path2) {
        Objects.requireNonNull(path2, "path cannot be null");
        return ColumnPath.get(path2.split("\\."));
    }

    public static ColumnPath get(String ... path2) {
        return paths.canonicalize(new ColumnPath(path2));
    }

    private ColumnPath(String[] path2) {
        this.p = path2;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ColumnPath) {
            return Arrays.equals(this.p, ((ColumnPath)obj).p);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.p);
    }

    public String toDotString() {
        return String.join((CharSequence)".", this.p);
    }

    public String toString() {
        return Arrays.toString(this.p);
    }

    @Override
    public Iterator<String> iterator() {
        return Arrays.asList(this.p).iterator();
    }

    public int size() {
        return this.p.length;
    }

    public String[] toArray() {
        return this.p;
    }
}

