/*
 * Decompiled with CFR 0.152.
 */
package shadedelta.org.apache.parquet.hadoop.util;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import shadedelta.org.apache.parquet.column.ColumnDescriptor;
import shadedelta.org.apache.parquet.column.ColumnReader;
import shadedelta.org.apache.parquet.column.ColumnWriteStore;
import shadedelta.org.apache.parquet.column.ColumnWriter;
import shadedelta.org.apache.parquet.column.ParquetProperties;
import shadedelta.org.apache.parquet.column.impl.ColumnReadStoreImpl;
import shadedelta.org.apache.parquet.column.page.PageReadStore;
import shadedelta.org.apache.parquet.column.values.bloomfilter.BloomFilter;
import shadedelta.org.apache.parquet.hadoop.CodecFactory;
import shadedelta.org.apache.parquet.hadoop.ColumnChunkPageWriteStore;
import shadedelta.org.apache.parquet.hadoop.ParquetFileWriter;
import shadedelta.org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import shadedelta.org.apache.parquet.hadoop.metadata.ColumnPath;
import shadedelta.org.apache.parquet.hadoop.metadata.ParquetMetadata;
import shadedelta.org.apache.parquet.hadoop.util.CompressionConverter;
import shadedelta.org.apache.parquet.internal.column.columnindex.ColumnIndex;
import shadedelta.org.apache.parquet.internal.column.columnindex.OffsetIndex;
import shadedelta.org.apache.parquet.io.api.Converter;
import shadedelta.org.apache.parquet.io.api.GroupConverter;
import shadedelta.org.apache.parquet.io.api.PrimitiveConverter;
import shadedelta.org.apache.parquet.schema.GroupType;
import shadedelta.org.apache.parquet.schema.MessageType;
import shadedelta.org.apache.parquet.schema.Type;

public class ColumnMasker {
    public void processBlocks(CompressionConverter.TransParquetFileReader reader, ParquetFileWriter writer, ParquetMetadata meta, MessageType schema2, List<String> paths, MaskMode maskMode) throws IOException {
        Set<ColumnPath> nullifyColumns = ColumnMasker.convertToColumnPaths(paths);
        int blockIndex = 0;
        PageReadStore store = reader.readNextRowGroup();
        while (store != null) {
            writer.startBlock(store.getRowCount());
            List<ColumnChunkMetaData> columnsInOrder = meta.getBlocks().get(blockIndex).getColumns();
            Map<ColumnPath, ColumnDescriptor> descriptorsMap = schema2.getColumns().stream().collect(Collectors.toMap(x -> ColumnPath.get(x.getPath()), x -> x));
            ColumnReadStoreImpl crStore = new ColumnReadStoreImpl(store, new DummyGroupConverter(), schema2, meta.getFileMetaData().getCreatedBy());
            for (int i = 0; i < columnsInOrder.size(); ++i) {
                ColumnChunkMetaData chunk = columnsInOrder.get(i);
                ColumnDescriptor descriptor = descriptorsMap.get(chunk.getPath());
                this.processChunk(descriptor, chunk, crStore, reader, writer, schema2, nullifyColumns, maskMode);
            }
            writer.endBlock();
            store = reader.readNextRowGroup();
            ++blockIndex;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processChunk(ColumnDescriptor descriptor, ColumnChunkMetaData chunk, ColumnReadStoreImpl crStore, CompressionConverter.TransParquetFileReader reader, ParquetFileWriter writer, MessageType schema2, Set<ColumnPath> paths, MaskMode maskMode) throws IOException {
        reader.setStreamPosition(chunk.getStartingPos());
        if (paths.contains(chunk.getPath())) {
            if (!maskMode.equals((Object)MaskMode.NULLIFY)) throw new UnsupportedOperationException("Only nullify is supported for now");
            Type.Repetition repetition = descriptor.getPrimitiveType().getRepetition();
            if (repetition.equals((Object)Type.Repetition.REQUIRED)) {
                throw new IOException("Required column [" + descriptor.getPrimitiveType().getName() + "] cannot be nullified");
            }
            this.nullifyColumn(descriptor, chunk, crStore, writer, schema2);
            return;
        } else {
            BloomFilter bloomFilter = reader.readBloomFilter(chunk);
            ColumnIndex columnIndex = reader.readColumnIndex(chunk);
            OffsetIndex offsetIndex = reader.readOffsetIndex(chunk);
            writer.appendColumnChunk(descriptor, reader.getStream(), chunk, bloomFilter, columnIndex, offsetIndex);
        }
    }

    private void nullifyColumn(ColumnDescriptor descriptor, ColumnChunkMetaData chunk, ColumnReadStoreImpl crStore, ParquetFileWriter writer, MessageType schema2) throws IOException {
        long totalChunkValues = chunk.getValueCount();
        int dMax = descriptor.getMaxDefinitionLevel();
        ColumnReader cReader = crStore.getColumnReader(descriptor);
        ParquetProperties.WriterVersion writerVersion = chunk.getEncodingStats().usesV2Pages() ? ParquetProperties.WriterVersion.PARQUET_2_0 : ParquetProperties.WriterVersion.PARQUET_1_0;
        ParquetProperties props = ParquetProperties.builder().withWriterVersion(writerVersion).build();
        CodecFactory codecFactory = new CodecFactory(new Configuration(), props.getPageSizeThreshold());
        CodecFactory.BytesCompressor compressor = codecFactory.getCompressor(chunk.getCodec());
        MessageType newSchema = this.newSchema(schema2, descriptor);
        ColumnChunkPageWriteStore cPageStore = new ColumnChunkPageWriteStore(compressor, newSchema, props.getAllocator(), props.getColumnIndexTruncateLength());
        ColumnWriteStore cStore = props.newColumnWriteStore(newSchema, cPageStore);
        ColumnWriter cWriter = cStore.getColumnWriter(descriptor);
        int i = 0;
        while ((long)i < totalChunkValues) {
            int rlvl = cReader.getCurrentRepetitionLevel();
            int dlvl = cReader.getCurrentDefinitionLevel();
            if (dlvl == dMax) {
                if (dlvl == 0) {
                    throw new IOException("definition level is detected to be 0 for column " + chunk.getPath().toDotString() + " to be nullified");
                }
                if (rlvl == 0) {
                    cWriter.writeNull(rlvl, dlvl - 1);
                }
            } else {
                cWriter.writeNull(rlvl, dlvl);
            }
            cStore.endRecord();
            ++i;
        }
        cStore.flush();
        cPageStore.flushToFileWriter(writer);
        cStore.close();
        cWriter.close();
    }

    private MessageType newSchema(MessageType schema2, ColumnDescriptor descriptor) {
        String[] path2 = descriptor.getPath();
        Type type = schema2.getType(path2);
        if (path2.length == 1) {
            return new MessageType(schema2.getName(), type);
        }
        for (Type field : schema2.getFields()) {
            Type newType;
            if (field.isPrimitive() || (newType = this.extractField(field.asGroupType(), type)) == null) continue;
            return new MessageType(schema2.getName(), newType);
        }
        throw new RuntimeException("No field is found");
    }

    private Type extractField(GroupType candidate, Type targetField) {
        if (targetField.equals((Object)candidate)) {
            return targetField;
        }
        for (Type field : candidate.asGroupType().getFields()) {
            if (field.isPrimitive()) {
                if (!field.equals((Object)targetField)) continue;
                return new GroupType(candidate.getRepetition(), candidate.getName(), targetField);
            }
            Type tempField = this.extractField(field.asGroupType(), targetField);
            if (tempField == null) continue;
            return tempField;
        }
        return null;
    }

    public static Set<ColumnPath> convertToColumnPaths(List<String> cols) {
        HashSet<ColumnPath> prunePaths = new HashSet<ColumnPath>();
        for (String col : cols) {
            prunePaths.add(ColumnPath.fromDotString(col));
        }
        return prunePaths;
    }

    private static final class DummyConverter
    extends PrimitiveConverter {
        private DummyConverter() {
        }

        @Override
        public GroupConverter asGroupConverter() {
            return new DummyGroupConverter();
        }
    }

    private static final class DummyGroupConverter
    extends GroupConverter {
        private DummyGroupConverter() {
        }

        @Override
        public void start() {
        }

        @Override
        public void end() {
        }

        @Override
        public Converter getConverter(int fieldIndex) {
            return new DummyConverter();
        }
    }

    public static enum MaskMode {
        NULLIFY("nullify"),
        HASH("hash"),
        REDACT("redact");

        private String mode;

        private MaskMode(String text) {
            this.mode = text;
        }

        public String getMode() {
            return this.mode;
        }

        public static MaskMode fromString(String mode) {
            for (MaskMode b : MaskMode.values()) {
                if (!b.mode.equalsIgnoreCase(mode)) continue;
                return b;
            }
            return null;
        }
    }
}

