/*
 * Decompiled with CFR 0.152.
 */
package shadedelta.org.apache.parquet.internal.column.columnindex;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import shadedelta.org.apache.parquet.io.api.Binary;
import shadedelta.org.apache.parquet.schema.LogicalTypeAnnotation;
import shadedelta.org.apache.parquet.schema.PrimitiveType;

public abstract class BinaryTruncator {
    private static final BinaryTruncator NO_OP_TRUNCATOR = new BinaryTruncator(){

        @Override
        public Binary truncateMin(Binary minValue, int length) {
            return minValue;
        }

        @Override
        public Binary truncateMax(Binary maxValue, int length) {
            return maxValue;
        }
    };
    private static final BinaryTruncator DEFAULT_UTF8_TRUNCATOR = new BinaryTruncator(){
        private final CharsetValidator validator = new CharsetValidator(StandardCharsets.UTF_8);

        @Override
        public Binary truncateMin(Binary minValue, int length) {
            if (minValue.length() <= length) {
                return minValue;
            }
            ByteBuffer buffer = minValue.toByteBuffer();
            byte[] array2 = this.validator.checkValidity(buffer) == Validity.VALID ? this.truncateUtf8(buffer, length) : this.truncate(buffer, length);
            return array2 == null ? minValue : Binary.fromConstantByteArray(array2);
        }

        @Override
        public Binary truncateMax(Binary maxValue, int length) {
            if (maxValue.length() <= length) {
                return maxValue;
            }
            ByteBuffer buffer = maxValue.toByteBuffer();
            byte[] array2 = this.validator.checkValidity(buffer) == Validity.VALID ? this.incrementUtf8(this.truncateUtf8(buffer, length)) : this.increment(this.truncate(buffer, length));
            return array2 == null ? maxValue : Binary.fromConstantByteArray(array2);
        }

        private byte[] truncate(ByteBuffer buffer, int length) {
            assert (length < buffer.remaining());
            byte[] array2 = new byte[length];
            buffer.get(array2);
            return array2;
        }

        private byte[] increment(byte[] array2) {
            for (int i = array2.length - 1; i >= 0; --i) {
                byte elem = array2[i];
                array2[i] = elem = (byte)(elem + 1);
                if (elem == 0) continue;
                return array2;
            }
            return null;
        }

        private byte[] truncateUtf8(ByteBuffer buffer, int length) {
            assert (length < buffer.remaining());
            ByteBuffer newBuffer = buffer.slice();
            newBuffer.limit(newBuffer.position() + length);
            while (this.validator.checkValidity(newBuffer) != Validity.VALID) {
                newBuffer.limit(newBuffer.limit() - 1);
                if (newBuffer.remaining() != 0) continue;
                return null;
            }
            byte[] array2 = new byte[newBuffer.remaining()];
            newBuffer.get(array2);
            return array2;
        }

        private byte[] incrementUtf8(byte[] array2) {
            if (array2 == null) {
                return null;
            }
            ByteBuffer buffer = ByteBuffer.wrap(array2);
            for (int i = array2.length - 1; i >= 0; --i) {
                byte prev;
                byte inc = prev = array2[i];
                block5: while ((inc = (byte)(inc + 1)) != 0) {
                    array2[i] = inc;
                    switch (this.validator.checkValidity(buffer)) {
                        case VALID: {
                            return array2;
                        }
                        case UNMAPPABLE: {
                            continue block5;
                        }
                    }
                }
                array2[i] = prev;
            }
            return null;
        }
    };

    public static BinaryTruncator getTruncator(PrimitiveType type) {
        if (type == null) {
            return NO_OP_TRUNCATOR;
        }
        switch (type.getPrimitiveTypeName()) {
            case INT96: {
                return NO_OP_TRUNCATOR;
            }
            case BINARY: 
            case FIXED_LEN_BYTE_ARRAY: {
                LogicalTypeAnnotation logicalTypeAnnotation = type.getLogicalTypeAnnotation();
                if (logicalTypeAnnotation == null) {
                    return DEFAULT_UTF8_TRUNCATOR;
                }
                return logicalTypeAnnotation.accept(new LogicalTypeAnnotation.LogicalTypeAnnotationVisitor<BinaryTruncator>(){

                    @Override
                    public Optional<BinaryTruncator> visit(LogicalTypeAnnotation.StringLogicalTypeAnnotation stringLogicalType) {
                        return Optional.of(DEFAULT_UTF8_TRUNCATOR);
                    }

                    @Override
                    public Optional<BinaryTruncator> visit(LogicalTypeAnnotation.EnumLogicalTypeAnnotation enumLogicalType) {
                        return Optional.of(DEFAULT_UTF8_TRUNCATOR);
                    }

                    @Override
                    public Optional<BinaryTruncator> visit(LogicalTypeAnnotation.JsonLogicalTypeAnnotation jsonLogicalType) {
                        return Optional.of(DEFAULT_UTF8_TRUNCATOR);
                    }

                    @Override
                    public Optional<BinaryTruncator> visit(LogicalTypeAnnotation.BsonLogicalTypeAnnotation bsonLogicalType) {
                        return Optional.of(DEFAULT_UTF8_TRUNCATOR);
                    }
                }).orElse(NO_OP_TRUNCATOR);
            }
        }
        throw new IllegalArgumentException("No truncator is available for the type: " + type);
    }

    public abstract Binary truncateMin(Binary var1, int var2);

    public abstract Binary truncateMax(Binary var1, int var2);

    private static class CharsetValidator {
        private final CharBuffer dummyBuffer = CharBuffer.allocate(1024);
        private final CharsetDecoder decoder;

        CharsetValidator(Charset charset) {
            this.decoder = charset.newDecoder();
            this.decoder.onMalformedInput(CodingErrorAction.REPORT);
            this.decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
        }

        Validity checkValidity(ByteBuffer buffer) {
            int pos = buffer.position();
            CoderResult result2 = CoderResult.OVERFLOW;
            while (result2.isOverflow()) {
                this.dummyBuffer.clear();
                result2 = this.decoder.decode(buffer, this.dummyBuffer, true);
            }
            buffer.position(pos);
            if (result2.isUnderflow()) {
                return Validity.VALID;
            }
            if (result2.isMalformed()) {
                return Validity.MALFORMED;
            }
            return Validity.UNMAPPABLE;
        }
    }

    static enum Validity {
        VALID,
        MALFORMED,
        UNMAPPABLE;

    }
}

