/*
 * Decompiled with CFR 0.152.
 */
package shadedelta.org.apache.parquet.internal.column.columnindex;

import java.nio.ByteBuffer;
import shadedelta.org.apache.parquet.filter2.predicate.Statistics;
import shadedelta.org.apache.parquet.internal.column.columnindex.ColumnIndexBuilder;
import shadedelta.org.apache.parquet.io.api.Binary;
import shadedelta.org.apache.parquet.schema.PrimitiveComparator;
import shadedelta.org.apache.parquet.schema.PrimitiveType;
import shadedelta.shaded.parquet.it.unimi.dsi.fastutil.booleans.BooleanArrayList;
import shadedelta.shaded.parquet.it.unimi.dsi.fastutil.booleans.BooleanList;

class BooleanColumnIndexBuilder
extends ColumnIndexBuilder {
    private final BooleanList minValues = new BooleanArrayList();
    private final BooleanList maxValues = new BooleanArrayList();

    BooleanColumnIndexBuilder() {
    }

    private static boolean convert(ByteBuffer buffer) {
        return buffer.get(0) != 0;
    }

    private static ByteBuffer convert(boolean value) {
        return ByteBuffer.allocate(1).put(0, value ? (byte)1 : 0);
    }

    @Override
    void addMinMaxFromBytes(ByteBuffer min2, ByteBuffer max2) {
        this.minValues.add(BooleanColumnIndexBuilder.convert(min2));
        this.maxValues.add(BooleanColumnIndexBuilder.convert(max2));
    }

    @Override
    void addMinMax(Object min2, Object max2) {
        this.minValues.add((boolean)((Boolean)min2));
        this.maxValues.add((boolean)((Boolean)max2));
    }

    ColumnIndexBuilder.ColumnIndexBase<Boolean> createColumnIndex(PrimitiveType type) {
        BooleanColumnIndex columnIndex = new BooleanColumnIndex(type);
        BooleanColumnIndex.access$102(columnIndex, this.minValues.toBooleanArray());
        BooleanColumnIndex.access$202(columnIndex, this.maxValues.toBooleanArray());
        return columnIndex;
    }

    @Override
    void clearMinMax() {
        this.minValues.clear();
        this.maxValues.clear();
    }

    @Override
    int compareMinValues(PrimitiveComparator<Binary> comparator, int index1, int index2) {
        return comparator.compare(this.minValues.get(index1), this.minValues.get(index2));
    }

    @Override
    int compareMaxValues(PrimitiveComparator<Binary> comparator, int index1, int index2) {
        return comparator.compare(this.maxValues.get(index1), this.maxValues.get(index2));
    }

    @Override
    int sizeOf(Object value) {
        return 1;
    }

    private static class BooleanColumnIndex
    extends ColumnIndexBuilder.ColumnIndexBase<Boolean> {
        private boolean[] minValues;
        private boolean[] maxValues;

        private BooleanColumnIndex(PrimitiveType type) {
            super(type);
        }

        @Override
        ByteBuffer getMinValueAsBytes(int pageIndex) {
            return BooleanColumnIndexBuilder.convert(this.minValues[pageIndex]);
        }

        @Override
        ByteBuffer getMaxValueAsBytes(int pageIndex) {
            return BooleanColumnIndexBuilder.convert(this.maxValues[pageIndex]);
        }

        @Override
        String getMinValueAsString(int pageIndex) {
            return this.stringifier.stringify(this.minValues[pageIndex]);
        }

        @Override
        String getMaxValueAsString(int pageIndex) {
            return this.stringifier.stringify(this.maxValues[pageIndex]);
        }

        @Override
        <T extends Comparable<T>> Statistics<T> createStats(int arrayIndex) {
            return new Statistics<Boolean>(this.minValues[arrayIndex], this.maxValues[arrayIndex], this.comparator);
        }

        @Override
        ColumnIndexBuilder.ColumnIndexBase.ValueComparator createValueComparator(Object value) {
            final boolean v = (Boolean)value;
            return new ColumnIndexBuilder.ColumnIndexBase.ValueComparator(){

                @Override
                int compareValueToMin(int arrayIndex) {
                    return comparator.compare(v, minValues[arrayIndex]);
                }

                @Override
                int compareValueToMax(int arrayIndex) {
                    return comparator.compare(v, maxValues[arrayIndex]);
                }
            };
        }

        static /* synthetic */ boolean[] access$102(BooleanColumnIndex x0, boolean[] x1) {
            x0.minValues = x1;
            return x1;
        }

        static /* synthetic */ boolean[] access$202(BooleanColumnIndex x0, boolean[] x1) {
            x0.maxValues = x1;
            return x1;
        }
    }
}

