/*
 * Decompiled with CFR 0.152.
 */
package shadedelta.org.apache.parquet.internal.column.columnindex;

import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;
import java.util.function.IntPredicate;
import java.util.function.IntUnaryOperator;
import java.util.stream.IntStream;
import shadedelta.org.apache.parquet.internal.column.columnindex.ColumnIndexBuilder;

class IndexIterator
implements PrimitiveIterator.OfInt {
    public static final PrimitiveIterator.OfInt EMPTY = IntStream.empty().iterator();
    private int index;
    private final int endIndex;
    private final IntPredicate filter;
    private final IntUnaryOperator translator;

    static PrimitiveIterator.OfInt all(int pageCount) {
        return new IndexIterator(0, pageCount, i -> true, i -> i);
    }

    static PrimitiveIterator.OfInt all(ColumnIndexBuilder.ColumnIndexBase.ValueComparator comparator) {
        return new IndexIterator(0, comparator.arrayLength(), i -> true, comparator::translate);
    }

    static PrimitiveIterator.OfInt filter(int pageCount, IntPredicate filter2) {
        return new IndexIterator(0, pageCount, filter2, i -> i);
    }

    static PrimitiveIterator.OfInt filterTranslate(int arrayLength, IntPredicate filter2, IntUnaryOperator translator) {
        return new IndexIterator(0, arrayLength, filter2, translator);
    }

    static PrimitiveIterator.OfInt rangeTranslate(int from, int to, IntUnaryOperator translator) {
        return new IndexIterator(from, to + 1, i -> true, translator);
    }

    private IndexIterator(int startIndex, int endIndex, IntPredicate filter2, IntUnaryOperator translator) {
        this.endIndex = endIndex;
        this.filter = filter2;
        this.translator = translator;
        this.index = this.nextPageIndex(startIndex);
    }

    private int nextPageIndex(int startIndex) {
        for (int i = startIndex; i < this.endIndex; ++i) {
            if (!this.filter.test(i)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean hasNext() {
        return this.index >= 0;
    }

    @Override
    public int nextInt() {
        if (this.hasNext()) {
            int ret = this.index;
            this.index = this.nextPageIndex(this.index + 1);
            return this.translator.applyAsInt(ret);
        }
        throw new NoSuchElementException();
    }
}

