/*
 * Decompiled with CFR 0.152.
 */
package shadedelta.org.apache.parquet.schema;

import java.util.ArrayList;
import java.util.List;
import shadedelta.org.apache.parquet.column.ColumnDescriptor;
import shadedelta.org.apache.parquet.io.InvalidRecordException;
import shadedelta.org.apache.parquet.schema.GroupType;
import shadedelta.org.apache.parquet.schema.PrimitiveType;
import shadedelta.org.apache.parquet.schema.Type;
import shadedelta.org.apache.parquet.schema.TypeConverter;
import shadedelta.org.apache.parquet.schema.TypeVisitor;

public final class MessageType
extends GroupType {
    public MessageType(String name, Type ... fields) {
        super(Type.Repetition.REPEATED, name, fields);
    }

    public MessageType(String name, List<Type> fields) {
        super(Type.Repetition.REPEATED, name, fields);
    }

    @Override
    public void accept(TypeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void writeToStringBuilder(StringBuilder sb, String indent) {
        sb.append("message ").append(this.getName()).append(this.getLogicalTypeAnnotation() == null ? "" : " (" + this.getLogicalTypeAnnotation().toString() + ")").append(" {\n");
        this.membersDisplayString(sb, "  ");
        sb.append("}\n");
    }

    public int getMaxRepetitionLevel(String ... path2) {
        return this.getMaxRepetitionLevel(path2, 0) - 1;
    }

    public int getMaxDefinitionLevel(String ... path2) {
        return this.getMaxDefinitionLevel(path2, 0) - 1;
    }

    public Type getType(String ... path2) {
        return this.getType(path2, 0);
    }

    public ColumnDescriptor getColumnDescription(String[] path2) {
        int maxRep = this.getMaxRepetitionLevel(path2);
        int maxDef = this.getMaxDefinitionLevel(path2);
        PrimitiveType type = this.getType(path2).asPrimitiveType();
        return new ColumnDescriptor(path2, type, maxRep, maxDef);
    }

    public List<String[]> getPaths() {
        return this.getPaths(0);
    }

    public List<ColumnDescriptor> getColumns() {
        List<String[]> paths = this.getPaths(0);
        ArrayList<ColumnDescriptor> columns = new ArrayList<ColumnDescriptor>(paths.size());
        for (String[] path2 : paths) {
            PrimitiveType primitiveType = this.getType(path2).asPrimitiveType();
            columns.add(new ColumnDescriptor(path2, primitiveType, this.getMaxRepetitionLevel(path2), this.getMaxDefinitionLevel(path2)));
        }
        return columns;
    }

    @Override
    public void checkContains(Type subType) {
        if (!(subType instanceof MessageType)) {
            throw new InvalidRecordException(subType + " found: expected " + this);
        }
        this.checkGroupContains(subType);
    }

    public <T> T convertWith(TypeConverter<T> converter) {
        ArrayList<GroupType> path2 = new ArrayList<GroupType>();
        path2.add(this);
        return converter.convertMessageType(this, this.convertChildren(path2, converter));
    }

    public boolean containsPath(String[] path2) {
        return this.containsPath(path2, 0);
    }

    public MessageType union(MessageType toMerge) {
        return this.union(toMerge, true);
    }

    public MessageType union(MessageType toMerge, boolean strict) {
        return new MessageType(this.getName(), this.mergeFields(toMerge, strict));
    }
}

