/*
 * Decompiled with CFR 0.152.
 */
package shadedelta.shaded.parquet.org.apache.thrift.protocol;

import java.util.BitSet;
import shadedelta.shaded.parquet.org.apache.thrift.TException;
import shadedelta.shaded.parquet.org.apache.thrift.protocol.TCompactProtocol;
import shadedelta.shaded.parquet.org.apache.thrift.protocol.TProtocol;
import shadedelta.shaded.parquet.org.apache.thrift.protocol.TProtocolFactory;
import shadedelta.shaded.parquet.org.apache.thrift.scheme.IScheme;
import shadedelta.shaded.parquet.org.apache.thrift.scheme.TupleScheme;
import shadedelta.shaded.parquet.org.apache.thrift.transport.TTransport;

public final class TTupleProtocol
extends TCompactProtocol {
    public TTupleProtocol(TTransport transport) {
        super(transport);
    }

    @Override
    public Class<? extends IScheme> getScheme() {
        return TupleScheme.class;
    }

    public void writeBitSet(BitSet bs, int vectorWidth) throws TException {
        byte[] bytes2;
        for (byte b : bytes2 = TTupleProtocol.toByteArray(bs, vectorWidth)) {
            this.writeByte(b);
        }
    }

    public BitSet readBitSet(int i) throws TException {
        int length = (int)Math.ceil((double)i / 8.0);
        byte[] bytes2 = new byte[length];
        for (int j = 0; j < length; ++j) {
            bytes2[j] = this.readByte();
        }
        BitSet bs = TTupleProtocol.fromByteArray(bytes2);
        return bs;
    }

    public static BitSet fromByteArray(byte[] bytes2) {
        BitSet bits = new BitSet();
        for (int i = 0; i < bytes2.length * 8; ++i) {
            if ((bytes2[bytes2.length - i / 8 - 1] & 1 << i % 8) <= 0) continue;
            bits.set(i);
        }
        return bits;
    }

    public static byte[] toByteArray(BitSet bits, int vectorWidth) {
        byte[] bytes2 = new byte[(int)Math.ceil((double)vectorWidth / 8.0)];
        for (int i = 0; i < bits.length(); ++i) {
            if (!bits.get(i)) continue;
            int n = bytes2.length - i / 8 - 1;
            bytes2[n] = (byte)(bytes2[n] | 1 << i % 8);
        }
        return bytes2;
    }

    public static class Factory
    implements TProtocolFactory {
        @Override
        public TProtocol getProtocol(TTransport trans) {
            return new TTupleProtocol(trans);
        }
    }
}

