/*
 * Decompiled with CFR 0.152.
 */
package io.delta.standalone.actions;

import io.delta.standalone.actions.JobInfo;
import io.delta.standalone.actions.NotebookInfo;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class CommitInfo {
    private final Optional<Long> version;
    private final Timestamp timestamp;
    private final Optional<String> userId;
    private final Optional<String> userName;
    private final String operation;
    private final Map<String, String> operationParameters;
    private final Optional<JobInfo> jobInfo;
    private final Optional<NotebookInfo> notebookInfo;
    private final Optional<String> clusterId;
    private final Optional<Long> readVersion;
    private final Optional<String> isolationLevel;
    private final Optional<Boolean> isBlindAppend;
    private final Optional<Map<String, String>> operationMetrics;
    private final Optional<String> userMetadata;

    public CommitInfo(Optional<Long> optional, Timestamp timestamp, Optional<String> optional2, Optional<String> optional3, String string, Map<String, String> map, Optional<JobInfo> optional4, Optional<NotebookInfo> optional5, Optional<String> optional6, Optional<Long> optional7, Optional<String> optional8, Optional<Boolean> optional9, Optional<Map<String, String>> optional10, Optional<String> optional11) {
        this.version = optional;
        this.timestamp = timestamp;
        this.userId = optional2;
        this.userName = optional3;
        this.operation = string;
        this.operationParameters = map;
        this.jobInfo = optional4;
        this.notebookInfo = optional5;
        this.clusterId = optional6;
        this.readVersion = optional7;
        this.isolationLevel = optional8;
        this.isBlindAppend = optional9;
        this.operationMetrics = optional10;
        this.userMetadata = optional11;
    }

    public Optional<Long> getVersion() {
        return this.version;
    }

    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    public Optional<String> getUserId() {
        return this.userId;
    }

    public Optional<String> getUserName() {
        return this.userName;
    }

    public String getOperation() {
        return this.operation;
    }

    public Map<String, String> getOperationParameters() {
        return Collections.unmodifiableMap(this.operationParameters);
    }

    public Optional<JobInfo> getJobInfo() {
        return this.jobInfo;
    }

    public Optional<NotebookInfo> getNotebookInfo() {
        return this.notebookInfo;
    }

    public Optional<String> getClusterId() {
        return this.clusterId;
    }

    public Optional<Long> getReadVersion() {
        return this.readVersion;
    }

    public Optional<String> getIsolationLevel() {
        return this.isolationLevel;
    }

    public Optional<Boolean> getIsBlindAppend() {
        return this.isBlindAppend;
    }

    public Optional<Map<String, String>> getOperationMetrics() {
        if (this.operationMetrics.isPresent()) {
            return Optional.of(Collections.unmodifiableMap(this.operationMetrics.get()));
        }
        return this.operationMetrics;
    }

    public Optional<String> getUserMetadata() {
        return this.userMetadata;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CommitInfo commitInfo = (CommitInfo)object;
        return Objects.equals(this.version, commitInfo.version) && Objects.equals(this.timestamp, commitInfo.timestamp) && Objects.equals(this.userId, commitInfo.userId) && Objects.equals(this.userName, commitInfo.userName) && Objects.equals(this.operation, commitInfo.operation) && Objects.equals(this.operationParameters, commitInfo.operationParameters) && Objects.equals(this.jobInfo, commitInfo.jobInfo) && Objects.equals(this.notebookInfo, commitInfo.notebookInfo) && Objects.equals(this.clusterId, commitInfo.clusterId) && Objects.equals(this.readVersion, commitInfo.readVersion) && Objects.equals(this.isolationLevel, commitInfo.isolationLevel) && Objects.equals(this.isBlindAppend, commitInfo.isBlindAppend) && Objects.equals(this.operationMetrics, commitInfo.operationMetrics) && Objects.equals(this.userMetadata, commitInfo.userMetadata);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.timestamp, this.userId, this.userName, this.operation, this.operationParameters, this.jobInfo, this.notebookInfo, this.clusterId, this.readVersion, this.isolationLevel, this.isBlindAppend, this.operationMetrics, this.userMetadata);
    }
}

