/*
 * Decompiled with CFR 0.152.
 */
package io.delta.standalone.actions;

import io.delta.standalone.actions.Format;
import io.delta.standalone.types.StructType;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class Metadata {
    private final String id;
    private final String name;
    private final String description;
    private final Format format;
    private final List<String> partitionColumns;
    private final Map<String, String> configuration;
    private final Optional<Long> createdTime;
    private final StructType schema;

    public Metadata(String string, String string2, String string3, Format format, List<String> list, Map<String, String> map, Optional<Long> optional, StructType structType) {
        this.id = string;
        this.name = string2;
        this.description = string3;
        this.format = format;
        this.partitionColumns = list;
        this.configuration = map;
        this.createdTime = optional;
        this.schema = structType;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Format getFormat() {
        return this.format;
    }

    public List<String> getPartitionColumns() {
        return Collections.unmodifiableList(this.partitionColumns);
    }

    public Map<String, String> getConfiguration() {
        return Collections.unmodifiableMap(this.configuration);
    }

    public Optional<Long> getCreatedTime() {
        return this.createdTime;
    }

    public StructType getSchema() {
        return this.schema;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Metadata metadata = (Metadata)object;
        return Objects.equals(this.id, metadata.id) && Objects.equals(this.name, metadata.name) && Objects.equals(this.description, metadata.description) && Objects.equals(this.format, metadata.format) && Objects.equals(this.partitionColumns, metadata.partitionColumns) && Objects.equals(this.configuration, metadata.configuration) && Objects.equals(this.createdTime, metadata.createdTime) && Objects.equals(this.schema, metadata.schema);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.name, this.description, this.format, this.partitionColumns, this.configuration, this.createdTime, this.schema);
    }
}

