/*
 * Decompiled with CFR 0.152.
 */
package io.delta.standalone.internal.exception;

import io.delta.standalone.types.StructType;
import java.io.FileNotFoundException;
import java.sql.Timestamp;
import org.apache.hadoop.fs.Path;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public final class DeltaErrors$ {
    public static DeltaErrors$ MODULE$;

    static {
        new DeltaErrors$();
    }

    public Throwable deltaVersionsNotContiguousException(Seq<Object> deltaVersions) {
        return new IllegalStateException(new StringBuilder(31).append("Versions (").append(deltaVersions).append(") are not contiguous.").toString());
    }

    public Throwable actionNotFoundException(String action, long version) {
        return new IllegalStateException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(166).append("\n         |The ").append(action).append(" of your Delta table couldn't be recovered while Reconstructing\n         |version: ").append(((Object)BoxesRunTime.boxToLong((long)version)).toString()).append(". Did you manually delete files in the _delta_log directory?\n       ").toString())).stripMargin());
    }

    public Throwable emptyDirectoryException(String directory) {
        return new FileNotFoundException(new StringBuilder(33).append("No file found in the directory: ").append(directory).append(".").toString());
    }

    public Throwable logFileNotFoundException(Path path, long version) {
        return new FileNotFoundException(new StringBuilder(135).append(path).append(": Unable to reconstruct state at version ").append(version).append(" as the ").append("transaction log has been truncated due to manual deletion or the log retention policy ").toString());
    }

    public Throwable missingPartFilesException(long version, Exception e) {
        return new IllegalStateException(new StringBuilder(56).append("Couldn't find all part files of the checkpoint version: ").append(version).toString(), e);
    }

    public Throwable noReproducibleHistoryFound(Path logPath) {
        return new RuntimeException(new StringBuilder(33).append("No reproducible commits found at ").append(logPath).toString());
    }

    public Throwable timestampEarlierThanTableFirstCommit(Timestamp userTimestamp, Timestamp commitTs) {
        return new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(152).append("The provided timestamp (").append(userTimestamp).append(") is before the earliest version available to this\n         |table (").append(commitTs).append("). Please use a timestamp greater than or equal to ").append(commitTs).append(".\n       ").toString())).stripMargin());
    }

    public Throwable timestampLaterThanTableLastCommit(Timestamp userTimestamp, Timestamp commitTs) {
        return new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(146).append("The provided timestamp (").append(userTimestamp).append(") is after the latest version available to this\n         |table (").append(commitTs).append("). Please use a timestamp less than or equal to ").append(commitTs).append(".\n       ").toString())).stripMargin());
    }

    public Throwable noHistoryFound(Path logPath) {
        return new RuntimeException(new StringBuilder(20).append("No commits found at ").append(logPath).toString());
    }

    public Throwable versionNotExistException(long userVersion, long earliest, long latest) {
        return new IllegalArgumentException(new StringBuilder(44).append("Cannot time travel Delta table to version ").append(userVersion).append(". ").append(new StringBuilder(25).append("Available versions: [").append(earliest).append(", ").append(latest).append("].").toString()).toString());
    }

    public Throwable nullValueFoundForPrimitiveTypes(String fieldName) {
        return new NullPointerException(new StringBuilder(54).append("Read a null value for field ").append(fieldName).append(" which is a primitive type").toString());
    }

    public Throwable nullValueFoundForNonNullSchemaField(String fieldName, StructType schema) {
        return new NullPointerException(new StringBuilder(51).append("Read a null value for field ").append(fieldName).append(", yet schema indicates ").append(new StringBuilder(39).append("that this field can't be null. Schema: ").append(schema.getTreeString()).toString()).toString());
    }

    private DeltaErrors$() {
        MODULE$ = this;
    }
}

