/*
 * Decompiled with CFR 0.152.
 */
package io.delta.standalone.types;

import io.delta.standalone.types.DataType;
import io.delta.standalone.types.StructField;
import java.util.Arrays;
import java.util.HashMap;

public final class StructType
extends DataType {
    private final StructField[] fields;
    private final HashMap<String, StructField> nameToField;

    public StructType(StructField[] structFieldArray) {
        if (structFieldArray.length == 0) {
            throw new IllegalArgumentException("a StructType must have at least one field");
        }
        this.fields = structFieldArray;
        this.nameToField = new HashMap();
        Arrays.stream(structFieldArray).forEach(structField -> this.nameToField.put(structField.getName(), (StructField)structField));
    }

    public StructField[] getFields() {
        return (StructField[])this.fields.clone();
    }

    public String[] getFieldNames() {
        return (String[])Arrays.stream(this.fields).map(StructField::getName).toArray(String[]::new);
    }

    public StructField get(String string) {
        if (!this.nameToField.containsKey(string)) {
            throw new IllegalArgumentException(String.format("Field \"%s\" does not exist. Available fields: %s", string, Arrays.toString(this.getFieldNames())));
        }
        return this.nameToField.get(string);
    }

    public String getTreeString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("root\n");
        Arrays.stream(this.fields).forEach(structField -> structField.buildFormattedString(" |", stringBuilder));
        return stringBuilder.toString();
    }

    protected void buildFormattedString(String string, StringBuilder stringBuilder) {
        Arrays.stream(this.fields).forEach(structField -> structField.buildFormattedString(string, stringBuilder));
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        StructType structType = (StructType)object;
        return Arrays.equals(this.fields, structType.fields);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.fields);
    }
}

