/*
 * Decompiled with CFR 0.152.
 */
package io.delta.standalone.types;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public final class FieldMetadata {
    private final Map<String, Object> metadata;

    private FieldMetadata(Map<String, Object> map) {
        this.metadata = map;
    }

    public Map<String, Object> getEntries() {
        return Collections.unmodifiableMap(this.metadata);
    }

    public boolean contains(String string) {
        return this.metadata.containsKey(string);
    }

    public Object get(String string) {
        return this.metadata.get(string);
    }

    public String toString() {
        return this.metadata.entrySet().stream().map(entry -> (String)entry.getKey() + "=" + (entry.getValue().getClass().isArray() ? Arrays.toString((Object[])entry.getValue()) : entry.getValue().toString())).collect(Collectors.joining(", ", "{", "}"));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        FieldMetadata fieldMetadata = (FieldMetadata)object;
        if (this.metadata.size() != fieldMetadata.metadata.size()) {
            return false;
        }
        return this.metadata.entrySet().stream().allMatch(entry -> entry.getValue().equals(fieldMetadata.metadata.get(entry.getKey())) || entry.getValue().getClass().isArray() && fieldMetadata.metadata.get(entry.getKey()).getClass().isArray() && Arrays.equals((Object[])entry.getValue(), (Object[])fieldMetadata.metadata.get(entry.getKey())));
    }

    public int hashCode() {
        return this.metadata.entrySet().stream().mapToInt(entry -> entry.getValue().getClass().isArray() ? (entry.getKey() == null ? 0 : ((String)entry.getKey()).hashCode()) ^ Arrays.hashCode((Object[])entry.getValue()) : entry.hashCode()).sum();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Map<String, Object> metadata = new HashMap<String, Object>();

        public Builder putNull(String string) {
            this.metadata.put(string, null);
            return this;
        }

        public Builder putLong(String string, long l) {
            this.metadata.put(string, l);
            return this;
        }

        public Builder putDouble(String string, double d) {
            this.metadata.put(string, d);
            return this;
        }

        public Builder putBoolean(String string, boolean bl) {
            this.metadata.put(string, bl);
            return this;
        }

        public Builder putString(String string, String string2) {
            this.metadata.put(string, string2);
            return this;
        }

        public Builder putMetadata(String string, FieldMetadata fieldMetadata) {
            this.metadata.put(string, fieldMetadata);
            return this;
        }

        public Builder putLongArray(String string, Long[] longArray) {
            this.metadata.put(string, longArray);
            return this;
        }

        public Builder putDoubleArray(String string, Double[] doubleArray) {
            this.metadata.put(string, doubleArray);
            return this;
        }

        public Builder putBooleanArray(String string, Boolean[] booleanArray) {
            this.metadata.put(string, booleanArray);
            return this;
        }

        public Builder putStringArray(String string, String[] stringArray) {
            this.metadata.put(string, stringArray);
            return this;
        }

        public Builder putMetadataArray(String string, FieldMetadata[] fieldMetadataArray) {
            this.metadata.put(string, fieldMetadataArray);
            return this;
        }

        public FieldMetadata build() {
            return new FieldMetadata(this.metadata);
        }
    }
}

