/*
 * Decompiled with CFR 0.152.
 */
package io.delta.standalone.types;

import io.delta.standalone.expressions.Column;
import io.delta.standalone.internal.util.SchemaUtils;
import io.delta.standalone.types.DataType;
import io.delta.standalone.types.StructField;
import java.util.Arrays;
import java.util.HashMap;

public final class StructType
extends DataType {
    private final StructField[] fields;
    private final HashMap<String, StructField> nameToField;

    public StructType() {
        this(new StructField[0]);
    }

    public StructType(StructField[] structFieldArray) {
        this.fields = structFieldArray;
        this.nameToField = new HashMap();
        Arrays.stream(structFieldArray).forEach(structField -> this.nameToField.put(structField.getName(), (StructField)structField));
    }

    public StructType add(StructField structField) {
        StructField[] structFieldArray = Arrays.copyOf(this.fields, this.fields.length + 1);
        structFieldArray[structFieldArray.length - 1] = structField;
        return new StructType(structFieldArray);
    }

    public StructType add(String string, DataType dataType) {
        StructField structField = new StructField(string, dataType, true);
        return this.add(structField);
    }

    public StructType add(String string, DataType dataType, boolean bl) {
        StructField structField = new StructField(string, dataType, bl);
        return this.add(structField);
    }

    public StructField[] getFields() {
        return (StructField[])this.fields.clone();
    }

    public String[] getFieldNames() {
        return (String[])Arrays.stream(this.fields).map(StructField::getName).toArray(String[]::new);
    }

    public int length() {
        return this.fields.length;
    }

    public StructField get(String string) {
        if (!this.nameToField.containsKey(string)) {
            throw new IllegalArgumentException(String.format("Field \"%s\" does not exist. Available fields: %s", string, Arrays.toString(this.getFieldNames())));
        }
        return this.nameToField.get(string);
    }

    public Column column(String string) {
        StructField structField = this.nameToField.get(string);
        return new Column(string, structField.getDataType());
    }

    public String getTreeString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("root\n");
        Arrays.stream(this.fields).forEach(structField -> structField.buildFormattedString(" |", stringBuilder));
        return stringBuilder.toString();
    }

    protected void buildFormattedString(String string, StringBuilder stringBuilder) {
        Arrays.stream(this.fields).forEach(structField -> structField.buildFormattedString(string, stringBuilder));
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        StructType structType = (StructType)object;
        return Arrays.equals(this.fields, structType.fields);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.fields);
    }

    public boolean isWriteCompatible(StructType structType) {
        return SchemaUtils.isWriteCompatible(this, structType);
    }
}

